/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchFilterException;

public class SearchFilter
implements AttrFilter {
    String filter;
    int pos;
    private StringFilter rootFilter;
    protected static final boolean debug = false;
    protected static final char BEGIN_FILTER_TOKEN = '(';
    protected static final char END_FILTER_TOKEN = ')';
    protected static final char AND_TOKEN = '&';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static final int EQUAL_MATCH = 1;
    static final int APPROX_MATCH = 2;
    static final int GREATER_MATCH = 3;
    static final int LESS_MATCH = 4;

    public SearchFilter(String string) throws InvalidSearchFilterException {
        this.filter = string;
        this.pos = 0;
        this.normalizeFilter();
        this.rootFilter = this.createNextFilter();
    }

    public boolean check(Attributes attributes) throws NamingException {
        if (attributes == null) {
            return false;
        }
        return this.rootFilter.check(attributes);
    }

    protected void consumeChar() {
        ++this.pos;
    }

    protected void consumeChars(int n) {
        this.pos += n;
    }

    protected StringFilter createNextFilter() throws InvalidSearchFilterException {
        StringFilter stringFilter;
        this.skipWhiteSpace();
        try {
            if (this.getCurrentChar() != '(') {
                throw new InvalidSearchFilterException("expected \"(\" at position " + this.pos);
            }
            this.consumeChar();
            this.skipWhiteSpace();
            switch (this.getCurrentChar()) {
                case '&': {
                    stringFilter = new CompoundFilter(true);
                    stringFilter.parse();
                    break;
                }
                case '|': {
                    stringFilter = new CompoundFilter(false);
                    stringFilter.parse();
                    break;
                }
                case '!': {
                    stringFilter = new NotFilter();
                    stringFilter.parse();
                    break;
                }
                default: {
                    stringFilter = new AtomicFilter();
                    stringFilter.parse();
                }
            }
            this.skipWhiteSpace();
            if (this.getCurrentChar() != ')') {
                throw new InvalidSearchFilterException("expected \")\" at position " + this.pos);
            }
            this.consumeChar();
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            throw invalidSearchFilterException;
        }
        catch (Exception exception) {
            throw new InvalidSearchFilterException("Unable to parse character " + this.pos + " in \"" + this.filter + "\"");
        }
        return stringFilter;
    }

    public static int findUnescaped(char c, String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(c, n);
            if (n3 == n || n3 == -1 || string.charAt(n3 - 1) != '\\') {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    public static String format(String string, Object[] objectArray) throws NamingException {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n = SearchFilter.findUnescaped('{', string, n2)) >= 0) {
            int n3;
            int n4 = n + 1;
            int n5 = string.indexOf(125, n4);
            if (n5 < 0) {
                throw new InvalidSearchFilterException("unbalanced {: " + string);
            }
            try {
                n3 = Integer.parseInt(string.substring(n4, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidSearchFilterException("integer expected inside {}: " + string);
            }
            if (n3 >= objectArray.length) {
                throw new InvalidSearchFilterException("number exceeds argument list: " + n3);
            }
            stringBuffer.append(string.substring(n2, n)).append(SearchFilter.getEncodedStringRep(objectArray[n3]));
            n2 = n5 + 1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String format(Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            return "objectClass=*";
        }
        String string = "(& ";
        NamingEnumeration namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = (Attribute)namingEnumeration.next();
            if (attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null) {
                string = String.valueOf(string) + "(" + attribute.getID() + "=" + "*)";
                continue;
            }
            NamingEnumeration namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                String string2 = SearchFilter.getEncodedStringRep(namingEnumeration2.next());
                if (string2 == null) continue;
                string = String.valueOf(string) + "(" + attribute.getID() + "=" + string2 + ")";
            }
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    protected char getCurrentChar() {
        return this.filter.charAt(this.pos);
    }

    private static String getEncodedStringRep(Object object) throws NamingException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append('\\');
                SearchFilter.hexDigit(stringBuffer, byArray[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
        String string = !(object instanceof String) ? object.toString() : (String)object;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '*': {
                    stringBuffer.append("\\2a");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    break;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void hexDigit(StringBuffer stringBuffer, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
    }

    protected void normalizeFilter() {
        this.skipWhiteSpace();
        if (this.getCurrentChar() != '(') {
            this.filter = String.valueOf('(') + this.filter + ')';
        }
    }

    protected char relCharAt(int n) {
        return this.filter.charAt(this.pos + n);
    }

    protected int relIndexOf(int n) {
        return this.filter.indexOf(n, this.pos) - this.pos;
    }

    protected String relSubstring(int n, int n2) {
        return this.filter.substring(n + this.pos, n2 + this.pos);
    }

    public static Attributes selectAttributes(Attributes attributes, String[] stringArray) throws NamingException {
        if (stringArray == null) {
            return attributes;
        }
        BasicAttributes basicAttributes = new BasicAttributes();
        int n = 0;
        while (n < stringArray.length) {
            Attribute attribute = attributes.get(stringArray[n]);
            if (attribute != null) {
                basicAttributes.put(attribute);
            }
            ++n;
        }
        return basicAttributes;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.getCurrentChar())) {
            this.consumeChar();
        }
    }

    static interface StringFilter
    extends AttrFilter {
        public void parse() throws InvalidSearchFilterException;
    }

    final class CompoundFilter
    implements StringFilter {
        private Vector subFilters = new Vector();
        private boolean polarity;

        CompoundFilter(boolean bl) {
            this.polarity = bl;
        }

        public boolean check(Attributes attributes) throws NamingException {
            int n = 0;
            while (n < this.subFilters.size()) {
                StringFilter stringFilter = (StringFilter)this.subFilters.elementAt(n);
                if (stringFilter.check(attributes) != this.polarity) {
                    return this.polarity ^ true;
                }
                ++n;
            }
            return this.polarity;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            while (SearchFilter.this.getCurrentChar() != ')') {
                StringFilter stringFilter = SearchFilter.this.createNextFilter();
                this.subFilters.addElement(stringFilter);
                SearchFilter.this.skipWhiteSpace();
            }
        }
    }

    final class NotFilter
    implements StringFilter {
        private StringFilter filter;

        NotFilter() {
        }

        public boolean check(Attributes attributes) throws NamingException {
            return this.filter.check(attributes) ^ true;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            this.filter = SearchFilter.this.createNextFilter();
        }
    }

    final class AtomicFilter
    implements StringFilter {
        private String attrID;
        private String value;
        private int matchType;

        AtomicFilter() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean check(Attributes var1_1) {
            try {
                var3_2 = var1_1.get(this.attrID);
                if (var3_2 == null) {
                    return false;
                }
                var2_3 = var3_2.getAll();
                if (true) ** GOTO lbl21
            }
            catch (NamingException v0) {
                return false;
            }
            do {
                var3_2 = var2_3.nextElement().toString();
                switch (this.matchType) {
                    case 1: 
                    case 2: {
                        if (!this.substringMatch(this.value, (String)var3_2)) break;
                        return true;
                    }
                    case 3: {
                        if (var3_2.compareTo(this.value) < 0) break;
                        return true;
                    }
                    case 4: {
                        if (var3_2.compareTo(this.value) > 0) break;
                        return true;
                    }
                }
lbl21:
                // 5 sources

            } while (var2_3.hasMoreElements());
            return false;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.skipWhiteSpace();
            try {
                int n = SearchFilter.this.relIndexOf(41);
                int n2 = SearchFilter.this.relIndexOf(61);
                char c = SearchFilter.this.relCharAt(n2 - 1);
                switch (c) {
                    case '~': {
                        this.matchType = 2;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case '>': {
                        this.matchType = 3;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case '<': {
                        this.matchType = 4;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case ':': {
                        throw new OperationNotSupportedException("Extensible match not supported");
                    }
                    default: {
                        this.matchType = 1;
                        this.attrID = SearchFilter.this.relSubstring(0, n2);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                    }
                }
                this.attrID = this.attrID.trim();
                this.value = this.value.trim();
                SearchFilter.this.consumeChars(n);
            }
            catch (Exception exception) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException("Unable to parse character " + SearchFilter.this.pos + " in \"" + SearchFilter.this.filter + "\"");
                invalidSearchFilterException.setRootCause(exception);
                throw invalidSearchFilterException;
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean substringMatch(String var1_1, String var2_2) {
            if (var1_1.equals(new Character('*').toString())) {
                return true;
            }
            if (var1_1.indexOf(42) == -1) {
                return var1_1.equalsIgnoreCase(var2_2);
            }
            var3_3 = 0;
            var4_4 = new StringTokenizer(var1_1, "*", false);
            if (var1_1.charAt(0) == '*' || var2_2.toString().toLowerCase().startsWith(var4_4.nextToken().toLowerCase())) ** GOTO lbl14
            return false;
lbl-1000:
            // 1 sources

            {
                var5_5 = var4_4.nextToken();
                var3_3 = var2_2.toLowerCase().indexOf(var5_5.toLowerCase(), var3_3);
                if (var3_3 == -1) {
                    return false;
                }
                var3_3 += var5_5.length();
lbl14:
                // 2 sources

                ** while (var4_4.hasMoreTokens())
            }
lbl15:
            // 1 sources

            return var1_1.charAt(var1_1.length() - 1) == '*' || var3_3 == var2_2.length();
        }
    }
}

