/*
// otrcsvr.sql - Creates stored procedures used by the Oracle Trace server.
//
// This file should be executed while logged into Oracle user SYS, from the
// directory where the otrc*.sql files reside.  This file needs to be
// executed for each database on which Trace collections will be run.
*/

/*
// Define package headers 
*/
@@otrcdbms.sql
/*
// Define package bodies
*/
@@otrcprvt.sql
/*
// Create Oracle user to be used by Trace daemon
*/
CREATE USER tracesvr IDENTIFIED BY trace
/
GRANT CREATE SESSION, SELECT ANY TABLE TO tracesvr
/
/*
// Allow user tracesvr to access the daemon procedures
*/
GRANT EXECUTE ON dbms_oracle_trace_agent TO tracesvr
/



