Rem
Rem $Header: catodci.sql 18-nov-98.22:43:30 rmurthy Exp $
Rem
Rem catodci.sql
Rem
Rem  Copyright (c) Oracle Corporation 1997, 1998. All Rights Reserved.
Rem
Rem    NAME
Rem      catodci.sql - Types and Interfaces for Extensibility
Rem
Rem    DESCRIPTION
Rem      This file contains the defintions of the object types that are used
Rem      as parameter datatypes in extensibility routines.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ddas        11/09/98 - enhance ODCIQueryInfoDump to handle QueryBlocking
Rem    rmurthy     11/09/98 - add QueryBlocking
Rem    ddas        10/31/98 - add QuerySortAsc and QuerySortDesc
Rem    rmurthy     06/03/98 - add RegularCall macro
Rem    hdnguyen    05/14/98 - modify to run with sqlplus and svrmgr 
Rem    spsundar    05/08/98 - add constants related to alter options
Rem    rmurthy     04/21/98 - handle case of null in dump routines
Rem    jsriniva    04/14/98 - catodci clean-up
Rem    jsriniva    04/14/98 - Print options in ODCIStatsOptionsDump
Rem    ddas        04/13/98 - add pragma for ODCIConst
Rem    jsriniva    04/12/98 - Dump Table Name in ODCIIndexInfoDump
Rem    alsrivas    04/10/98 - adding constant for index interface version
Rem    rmurthy     04/05/98 - indexinfo - remove table name and schema
Rem    jsriniva    04/04/98 - ODCI Types/Interfaces Clean-up
Rem    nagarwal    03/25/98 - Grant privs on ODCIStatsOptions
Rem    ddas        02/04/98 - add ODCI types for extensible optimizer
Rem    nagarwal    03/09/98 - Change ODCIStatsOptions
Rem    rmurthy     01/27/98 - odciindexctx: add flag
Rem    nagarwal    02/02/98 - Add ODCI types for analyze and optimizer
Rem    rmurthy     12/02/97 - remove odcioperbnds, add icoltype, modify odciope
Rem    rmurthy     10/28/97 - add drop odciindexctx
Rem    rmurthy     10/07/97 - add type ODCIIndexCtx
Rem    rmurthy     09/16/97 - change ridlist to varray type, again!
Rem    rmurthy     08/29/97 - change ridlist to a table type from varray
Rem    rmurthy     08/06/97 - add ODCIRidList as OUT parameter from fetch
Rem    alsrivas    07/22/97 - removing creation of varray of rids from here
Rem    rmurthy     07/03/97 - change ODCIColName to varchar2
Rem                           make rowid and ctx as OUT parameters of
Rem                           of fetch() and start()
Rem    alsrivas    06/25/97 - adding new types
Rem    rmurthy     06/18/97 - grant execute on odcitypes with grant option
Rem    rmurthy     06/06/97 - change varchar->varchar2, also change valarg to
Rem                           varchar2(4000)
Rem    rmurthy     05/19/97 - Add flags parameter for ODCIOperBounds
Rem    rmurthy     04/29/97 - Creates types and interfaces for extensibility
Rem    rmurthy     04/29/97 - Created
Rem
REM  ***************************************
REM  THIS PACKAGE MUST BE CREATED UNDER SYS
REM  ***************************************
 
--/************************************************************************/
--/*  ODCI Types: Common to both Extensible Indexing/Optimizer            */
--/************************************************************************/

DROP PROCEDURE ODCIIndexInfoDump;     
DROP PROCEDURE ODCIPredInfoDump;     
DROP PROCEDURE ODCIQueryInfoDump;   
DROP PROCEDURE ODCIColInfoDump;    
DROP PROCEDURE ODCIStatsOptionsDump;
DROP PROCEDURE ODCIIndexAlterOptionDump;

DROP TYPE ODCIIndexCtx;
DROP TYPE ODCIRidList;
DROP TYPE ODCIPredInfo;            
DROP TYPE ODCIIndexInfo;
DROP TYPE ODCIColInfoList;
DROP TYPE ODCIColInfo;
DROP TYPE ODCICost;
DROP TYPE ODCIArgDescList;        
DROP TYPE ODCIArgDesc;
DROP TYPE ODCIQueryInfo;
DROP TYPE ODCIObjectList;
DROP TYPE ODCIObject;
DROP TYPE ODCIFuncInfo;
DROP TYPE ODCIStatsOptions;

--
-- Used by ODCIStats{Collect|Delete} 
--
--/*************************************************************/
--/*     TYPE ODCIColInfo:                                     */
--/* TableSchema           -- schema name                      */
--/* TableName             -- table name                       */
--/* ColName               -- column name                      */
--/* ColTypeName           -- column type                      */
--/* ColTypeSchema         -- column type schema               */
--/*************************************************************/

CREATE TYPE ODCIColInfo AS object 
(
  TableSchema VARCHAR2(30),      
  TableName   VARCHAR2(30),     
  ColName  VARCHAR2(4000),     
  ColTypeName VARCHAR2(30),  
  ColTypeSchema VARCHAR2(30)
);
/


CREATE TYPE ODCIColInfoList      
  AS VARRAY(32) of ODCIColInfo; 
/

--
-- Used by ODCIIndex{Create|Alter|Truncate|Drop|Start|Insert|Delete|Update}
--         ODCIStats(Collect|Delete|IndexCost}
--
--/*****************************************************************/
--/*     TYPE ODCIIndexInfo:                                       */
--/*    IndexSchema      -- index schema name                      */
--/*    IndexName        -- index name                             */
--/*    IndexCols        -- indexed columns                        */
--/*****************************************************************/

CREATE TYPE ODCIIndexInfo AS object
(
  IndexSchema VARCHAR2(30),     
  IndexName VARCHAR2(30),      
  IndexCols ODCIColInfoList 
);
/


--
-- Predicate info containing user-defined operator or function
-- Used by ODCIIndexStart, ODCIStats{Selectivity|IndexCost}
--
--/*****************************************************************/
--/*     TYPE ODCIPredInfo:                                        */
--/*   ObjectSchema       -- Object schema name                    */
--/*   ObjectName         -- Func/Package/Type name                */
--/*   MethodName         -- set only for Pkg/Type                 */
--/*   Flags              -- predicate flags                       */
--/*                      -- (SEE ODCIConst for bit definitions)   */
--/*****************************************************************/

CREATE TYPE ODCIPredInfo AS object  
(
  ObjectSchema VARCHAR2(30),       
  ObjectName VARCHAR2(30),        
  MethodName VARCHAR2(30),       
  Flags NUMBER                 
                              
);
/

--
-- Used by ODCIIndex{Fetch|Insert|Delete|Update}
-- MX_UROWID_S Z= 3800(Max UROWID)*4/3(URWOIDR2Char ovhd)= 5066.67 < 5072
-- Use a large size to simulate unbounded varrays 
--
--
CREATE TYPE ODCIRidList 
 AS VARRAY(32767) OF VARCHAR2(5072); 
/

--
-- Used by Function with index context
--
--/*********************************************************/
--/*     TYPE ODCIIndexCtx:                                */
--/*   IndexInfo          -- Index Information             */
--/*   Rid                -- Row Identifier                */
--/*********************************************************/

CREATE TYPE ODCIIndexCtx AS object
(
  IndexInfo ODCIIndexInfo,          
  Rid VARCHAR2(5072)              
);
/


CREATE TYPE ODCIObject AS object 
(
  ObjectSchema VARCHAR2(30),
  ObjectName   VARCHAR2(30)
);
/

CREATE TYPE ODCIObjectList AS VARRAY(32) of ODCIObject; 
/

--
-- Used by ODCIIndexStart, ODCIStatsIndexCost
--
--/*********************************************************/
--/*     TYPE ODCIQueryInfo:                               */
--/* Flags              -- (SEE ODCIConst for definitions) */
--/* AncOps             -- Ancillary Operators Referenced  */
--/*********************************************************/

CREATE TYPE ODCIQueryInfo AS object   
(
  Flags NUMBER,                      
  AncOps ODCIObjectList   	    
);
/


--/************************************************************************/
--/*  ODCI Types used by Exensible Optimizer (in addition to above)       */
--/************************************************************************/

-- Function (standalone or package) or method info
-- Used by ODCIStatsFunctionCost
--
--/****************************************************************/
--/*     TYPE ODCIFuncInfo:                                       */
--/*   ObjectSchema      -- Object schema name                    */
--/*   ObjectName        -- Function/Pkg/Type name                */
--/*   MethodName        -- set only for Pkg/Type                 */
--/*   Flags             -- function bounds flag                  */
--/*                     -- (SEE ODCIConst for definitions)       */
--/****************************************************************/

CREATE TYPE ODCIFuncInfo AS object
(
  ObjectSchema VARCHAR2(30),       
  ObjectName VARCHAR2(30),        
  MethodName VARCHAR2(30),       
  Flags NUMBER               
);
/



-- Cost structure for user-defined cost functions
-- Used by ODCIStats{FunctionCost|IndexCost}
--
--/************************************************************/
--/*     TYPE ODCICost:                                       */
--/*   CPUcost              -- CPU cost                       */
--/*   IOcost               -- I/O cost                       */
--/*   NetworkCost          -- network cost                   */
--/************************************************************/

CREATE TYPE ODCICost AS object
(
  CPUcost NUMBER,          
  IOcost NUMBER,          
  NetworkCost NUMBER     
);
/


-- Argument descriptor for user-defined operators, functions, and methods
--/************************************************************/
--/*     TYPE ODCIArgDesc:                                    */
--/* ArgType            -- argument type:                     */     
--/*                    -- (SEE ODCIConst for definitions)    */
--/* TableName          -- table name if column or attribute  */
--/* TableSchema        -- schema containing the table        */
--/* ColName            -- column/attribute name (e.g., a.b.c)*/
--/************************************************************/

CREATE TYPE ODCIArgDesc AS object
(
  ArgType NUMBER,            
  TableName VARCHAR2(30),  
  TableSchema VARCHAR2(30),  
  ColName VARCHAR2(4000)   
);
/


--
-- Metadata for parameters of user-defined operators, functions, and methods
-- Used byODCIStats{Selectivity|FunctionCost|IndexCost}
--
CREATE TYPE ODCIArgDescList    
  AS VARRAY(32767) of ODCIArgDesc; 
/


--
-- Used by ODCIStatsCollect
--
--/************************************************************/
--/*     TYPE ODCIStatsOptions:                               */
--/* Sample               -- sample size in analyze           */
--/* Options              -- (SEE ODCIConst for definitions)  */
--/* Flags                -- (SEE ODCIConst for definitions)  */
--/************************************************************/

CREATE TYPE ODCIStatsOptions AS object 
(
  Sample    NUMBER,           
  Options   NUMBER,          
  Flags     NUMBER          
                           
);
/


GRANT EXECUTE ON ODCIIndexInfo TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIPredInfo TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIRidList TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIIndexCtx TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCICost TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIArgDesc TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIArgDescList TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIFuncInfo TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIStatsOptions TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIColInfo TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIColInfoList TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIObject TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIObjectList TO PUBLIC WITH GRANT OPTION;
GRANT EXECUTE ON ODCIQueryInfo TO PUBLIC WITH GRANT OPTION;


--
--/*********************************************/
--/*  Constant Definitions                     */
--/*********************************************/
CREATE OR REPLACE PACKAGE ODCIConst IS

     pragma restrict_references(ODCIConst, WNDS, RNDS, WNPS, RNPS);

  -- Constants for Return Status
     Success          CONSTANT INTEGER  :=  0;
     Error            CONSTANT INTEGER  :=  1;
     Warning          CONSTANT INTEGER  :=  2;

  -- Constants for ODCIPredInfo.Flags
     PredExactMatch   CONSTANT INTEGER  :=  1;
     PredPrefixMatch  CONSTANT INTEGER  :=  2;
     PredIncludeStart CONSTANT INTEGER  :=  4;
     PredIncludeStop  CONSTANT INTEGER  :=  8;
     PredObjectFunc   CONSTANT INTEGER  := 16;
     PredObjectPkg    CONSTANT INTEGER  := 32;
     PredObjectType   CONSTANT INTEGER  := 64;
  
  -- Constants for ODCIQueryInfo.Flags
     QueryFirstRows   CONSTANT INTEGER  :=  1;
     QueryAllRows     CONSTANT INTEGER  :=  2;
     QuerySortAsc     CONSTANT INTEGER  :=  4;
     QuerySortDesc    CONSTANT INTEGER  :=  8;
     QueryBlocking    CONSTANT INTEGER  := 16;

  -- Constants for ScnFlg(Func /w Index Context)
     CleanupCall      CONSTANT INTEGER  :=  1;
     RegularCall      CONSTANT INTEGER  :=  2;

  -- Constants for ODCIFuncInfo.Flags
     ObjectFunc       CONSTANT INTEGER  :=  1;
     ObjectPkg        CONSTANT INTEGER  :=  2;
     ObjectType       CONSTANT INTEGER  :=  4;

  -- Constants for ODCIArgDesc.ArgType
     ArgOther         CONSTANT INTEGER  :=  1;
     ArgCol           CONSTANT INTEGER  :=  2;
     ArgLit           CONSTANT INTEGER  :=  3;
     ArgAttr          CONSTANT INTEGER  :=  4;
     ArgNull          CONSTANT INTEGER  :=  5;

  -- Constants for ODCIStatsOptions.Options
     PercentOption    CONSTANT INTEGER  :=  1;
     RowOption        CONSTANT INTEGER  :=  2;

  -- Constants for ODCIStatsOptions.Flags
     EstimateStats    CONSTANT INTEGER  :=  1;
     ComputeStats     CONSTANT INTEGER  :=  2;
     Validate         CONSTANT INTEGER  :=  4;

  -- Constants for ODCIIndexAlter parameter alter_option
     AlterIndexNone           CONSTANT INTEGER  :=  0;
     AlterIndexRename         CONSTANT INTEGER  :=  1;
     AlterIndexRebuild        CONSTANT INTEGER  :=  2;
     AlterIndexRebuildOnline  CONSTANT INTEGER  :=  3;


END ODCIConst;
/

-- create synonyms and grant privileges
DROP PUBLIC SYNONYM ODCIConst;
CREATE PUBLIC SYNONYM ODCIConst FOR SYS.ODCIConst;
GRANT EXECUTE ON ODCIConst TO PUBLIC;
/



--/*********************************************/
--/*  Supplementary routines                   */
--/*********************************************/
CREATE PROCEDURE ODCIIndexInfoDump(ia ODCIIndexInfo) IS 
  col NUMBER;
BEGIN
  if ia is null then
   dbms_output.put_line('ODCIIndexInfo is null');
   return;
  end if;

  dbms_output.put_line('ODCIIndexInfo');
  dbms_output.put_line('Index owner : ' || ia.IndexSchema); 
  dbms_output.put_line('Index name : ' || ia.IndexName);
  
  -- use first index column's table name as table name for index
  -- (ok since all index columns  belong to same table)
  dbms_output.put_line('Table owner : ' || ia.IndexCols(1).TableSchema);
  dbms_output.put_line('Table name : ' || ia.IndexCols(1).TableName);

  FOR col IN ia.IndexCols.FIRST..ia.IndexCols.LAST LOOP
     dbms_output.put_line('Indexed column : '|| 
                          ia.IndexCols(col).ColName);
     dbms_output.put_line('Indexed column type :'||
		          ia.IndexCols(col).ColTypeName);
     dbms_output.put_line('Indexed column type schema:'||
		          ia.IndexCols(col).ColTypeSchema);
  END LOOP;
END;
/

CREATE PROCEDURE ODCIPredInfoDump(op ODCIPredInfo) IS   
BEGIN
  if op is null then
   dbms_output.put_line('ODCIPredInfo is null');
   return;
  end if;

  dbms_output.put_line('ODCIPredInfo');
  dbms_output.put_line('Object owner : ' ||op.ObjectSchema);
  dbms_output.put_line('Object name : '  ||op.ObjectName);
  dbms_output.put_line('Method name : '  ||op.MethodName);
  dbms_output.put_line('Predicate bounds flag :');

  IF (bitand(op.Flags, ODCIConst.PredExactMatch) 
      = ODCIConst.PredExactMatch)
  THEN
    dbms_output.put_line('     Exact Match');
  END IF;

  IF (bitand(op.Flags, ODCIConst.PredPrefixMatch) 
      = ODCIConst.PredPrefixMatch)
  THEN
    dbms_output.put_line('     Prefix Match');
  END IF;

  IF (bitand(op.Flags, ODCIConst.PredIncludeStart) 
      = ODCIConst.PredIncludeStart)
  THEN
    dbms_output.put_line('     Include Start Key');
  END IF;

  IF (bitand(op.Flags, ODCIConst.PredIncludeStop) 
      = ODCIConst.PredIncludeStop)
  THEN
    dbms_output.put_line('     Include Stop Key');
  END IF;

END;
/

CREATE PROCEDURE ODCIQueryInfoDump(qi ODCIQueryInfo) IS 
BEGIN
  if qi is null then
   dbms_output.put_line('ODCIQueryInfo is null');
   return;
  end if;

  dbms_output.put_line('ODCIQueryInfo');
  dbms_output.put_line('Flags :');

  IF (bitand(qi.Flags, ODCIConst.QueryFirstRows) > 0)
  THEN
    dbms_output.put_line('     First Rows');
  END IF;

  IF (bitand(qi.Flags, ODCIConst.QueryAllRows) > 0) 
  THEN
    dbms_output.put_line('     All Rows');
  END IF;

  IF (bitand(qi.Flags, ODCIConst.QuerySortAsc) > 0)
  THEN
    dbms_output.put_line('     Sort Ascending');
  END IF;

  IF (bitand(qi.Flags, ODCIConst.QuerySortDesc) > 0)
  THEN
    dbms_output.put_line('     Sort Descending');
  END IF;

  IF (bitand(qi.Flags, ODCIConst.QueryBlocking) > 0)
  THEN
    dbms_output.put_line('     Blocking Operations');
  END IF;

  IF qi.AncOps IS NOT NULL AND qi.AncOps.COUNT > 0 THEN
    dbms_output.put_line('Ancillary Operators  ');
    FOR i IN qi.AncOps.FIRST..qi.AncOps.LAST LOOP
       dbms_output.put_line('   Name : '|| 
                            qi.AncOps(i).ObjectName);
       dbms_output.put_line('   Schema :'||
		          qi.AncOps(i).ObjectSchema);
    END LOOP;
  END IF;

END;
/

CREATE PROCEDURE ODCIColInfoDump(ci ODCIColInfo) IS 
  col NUMBER;
BEGIN
  if ci is null then
   dbms_output.put_line('ODCIColInfo is null');
   return;
  end if;

  dbms_output.put_line('ODCIColInfo');
  dbms_output.put_line('Table owner : ' || ci.TableSchema);
  dbms_output.put_line('Table name : ' || ci.TableName);
  dbms_output.put_line('Column name: '|| ci.ColName);
  dbms_output.put_line('Column type :'|| ci.ColTypeName);
  dbms_output.put_line('Column type schema:'|| ci.ColTypeSchema);
END;
/

CREATE PROCEDURE ODCIStatsOptionsDump(so ODCIStatsOptions) IS 
BEGIN
  if so is null then
   dbms_output.put_line('ODCIStatsOptions is null');
   return;
  end if;

  dbms_output.put_line('ODCIStatsOptions');
  IF (so.Flags = ODCIConst.ComputeStats)
  THEN
    dbms_output.put_line('     Compute Stats');
  END IF;
  IF (so.Flags = ODCIConst.EstimateStats)
  THEN
    dbms_output.put_line('     Estimate Stats');
    IF (so.Options = ODCIConst.PercentOption)
    THEN
	  dbms_output.put_line('     Sample ' || so.Sample || ' Percent');
    ELSE
          dbms_output.put_line('     Sample ' || so.Sample || ' Rows');
    END IF;
  END IF;
  IF (so.Flags = ODCIConst.Validate)
  THEN
    dbms_output.put_line('     Validate');
  END IF;

END;
/

CREATE PROCEDURE ODCIIndexAlterOptionDump(op NUMBER) IS
BEGIN
    dbms_output.put('Alter Option :');
    IF (op = ODCIConst.AlterIndexNone)
    THEN
       dbms_output.put_line(' None');
    END IF;
    IF (op = ODCIConst.AlterIndexRename)
    THEN
       dbms_output.put_line(' Rename');
    END IF;
    IF (op = ODCIConst.AlterIndexRebuild)
    THEN
       dbms_output.put_line(' Rebuild');
    END IF;
    IF (op = ODCIConst.AlterIndexRebuildOnline)
    THEN
       dbms_output.put_line(' Rebuild Online');
    END IF;
END;
/

GRANT EXECUTE ON ODCIIndexInfoDump TO PUBLIC;
GRANT EXECUTE ON ODCIPredInfoDump TO PUBLIC;
GRANT EXECUTE ON ODCIQueryInfoDump TO PUBLIC;
GRANT EXECUTE ON ODCIColInfoDump TO PUBLIC;
GRANT EXECUTE ON ODCIStatsOptionsDump TO PUBLIC;
GRANT EXECUTE ON ODCIIndexAlterOptionDump TO PUBLIC;

--/*********************************************/
--/*  ODCIIndex Interface                      */
--/*********************************************/
-- CREATE interface ODCIIndex AS
-- (
--   FUNCTION ODCIGetInterfaces(ifclist OUT ODCIObjectList)  
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexCreate(ia ODCIIndexInfo, 
--                            parms VARCHAR2)
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexAlter(ia ODCIIndexInfo,  
--                           parms IN OUT VARCHAR2,
--                           alter_option NUMBER) 
--     RETURN NUMBER, 
--
--   FUNCTION ODCIIndexTruncate(ia ODCIIndexInfo) 
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexDrop(ia ODCIIndexInfo)     
--     RETURN NUMBER, 
--
--
--   FUNCTION ODCIIndexStart(self IN OUT <impltype>, 
--                           ia ODCIIndexInfo, 
--                           op ODCIPredInfo, 
--                           qi ODCIQueryInfo,       
--                           strt <op_return_type>, 
--                           stop <op_return_type>,
--                           <valargs>)  
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexFetch(nrows NUMBER,           
--                           rids OUT ODCIRidList)
--     RETURN NUMBER,                     
--
--   FUNCTION ODCIIndexClose RETURN NUMBER,          
--
--
--   FUNCTION ODCIIndexInsert(ia ODCIIndexInfo,      
--                            rid VARCHAR2, 
--                            newval <icoltype>) 
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexDelete(ia ODCIIndexInfo,      
--                            rid VARCHAR2, 
--                            old <icoltype>) 
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexUpdate(ia ODCIIndexInfo,      
--                            rid VARCHAR2, 
--                            old <icoltype>, 
--                            new <icoltype>) 
--     RETURN NUMBER,
--
-------------------------------------------------------------
--   DML interface for For WITHOUT COLUMN DATA 
-------------------------------------------------------------
--   FUNCTION ODCIIndexInsert(ia ODCIIndexInfo, 
--                            ridlist ODCIRidList)
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexDelete(ia ODCIIndexInfo, 
--                            ridlist ODCIRidList), 
--     RETURN NUMBER,
--
--   FUNCTION ODCIIndexUpdate(ia ODCIIndexInfo, 
--                            ridlist ODCIRidList), 
--     RETURN NUMBER,
--
-- ); 
--
--/**********************************************************/
--/*  Function with index context                           */
--/*    - index-based functional implementation             */
--/*    - functional implementation for ancillary operators */
--/**********************************************************/
-- FUNCTION funcname(<list of function args>,
--                         ia ODCIIndexCtx,
--                         sctx IN OUT <imp_type>,
--                         scnflg NUMBER) RETURN <ret_type>
--                           -- (SEE ODCIConst for definition) 
--
--
-- CREATE interface ODCIStats AS 
-- ( 
--
--   FUNCTION ODCIGetInterfaces(ifclist OUT ODCIObjectList)  
--     RETURN NUMBER,
--
--   FUNCTION ODCIStatsCollect(col ODCIColInfo, 
--                             options ODCIStatsOptions, 
--                             statistics OUT RAW) 
--     return NUMBER, 
--
--   FUNCTION ODCIStatsCollect(ia ODCIIndexInfo, 
--                             options ODCIStatsOptions, 
--                             statistics OUT RAW) 
--     return NUMBER, 
--
--   FUNCTION ODCIStatsDelete(col ODCIColInfo)
--     return NUMBER, 
-- 
--   FUNCTION ODCIStatsDelete(ia ODCIIndexInfo) 
--     return NUMBER, 
--
--   FUNCTION ODCIStatsSelectivity(pred ODCIPredInfo, sel OUT NUMBER, 
--                                 args ODCIArgDescList, 
--                                 start <function_return_type>, 
--                                 stop <function_return_type>, 
--                                 <list of function arguments>) 
--     return NUMBER, 
-- 
--   FUNCTION ODCIStatsFunctionCost(func ODCIFuncInfo, 
--                                  cost OUT ODCICost, 
--                                  args ODCIArgDescList, 
--                                  <list of function arguments>) 
--     return NUMBER, 
-- 
--   FUNCTION ODCIStatsIndexCost(ia ODCIIndexInfo, sel NUMBER, 
--                               cost OUT ODCICost, qi ODCIQueryInfo, 
--                               pred ODCIPredInfo, 
--                               args ODCIArgDescList, 
--                               start <operator_return_type>, 
--                               stop  <operator_return_type>, 
--                               <list of operator value arguments>) 
--     return NUMBER, 
-- );
--

