#
#   File:    fscan-models-d.x
#   Author:  Tom Yuyitung
#   Version: 1.22 02/08/28 15:12:26     
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   OpenAgent File Scanning Object and Property Model
#

    type = reference
    consoleHint:mediumDesc = base.modules.fscan:moduleDetail

    #
    # Load rules
    #
    _rules = {
	[ use PROC ]
	[ source fscan-d.rul ]
    }

    fscanstats = { [ use MANAGED-OBJECT ]
	mediumDesc = File Scan

	consoleHint:mediumDesc = base.modules.fscan:fscanstats

        fileid = { [ use MANAGED-PROPERTY-CLASS ]

	    mediumDesc	= File Id

	    consoleHint:mediumDesc = base.modules.fscan:fscanstats.fileid

	    filename = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		alarmRules		= filename
            	shortDesc		= filename
            	mediumDesc		= File
            	fullDesc		= The name of the file

		consoleHint:mediumDesc = base.modules.fscan:fscanstats.fileid.filename

	    }

	    scanmode = { [ use STRING MANAGED-PROPERTY ]
            	shortDesc		= scanmode
            	mediumDesc		= Scan Mode
            	fullDesc		= The scan mode
		
		consoleHint:mediumDesc = base.modules.fscan:fscanstats.fileid.scanmode

	    }

	    stime = { [ use STRING MANAGED-PROPERTY ]
            	shortDesc		= stime
            	mediumDesc		= Start Time
            	fullDesc		= The time the agent started scanning the file  
		
		consoleHint:mediumDesc = base.modules.fscan:fscanstats.fileid.stime

	    }
	}

        filestats = { [ use MANAGED-PROPERTY-CLASS ]

	    mediumDesc	= File Stats

	    consoleHint:mediumDesc = base.modules.fscan:fscanstats.filestats

	    mtime = { [ use STRING MANAGED-PROPERTY ]
            	shortDesc		= mtime
            	mediumDesc		= Modification Time
            	fullDesc		= The time the file was last modified

        	consoleHint:mediumDesc = base.modules.fscan:fscanstats.filestats.mtime

	    }

	    size = { [ use INTHI MANAGED-PROPERTY ]
            	shortDesc		= size 
            	mediumDesc		= File Size
            	fullDesc		= The size of the file
	    	units			= " bytes"

                consoleHint:mediumDesc = base.modules.fscan:fscanstats.filestats.size
                consoleHint:i18nunits = base.modules.fscan:units.bytes

	    }

	    length = { [ use INTHI MANAGED-PROPERTY ]
            	shortDesc		= length
            	mediumDesc		= Number of Lines
            	fullDesc		= The number of lines in the file
	    	units		= " lines"
	    
 		consoleHint:mediumDesc = base.modules.fscan:fscanstats.filestats.length
                consoleHint:i18nunits = base.modules.fscan:units.lines

	    }

            lengthrate = { [ use FLOATHI MANAGED-PROPERTY ]
            	shortDesc               = rate
            	mediumDesc              = Lines Per Second
            	fullDesc                = The number of lines written per second
	    	units			= " lines/sec"
	    
		consoleHint:mediumDesc = base.modules.fscan:fscanstats.filestats.lengthrate
                consoleHint:i18nunits = base.modules.fscan:units.linespersec

	    }
        }

	scanTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc = Scan Table

	    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable

	    scanEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc 	= Scan Entry
		index		= name
		descColumn	= desc

		consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry

		rowstatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
                    shortDesc   = row status
                    mediumDesc  = Row Status
                    fullDesc    = The row status

		    consoleHint:hidden = true 
                    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.rowstatus
 
                }

		name = { [ use STRING MANAGED-PROPERTY ]
            	    shortDesc	= pattern name 
            	    mediumDesc	= Pattern Name
            	    fullDesc	= The pattern name

		    dataFormat  = instance
		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.name

		}

		desc = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
            	    shortDesc	= pattern desc 
            	    mediumDesc	= Pattern Description
            	    fullDesc	= The pattern description
                    required	= true
                    dataFormat  = unicode

		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.desc

		}

	    	pattern = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
            	    shortDesc	= pattern
            	    mediumDesc	= Regexp Pattern
            	    fullDesc	= The regular expression pattern
                    required    = true
		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.pattern

	    	}

	    	state = { [ use STRING MANAGED-PROPERTY ]
            	    shortDesc	= state 
            	    mediumDesc	= Pattern State
            	    fullDesc	= The state of the pattern
		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.state

	    	}

	    	matches = { [ use INT MANAGED-PROPERTY ]
            	    shortDesc	= matches
            	    mediumDesc	= Matches
            	    fullDesc	= The number of matches
		    dataFormat  = nodisplay
		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.matches
		    consoleHint:hidden = true

	    	}

	    	total = { [ use INTHILO MANAGED-PROPERTY _rules ]
            	    shortDesc	= matches
            	    mediumDesc	= Matches 
            	    fullDesc	= The total number of matches in current file 
		
		    consoleHint:mediumDesc = base.modules.fscan:fscanstats.scanTable.scanEntry.total

		    alarmRules	= rCompare_match
		}
	    }
	}
    }

    resetter = { [ use STRING ] }
    [ load fscan-ruleinit-d.x ]
