#!/bin/sh
#
# File: base-mibman-d.x
#
# @(#)base-mibman-d.x	1.64 01/02/14
# Copyright (c) 1993-1998 Halcyon Inc.
#
#   OpenAgent MIB Manager Module

# *********************************************************** 
# WARNING!!!!!
#
# The *ordering* of the entries in this file is important.
# It must agree with oa/base/daemon/cfg/base-snmp-cache-d.dat.
# If you make a change here, look at the *snmp*.dat file also.
# *********************************************************** 

    [ use MODULE ]

    oid = 1

    module = base-mibman
    modulename = MIB Manager
    mibTextPrefix = mib

    #
    # MIB Management Utility Procedures
    #
    _procedures = {
	[ use PROC ]
	[ source base-mibman-d.prc ]
    }

    #
    # Dynamic MIB OID Lookup Service
    #
    finder = { [ use STRING _procedures ]
	access 		= rw
	setActions	= *getoid
	setService(getoid)	= modules
	setMethod(getoid)	= findMIBObject %value
	shortDesc	= Finder
	mediumDesc	= OID Finder
	fullDesc	= The variable used to locate MIB nodes

	userAccess(%generalUsers,write)   = auth
	groupAccess(%generalGroups,write) = auth
	userAccess(%generalCommunities,write)   = noauth

        shadowMapping        = 5000:multiVarbindFinder
 
        shadowDesc(multiVarbindFinder)      = OID Finder;
        shadowType(multiVarbindFinder)      = string;
        shadowMaxAccess(multiVarbindFinder) = rw;
        shadowDim(multiVarbindFinder)       = scalar;
        shadowGet(multiVarbindFinder)       = ;
        shadowSet(multiVarbindFinder)       = toe_send [ locate modules ] findMIBObject %value;
    }

    #
    # Dynamic MIB Module Loader Service
    #
    loader = { [ use STRING _procedures ]
	access 		= rw
	setActions	= *loadmodule
        #
	#setService(loadmodule)	= modules
	#setMethod(loadmodule)	= quickLoad %value %pdu
	setService(loadmodule)	= schedule.scheduleTable.scheduleEntry
	setMethod(loadmodule)	= schModuleScheduling "load" %value %pdu

	shortDesc	= Loader
	mediumDesc	= MIB Loader
	fullDesc	= The variable used to load MIB modules

	userAccess(%operatorUsers,write)   = none
	groupAccess(%operatorGroups,write) = none
	userAccess(%operatorCommunities,write)   = none
    }

    #
    # root URL for browser
    #
    browserRoot = { [ use STRING _procedures ]
	type = active
	initInterval = 1
	refreshInterval = 0
	refreshService = _internal
	refreshCommand = getRootURL
    
	shortDesc = Root
	mediumDesc = Browser Root URL
	fullDesc = The root URL used by the browser
    }

    #
    # Checker for existence of module
    #
    checker = { [ use STRING ]
	access          = rw
	setActions      = *checkmodule
	setService(checkmodule) = modules
	setMethod(checkmodule) = checkModule %value
	shortDesc = Checker
	mediumDesc = Module Existence Checker
	fullDesc = The variable used to check the existence of a module
    }

    #
    # Module revision control
    #
    moduleRegistry = { [ use STRING ]
	access 	= wo
	setActions	= *listmodules
	setService(listmodules)	= modules
	setMethod(listmodules)  = getModuleRevisions %value

	userAccess(%generalUsers,write)   = auth

	shortDesc	= Module Registry
	mediumDesc	= Module Registry List
	fullDesc	= The variable used to return revision list of loaded modules
    }

    #
    # Module Management Table
    #
    modules = { [ use MANAGED-OBJECT _procedures ]
	#
	# functions in base-mibman-d.prc override functions for MANAGED-OBJECT
	# need to resource it
	#
	[ source base-mibman-d.prc ]
	shortDesc = Module Table
	#mediumDesc = Module Management Table
        # mediumDesc changed to something more appropriate for console
        # status message
	mediumDesc = Host Modules
	fullDesc = Tables for module management

        activateActions(post) = load
        activateService(load) = _internal
        activateCommand(load) = registerOneShot 8 loadModules

        # This object has no active time window
	shadowGroups() = Info base.console.ConsoleGeneric:editGroup.info \
			 Security base.console.ConsoleGeneric:editGroup.security

        shadowGroups(Info) = host snmpport trapdest

	persistentSlices	= [ lookup value moduleFile ]
	forwardStatus		= false
	initInterval		= 1

	hardware = { [ use MODULE-TYPE _procedures ]
	    shortDesc = hardware
	    mediumDesc = Hardware
	    fullDesc = Hardware module table
	    consoleHint:family = hardware-moduletbl
            consoleHint:mediumDesc = base.console.ConsoleGeneric:agent.hardware

            # This object has no active time window
            #shadowGroups(Module)    = useracls groupacls

	    type		= active
	    refreshService	= _superior
	    refreshCommand	= getModules hardware
	    refreshInterval	= 0

	    mibTextPrefix = hw

	    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
		moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                    mediumDesc = Module
		    index = modspec
		    indexImplied = true
		    descColumn = name
		    consoleHint:descColumn = i18nName
		    consoleHint:referenceColumn = id
		    
		    modspec	= { [ use MANAGED-PROPERTY STRING ] }
		    name	= { [ use MANAGED-PROPERTY STRING ] }
		    i18nName	= { [ use MANAGED-PROPERTY STRING ] }
		    version	= { [ use MANAGED-PROPERTY STRING ] }
		    url		= { [ use MANAGED-PROPERTY STRING ] }
		    status	= { [ use MANAGED-PROPERTY STATUSPROXY ] }
		    id		= { [ use MANAGED-PROPERTY STRING ] }
		}
	    }
	}

	operatingSystem = { [ use MODULE-TYPE _procedures ]
	    shortDesc = os
	    mediumDesc = Operating System 
	    fullDesc = Operating system module table
	    consoleHint:family = os-moduletbl
            consoleHint:mediumDesc = base.console.ConsoleGeneric:agent.operatingSystem

            # This object has no active time window
            #shadowGroups(Module)    = useracls groupacls

	    type		= active
	    refreshService	= _superior
	    refreshCommand	= getModules operatingSystem
	    refreshInterval	= 0

	    mibTextPrefix = os

	    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
		moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                    mediumDesc = Module
		    index = modspec
		    indexImplied = true
		    descColumn = name
		    consoleHint:descColumn = i18nName
		    consoleHint:referenceColumn = id

		    modspec	= { [ use MANAGED-PROPERTY STRING ] }
		    name	= { [ use MANAGED-PROPERTY STRING ] }
		    i18nName	= { [ use MANAGED-PROPERTY STRING ] }
		    version	= { [ use MANAGED-PROPERTY STRING ] }
		    url		= { [ use MANAGED-PROPERTY STRING ] }
		    status	= { [ use MANAGED-PROPERTY STATUSPROXY ] }
		    id		= { [ use MANAGED-PROPERTY STRING ] }
		}
	    }
	}

	localApplication = { [ use MODULE-TYPE _procedures ]
	    shortDesc = localapps
	    mediumDesc = Local Applications
	    fullDesc = Local applications module table
	    consoleHint:family = local-moduletbl
            consoleHint:mediumDesc = base.console.ConsoleGeneric:agent.localApp

            # This object has no active time window
            #shadowGroups(Module)    = useracls groupacls
	    #shadowGroups()    = Info base.console.ConsoleGeneric:editGroup.info

	    type		= active
	    refreshService	= _superior
	    refreshCommand	= getModules localApplication
	    refreshInterval	= 0

	    mibTextPrefix = la

	    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
		moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                    mediumDesc = Module
		    index = modspec
		    indexImplied = true
		    descColumn = name
		    consoleHint:descColumn = i18nName
		    consoleHint:referenceColumn = id
		    
		    modspec	= { [ use MANAGED-PROPERTY STRING ] }
		    name	= { [ use MANAGED-PROPERTY STRING ] }
		    i18nName	= { [ use MANAGED-PROPERTY STRING ] }
		    version	= { [ use MANAGED-PROPERTY STRING ] }
		    url		= { [ use MANAGED-PROPERTY STRING ] }
		    status	= { [ use MANAGED-PROPERTY STATUSPROXY ] }
		    id		= { [ use MANAGED-PROPERTY STRING ] }
		}
	    }
	}

	remoteSystem = { [ use MODULE-TYPE _procedures ]
	    shortDesc = remotesys
	    mediumDesc = Remote Systems
	    fullDesc = Remote systems module table
	    consoleHint:family = remote-moduletbl
            consoleHint:mediumDesc = base.console.ConsoleGeneric:agent.remoteSys

            # This object has no active time window
            #shadowGroups(Module)    = useracls groupacls

	    type		= active
	    refreshService	= _superior
	    refreshCommand	= getModules remoteSystem
	    refreshInterval	= 0

	    mibTextPrefix = rs

	    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
		moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                    mediumDesc = Module
		    index = modspec
		    indexImplied = true
		    descColumn = name
		    consoleHint:descColumn = i18nName
		    consoleHint:referenceColumn = id
		    
		    modspec	= { [ use MANAGED-PROPERTY STRING ] }
		    name	= { [ use MANAGED-PROPERTY STRING ] }
		    i18nName	= { [ use MANAGED-PROPERTY STRING ] }
		    version	= { [ use MANAGED-PROPERTY STRING ] }
		    url		= { [ use MANAGED-PROPERTY STRING ] }
		    status	= { [ use MANAGED-PROPERTY STATUSPROXY ] }
		    id		= { [ use MANAGED-PROPERTY STRING ] }
		}
	    }
	}

	#
	# NOTE: do not put the serverSupport group in here.  It will cause
	# loops in the object tree due to the potential appearance of topology
	# module instances.  If it becomes necessary to insert said group,
	# set the consoleHint:hidden to false (so it is invisible in the console)
	# and the value:forwardStatus to false (so it does not endlessly forward
	# status in loops).
	#
        # The status column in the serverSupport table is obselete -- it shall
        # always contain a blank value -- this field is not referenced and
        # is not needlessly refreshed
        #
	serverSupport = { [ use MODULE-TYPE _procedures ]
	    shortDesc = serverSupport
	    mediumDesc = Server Support
	    fullDesc = Server Support
	    consoleHint:family = remote-moduletbl
            consoleHint:mediumDesc = base.console.ConsoleGeneric:agent.server
	    consoleHint:hidden = true
            forwardStatus      = false

            # This object has no active time window
            #shadowGroups(Module)    = useracls groupacls

	    type		= active
	    refreshService	= _superior
	    refreshCommand	= getModules serverSupport 0
	    refreshInterval	= 0

	    mibTextPrefix = ss

	    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
		moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                    mediumDesc = Module
		    index = modspec
		    indexImplied = true
		    descColumn = name
		    consoleHint:descColumn = i18nName
		    consoleHint:referenceColumn = id

		    modspec	= { [ use MANAGED-PROPERTY STRING ] }
		    name	= { [ use MANAGED-PROPERTY STRING ] }
		    i18nName	= { [ use MANAGED-PROPERTY STRING ] }
		    version	= { [ use MANAGED-PROPERTY STRING ] }
		    url		= { [ use MANAGED-PROPERTY STRING ] }
		    status	= { [ use MANAGED-PROPERTY STRING ] 
                        mediumDesc = Obselete Server Support status field
                        fullDesc = Obselete Server Support status field
                    }
		    id		= { [ use MANAGED-PROPERTY STRING ] }
		}
	    }
	}
    }

    #
    # module management: schedule service
    #------------------------------------
    schedule = { [ use MANAGED-OBJECT ]

        mediumDesc = schedule

        #
        # schedule table
        #---------------
        scheduleTable = { [ use MANAGED-OBJECT-TABLE ]

            mediumDesc = schedule table

            scheduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY _procedures ]

                mediumDesc = schedule entry

                persistentSlices = value:schedule.dat

                activateActions(post) = init
                activateService(init) = _internal
                activateCommand(init) = schInitSchedule

                type = active
                refreshService  = _internal
                refreshCommand  = schRefreshSchedule
                refreshInterval = 600  

                index      = modspec
                descColumn = modspec

                rowstatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
                    mediumDesc = rowstatus
                }

                modspec = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = modspec
                }

                enabletimewindow = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = enabletimewindow
                }

                enablestate = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = enablestate
                }

                loadtimewindow = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = loadtimewindow
                }

                loadstate = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = loadstate
                }

                info = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    mediumDesc = info
                }
            }
        }

        #
        # schedule request
        #-----------------
        scheduleRequest = { [ use STRING MANAGED-PROPERTY ]

            mediumDesc = schedule request

            access = wo

            setActions = *set
            setService(set) = scheduleTable.scheduleEntry
            setCommand(set) = schModuleScheduling "schedulerequest" %value %pdu
        }
    }
