/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MdDataSourceProperties
implements Cloneable,
Serializable {
    public static final String DIRECTORY = "directory";
    public static final String FILE = "file";
    public static final String JDBC_DRIVER = "driver";
    public static final String JDBC_URL = "url";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    private String type;
    private Properties properties;

    public MdDataSourceProperties(MdDataSourceProperties mdDataSourceProperties) {
        if (mdDataSourceProperties == null) {
            throw new IllegalArgumentException("defaultMdDataSourceProperties is null");
        }
        this.type = mdDataSourceProperties.getType();
        this.properties = new Properties(mdDataSourceProperties.properties);
    }

    public MdDataSourceProperties(String string) {
        this.type = string;
        this.properties = new Properties();
    }

    public Object clone() {
        try {
            MdDataSourceProperties mdDataSourceProperties = (MdDataSourceProperties)super.clone();
            mdDataSourceProperties.properties = (Properties)((Hashtable)this.properties).clone();
            return mdDataSourceProperties;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(String.valueOf(String.valueOf(this.getClass())) + " could not be cloned: " + cloneNotSupportedException.getMessage());
        }
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public String getType() {
        return this.type;
    }

    public Enumeration keys() {
        return ((Hashtable)this.properties).keys();
    }

    public String setProperty(String string, String string2) {
        return (String)this.properties.setProperty(string, string2);
    }

    public void setType(String string) {
        this.type = string;
    }
}

