/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment.server;

import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Identity;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import oracle.aurora.AuroraServices.EJBGenerationError;
import oracle.aurora.ejb.OracleEntityDescriptor;
import oracle.aurora.ejb.deployment.server.EjbBinaryClassProcessor;
import oracle.aurora.ejb.deployment.server.GenerationErrors;
import oracle.aurora.ejb.deployment.server.JasperGenerationError;
import oracle.aurora.ejb.deployment.server.MethodInfo;
import oracle.aurora.ejb.persistence.ocmp.OcmpBeanMapping;
import oracle.aurora.rdbms.ClassResolver;
import oracle.aurora.rdbms.DbmsRealm;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.jdbc.driver.OracleDriver;

class BeanGenerator {
    private Resolver resolver;
    private boolean initialized = false;
    private boolean homeMethodsInit = false;
    private final Dictionary userMap = new Hashtable();
    private ClassLoader loader;
    private DeploymentDescriptor descriptor;
    private final Hashtable methodIndex = new Hashtable();
    private MethodInfo[] allMethods;
    private int[][] acl;
    private int[] runAs;
    private int[] runAsMode;
    private int[] isolationLevel;
    private int[] txnType;
    private String[][] props;
    private String ejbObjectSource;
    private String ejbHomeSource;
    private String pmSource;
    private String ocmpSqlSource;
    private String grantedUsers;
    private Vector allCreateMethods;
    private MethodInfo findByPrimaryKeyMethod;
    private Vector allFinderMethods;
    private static final String sys_generatedPackage = "oracle.aurora.ejb.gen";
    private static final String EJB_OBJECT_BASE_NAME = "EjbObject_";
    private static final String EJB_HOME_BASE_NAME = "EjbHome_";
    private static final String EJB_BMP_BASE_NAME = "Bmp_";
    private static final String EJB_OCMP_SQL_BASE_NAME = "OcmpSqlEngine_";
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$SessionSynchronization;

    private BeanGenerator() {
    }

    public BeanGenerator(DeploymentDescriptor d, Schema s) throws EJBGenerationError {
        this.descriptor = d;
        try {
            this.resolver = new Resolver(new ResolverTerm[]{new ResolverTerm("*", s)});
            this.resolver.concatenate(Resolver.defaultResolver());
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
        }
        catch (InvalidResolverPatternException invalidResolverPatternException) {}
        this.loader = new ClassResolver(this.resolver);
    }

    private AccessControlEntry[] acl() {
        return this.descriptor.getAccessControlEntries();
    }

    Enumeration allHomeInterfaces() {
        Vector interfaces = new Vector();
        Class<?> homeInterface = null;
        try {
            homeInterface = this.loader.loadClass(this.getHomeInterfaceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new JasperGenerationError(String.valueOf(e.getClass().getName()) + " : Home Interface not found: " + this.getHomeInterfaceClassName() + " : " + e.getMessage());
        }
        interfaces.addElement(homeInterface);
        Class<?>[] his = homeInterface.getInterfaces();
        int i = 0;
        while (i < his.length) {
            if (his[i] != (class$javax$ejb$EJBHome != null ? class$javax$ejb$EJBHome : BeanGenerator.class$("javax.ejb.EJBHome"))) {
                interfaces.addElement(his[i]);
            }
            ++i;
        }
        return interfaces.elements();
    }

    void allHomeMethodsInit() {
        this.allCreateMethods = new Vector();
        this.allFinderMethods = new Vector();
        Enumeration interfaces = this.allHomeInterfaces();
        while (interfaces.hasMoreElements()) {
            Class current = (Class)interfaces.nextElement();
            Method[] interfaceMethods = current.getDeclaredMethods();
            int i = 0;
            while (i < interfaceMethods.length) {
                if (interfaceMethods[i].getName().equals("create")) {
                    this.allCreateMethods.addElement(new MethodInfo(interfaceMethods[i]));
                } else if (interfaceMethods[i].getName().equals("findByPrimaryKey")) {
                    this.findByPrimaryKeyMethod = new MethodInfo(interfaceMethods[i]);
                } else if (interfaceMethods[i].getName().startsWith("find")) {
                    this.allFinderMethods.addElement(new MethodInfo(interfaceMethods[i]));
                }
                ++i;
            }
            this.homeMethodsInit = true;
        }
    }

    private Enumeration allInterfaces() {
        Vector interfaces = new Vector();
        Class<?> remoteInterface = null;
        Class<?> homeInterface = null;
        try {
            remoteInterface = this.loader.loadClass(this.getRemoteInterfaceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new JasperGenerationError(String.valueOf(e.getClass().getName()) + " : Remote Interface not found: " + this.getRemoteInterfaceClassName() + " : " + e.getMessage());
        }
        try {
            homeInterface = this.loader.loadClass(this.getHomeInterfaceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new JasperGenerationError(String.valueOf(e.getClass().getName()) + " : Home Interface not found: " + this.getHomeInterfaceClassName() + " : " + e.getMessage());
        }
        interfaces.addElement(remoteInterface);
        Class<?>[] ris = remoteInterface.getInterfaces();
        int i = 0;
        while (i < ris.length) {
            if (ris[i] != (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : BeanGenerator.class$("javax.ejb.EJBObject"))) {
                interfaces.addElement(ris[i]);
            }
            ++i;
        }
        interfaces.addElement(homeInterface);
        Class<?>[] his = homeInterface.getInterfaces();
        int i2 = 0;
        while (i2 < his.length) {
            if (his[i2] != (class$javax$ejb$EJBHome != null ? class$javax$ejb$EJBHome : BeanGenerator.class$("javax.ejb.EJBHome"))) {
                interfaces.addElement(his[i2]);
            }
            ++i2;
        }
        return interfaces.elements();
    }

    private ControlDescriptor[] cdl() {
        return this.descriptor.getControlDescriptors();
    }

    boolean checkPrimitive() throws ClassNotFoundException {
        String name = this.getPrimaryKeyClassName();
        Class<?> cl = this.loader.loadClass(name);
        return cl.isPrimitive();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void close(ResultSet s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (SQLException sQLException) {}
    }

    private void close(Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (SQLException sQLException) {}
    }

    private void compile(String name, String grants, String source) throws EJBGenerationError {
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = new OracleDriver().defaultConnection();
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                if (Boolean.getBoolean("EJBDeploymentDebug")) {
                    System.out.println("create or replace and compile java source named \"" + name + "\" " + this.resolver + " as " + source);
                    System.out.println("grant execute on \"" + name.replace('.', '/') + "\" to " + grants);
                }
                stmt.execute("create or replace and compile java source named \"" + name + "\" " + this.resolver + " as " + source);
                if (!grants.equals("")) {
                    stmt.execute("grant execute on \"" + name.replace('.', '/') + "\" to " + grants);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                GenerationErrors.fail2("SQL_EXCEPTION_COMPILING", name, e.getMessage());
            }
            Object var7_7 = null;
            this.close(stmt);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(stmt);
            throw throwable;
        }
        this.getErrors(name);
    }

    private String gatherUsers() {
        String exclude = "SYS";
        Enumeration users = this.userMap.keys();
        Vector<String> gathered = new Vector<String>();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            if (user.equals(exclude)) continue;
            gathered.addElement(user);
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < gathered.size() - 1) {
            out.append((String)gathered.elementAt(i));
            out.append(',');
            ++i;
        }
        if (gathered.size() > 0) {
            out.append((String)gathered.lastElement());
        }
        return out.toString();
    }

    public String[] generate() throws EJBGenerationError {
        this.mapUsers();
        try {
            if (this.descriptor instanceof SessionDescriptor) {
                this.generateEjbHome();
                this.generateSSEjbObject();
            } else if (this.descriptor instanceof OracleEntityDescriptor) {
                this.generateEntityPm();
                this.generateEntityHome();
                this.generateEntityObject();
            }
        }
        catch (JasperGenerationError e) {
            e.printStackTrace();
            GenerationErrors.fail1("CODE_GENERATION_ERROR", e.getMessage());
        }
        String grants = this.gatherUsers();
        if (this.ejbObjectSource == null || this.ejbHomeSource == null) {
            GenerationErrors.fail1("CODE_GENERATION_ERROR", "Unknown failure");
        }
        if (this.descriptor instanceof OracleEntityDescriptor) {
            String ppn = ((OracleEntityDescriptor)this.descriptor).getPersistenceProviderName();
            if (ppn != null && ppn.equalsIgnoreCase("OracleBaby")) {
                this.compile(this.getFullOcmpSqlClassName(), grants, this.ocmpSqlSource);
            }
            this.compile(this.getFullPmClassName(), grants, this.pmSource);
        }
        this.compile(this.getFullEjbObjectClassName(), grants, this.ejbObjectSource);
        this.compile(this.getFullEjbHomeClassName(), grants, this.ejbHomeSource);
        String[] names = new String[]{this.getFullEjbHomeClassName(), this.getEjbHomeHelperClassName()};
        return names;
    }

    private void generateEjbHome() throws EJBGenerationError {
        String[] argv = new String[]{"-forEachClass", "oracle.aurora.ejb.deployment.server.EjbHomeRuntimeGenerator", this.descriptor.getHomeInterfaceClassName()};
        EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
        generator.setGenerationContext(this);
        generator.run();
    }

    private void generateEntityHome() throws EJBGenerationError {
        String[] argv = new String[]{"-forEachClass", "oracle.aurora.ejb.deployment.server.EntityHomeRuntimeGenerator", this.descriptor.getHomeInterfaceClassName()};
        EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
        generator.setGenerationContext(this);
        generator.run();
    }

    private void generateEntityObject() throws EJBGenerationError {
        String[] argv = new String[]{"-forEachClass", "oracle.aurora.ejb.deployment.server.EntityBeanRuntimeGenerator", this.descriptor.getRemoteInterfaceClassName()};
        EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
        generator.setGenerationContext(this);
        generator.run();
    }

    private void generateEntityPm() throws EJBGenerationError {
        String[] argv = new String[3];
        argv[0] = "-forEachClass";
        if (((OracleEntityDescriptor)this.descriptor).getPersistenceType().equalsIgnoreCase("Bean")) {
            argv[1] = "oracle.aurora.ejb.deployment.server.BmpRuntimeGenerator";
            argv[2] = this.descriptor.getHomeInterfaceClassName();
            EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
            generator.setGenerationContext(this);
            generator.run();
        } else if (((OracleEntityDescriptor)this.descriptor).getPersistenceProviderName().equalsIgnoreCase("OracleBaby")) {
            argv[1] = "oracle.aurora.ejb.deployment.server.OcmpRuntimeGenerator";
            argv[2] = this.descriptor.getHomeInterfaceClassName();
            EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
            generator.setGenerationContext(this);
            generator.run();
            argv[1] = "oracle.aurora.ejb.deployment.server.OcmpSqlRuntimeGenerator";
            argv[2] = this.descriptor.getHomeInterfaceClassName();
            generator = new EjbBinaryClassProcessor(this.resolver, argv);
            generator.setGenerationContext(this);
            generator.run();
        }
    }

    private void generateSSEjbObject() throws EJBGenerationError {
        String[] argv = new String[]{"-forEachClass", "oracle.aurora.ejb.deployment.server.EjbSSBeanRuntimeGenerator", this.descriptor.getRemoteInterfaceClassName()};
        EjbBinaryClassProcessor generator = new EjbBinaryClassProcessor(this.resolver, argv);
        generator.setGenerationContext(this);
        generator.run();
    }

    int[][] getACL() {
        if (this.initialized) {
            return this.acl;
        }
        this.init();
        return this.acl;
    }

    void getAllMethods() {
        Vector<MethodInfo> methods = new Vector<MethodInfo>();
        Enumeration interfaces = this.allInterfaces();
        while (interfaces.hasMoreElements()) {
            Class current = (Class)interfaces.nextElement();
            Method[] interfaceMethods = current.getDeclaredMethods();
            int i = 0;
            while (i < interfaceMethods.length) {
                methods.addElement(new MethodInfo(interfaceMethods[i]));
                ++i;
            }
        }
        this.allMethods = new MethodInfo[methods.size()];
        methods.copyInto(this.allMethods);
    }

    boolean getBeanManaged() {
        return this.txnType[0] == 1;
    }

    Enumeration getCreateMethods() {
        if (!this.homeMethodsInit) {
            this.allHomeMethodsInit();
        }
        return this.allCreateMethods.elements();
    }

    String getEjbHomeClassName() {
        String[] parsed = this.parseString(this.descriptor.getHomeInterfaceClassName(), ".");
        String base = parsed[parsed.length - 1];
        return EJB_HOME_BASE_NAME + base;
    }

    String getEjbHomeHelperClassName() {
        String[] names = this.parseString(this.getHomeInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write(names[names.length - 1]);
        stream.write("Helper");
        return stream.toString();
    }

    String getEjbHomeOperationsClassName() {
        String[] names = this.parseString(this.getHomeInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write(names[names.length - 1]);
        stream.write("Operations");
        return stream.toString();
    }

    String getEjbHomePackageName() {
        return this.getGeneratedPackageName();
    }

    String getEjbHomeTieClassName() {
        String[] names = this.parseString(this.getHomeInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write("_tie_");
        stream.write(names[names.length - 1]);
        return stream.toString();
    }

    String getEjbObjectClassName() {
        String[] parsed = this.parseString(this.descriptor.getRemoteInterfaceClassName(), ".");
        String base = parsed[parsed.length - 1];
        return EJB_OBJECT_BASE_NAME + base;
    }

    String getEjbObjectOperationsClassName() {
        String[] names = this.parseString(this.getRemoteInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write(names[names.length - 1]);
        stream.write("Operations");
        return stream.toString();
    }

    String getEjbObjectPackageName() {
        return this.getGeneratedPackageName();
    }

    String getEjbObjectTieClassName() {
        String[] names = this.parseString(this.getRemoteInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write("_tie_");
        stream.write(names[names.length - 1]);
        return stream.toString();
    }

    String getEnterpriseBeanClassName() {
        return this.descriptor.getEnterpriseBeanClassName();
    }

    private void getErrors(String classname) throws EJBGenerationError {
        classname = classname.replace('.', '/');
        Connection conn = null;
        CallableStatement call = null;
        ResultSet rset = null;
        boolean errors = false;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                conn = new OracleDriver().defaultConnection();
                call = conn.prepareCall("{ ? = call get_error$.error_lines (?)}");
                call.registerOutParameter(1, -10);
                call.setString(2, classname);
                call.execute();
                rset = (ResultSet)call.getObject(1);
                boolean firstMsg = true;
                while (rset.next()) {
                    errors = true;
                    if (firstMsg) {
                        firstMsg = false;
                        sb.append("Compilation errors in " + classname + ":");
                    }
                    sb.append(rset.getString(1));
                }
            }
            catch (SQLException e) {
                GenerationErrors.error("SQL error in retrieving errors for : " + classname + " : " + e.getMessage());
            }
            Object var8_9 = null;
            this.close(call);
            this.close(rset);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.close(call);
            this.close(rset);
            throw throwable;
        }
        if (errors) {
            GenerationErrors.error(sb.toString());
        }
    }

    MethodInfo getFindByPrimaryKeyMethod() {
        if (!this.homeMethodsInit) {
            this.allHomeMethodsInit();
        }
        return this.findByPrimaryKeyMethod;
    }

    Enumeration getFinderMethods() {
        if (!this.homeMethodsInit) {
            this.allHomeMethodsInit();
        }
        return this.allFinderMethods.elements();
    }

    String getFullEjbHomeClassName() {
        String packageName = this.getEjbHomePackageName();
        String objectName = this.getEjbHomeClassName();
        if (packageName.length() == 0) {
            return objectName;
        }
        return String.valueOf(packageName) + '.' + objectName;
    }

    String getFullEjbObjectClassName() {
        String packageName = this.getEjbObjectPackageName();
        String objectName = this.getEjbObjectClassName();
        if (packageName.length() == 0) {
            return objectName;
        }
        return String.valueOf(packageName) + '.' + objectName;
    }

    String getFullOcmpSqlClassName() {
        String packageName = this.getPmPackageName();
        String[] parsed = this.parseString(this.descriptor.getRemoteInterfaceClassName(), ".");
        String base = parsed[parsed.length - 1];
        if (packageName.length() == 0) {
            return EJB_OCMP_SQL_BASE_NAME + base;
        }
        return String.valueOf(packageName) + '.' + EJB_OCMP_SQL_BASE_NAME + base;
    }

    String getFullPmClassName() {
        String packageName = this.getPmPackageName();
        String objectName = this.getPmClassName();
        if (packageName.length() == 0) {
            return objectName;
        }
        return String.valueOf(packageName) + '.' + objectName;
    }

    String getGeneratedPackageName() {
        return "oracle.aurora.ejb.gen." + this.getJndiNameString();
    }

    String getHelperClassName() {
        String[] names = this.parseString(this.getRemoteInterfaceClassName(), ".");
        StringWriter stream = new StringWriter();
        int i = 0;
        while (i < names.length - 1) {
            stream.write(String.valueOf(names[i]) + '.');
            ++i;
        }
        stream.write(names[names.length - 1]);
        stream.write("Helper");
        return stream.toString();
    }

    Class getHomeInterfaceClass() {
        try {
            return this.loader.loadClass(this.descriptor.getHomeInterfaceClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    String getHomeInterfaceClassName() {
        return this.descriptor.getHomeInterfaceClassName();
    }

    String getHomeInterfacePackageName() {
        String[] names = this.parseString(this.descriptor.getHomeInterfaceClassName(), ".");
        if (names.length == 1) {
            return "";
        }
        String packageName = names[0];
        int i = 1;
        while (i < names.length - 1) {
            packageName = String.valueOf(packageName) + '.' + names[i];
            ++i;
        }
        return packageName;
    }

    int[] getIsolationLevel() {
        return this.isolationLevel;
    }

    String getJndiNameString() {
        return this.mangle(this.descriptor.getBeanHomeName().toString());
    }

    OcmpBeanMapping getOcmpBeanMapping() {
        if (this.descriptor instanceof OracleEntityDescriptor && ((OracleEntityDescriptor)this.descriptor).getPersistenceProviderName().equalsIgnoreCase("Oraclebaby")) {
            Object[] params = ((OracleEntityDescriptor)this.descriptor).getParams();
            int i = 0;
            while (i < params.length) {
                if (params[i] instanceof OcmpBeanMapping) {
                    return (OcmpBeanMapping)params[i];
                }
                ++i;
            }
        }
        return null;
    }

    String getOcmpSqlClassName() {
        String[] parsed = this.parseString(this.descriptor.getRemoteInterfaceClassName(), ".");
        String base = parsed[parsed.length - 1];
        return EJB_OCMP_SQL_BASE_NAME + base;
    }

    String getPmClassName() {
        if (((OracleEntityDescriptor)this.descriptor).getPersistenceType().equalsIgnoreCase("Container")) {
            String[] parsed = this.parseString(((OracleEntityDescriptor)this.descriptor).getPersistenceManager(), ".");
            return parsed[parsed.length - 1];
        }
        String[] parsed = this.parseString(this.descriptor.getRemoteInterfaceClassName(), ".");
        String base = parsed[parsed.length - 1];
        return EJB_BMP_BASE_NAME + base;
    }

    String getPmPackageName() {
        return this.getGeneratedPackageName();
    }

    String getPrimaryKeyClassName() {
        return ((EntityDescriptor)this.descriptor).getPrimaryKeyClassName();
    }

    String[] getPrimaryKeyFields() {
        try {
            Class<?> cl = this.loader.loadClass(this.getPrimaryKeyClassName());
            if (cl.isPrimitive()) {
                String[] ret = new String[]{cl.toString()};
                return ret;
            }
            Field[] f = cl.getDeclaredFields();
            String[] ret = new String[f.length];
            int i = 0;
            while (i < f.length) {
                String[] parsed = this.parseString(f[i].toString(), ".");
                ret[i] = parsed[parsed.length - 1];
                ++i;
            }
            return ret;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    String[][] getProps() {
        return this.props;
    }

    String getRemoteInterfaceClassName() {
        return this.descriptor.getRemoteInterfaceClassName();
    }

    String getRemoteInterfacePackageName() {
        String[] names = this.parseString(this.descriptor.getRemoteInterfaceClassName(), ".");
        if (names.length == 1) {
            return "";
        }
        String packageName = names[0];
        int i = 1;
        while (i < names.length - 1) {
            packageName = String.valueOf(packageName) + '.' + names[i];
            ++i;
        }
        return packageName;
    }

    MethodInfo getRemoveMethodOnBean() {
        Method m;
        Class<?> remoteInterface;
        try {
            remoteInterface = this.loader.loadClass(this.getRemoteInterfaceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new JasperGenerationError(String.valueOf(e.getClass().getName()) + " : Remote Interface not found: " + this.getRemoteInterfaceClassName() + " : " + e.getMessage());
        }
        try {
            m = remoteInterface.getMethod("remove", null);
        }
        catch (NoSuchMethodException e) {
            throw new JasperGenerationError(String.valueOf(e.getClass().getName()) + " : Remove method not found: " + this.getRemoteInterfaceClassName() + " : " + e.getMessage());
        }
        return new MethodInfo(m);
    }

    int[] getRunAs() {
        return this.runAs;
    }

    int[] getRunAsMode() {
        return this.runAsMode;
    }

    String getSuperclassName() {
        if (this.descriptor instanceof SessionDescriptor) {
            return "oracle.aurora.ejb.server.AuroraStatefulSessionBean";
        }
        return "oracle.aurora.ejb.server.AuroraEntityBean";
    }

    boolean getSync() {
        try {
            Class<?> theClass = this.loader.loadClass(this.descriptor.getEnterpriseBeanClassName());
            return (class$javax$ejb$SessionSynchronization != null ? class$javax$ejb$SessionSynchronization : (class$javax$ejb$SessionSynchronization = BeanGenerator.class$("javax.ejb.SessionSynchronization"))).isAssignableFrom(theClass);
        }
        catch (Exception exception) {
            return false;
        }
    }

    int getTimeout() {
        if (this.descriptor instanceof SessionDescriptor) {
            return Math.max(((SessionDescriptor)this.descriptor).getSessionTimeout(), 0);
        }
        return 0;
    }

    void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.getAllMethods();
        int i = 1;
        while (i < this.allMethods.length + 1) {
            this.methodIndex.put(this.allMethods[i - 1], new Integer(i));
            ++i;
        }
        int size = this.allMethods.length + 1;
        this.acl = new int[size][];
        this.runAs = new int[size];
        this.runAsMode = new int[size];
        this.isolationLevel = new int[size];
        this.txnType = new int[size];
        AccessControlEntry[] theACL = this.acl();
        ControlDescriptor[] theCDL = this.cdl();
        int i2 = 0;
        while (i2 < theACL.length) {
            if (theACL[i2] != null) {
                MethodInfo method = this.translateMethod(theACL[i2].getMethod());
                if (method == null) {
                    this.acl[0] = this.mapUsers(theACL[i2].getAllowedIdentities());
                } else {
                    this.acl[this.methodIndex((MethodInfo)method)] = this.mapUsers(theACL[i2].getAllowedIdentities());
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < theCDL.length) {
            if (theCDL[i3] != null) {
                MethodInfo method = this.translateMethod(theCDL[i3].getMethod());
                if (method == null) {
                    this.runAsMode[0] = theCDL[i3].getRunAsMode();
                    this.runAs[0] = this.mapUser(theCDL[i3].getRunAsIdentity());
                    this.txnType[0] = theCDL[i3].getTransactionAttribute();
                    this.isolationLevel[0] = theCDL[i3].getIsolationLevel();
                } else {
                    this.runAsMode[this.methodIndex((MethodInfo)method)] = theCDL[i3].getRunAsMode();
                    this.runAs[this.methodIndex((MethodInfo)method)] = this.mapUser(theCDL[i3].getRunAsIdentity());
                    this.txnType[this.methodIndex((MethodInfo)method)] = theCDL[i3].getTransactionAttribute();
                    this.isolationLevel[this.methodIndex((MethodInfo)method)] = theCDL[i3].getIsolationLevel();
                }
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < size) {
            if (this.acl[i4] == null) {
                this.acl[i4] = this.acl[0];
                this.runAs[i4] = this.runAs[0];
                this.runAsMode[i4] = this.runAsMode[0];
                this.isolationLevel[i4] = this.isolationLevel[0];
                this.txnType[i4] = this.txnType[0];
            }
            ++i4;
        }
        Properties environment = this.descriptor.getEnvironmentProperties();
        this.props = new String[((Hashtable)environment).size()][2];
        int i5 = 0;
        Enumeration keys = ((Hashtable)environment).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)((Hashtable)environment).get(key);
            this.props[i5][0] = key;
            this.props[i5][1] = value;
            ++i5;
        }
    }

    private String mangle(String string) {
        return string.replace('/', '_');
    }

    private int mapUser(Identity user) {
        if (user == null) {
            return -1;
        }
        return (Integer)this.userMap.get(user.getName().toUpperCase());
    }

    private void mapUsers() throws EJBGenerationError {
        ControlDescriptor[] cd = this.descriptor.getControlDescriptors();
        Integer defaultMapping = new Integer(-1);
        int i = 0;
        while (i < cd.length) {
            switch (cd[i].getRunAsMode()) {
                case 2: {
                    if (!DbmsRealm.theLoginSchema.resolvesTo((Object)DbmsRealm.theSystemSchema)) {
                        GenerationErrors.fail0("MUST_BE_SYS_TO_RUNAS_SYS");
                    }
                    this.userMap.put("SYS", defaultMapping);
                    break;
                }
                case 1: {
                    Identity runAsId = cd[i].getRunAsIdentity();
                    String schema = runAsId.getName().toUpperCase();
                    if (!DbmsRealm.theLoginSchema.resolvesTo((Object)DbmsRealm.theSystemSchema) && !DbmsRealm.theLoginSchema.resolvesTo((Object)Schema.lookup((String)schema))) {
                        GenerationErrors.fail1("CANNOT_GRANT_RUNAS_TO", schema);
                    }
                    this.userMap.put(schema, defaultMapping);
                    break;
                }
            }
            ++i;
        }
        AccessControlEntry[] acl = this.descriptor.getAccessControlEntries();
        int i2 = 0;
        while (i2 < acl.length) {
            Identity[] ids = acl[i2].getAllowedIdentities();
            int j = 0;
            while (j < ids.length) {
                this.userMap.put(ids[j].getName().toUpperCase(), defaultMapping);
                ++j;
            }
            ++i2;
        }
        String[] user_names = new String[this.userMap.size()];
        Enumeration users = this.userMap.keys();
        int i3 = 0;
        while (i3 < user_names.length) {
            user_names[i3] = (String)users.nextElement();
            ++i3;
        }
        int[] schemas = this.translateUsers(user_names);
        boolean badUser = false;
        int i4 = 0;
        while (i4 < schemas.length) {
            if (schemas[i4] == -1) {
                GenerationErrors.fail1("INVALID_USER", user_names[i4]);
            }
            this.userMap.put(user_names[i4], new Integer(schemas[i4]));
            ++i4;
        }
    }

    private int[] mapUsers(Identity[] users) {
        int[] mapped = new int[users.length];
        int i = 0;
        while (i < users.length) {
            mapped[i] = this.mapUser(users[i]);
            ++i;
        }
        return mapped;
    }

    int methodIndex(MethodInfo method) {
        this.init();
        Integer index = (Integer)this.methodIndex.get(method);
        if (index == null) {
            return 0;
        }
        return index;
    }

    private String[] parseString(String string, String separators) {
        StringTokenizer toker = new StringTokenizer(string, separators);
        int count = toker.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = toker.nextToken();
            ++i;
        }
        return result;
    }

    void setEjbHomeSource(String sourceString) {
        this.ejbHomeSource = sourceString;
        if (Boolean.getBoolean("EJBDeploymentDebug")) {
            System.out.println(this.ejbHomeSource);
        }
    }

    void setEjbObjectSource(String sourceString) {
        this.ejbObjectSource = sourceString;
        if (Boolean.getBoolean("EJBDeploymentDebug")) {
            System.out.println(this.ejbObjectSource);
        }
    }

    void setOcmpSqlSource(String sourceString) {
        this.ocmpSqlSource = sourceString;
        if (Boolean.getBoolean("EJBDeploymentDebug")) {
            System.out.println(this.ocmpSqlSource);
        }
    }

    void setPmSource(String sourceString) {
        this.pmSource = sourceString;
        if (Boolean.getBoolean("EJBDeploymentDebug")) {
            System.out.println(this.pmSource);
        }
    }

    private MethodInfo translateMethod(Method m) {
        if (m == null) {
            return null;
        }
        if (m.getName().equals("ejbCreate")) {
            try {
                m = this.getHomeInterfaceClass().getMethod("create", m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JasperGenerationError("Cannot find create method");
            }
        }
        return new MethodInfo(m);
    }

    public int[] translateUsers(String[] userNames) {
        Connection conn = null;
        try {
            conn = new OracleDriver().defaultConnection();
        }
        catch (SQLException sQLException) {}
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int[] ids = new int[userNames.length];
        try {
            try {
                pstmt = conn.prepareStatement("select user# from user$ where name = ?");
                int i = 0;
                while (i < ids.length) {
                    if (userNames[i].equals("PUBLIC")) {
                        ids[i] = 1;
                    } else {
                        pstmt.setString(1, userNames[i]);
                        pstmt.execute();
                        rs = pstmt.getResultSet();
                        ids[i] = rs.next() ? rs.getInt(1) : -1;
                    }
                    ++i;
                }
                this.close(rs);
                this.close(pstmt);
                int[] nArray = ids;
                Object var8_9 = null;
                this.close(pstmt);
                this.close(rs);
                return nArray;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.close(pstmt);
                this.close(rs);
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    int txnType(MethodInfo method) {
        return this.txnType[this.methodIndex(method)];
    }
}

