/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.xobject;

import com.sun.symon.base.xobject.XEnumeration;
import com.sun.symon.base.xobject.XHashEntry;
import java.util.Hashtable;
import java.util.Vector;

class XHashtable {
    static XHashEntry Dummy = null;
    XHashEntry[] Entries;
    private int Occupied;
    private int ObjectCount;
    private int TableMask;
    private String[] Slices;
    private int SliceCount;
    private int[] SliceIndex;
    private int SliceIndexer;

    XHashtable() {
        if (Dummy == null) {
            Dummy = new XHashEntry();
        }
        this.TableMask = 7;
        this.Entries = new XHashEntry[this.TableMask + 1];
        this.Slices = new String[2];
        this.SliceIndex = new int[2];
        this.clear();
    }

    void clear() {
        int n = 0;
        while (n <= this.TableMask) {
            this.Entries[n] = null;
            ++n;
        }
        this.ObjectCount = 0;
        this.Occupied = 0;
        int n2 = 0;
        while (n2 < this.Slices.length) {
            this.Slices[n2] = null;
            this.SliceIndex[n2] = -1;
            ++n2;
        }
        this.SliceIndexer = 0;
        this.SliceCount = 0;
    }

    void compareSlice(String string, String string2, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Object object;
        int n = this.findSlice(string, false);
        int n2 = this.findSlice(string2, false);
        if (n < 0) {
            this.sliceEntries(string2, hashtable);
            return;
        }
        if (n2 < 0) {
            this.sliceEntries(string, hashtable2);
            return;
        }
        Hashtable<String, XHashEntry> hashtable4 = new Hashtable<String, XHashEntry>();
        int n3 = 0;
        while (n3 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n3];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n2) {
                hashtable4.put(xHashEntry.Key, xHashEntry);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 <= this.TableMask) {
            object = this.Entries[n4];
            if (object != null && object != Dummy && ((XHashEntry)object).SliceCode == n) {
                if (hashtable4.containsKey(((XHashEntry)object).Key)) {
                    hashtable3.put(((XHashEntry)object).Key, ((XHashEntry)object).Value);
                    hashtable4.remove(((XHashEntry)object).Key);
                } else {
                    hashtable2.put(((XHashEntry)object).Key, ((XHashEntry)object).Value);
                }
            }
            ++n4;
        }
        object = hashtable4.elements();
        while (object.hasMoreElements()) {
            XHashEntry xHashEntry = (XHashEntry)object.nextElement();
            hashtable.put(xHashEntry.Key, xHashEntry.Value);
        }
    }

    boolean containsKey(String string, String string2) {
        return this.findKey(string, string2, false) != null;
    }

    void copySlice(String string, String string2) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return;
        }
        int n2 = this.findSlice(string2, true);
        Vector<XHashEntry> vector = new Vector<XHashEntry>();
        int n3 = 0;
        while (n3 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n3];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n) {
                vector.addElement(xHashEntry);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            XHashEntry xHashEntry = (XHashEntry)vector.elementAt(n4);
            XHashEntry xHashEntry2 = this.fastFindKey(n2, xHashEntry.Key, true);
            xHashEntry2.Value = xHashEntry.Value;
            ++n4;
        }
    }

    XEnumeration enumerate(String string) {
        int n;
        if (string == null) {
            n = -1;
        } else {
            n = this.findSlice(string, false);
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
        }
        String[] stringArray = new String[this.SliceIndexer];
        int n2 = 0;
        while (n2 < this.SliceCount) {
            stringArray[this.SliceIndex[n2]] = this.Slices[n2];
            ++n2;
        }
        return new XEnumeration(n, stringArray, this.Entries, this.TableMask + 1);
    }

    private void expand() {
        this.Occupied = this.ObjectCount;
        int n = this.TableMask;
        this.TableMask = this.TableMask << 1 | 1;
        XHashEntry[] xHashEntryArray = new XHashEntry[this.TableMask + 1];
        int n2 = 0;
        while (n2 <= this.TableMask) {
            xHashEntryArray[n2] = null;
            ++n2;
        }
        int n3 = 0;
        while (n3 <= n) {
            XHashEntry xHashEntry = this.Entries[n3];
            if (xHashEntry != null && xHashEntry != Dummy) {
                int n4 = xHashEntry.KeyHashCode << 2 | xHashEntry.SliceCode & 3;
                int n5 = n4 & this.TableMask;
                if (xHashEntryArray[n5] != null) {
                    int n6 = n4 % (this.TableMask - 2) + 2 | 1;
                    while (xHashEntryArray[n5 = n5 + n6 & this.TableMask] != null) {
                    }
                }
                xHashEntryArray[n5] = xHashEntry;
            }
            ++n3;
        }
        this.Entries = xHashEntryArray;
    }

    private XHashEntry fastFindKey(int n, String string, boolean bl) {
        int n2 = string.hashCode();
        int n3 = n2 << 2 | n & 3;
        XHashEntry xHashEntry = null;
        int n4 = n3 & this.TableMask;
        int n5 = -1;
        xHashEntry = this.Entries[n4];
        if (xHashEntry != null) {
            int n6 = n3 % (this.TableMask - 2) + 2 | 1;
            do {
                if (xHashEntry == Dummy) {
                    if (n5 >= 0) continue;
                    n5 = n4;
                    continue;
                }
                if (xHashEntry.SliceCode == n && xHashEntry.KeyHashCode == n2 && xHashEntry.Key.compareTo(string) == 0) break;
            } while ((xHashEntry = this.Entries[n4 = n4 + n6 & this.TableMask]) != null);
        }
        if (xHashEntry != null) {
            return xHashEntry;
        }
        if (bl) {
            ++this.ObjectCount;
            xHashEntry = new XHashEntry(n, n2, string);
            if (n5 < 0) {
                ++this.Occupied;
                this.Entries[n4] = xHashEntry;
                if (this.Occupied + (this.Occupied >>> 1) > this.TableMask) {
                    this.expand();
                }
            } else {
                this.Entries[n5] = xHashEntry;
            }
            return xHashEntry;
        }
        return null;
    }

    XHashEntry findKey(String string, String string2, boolean bl) {
        int n = this.findSlice(string, bl);
        if (n < 0) {
            return null;
        }
        return this.fastFindKey(n, string2, bl);
    }

    /*
     * Unable to fully structure code
     */
    int findSlice(String var1_1, boolean var2_2) {
        if (this.SliceCount == 0) {
            if (var2_2) {
                var3_3 = this.getNextSliceIndex();
                ++this.SliceCount;
                this.Slices[0] = var1_1;
                this.SliceIndex[0] = var3_3;
                return var3_3;
            }
            return -1;
        }
        var3_4 = 0;
        var4_5 = this.Slices[0].compareTo(var1_1);
        if (var4_5 == 0) {
            return this.SliceIndex[0];
        }
        if (var4_5 > 0) {
            if (var2_2) {
                var5_6 = this.getNextSliceIndex();
                if (this.SliceCount == this.Slices.length) {
                    var6_8 = new String[this.SliceCount + 2];
                    System.arraycopy(this.Slices, 0, var6_8, 1, this.SliceCount);
                    this.Slices = var6_8;
                    var7_10 = new int[this.SliceCount + 2];
                    System.arraycopy(this.SliceIndex, 0, var7_10, 1, this.SliceCount);
                    this.SliceIndex = var7_10;
                } else {
                    System.arraycopy(this.Slices, 0, this.Slices, 1, this.SliceCount);
                    System.arraycopy(this.SliceIndex, 0, this.SliceIndex, 1, this.SliceCount);
                }
                ++this.SliceCount;
                this.Slices[0] = var1_1;
                this.SliceIndex[0] = var5_6;
                return var5_6;
            }
            return -1;
        }
        var5_7 = this.SliceCount - 1;
        var6_9 = this.Slices[var5_7].compareTo(var1_1);
        if (var6_9 == 0) {
            return this.SliceIndex[var5_7];
        }
        if (var6_9 >= 0) ** GOTO lbl58
        if (var2_2) {
            var7_11 = this.getNextSliceIndex();
            if (this.SliceCount == this.Slices.length) {
                var8_13 = new String[this.SliceCount + 2];
                System.arraycopy(this.Slices, 0, var8_13, 0, this.SliceCount);
                this.Slices = var8_13;
                var9_16 = new int[this.SliceCount + 2];
                System.arraycopy(this.SliceIndex, 0, var9_16, 0, this.SliceCount);
                this.SliceIndex = var9_16;
            }
            var5_7 = this.SliceCount++;
            this.Slices[var5_7] = var1_1;
            this.SliceIndex[var5_7] = var7_11;
            return var7_11;
        }
        return -1;
lbl-1000:
        // 1 sources

        {
            var7_12 = (var5_7 + var3_4) / 2;
            var8_14 = this.Slices[var7_12].compareTo(var1_1);
            if (var8_14 == 0) {
                return this.SliceIndex[var7_12];
            }
            if (var8_14 > 0) {
                var5_7 = var7_12;
                continue;
            }
            var3_4 = var7_12;
lbl58:
            // 3 sources

            ** while (var5_7 - var3_4 > 1)
        }
lbl59:
        // 1 sources

        if (var2_2) {
            var7_12 = this.getNextSliceIndex();
            if (this.SliceCount == this.Slices.length) {
                var8_15 = new String[this.SliceCount + 2];
                System.arraycopy(this.Slices, 0, var8_15, 0, this.SliceCount);
                this.Slices = var8_15;
                var9_17 = new int[this.SliceCount + 2];
                System.arraycopy(this.SliceIndex, 0, var9_17, 0, this.SliceCount);
                this.SliceIndex = var9_17;
            }
            System.arraycopy(this.Slices, var5_7, this.Slices, var5_7 + 1, this.SliceCount - var5_7);
            System.arraycopy(this.SliceIndex, var5_7, this.SliceIndex, var5_7 + 1, this.SliceCount - var5_7);
            ++this.SliceCount;
            this.Slices[var5_7] = var1_1;
            this.SliceIndex[var5_7] = var7_12;
            return var7_12;
        }
        return -1;
    }

    String get(String string, String string2, String string3) {
        XHashEntry xHashEntry = this.findKey(string, string2, false);
        if (xHashEntry == null) {
            return string3;
        }
        return xHashEntry.Value;
    }

    int getNextSliceIndex() {
        if (this.SliceCount == this.SliceIndexer) {
            return this.SliceIndexer++;
        }
        byte[] byArray = new byte[this.SliceIndexer];
        int n = 0;
        while (n < this.SliceIndexer) {
            byArray[n] = 1;
            ++n;
        }
        n = 0;
        while (n < this.SliceCount) {
            byArray[this.SliceIndex[n]] = 0;
            ++n;
        }
        n = 0;
        while (n < this.SliceIndexer) {
            if (byArray[n] != 0) {
                return n;
            }
            ++n;
        }
        System.err.println("Slice indexing failure!");
        return -1;
    }

    boolean isEmpty() {
        return this.ObjectCount == 0;
    }

    boolean isEmpty(String string) {
        return this.sliceCount(string) == 0;
    }

    Vector keys(String string) {
        Vector<String> vector = new Vector<String>();
        int n = this.findSlice(string, false);
        if (n < 0) {
            return vector;
        }
        int n2 = 0;
        while (n2 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n2];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n) {
                vector.addElement(xHashEntry.Key);
            }
            ++n2;
        }
        return vector;
    }

    void mergeInto(String string, Hashtable hashtable) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return;
        }
        int n2 = 0;
        while (n2 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n2];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n && !hashtable.containsKey(xHashEntry.Key)) {
                hashtable.put(xHashEntry.Key, xHashEntry.Value);
            }
            ++n2;
        }
    }

    void put(String string, String string2, String string3) {
        XHashEntry xHashEntry = this.findKey(string, string2, true);
        xHashEntry.Value = string3;
    }

    void remove(String string) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return;
        }
        int n2 = 0;
        while (n2 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n2];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n) {
                this.Entries[n2] = Dummy;
                --this.ObjectCount;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.SliceCount) {
            if (this.SliceIndex[n3] == n) {
                --this.SliceCount;
                System.arraycopy(this.Slices, n3 + 1, this.Slices, n3, this.SliceCount - n3);
                System.arraycopy(this.SliceIndex, n3 + 1, this.SliceIndex, n3, this.SliceCount - n3);
                this.Slices[this.SliceCount] = null;
                this.SliceIndex[this.SliceCount] = -1;
                if (n3 != this.SliceIndexer - 1) break;
                --this.SliceIndexer;
                break;
            }
            ++n3;
        }
    }

    void remove(String string, String string2) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return;
        }
        int n2 = string2.hashCode();
        int n3 = n2 << 2 | n & 3;
        XHashEntry xHashEntry = null;
        int n4 = n3 & this.TableMask;
        xHashEntry = this.Entries[n4];
        if (xHashEntry != null) {
            int n5 = n3 % (this.TableMask - 2) + 2 | 1;
            while ((xHashEntry == Dummy || xHashEntry.SliceCode != n || xHashEntry.KeyHashCode != n2 || xHashEntry.Key.compareTo(string2) != 0) && (xHashEntry = this.Entries[n4 = n4 + n5 & this.TableMask]) != null) {
            }
        }
        if (xHashEntry != null) {
            this.Entries[n4] = Dummy;
            --this.ObjectCount;
            if (this.isEmpty(string)) {
                this.remove(string);
            }
        }
    }

    int size() {
        return this.ObjectCount;
    }

    int sliceCount(String string) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n3];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    void sliceEntries(String string, Hashtable hashtable) {
        int n = this.findSlice(string, false);
        if (n < 0) {
            return;
        }
        int n2 = 0;
        while (n2 <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n2];
            if (xHashEntry != null && xHashEntry != Dummy && xHashEntry.SliceCode == n) {
                hashtable.put(xHashEntry.Key, xHashEntry.Value);
            }
            ++n2;
        }
    }

    Vector slices() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.SliceCount) {
            vector.addElement(this.Slices[n]);
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("XHashtable: TableMask " + this.TableMask + ", ObjectCount " + this.ObjectCount + ", Occupied " + this.Occupied + "\n");
        int n = 0;
        while (n <= this.TableMask) {
            XHashEntry xHashEntry = this.Entries[n];
            if (xHashEntry != null && xHashEntry != Dummy) {
                stringBuffer.append("Key at " + n + "=> " + xHashEntry + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

