/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security;

import com.sun.symon.base.utility.UcDDL;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class SyKeyExchange {
    private static final int MAXIMUM_SIZE = 128;

    public static byte[] apply(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[128];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - byArray3.length];
        System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
        return SyKeyExchange.delta(byArray, byArray3, byArray4);
    }

    public static byte[] create(byte[] byArray, byte[] byArray2) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray3 = new byte[128];
        secureRandom.nextBytes(byArray3);
        byte[] byArray4 = SyKeyExchange.delta(byArray, byArray3, byArray2);
        if (byArray4 == null) {
            UcDDL.logErrorMessage("unable to create key difference");
            return null;
        }
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
        return byArray5;
    }

    private static byte[] delta(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage("unable to get MD5 algorithm", exception);
            return null;
        }
        byte[] byArray4 = new byte[byArray3.length];
        byte[] byArray5 = byArray;
        int n2 = (byArray3.length - 1) / 16;
        int n3 = 0;
        while (n3 < n2) {
            messageDigest.update(byArray5);
            byArray5 = messageDigest.digest(byArray2);
            n = 0;
            while (n < 16) {
                byArray4[n3 * 16 + n] = (byte)((byArray5[n] & 0xFF ^ byArray3[n3 * 16 + n] & 0xFF) & 0xFF);
                ++n;
            }
            ++n3;
        }
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest(byArray2);
        n = 0;
        while (n < byArray3.length - n2 * 16) {
            byArray4[n + n2 * 16] = (byte)((byArray5[n] & 0xFF ^ byArray3[n + n2 * 16] & 0xFF) & 0xFF);
            ++n;
        }
        return byArray4;
    }
}

