/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CvFontEditor
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener {
    public static Font DEFAULTFONT = new Font("Serif", 0, 12);
    private String i18nText = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nText");
    private String i18nSize = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nSize");
    private String i18nName = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nName");
    private String i18nStyle = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nStyle");
    JTextField sampleArea = new JTextField("Sample text");
    Font selectFont = DEFAULTFONT;
    Vector sizes = new Vector();
    Vector fontNames = new Vector();
    JCheckBox plain = new JCheckBox(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.style.plain"));
    JCheckBox bold = new JCheckBox(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.style.bold"));
    JCheckBox italic = new JCheckBox(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.style.italic"));
    JPanel styleList = new JPanel();
    JList fontList;
    JList sizeList;
    JComboBox textList = new JComboBox();
    String[] legendTexts;
    boolean usedForLegend = false;
    String delimit = "^";

    public CvFontEditor() {
        this.setups();
    }

    public CvFontEditor(Font font) {
        this.selectFont = font;
        this.setups();
    }

    public CvFontEditor(boolean bl) {
        this.usedForLegend = bl;
        this.setups();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource() == this.plain) {
            if (this.plain.isSelected()) {
                n = 0;
                this.bold.setSelected(false);
                this.italic.setSelected(false);
            }
        } else if (actionEvent.getSource() == this.bold) {
            if (this.bold.isSelected()) {
                n = 1;
                this.plain.setSelected(false);
            }
            if (this.italic.isSelected()) {
                n = 2;
                this.plain.setSelected(false);
            }
        } else if (actionEvent.getSource() == this.italic) {
            if (this.italic.isSelected()) {
                n = 2;
                this.plain.setSelected(false);
            }
            if (this.bold.isSelected()) {
                n = 1;
                this.plain.setSelected(false);
            }
        }
        if (this.bold.isSelected() && this.italic.isSelected()) {
            n = 3;
            this.plain.setSelected(false);
        }
        if (!(this.bold.isSelected() || this.italic.isSelected() || this.plain.isSelected())) {
            n = 0;
        }
        this.selectFont = new Font(this.selectFont.getName(), n, this.selectFont.getSize());
        this.update();
    }

    private void addRow(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
    }

    public String getConfiguration() {
        return String.valueOf(this.getSampleText()) + this.delimit + this.getFontConfiguration();
    }

    public String getFontConfiguration() {
        String string = this.selectFont.getName();
        String string2 = new Integer(this.selectFont.getSize()).toString();
        String string3 = "plain";
        if (this.selectFont.getStyle() == 0) {
            string3 = "plain";
        } else if (this.selectFont.getStyle() == 1) {
            string3 = "bold";
        } else if (this.selectFont.getStyle() == 2) {
            string3 = "italic";
        } else if (this.selectFont.getStyle() == 3) {
            string3 = "bolditalic";
        }
        return String.valueOf(string3) + this.delimit + string + this.delimit + string2;
    }

    public String getSampleText() {
        return this.sampleArea.getText();
    }

    public Font getSelectFont() {
        return this.selectFont;
    }

    private int getSelectedFontIndex(String string) {
        if (string.equals("SansSerif")) {
            return 1;
        }
        if (string.equals("Monospaced")) {
            return 2;
        }
        return 0;
    }

    private String getSelectedFontName(int n) {
        if (n == 1) {
            return "SansSerif";
        }
        if (n == 2) {
            return "Monospaced";
        }
        return "Serif";
    }

    public int getSelectedIndex() {
        return this.textList.getSelectedIndex();
    }

    public JComboBox getTextList() {
        return this.textList;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.update();
    }

    private JList makeFontList() {
        this.fontNames.addElement(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.name.Serif"));
        this.fontNames.addElement(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.name.SansSerif"));
        this.fontNames.addElement(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:font.name.Monospaced"));
        JList jList = new JList(this.fontNames);
        int n = 0;
        while (n < this.fontNames.size()) {
            String string = (String)this.fontNames.elementAt(n);
            ++n;
        }
        jList.setSelectedIndex(this.getSelectedFontIndex(this.selectFont.getName()));
        jList.setVisibleRowCount(3);
        return jList;
    }

    private JPanel makeFontPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.add(this.styleList);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.fontList);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.sizeList);
        jPanel3.add(jScrollPane);
        jPanel4.add(jScrollPane2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.i18nStyle));
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.i18nName));
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.i18nSize));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel makeSamplePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.setLayout(gridBagLayout);
        if (!this.usedForLegend) {
            this.addRow(jPanel, gridBagLayout, gridBagConstraints, this.sampleArea, new JLabel());
        } else {
            this.addRow(jPanel, gridBagLayout, gridBagConstraints, this.sampleArea, this.textList);
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(this.i18nText));
        return jPanel;
    }

    private JList makeSizeList() {
        Object object;
        this.sizes = new Vector();
        String string = "";
        int n = 6;
        while (n < 27) {
            object = new Integer(n).toString();
            this.sizes.addElement(object);
            n += 2;
        }
        object = new JList(this.sizes);
        String string2 = new Integer(this.selectFont.getSize()).toString();
        ((JList)object).setSelectedValue(string2, true);
        int n2 = ((JList)object).getSelectedIndex();
        ((JList)object).ensureIndexIsVisible(n2);
        ((JList)object).setFixedCellWidth(60);
        ((JList)object).setVisibleRowCount(3);
        return object;
    }

    private JPanel makeStyleList() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.plain);
        jPanel.add(this.bold);
        jPanel.add(this.italic);
        return jPanel;
    }

    private void resetFontSelection() {
        String string;
        this.plain.setSelected(this.selectFont.getStyle() == 0);
        this.bold.setSelected(this.selectFont.getStyle() == 1);
        this.italic.setSelected(this.selectFont.getStyle() == 2);
        if (this.selectFont.getStyle() == 3) {
            this.bold.setSelected(true);
            this.italic.setSelected(true);
        }
        if ((string = this.selectFont.getName()).equals("Serif") || string.equals("SansSerif") || string.equals("Monospaced")) {
            this.fontList.setSelectedValue(string, true);
        } else {
            this.fontList.setSelectedValue("Serif", true);
        }
        this.sizeList.setSelectedValue(new Integer(this.selectFont.getSize()).toString(), true);
        int n = this.sizeList.getSelectedIndex();
        this.sizeList.ensureIndexIsVisible(n);
    }

    public void setSampleText(String string) {
        this.sampleArea.setText(string);
        this.update();
    }

    public void setSelectFont(Font font) {
        this.selectFont = font;
        this.resetFontSelection();
    }

    public void setTextList(String[] stringArray) {
        this.textList.removeAllItems();
        this.legendTexts = stringArray;
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:first"));
            } else if (n == 1) {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:second"));
            } else if (n == 2) {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:third"));
            } else if (n == 3) {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:fourth"));
            } else if (n == 4) {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:fifth"));
            } else {
                this.textList.addItem(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:fifth"));
            }
            ++n;
        }
        this.sampleArea.setText(this.legendTexts[0]);
        this.textList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = CvFontEditor.this.textList.getSelectedIndex();
                if (n >= 0) {
                    CvFontEditor.this.sampleArea.setText(CvFontEditor.this.legendTexts[n]);
                }
            }
        });
    }

    private void setups() {
        this.sampleArea.setFont(this.selectFont);
        this.setLayout(new BorderLayout());
        this.styleList = this.makeStyleList();
        this.fontList = this.makeFontList();
        this.sizeList = this.makeSizeList();
        this.fontList.setSelectionMode(0);
        this.sizeList.setSelectionMode(0);
        this.plain.addActionListener(this);
        this.bold.addActionListener(this);
        this.italic.addActionListener(this);
        this.fontList.addListSelectionListener(this);
        this.sizeList.addListSelectionListener(this);
        JPanel jPanel = this.makeSamplePanel();
        JPanel jPanel2 = this.makeFontPanel();
        this.add("North", jPanel);
        this.add("Center", jPanel2);
        this.resetFontSelection();
    }

    private void update() {
        this.sampleArea.setFont(this.selectFont);
        this.sampleArea.setScrollOffset(0);
        this.validate();
        super.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.fontList) {
            try {
                String string = this.getSelectedFontName(this.fontList.getSelectedIndex());
                this.selectFont = new Font(string, this.selectFont.getStyle(), this.selectFont.getSize());
                this.update();
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                String string = (String)this.sizeList.getSelectedValue();
                int n = new Integer(string);
                this.selectFont = new Font(this.selectFont.getName(), this.selectFont.getStyle(), n);
                this.update();
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

