/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.topology;

import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.topology.SMFamilyImages;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayNode;
import com.sun.symon.base.console.views.topology.CvTopologyLinkEntity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CvTopBaseLinkEntity
extends CvTopologyLinkEntity {
    protected static final int SEPARATION = 5;
    private int DispMajor;
    private int TextWidth;
    private int TextHeight;
    private int TextVOffset;
    private String CurrentStatus = "OK ";
    private Icon CurrentIcon = null;
    private Color CurrentStatusColor = null;

    public CvTopBaseLinkEntity(CvTopologyDisplayNode cvTopologyDisplayNode, CvTopologyDisplayNode cvTopologyDisplayNode2) {
        super(cvTopologyDisplayNode, cvTopologyDisplayNode2);
    }

    public boolean contains(int n, int n2) {
        if (this.ListAlignment) {
            Rectangle rectangle;
            if (this.CurrentIcon != null && (rectangle = new Rectangle(this.XOrigin - this.DispMajor / 2, this.YOrigin - this.CurrentIcon.getIconHeight() / 2, this.CurrentIcon.getIconWidth(), this.CurrentIcon.getIconHeight())).contains(n, n2)) {
                return true;
            }
            rectangle = new Rectangle(this.XOrigin + this.DispMajor / 2 - this.TextWidth, this.YOrigin - this.TextHeight / 2, this.TextWidth, this.TextHeight);
            return rectangle.contains(n, n2);
        }
        Polygon polygon = new Polygon();
        Dimension dimension = this.getBounds();
        if (dimension.width > dimension.height) {
            polygon.addPoint(this.AXOrigin, this.AYOrigin - 2);
            polygon.addPoint(this.AXOrigin, this.AYOrigin + 2);
            polygon.addPoint(this.ZXOrigin, this.ZYOrigin + 2);
            polygon.addPoint(this.ZXOrigin, this.ZYOrigin - 2);
        } else {
            polygon.addPoint(this.AXOrigin - 2, this.AYOrigin);
            polygon.addPoint(this.AXOrigin + 2, this.AYOrigin);
            polygon.addPoint(this.ZXOrigin + 2, this.ZYOrigin);
            polygon.addPoint(this.ZXOrigin - 2, this.ZYOrigin);
        }
        return polygon.contains(n, n2);
    }

    public void determineLayout(Font font) {
        FontMetrics fontMetrics = ((Component)this.ViewParent).getFontMetrics(font);
        this.TextWidth = fontMetrics.stringWidth(this.Name);
        this.TextHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.DispMajor = this.CurrentIcon != null ? this.CurrentIcon.getIconWidth() + 5 + this.TextWidth : this.TextWidth;
        this.TextVOffset = this.TextHeight / 2 - fontMetrics.getDescent();
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.ListAlignment) {
            int n3;
            if (this.CurrentIcon != null) {
                n3 = this.XOrigin - this.DispMajor / 2;
                int n4 = this.YOrigin - this.CurrentIcon.getIconHeight() / 2;
                if (this.IsSelected) {
                    graphics.setXORMode(this.ViewParent.getForeground());
                }
                this.CurrentIcon.paintIcon(this.ViewParent, graphics, n + n3, n2 + n4);
                if (this.IsSelected) {
                    graphics.setPaintMode();
                }
            }
            n3 = this.XOrigin + this.DispMajor / 2 - this.TextWidth;
            int n5 = this.YOrigin - this.TextHeight / 2;
            if (!this.IsSelected) {
                graphics.setColor(this.ViewParent.getBackground());
                graphics.fillRect(n + n3 - 1, n2 + n5 - 1, this.TextWidth + 2, this.TextHeight + 2);
                graphics.setColor(this.ViewParent.getForeground());
                graphics.drawString(this.Name, n + n3, n2 + this.YOrigin + this.TextVOffset);
            } else {
                graphics.setColor(Color.blue.darker().darker());
                graphics.fillRect(n + n3 - 1, n2 + n5 - 1, this.TextWidth + 2, this.TextHeight + 2);
                graphics.setColor(this.ViewParent.getBackground());
                graphics.drawString(this.Name, n + n3, n2 + this.YOrigin + this.TextVOffset);
            }
        } else {
            if (this.CurrentStatusColor != null) {
                graphics.setColor(this.CurrentStatusColor);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawLine(n + this.AXOrigin, n2 + this.AYOrigin, n + this.ZXOrigin, n2 + this.ZYOrigin);
            if (this.IsSelected) {
                Dimension dimension = this.getBounds();
                if (dimension.width > dimension.height) {
                    graphics.drawLine(n + this.AXOrigin, n2 + this.AYOrigin - 1, n + this.ZXOrigin, n2 + this.ZYOrigin - 1);
                    graphics.drawLine(n + this.AXOrigin, n2 + this.AYOrigin + 1, n + this.ZXOrigin, n2 + this.ZYOrigin + 1);
                } else {
                    graphics.drawLine(n + this.AXOrigin + 1, n2 + this.AYOrigin, n + this.ZXOrigin + 1, n2 + this.ZYOrigin);
                    graphics.drawLine(n + this.AXOrigin - 1, n2 + this.AYOrigin, n + this.ZXOrigin - 1, n2 + this.ZYOrigin);
                }
            }
        }
    }

    public Dimension getBounds() {
        int n;
        if (this.ListAlignment) {
            if (this.CurrentIcon != null) {
                int n2 = this.CurrentIcon.getIconHeight();
                if (this.TextHeight > n2) {
                    n2 = this.TextHeight;
                }
                return new Dimension(this.DispMajor, n2);
            }
            return new Dimension(this.TextWidth, this.TextHeight);
        }
        int n3 = this.ZXOrigin - this.AXOrigin;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n = this.ZYOrigin - this.AYOrigin) < 0) {
            n = -n;
        }
        return new Dimension(n3, n);
    }

    public String getConfigureInfo() {
        return "";
    }

    public void handleNewFont() {
        if (this.ListAlignment) {
            this.determineLayout(this.getFont());
        }
    }

    public void init() {
        if (this.ListAlignment) {
            this.determineLayout(this.getFont());
        }
    }

    public void setConfigureInfo(String string) {
    }

    public void setCurrentStatus(SMAlarmStatusData sMAlarmStatusData) {
        super.setCurrentStatus(sMAlarmStatusData);
        String string = sMAlarmStatusData.getState();
        if (this.CurrentStatus.compareTo(string) != 0) {
            this.CurrentStatus = string;
            if (this.FamilyImages != null) {
                this.CurrentIcon = this.FamilyImages.getIcon(this.CurrentStatus, true);
            }
            this.CurrentStatusColor = SMAlarmStatusRequest.getStatusColor((String)this.CurrentStatus);
            if (this.ListAlignment) {
                this.determineLayout(this.getFont());
            }
            this.ViewParent.requestUpdate(true);
        }
    }

    public void setFamilyImages(SMFamilyImages sMFamilyImages) {
        super.setFamilyImages(sMFamilyImages);
        this.CurrentIcon = null;
        if (sMFamilyImages != null) {
            this.CurrentIcon = sMFamilyImages.getIcon(this.CurrentStatus, true);
        }
        if (this.ListAlignment) {
            this.determineLayout(this.getFont());
            this.ViewParent.requestUpdate(true);
        }
    }

    public void setListAlignment(boolean bl) {
        if (this.ListAlignment == bl) {
            return;
        }
        super.setListAlignment(bl);
        if (this.ListAlignment) {
            this.determineLayout(this.getFont());
        }
    }

    public void shutdown() {
    }

    public boolean within(Rectangle rectangle) {
        if (this.ListAlignment) {
            Dimension dimension = this.getBounds();
            dimension.setSize(dimension.width / 2, dimension.height / 2);
            if (!rectangle.contains(this.XOrigin - dimension.width, this.YOrigin - dimension.height)) {
                return false;
            }
            if (!rectangle.contains(this.XOrigin + dimension.width, this.YOrigin + dimension.height)) {
                return false;
            }
        } else {
            if (!rectangle.contains(this.AXOrigin, this.AYOrigin)) {
                return false;
            }
            if (!rectangle.contains(this.ZXOrigin, this.ZYOrigin)) {
                return false;
            }
        }
        return true;
    }
}

