/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.utility.UcDDL;

public class CvGraphStyleFormat {
    public static final String GRAPH_STYLE_AREA = "area";
    public static final String GRAPH_STYLE_BAR = "bar";
    public static final String GRAPH_STYLE_PIE = "pie";
    public static final String GRAPH_STYLE_PLOT = "line";
    protected static final String DEFAULT_GRAPH_STYLE = "line";
    private String graphStyle = "line";

    public CvGraphStyleFormat() {
        this.setupFormat("line");
    }

    public CvGraphStyleFormat(String string) {
        this.setupFormat(string);
    }

    public String getConfiguration() {
        return "Style^" + this.getGraphStyle();
    }

    public String getGraphStyle() {
        return this.graphStyle;
    }

    public static int getGraphStyleNumber(String string) {
        if (string.equals(GRAPH_STYLE_AREA)) {
            return 8;
        }
        if (string.equals(GRAPH_STYLE_BAR)) {
            return 9;
        }
        if (string.equals(GRAPH_STYLE_PIE)) {
            return 11;
        }
        if (string.equals("line")) {
            return 0;
        }
        UcDDL.logDebugMessage((String)"CvGraphStyleFormat::getGraphStyleNumber - non-standard graph type, replaced by PLOT");
        return 0;
    }

    public int getGraphType() {
        return CvGraphStyleFormat.getGraphStyleNumber(this.graphStyle);
    }

    public void setConfiguration(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 2) {
            UcDDL.logDebugMessage((String)("CvGraphStyleFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("Style")) {
            UcDDL.logDebugMessage((String)("CvGraphFormat::setGraphConfiguration - invalid keyword '" + stringArray[0] + "'"));
            return;
        }
        this.graphStyle = stringArray[1];
        this.validateGraphStyle();
    }

    private void setupFormat(String string) {
        this.graphStyle = string != null ? string : "line";
        this.validateGraphStyle();
    }

    private void validateGraphStyle() {
        if (!(this.graphStyle.equals(GRAPH_STYLE_AREA) || this.graphStyle.equals(GRAPH_STYLE_BAR) || this.graphStyle.equals(GRAPH_STYLE_PIE) || this.graphStyle.equals("line"))) {
            this.graphStyle = "line";
        }
    }
}

