/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.logview;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.log.SMLogViewerRequest;
import com.sun.symon.base.console.logview.Filter;
import com.sun.symon.base.console.logview.FilterListener;
import com.sun.symon.base.console.logview.ReloadListener;
import com.sun.symon.base.console.logview.Search;
import com.sun.symon.base.console.logview.SearchDownListener;
import com.sun.symon.base.console.logview.SearchUpListener;
import com.sun.symon.base.console.logview.TailListener;
import com.sun.symon.base.utility.UcButton;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class LogPanel
extends JPanel {
    private int agentPort;
    private boolean firstTime = true;
    private boolean newFile = true;
    private String agentHost;
    private String currentType = "syslog";
    private String currentPath = null;
    private String currentFile = this.translate("sysLog");
    private String[] sunmcPaths = null;
    private String[] sunmcFiles = null;
    private String[] otherPaths;
    private String[] otherFiles;
    private Frame frame;
    private ImageIcon fileTypeImage;
    private ImageIcon filterImage;
    private ImageIcon reloadImage;
    private ImageIcon monitorImage;
    private ImageIcon downArrow;
    private ImageIcon upArrow;
    private JPanel fileTypePanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JLabel status;
    private JLabel fileTypeValue;
    private JButton fileTypeButt;
    private JButton filterButt;
    private JButton reloadButt;
    private JButton tailButt;
    private JPopupMenu fileTypeMenu = new JPopupMenu();
    private JPopupMenu sunmcPopupMenu;
    private JPopupMenu otherPopupMenu;
    private JTextField searchText;
    private JTextArea filterArea;
    private JTextArea tailArea;
    private JScrollPane logPane;
    private JScrollPane tailPane;
    private JSplitPane splitPane;
    private SMRawDataRequest rawReq;
    private SMLogViewerRequest logReq;
    private SMResourceAccess ra;
    private Filter filter = new Filter();
    private FilterListener filterListener;
    private TailListener tailListener;
    private Search search = new Search();

    public void cleanUp() {
        if (this.logReq != null) {
            try {
                SMLogViewerRequest sMLogViewerRequest;
                if (this.tailListener != null && (sMLogViewerRequest = this.tailListener.getLogRequest()) != null) {
                    sMLogViewerRequest.closeConnection();
                }
                this.logReq.closeConnection();
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)"Close Connection", (Throwable)sMAPIException);
            }
            this.logReq = null;
        }
        this.rawReq = null;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    String getCurrentFile() {
        return this.currentFile;
    }

    String getCurrentPath() {
        return this.currentPath;
    }

    String getCurrentType() {
        return this.currentType;
    }

    Filter getFilter() {
        return this.filter;
    }

    String getFilterArea() {
        return this.filterArea.getText();
    }

    Frame getLogFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    SMLogViewerRequest getLogReq() {
        return this.logReq;
    }

    Window getLogWindow(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    boolean getNewFile() {
        return this.newFile;
    }

    public SMRawDataRequest getRawHandle() {
        return this.rawReq;
    }

    JButton getReloadButton() {
        return this.reloadButt;
    }

    Search getSearch() {
        return this.search;
    }

    String getSearchText() {
        return this.searchText.getText();
    }

    String getTailArea() {
        return this.tailArea.getText();
    }

    public JLabel getWindowStatusField() {
        return this.status;
    }

    public void init() {
        int n;
        try {
            this.logReq = new SMLogViewerRequest(this.rawReq, this.agentHost, this.agentPort);
        }
        catch (Exception exception) {
            UcDialog.showOk((String)(String.valueOf(this.translate("requestHandleException")) + "\n" + exception.getMessage()));
            this.logReq = null;
            return;
        }
        if (this.status != null) {
            this.status.setText("");
        }
        this.frame = this.getLogFrame(this);
        this.ra = new SMResourceAccess(this.getRawHandle());
        this.fileTypeImage = new ImageIcon(this.ra.getImage("stdimages/LogFileType-24x24.gif"));
        this.filterImage = new ImageIcon(this.ra.getImage("stdimages/Filter-24x24.gif"));
        this.reloadImage = new ImageIcon(this.ra.getImage("stdimages/Refresh-24x24.gif"));
        this.monitorImage = new ImageIcon(this.ra.getImage("stdimages/Monitor-24x24.gif"));
        this.downArrow = new ImageIcon(this.ra.getImage("stdimages/downArrow.gif"));
        this.upArrow = new ImageIcon(this.ra.getImage("stdimages/upArrow.gif"));
        try {
            this.sunmcPaths = this.logReq.getSunMCLogList();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("sunmcListException"), (SMAPIException)sMAPIException);
        }
        if (this.sunmcPaths != null && this.sunmcPaths.length > 0) {
            this.sunmcFiles = new String[this.sunmcPaths.length];
            int n2 = 0;
            while (n2 < this.sunmcPaths.length) {
                n = this.sunmcPaths[n2].lastIndexOf(47) + 1;
                this.sunmcFiles[n2] = this.sunmcPaths[n2].substring(n);
                ++n2;
            }
        }
        try {
            this.otherPaths = this.logReq.getOtherFileList();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("otherListException"), (SMAPIException)sMAPIException);
        }
        if (this.otherPaths != null && this.otherPaths.length > 0) {
            this.otherFiles = new String[this.otherPaths.length];
            int n3 = 0;
            while (n3 < this.otherPaths.length) {
                n = this.otherPaths[n3].lastIndexOf(47) + 1;
                this.otherFiles[n3] = this.otherPaths[n3].substring(n);
                ++n3;
            }
        }
        this.fileTypeButt = new UcButton((Icon)this.fileTypeImage, this.translate("fileTypeTip"));
        this.fileTypeButt.setHorizontalTextPosition(10);
        this.fileTypeButt.setHorizontalAlignment(2);
        this.fileTypeButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                Dimension dimension = jButton.getSize();
                LogPanel.this.fileTypeMenu.show(jButton, 0, (int)dimension.getHeight());
            }
        });
        JMenuItem jMenuItem = new JMenuItem(this.translate("sysLog"));
        jMenuItem.setActionCommand("syslog");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setCurrentType("syslog");
                LogPanel.this.setCurrentPath(null);
                LogPanel.this.setCurrentFile(LogPanel.this.translate("sysLog"));
                LogPanel.this.filterListener.enableDateTime(true);
            }
        });
        JMenu jMenu = new JMenu(this.translate("sunmcLog"));
        this.sunmcPopupMenu = jMenu.getPopupMenu();
        if (this.sunmcFiles == null) {
            jMenu.setEnabled(false);
        } else {
            int n4 = 0;
            while (n4 < this.sunmcFiles.length) {
                jMenu.add(new JMenuItem(this.sunmcFiles[n4]));
                jMenu.getItem(n4).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Component component = (Component)actionEvent.getSource();
                        int n = LogPanel.this.sunmcPopupMenu.getComponentIndex(component);
                        LogPanel.this.setCurrentType("sunmclog");
                        LogPanel.this.setCurrentPath(LogPanel.this.sunmcPaths[n]);
                        LogPanel.this.setCurrentFile(LogPanel.this.sunmcFiles[n]);
                        LogPanel.this.filterListener.enableDateTime(false);
                    }
                });
                ++n4;
            }
        }
        JMenu jMenu2 = new JMenu(this.translate("otherLog"));
        this.otherPopupMenu = jMenu2.getPopupMenu();
        if (this.otherFiles == null) {
            jMenu2.setEnabled(false);
        } else {
            int n5 = 0;
            while (n5 < this.otherFiles.length) {
                jMenu2.add(new JMenuItem(this.otherFiles[n5]));
                jMenu2.getItem(n5).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Component component = (Component)actionEvent.getSource();
                        int n = LogPanel.this.otherPopupMenu.getComponentIndex(component);
                        LogPanel.this.setCurrentType("otherfile");
                        LogPanel.this.setCurrentPath(LogPanel.this.otherPaths[n]);
                        LogPanel.this.setCurrentFile(LogPanel.this.otherFiles[n]);
                        LogPanel.this.filterListener.enableDateTime(false);
                    }
                });
                ++n5;
            }
        }
        this.fileTypeMenu.add(jMenuItem);
        this.fileTypeMenu.add(jMenu);
        this.fileTypeMenu.add(jMenu2);
        this.filterButt = new UcButton((Icon)this.filterImage, this.translate("filterTip"));
        this.filterListener = new FilterListener(this, this.frame);
        this.filterButt.addActionListener(this.filterListener);
        this.tailButt = new UcButton((Icon)this.monitorImage, this.translate("monitorTip"));
        this.tailListener = new TailListener(this, this.frame);
        this.tailButt.addActionListener(this.tailListener);
        this.reloadButt = new UcButton((Icon)this.reloadImage, this.translate("reloadTip"));
        this.reloadButt.addActionListener(new ReloadListener(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.fileTypeButt);
        jToolBar.addSeparator();
        jToolBar.add(this.filterButt);
        jToolBar.add(this.tailButt);
        jToolBar.add(this.reloadButt);
        gridBagConstraints.insets = new Insets(12, 9, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jToolBar, gridBagConstraints);
        this.fileTypePanel = new JPanel(new FlowLayout(0, 3, 0));
        this.fileTypePanel.add(new JLabel(this.translate("filteredMessages")));
        this.fileTypeValue = new JLabel(this.currentFile);
        this.fileTypeValue.setFont(this.fileTypeValue.getFont().deriveFont(0));
        this.fileTypeValue.setForeground(Color.black);
        this.fileTypePanel.add(this.fileTypeValue);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.add((Component)this.fileTypePanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(2, 4, 0));
        jPanel.add(new JLabel(this.translate("find")));
        this.searchText = new JTextField("", 10);
        this.searchText.setMargin(new Insets(1, 2, 1, 0));
        SearchDownListener searchDownListener = new SearchDownListener();
        searchDownListener.setLogPanel(this);
        this.searchText.addActionListener(searchDownListener);
        jPanel.add(this.searchText);
        JButton jButton = new JButton(this.downArrow);
        jButton.setMargin(new Insets(0, 1, 1, 1));
        jButton.addActionListener(searchDownListener);
        JButton jButton2 = new JButton(this.upArrow);
        jButton2.setMargin(new Insets(0, 1, 1, 1));
        SearchUpListener searchUpListener = new SearchUpListener();
        searchUpListener.setLogPanel(this);
        jButton2.addActionListener(searchUpListener);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.add((Component)jPanel, gridBagConstraints);
        this.topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.topPanel.setMinimumSize(new Dimension(200, 80));
        this.topPanel.setPreferredSize(new Dimension(200, 80));
        this.topPanel.setMaximumSize(new Dimension(900, 500));
        StringBuffer stringBuffer = null;
        if (this.status != null) {
            this.status.setText(this.translate("loadingMessages"));
        }
        try {
            stringBuffer = this.logReq.logSearch(this.getCurrentType(), this.getCurrentPath(), this.filter.getMaxMatches(), this.filter.getMaxLines(), this.filter.getStartTimeStamp(), this.filter.getEndTimeStamp(), this.filter.getFromLatest(), this.filter.getPattern(), 0);
        }
        catch (Exception exception) {
            UcDialog.showOk((String)(String.valueOf(this.translate("requestException")) + "\n" + exception.getMessage()));
            stringBuffer = null;
        }
        if (stringBuffer != null) {
            this.filterArea = new JTextArea(stringBuffer.toString());
            this.status.setText("");
        } else {
            this.filterArea = new JTextArea();
            if (this.status != null) {
                this.status.setText(this.translate("noMatches"));
            }
        }
        this.filterArea.setEditable(false);
        this.filterArea.setMargin(new Insets(5, 7, 5, 7));
        this.logPane = new JScrollPane(this.filterArea, 22, 30);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridwidth = 0;
        this.topPanel.add((Component)this.logPane, gridBagConstraints2);
        this.bottomPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.bottomPanel.setLayout(gridBagLayout);
        this.bottomPanel.setMinimumSize(new Dimension(200, 80));
        this.bottomPanel.setPreferredSize(new Dimension(200, 80));
        this.bottomPanel.setMaximumSize(new Dimension(900, 500));
        JLabel jLabel = new JLabel(this.translate("monitoredMessages"));
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets = new Insets(2, 2, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridwidth = 0;
        this.bottomPanel.add((Component)jLabel, gridBagConstraints3);
        this.tailArea = new JTextArea();
        this.tailArea.setEditable(false);
        this.tailArea.setMargin(new Insets(5, 7, 5, 7));
        this.tailPane = new JScrollPane(this.tailArea, 22, 30);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridwidth = 0;
        this.bottomPanel.add((Component)this.tailPane, gridBagConstraints3);
        this.splitPane = new JSplitPane(0, false, this.topPanel, this.bottomPanel);
        this.splitPane.setDividerLocation(350);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 11, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.splitPane, gridBagConstraints);
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    void setCurrentFile(String string) {
        if (this.fileTypePanel == null) {
            return;
        }
        this.currentFile = string;
        this.fileTypePanel.remove(this.fileTypeValue);
        this.getParent().validate();
        this.fileTypeValue = new JLabel(this.currentFile);
        this.fileTypeValue.setFont(this.fileTypeValue.getFont().deriveFont(0));
        this.fileTypeValue.setForeground(Color.black);
        this.fileTypePanel.add(this.fileTypeValue);
        this.getParent().validate();
        this.reloadButt.doClick();
        this.setNewFile(true);
    }

    void setCurrentPath(String string) {
        this.currentPath = string;
    }

    void setCurrentType(String string) {
        this.currentType = string;
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    void setFilterArea(String string) {
        this.filterArea.setText(string);
    }

    void setNewFile(boolean bl) {
        this.newFile = bl;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.rawReq = sMRawDataRequest;
    }

    void setSearchedText(int n, int n2) {
        this.filterArea.select(n, n2);
    }

    void setTailArea(String string) {
        if (string.length() > 0) {
            int n = this.tailArea.getText().length();
            int n2 = n + string.length();
            this.tailArea.append(string);
            this.tailArea.select(n, n2);
        } else {
            this.tailArea.setText("");
        }
    }

    public void setWindowStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.logview.LogBundle:" + string));
    }
}

