/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.alarm.SMAlarmMessage;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.NoteListener;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NoteListener
extends JDialog
implements ActionListener {
    AlarmPanel ap;
    AlarmData[] ad;
    SMAlarmPageAsyncRequest request;
    SMAlarmMessage[] notes;
    JTextArea noteArea = new JTextArea(10, 50);
    int offset = 0;

    public NoteListener(AlarmPanel alarmPanel, Frame frame) {
        super(frame, true);
        this.ap = alarmPanel;
        this.request = this.ap.getRequestHandle();
        this.setTitle(this.ap.translate("noteTitle"));
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.noteArea.setMargin(new Insets(2, 5, 0, 0));
        this.noteArea.setLineWrap(true);
        this.noteArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.noteArea, 20, 31);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        container.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(2, 6, 0));
        JButton jButton = new JButton(this.ap.translate("ok"));
        class NoteOKListener
        implements ActionListener {
            private final /* synthetic */ NoteListener this$0;

            NoteOKListener(NoteListener noteListener) {
                this.this$0 = noteListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.this$0.noteArea.getText().substring(this.this$0.offset);
                try {
                    this.this$0.request.setAlarmNotes(this.this$0.ad[0].getId(), UcListUtil.UnicodeToAscii((String)string));
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showSMAPIexception((String)this.this$0.ap.translate("setNoteException"), (SMAPIException)sMAPIException);
                    return;
                }
                ((Component)this.this$0).setVisible(false);
            }
        }
        NoteOKListener noteOKListener = new NoteOKListener(this);
        jButton.addActionListener(noteOKListener);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.ap.translate("cancel"));
        class NoteCancelListener
        implements ActionListener {
            private final /* synthetic */ NoteListener this$0;

            NoteCancelListener(NoteListener noteListener) {
                this.this$0 = noteListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.this$0).setVisible(false);
            }
        }
        jButton2.addActionListener(new NoteCancelListener(this));
        jPanel.add(jButton2);
        gridBagConstraints.insets = new Insets(17, 0, 11, 5);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.show();
            return;
        }
        this.ad = this.ap.getAlarmTable().getAlarmData();
        if (this.ad.length != 1) {
            UcDialog.showOk((String)this.ap.translate("pleaseSelectOneAlarm"));
            return;
        }
        try {
            this.notes = this.request.getAlarmNotes(this.ad[0].getId());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.ap.translate("getNoteException"), (SMAPIException)sMAPIException);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        int n = 0;
        while (n < this.notes.length) {
            long l = Long.parseLong(this.notes[n].getTime().trim()) * 1000L;
            string = dateFormat.format(new Date(l));
            stringBuffer.append(String.valueOf(string) + " " + this.notes[n].getUser() + "\n");
            stringBuffer.append(String.valueOf(UcListUtil.AsciiToUnicode((String)this.notes[n].getMessage())) + "\n\n");
            ++n;
        }
        this.noteArea.setText(stringBuffer.toString());
        this.offset = stringBuffer.length();
        ((Component)this).setVisible(true);
    }
}

