/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.lv.console.presentation;

import com.sun.symon.apps.lv.console.presentation.SMLvTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class SMLvTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected SMLvTreeNode treeNode;
    protected boolean selected;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public SMLvTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setText(string);
        this.treeNode = (SMLvTreeNode)object;
        if (bl && (this.treeNode.getNode().getAlarmState() == 1 || this.treeNode.getNode().getAlarmState() == 2 || this.treeNode.getNode().getAlarmState() == 3)) {
            this.setForeground(Color.white);
        } else if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (bl3) {
            this.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = 0;
        if (color != null) {
            Icon icon = this.getIcon();
            graphics.setColor(color);
            if (this.treeNode.getNode().getAlarmState() == 1) {
                graphics.setColor(Color.red);
            } else if (this.treeNode.getNode().getAlarmState() == 2) {
                graphics.setColor(Color.yellow);
            } else if (this.treeNode.getNode().getAlarmState() == 3) {
                graphics.setColor(Color.blue);
            }
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        if (this.selected) {
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }
}

