/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import com.sun.symon.base.utility.UcPeriodic;
import com.sun.symon.base.utility.UcPeriodicException;
import java.util.Date;

public class UcPeriodicInterval {
    private static long PeriodStart = new Date().getTime() / 1000L;
    private int PeriodicId;
    private long IntervalLong;

    public UcPeriodicInterval(long l) throws UcPeriodicException {
        if (l <= 0L) {
            throw new UcPeriodicException("interval must be > 0");
        }
        this.IntervalLong = l;
        this.PeriodicId = 0;
    }

    public UcPeriodicInterval(String string) throws UcPeriodicException {
        try {
            this.IntervalLong = Long.parseLong(string);
            this.PeriodicId = 0;
        }
        catch (NumberFormatException numberFormatException) {
            this.IntervalLong = 0L;
            this.PeriodicId = UcPeriodic.parse(string);
        }
    }

    public void finalize() throws Throwable {
        if (this.PeriodicId != 0) {
            UcPeriodic.free(this.PeriodicId);
        }
        super.finalize();
    }

    public long secsToWait() {
        return this.secsToWait(new Date());
    }

    public long secsToWait(Date date) {
        if (this.PeriodicId == 0) {
            return this.IntervalLong;
        }
        return UcPeriodic.secsToWait(this.PeriodicId, UcPeriodic.BEAT, date.getTime() / 1000L, PeriodStart);
    }
}

