/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.admin.hostmgr.common.TnrhdbData;
import com.sun.admin.hostmgr.server.HostMgr;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.ServiceList;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Vector;

public class ViperServiceWrapper
extends ServiceWrapper {
    private HostMgr hostMgrServer = null;
    private PermissionCollection permissionCollection = null;
    private ToolInfrastructure infrastructure = null;

    public void addHost(HostData hostData) throws AdminException {
        try {
            this.hostMgrServer.addHost(hostData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void addNetwork(NetworkData networkData) throws AdminException {
        try {
            this.hostMgrServer.addNetwork(networkData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void addTemplate(TemplateData templateData) throws AdminException, DirectoryTableException, HostAuthException {
        try {
            this.hostMgrServer.addTemplate(templateData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void deleteHost(HostData hostData) throws AdminException {
        try {
            this.hostMgrServer.deleteHost(hostData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void deleteNetwork(NetworkData networkData) throws AdminException {
        try {
            this.hostMgrServer.deleteNetwork(networkData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void deleteTnrhdb(TnrhdbData tnrhdbData) throws AdminException, DirectoryTableException, RemoteException {
        this.hostMgrServer.deleteTnrhdb(tnrhdbData);
    }

    public void deleteTnrhtp(TemplateData templateData) throws AdminException, DirectoryTableException, RemoteException {
        this.hostMgrServer.deleteTnrhtp(templateData);
    }

    public HostData getHostByAddress(String string) throws AdminException {
        try {
            return this.hostMgrServer.getHostByAddress(string);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public HostData getHostByNameAddr(String string, String string2) throws AdminException {
        try {
            return this.hostMgrServer.getHostByNameAddr(string, string2);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector getHostOtherAddrs(HostData hostData) throws AdminException {
        try {
            return this.hostMgrServer.getHostOtherAddrs(hostData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector getHostsByName(String string) throws AdminException {
        try {
            return this.hostMgrServer.getHostsByName(string);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public NetworkData getNetwork(NetworkData networkData) throws AdminException {
        try {
            return this.hostMgrServer.getNetwork(networkData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public String getTemplateByAddress(String string) throws AdminException, DirectoryTableException {
        try {
            return this.hostMgrServer.getTemplateByAddress(string);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public boolean hasSecurityReadAuthorization() {
        VPermission vPermission = new VPermission("solaris.network.security.read");
        return this.permissionCollection != null && this.permissionCollection.implies((Permission)vPermission);
    }

    public boolean hasSecurityWriteAuthorization() {
        VPermission vPermission = new VPermission("solaris.network.security.write");
        return this.permissionCollection != null && this.permissionCollection.implies((Permission)vPermission);
    }

    public boolean hasWriteAuthorization() {
        VPermission vPermission = new VPermission("solaris.network.hosts.write");
        return this.permissionCollection != null && this.permissionCollection.implies((Permission)vPermission);
    }

    public void init(Object object, Object object2, AdminMgmtScope adminMgmtScope) throws Exception {
        this.hostMgrServer = (HostMgr)object;
        this.infrastructure = (ToolInfrastructure)object2;
        this.hostMgrServer.initializeScope(adminMgmtScope);
        try {
            Authorization authorization = (Authorization)this.infrastructure.getServiceByName(ServiceList.AUTHORIZATION);
            this.permissionCollection = authorization.readUserPermissions((Principal)this.infrastructure.getIdentity());
        }
        catch (Exception exception) {}
    }

    public Vector listHosts(ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listHosts(listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsByNetwork(NetworkData networkData, ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listHostsByNetwork(networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void listHostsByNetworkEnd() throws AdminException {
        try {
            this.hostMgrServer.listHostsByNetworkEnd();
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsByNetworkNext() throws AdminException {
        try {
            return this.hostMgrServer.listHostsByNetworkNext();
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int listHostsByNetworkPrime(NetworkData networkData, ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listHostsByNetworkPrime(networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void listHostsEnd() throws AdminException {
        try {
            this.hostMgrServer.listHostsEnd();
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsNext() throws AdminException {
        try {
            return this.hostMgrServer.listHostsNext();
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int listHostsPrime(ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listHostsPrime(listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listNetworkSubnets(NetworkData networkData, ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listNetworkSubnets(networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listNetworks(ListProperties listProperties) throws AdminException {
        try {
            return this.hostMgrServer.listNetworks(listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listTemplates() throws AdminException, DirectoryTableException {
        try {
            return this.hostMgrServer.listTemplates();
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listTnrhdb(String string) throws AdminException, DirectoryTableException, RemoteException {
        return this.hostMgrServer.listTnrhdb(string);
    }

    public Vector listTnrhdbByIPAddress(String string, String string2) throws AdminException, DirectoryTableException, RemoteException {
        return this.hostMgrServer.listTnrhdbByIPAddress(string, string2);
    }

    public void modTemplate(TemplateData templateData, TemplateData templateData2) throws AdminException, DirectoryTableException, HostAuthException {
        try {
            this.hostMgrServer.modTemplate(templateData, templateData2);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int renameHost(HostData hostData, String string, Integer n) throws AdminException {
        try {
            return this.hostMgrServer.renameHost(hostData, string, n);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void setHost(HostData hostData, HostData hostData2) throws AdminException {
        try {
            this.hostMgrServer.setHost(hostData, hostData2);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void setNetwork(NetworkData networkData, NetworkData networkData2) throws AdminException {
        try {
            this.hostMgrServer.setNetwork(networkData, networkData2);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int setTnrhdb(TnrhdbData tnrhdbData) throws AdminException, DirectoryTableException {
        try {
            this.hostMgrServer.setTnrhdb(tnrhdbData);
            return 1;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void terminateConnection() throws Exception {
    }
}

