/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetch;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.NetworkPropsDialog;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.ShowNetworksDialog;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class NetworkContent
extends Content {
    public static final String NETWORK_COLUMN_NETWORKNAME = "networkListNetworkName";
    public static final String NETWORK_COLUMN_IPADDRESS = "networkListIPAddress";
    public static final String NETWORK_COLUMN_ALIASES = "networkListAliases";
    public static final String NETWORK_COLUMN_COMMENT = "networkListComment";
    public static final String NETWORK_COLUMN_NETMASK = "networkListNetmask";
    private boolean createSecFamily = false;
    private int displayChunkSize = -99999;
    private String sortPreferencesKey;
    private final Object[][] advColumnHeaderConfig = new Object[][]{{"networkListNetworkName", new Integer(8)}, {"networkListNetmask", new Integer(8)}, {"networkListComment", new Integer(8)}, {"networkListAliases", new Integer(8)}};
    private final Object[][] genColumnHeaderConfig = new Object[][]{{"networkListNetworkName", new Integer(16)}};
    private static String[][] columnHeaders = null;

    public NetworkContent(VHostMgr vHostMgr, boolean bl) {
        super(vHostMgr);
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.createSecFamily = bl;
    }

    public void clear() {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.theApp.getTree().removeAllNetworks(this.treeNode);
        this.bRefresh = true;
    }

    public void createProperties() {
        NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(this.theApp, this.theApp.getFrame(), this.whatAmI().equals("networks"), new NetworkData());
        ((Component)((Object)networkPropsDialog)).setVisible(true);
    }

    public void deleteSelected() {
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            return;
        }
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetwork"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)20, (int)5, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)2, (int)1, (int)20, (int)5, (int)10, (int)5);
        ImageIcon imageIcon = this.theApp.loadImageIcon("warning_bullet_icon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain((Container)jPanel, (Component)jButton, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"DeleteNetworkTitle");
        int n2 = Math.max(string.length(), 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n2, true);
        progressPanel.setRange(0, vector.size() + 1);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(resourceBundle, progressPanel, this, vector){
                    private final /* synthetic */ NetworkContent this$0;
                    private final /* synthetic */ ResourceBundle val$bundle;
                    private final /* synthetic */ Vector val$vSelected;
                    private final /* synthetic */ ProgressPanel val$progressPanel;
                    {
                        this.val$bundle = resourceBundle;
                        this.val$progressPanel = progressPanel;
                        this.this$0 = networkContent;
                        this.val$vSelected = vector;
                    }

                    public void run() {
                        Object object;
                        this.val$progressPanel.setVisible(true);
                        String string = new String();
                        String string2 = "EXM_HST_GUI_CANT_DELETE_UNREAL_NETWORK";
                        int n = 0;
                        while (n < this.val$vSelected.size()) {
                            try {
                                object = (VScopeNode)this.val$vSelected.elementAt(n);
                                TreeNodeData treeNodeData = (TreeNodeData)object.getPayload();
                                NetworkData networkData = treeNodeData.getNetworkData();
                                if (networkData.getNetworkAddress().length() == 0) {
                                    throw new HostException(string2, networkData.getNetworkName());
                                }
                                if (!networkData.isStaticNetwork()) {
                                    string = String.valueOf(string) + networkData.getNetworkAddress() + "    ";
                                } else {
                                    String string3 = ResourceStrings.getString((ResourceBundle)this.val$bundle, (String)"DeletingNetwork");
                                    Object[] objectArray = new Object[]{networkData.getNetworkAddress()};
                                    this.val$progressPanel.setText(MessageFormat.format(string3, objectArray));
                                    this.this$0.theApp.getHostMgr().deleteNetwork(networkData);
                                    Content.broadcastUpdate(networkData, null, true);
                                }
                            }
                            catch (Exception exception) {
                                this.this$0.theApp.reportErrorException(exception);
                            }
                            this.val$progressPanel.setValue(n + 1);
                            ++n;
                        }
                        this.val$progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.val$bundle, (String)"RepaintingCurrentView"));
                        this.this$0.setSelected(new Vector<E>());
                        this.val$progressPanel.setValue(this.val$progressPanel.getValue() + 1);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        this.val$progressPanel.setVisible(false);
                        this.val$progressPanel.dispose();
                        if (string.length() > 0) {
                            object = new HostException("EXM_HST_GUI_CANT_DELETE_DYNAMIC_NETWORKS", string);
                            this.this$0.theApp.reportErrorException((Exception)object);
                        }
                    }
                };
                thread.start();
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNetworkTitle"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Delete"));
    }

    public void find(Object object) {
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getFirstChild();
        while (vScopeNode != null) {
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            NetworkData networkData = treeNodeData.getNetworkData();
            if (networkData == (NetworkData)object) {
                this.clearSelection();
                Vector<VScopeNode> vector = new Vector<VScopeNode>();
                vector.addElement(vScopeNode);
                this.setSelected(vector);
                return;
            }
            vScopeNode = (VScopeNode)vScopeNode.getNextSibling();
        }
    }

    public String[][] getColumnHeaders() {
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        if (columnHeaders == null) {
            columnHeaders = applicationContext.isNetworksSupported() ? this.constructColumnHeaders(this.advColumnHeaderConfig) : this.constructColumnHeaders(this.genColumnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, NetworkData networkData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_IPADDRESS);
        hashtable.put(string, networkData.getNetworkAddress());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_NETWORKNAME);
        hashtable.put(string, networkData.getNetworkName());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_NETMASK);
        hashtable.put(string, networkData.getNetmask());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_COMMENT);
        hashtable.put(string, networkData.getDescription());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_ALIASES);
        hashtable.put(string, networkData.getAliases());
        return hashtable;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.PreferredDisplayChunkSize");
            this.displayChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 10;
        }
        return this.displayChunkSize;
    }

    private int getServerChunkSize() {
        return 0;
    }

    public String getSortAttribute() {
        return NETWORK_COLUMN_IPADDRESS;
    }

    public boolean isShowByTypeSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        return networkData == null;
    }

    public boolean offerDelete(Object object, boolean bl) {
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData2 = treeNodeData.getNetworkData();
        boolean bl2 = true;
        if (networkData2 != null) {
            bl2 = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            bl2 = false;
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (this.theApp.getTree().getCurrentContent() == this) {
            this.getDataCache().removeElement(networkData);
        } else {
            Vector vector = this.getDataCache();
            int n = 0;
            while (n < vector.size()) {
                NetworkData networkData3 = (NetworkData)vector.elementAt(n);
                if (networkData3.equals(networkData)) {
                    vector.removeElement(networkData3);
                    break;
                }
                ++n;
            }
        }
        this.theApp.getTree().removeNetwork(this.treeNode, networkData);
        return true;
    }

    public boolean offerNew(Object object, boolean bl) {
        TreeNodeData treeNodeData;
        Object object2;
        Object object3;
        int n;
        if (object != null && !(object instanceof NetworkData)) {
            return false;
        }
        NetworkData networkData = (NetworkData)object;
        TreeNodeData treeNodeData2 = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        if (!networkData.isNetwork() && networkData2 != null) {
            networkData.setNetmaskForSubnet(networkData2.getNetmask());
        }
        Integer n2 = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (n2 == 2) {
            n = 0;
            while (n < Content.getNumInstances()) {
                long l;
                long l2;
                object3 = Content.getInstance(n);
                object2 = ((Content)object3).getTreeNode();
                treeNodeData = (TreeNodeData)object2.getPayload();
                NetworkData networkData3 = treeNodeData.getNetworkData();
                if (networkData3 != null && networkData3.getNetworkAddress().length() != 0 && (l2 = networkData3.getNetworkAddressLong()) == (l = networkData.getNetworkAddressLong())) {
                    defaultMutableTreeNode = object2;
                    break;
                }
                ++n;
            }
        }
        n = 1;
        if (defaultMutableTreeNode != null) {
            n = 1;
        } else if (networkData2 != null) {
            n = networkData2.belongsNetwork(networkData.getNetworkAddress());
        } else if (!networkData.isNetwork()) {
            n = 0;
        }
        if (bl || n == 0) {
            return n != 0;
        }
        if (defaultMutableTreeNode != null) {
            object3 = (TreeNodeData)defaultMutableTreeNode.getPayload();
            object2 = ((TreeNodeData)object3).getNetworkData();
            treeNodeData = (VScopeNode)defaultMutableTreeNode.getParent();
            this.theApp.getTree().removeNetwork((VScopeNode)treeNodeData, (NetworkData)object2);
        }
        this.theApp.getTree().addNetwork(this.treeNode, networkData);
        return true;
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.scopeselected", (Object)vScopeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void refresh() {
        String string;
        String string2;
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear();
        this.theApp.setStatusBar("");
        this.clearSelection();
        this.theApp.getTree().removeAllNetworks(this.treeNode);
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        if (networkData == null) {
            string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchNetworksTitle");
            string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"NetworkBatchReceived");
        } else {
            string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchSubnetworksTitle");
            string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SubnetworkBatchReceived");
        }
        String string3 = string2;
        final String string4 = string;
        String string5 = String.valueOf(string3) + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Ellipsis");
        final String string6 = String.valueOf(string3) + " " + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RefreshInterrupted") + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Ellipsis");
        int n = Math.max(string3.length(), string5.length());
        n = Math.max(n, string4.length());
        n = Math.max(n, string6.length());
        n = Math.max(n, 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n, true, true);
        progressPanel.setRange(0, 100);
        progressPanel.setValue(0);
        progressPanel.setTitle(string3);
        progressPanel.setText(string5);
        progressPanel.setStopListener(new ActionListener((ListFetch)myListFetch, progressPanel){
            private final /* synthetic */ ProgressPanel val$progressPanel;
            private final /* synthetic */ ListFetch val$listFetch;
            {
                this.val$listFetch = listFetch;
                this.val$progressPanel = progressPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.val$listFetch.isInterrupted()) {
                    this.val$progressPanel.setText(string6);
                    this.val$listFetch.interrupt();
                }
            }
        });
        progressPanel.show();
        if (this.createSecFamily) {
            this.theApp.getTree().createSecFamilyNode(this.treeNode);
        }
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    this.updateStatusBar();
                    progressPanel.dispose();
                    theApp.waitOff();
                    return;
                }
                if (listFetchEvent.getSize() > 0) {
                    progressPanel.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                    Object[] objectArray = new Object[]{new Integer(listFetchEvent.getNumReceived()), new Integer(listFetchEvent.getSize())};
                    String string = MessageFormat.format(string4, objectArray);
                    progressPanel.appendText(string);
                    if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                        progressPanel.setValue(100);
                    }
                }
                theApp.getTree().appendToNode(treeNode, vector);
            }

            public synchronized void errorException(Exception exception) {
                theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void showByType() {
        Integer n = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
        final ShowNetworksDialog showNetworksDialog = new ShowNetworksDialog(this.theApp, this.theApp.getFrame(), n);
        showNetworksDialog.getOKBtn().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminCommonTools.CMN_setPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(showNetworksDialog.getShowValue()));
                ((Window)((Object)showNetworksDialog)).dispose();
                this.refresh();
            }
        });
        ((Dialog)((Object)showNetworksDialog)).show();
    }

    public void updateDefaultColumns() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)NETWORK_COLUMN_IPADDRESS));
        Object[][] objectArray = new Object[][]{{NETWORK_COLUMN_IPADDRESS, new Integer(128)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        if (networkData == null) {
            String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"NetworkListContents");
            Object[] objectArray = new Object[2];
            int n = Math.max(0, this.getDataCache().size() - 1);
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(1);
            String string2 = MessageFormat.format(string, objectArray);
            this.theApp.setStatusBar(string2);
        } else {
            String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SubnetworkListContents");
            Object[] objectArray = new Object[2];
            int n = Math.max(0, this.getDataCache().size() - 1);
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(1);
            String string3 = MessageFormat.format(string, objectArray);
            this.theApp.setStatusBar(string3);
        }
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        try {
            VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            NetworkData networkData = treeNodeData.getNetworkData();
            NetworkPropsDialog networkPropsDialog = new NetworkPropsDialog(this.theApp, this.theApp.getFrame(), this.whatAmI().equals("networks"), networkData);
            if (networkData.getNetworkAddress().length() == 0) {
                throw new HostException("EXM_HST_GUI_CANT_VIEW_UNREAL_NETWORK", networkData.getNetworkName());
            }
            ((Dialog)((Object)networkPropsDialog)).show();
        }
        catch (HostException hostException) {
            this.theApp.reportErrorException((Exception)((Object)hostException));
        }
    }

    public String whatAmI() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        if (networkData == null) {
            return "networks";
        }
        return "subnetworks";
    }

    class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper hostMgr;
        NetworkData networkData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            try {
                this.listProps = new ListProperties();
                this.listProps.setSortOrderAscending();
                this.listProps.setSortColumn(NetworkContent.this.getSortAttribute());
                this.listProps.setChunkSize(n);
            }
            catch (Exception exception) {}
            this.hostMgr = NetworkContent.this.theApp.getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)NetworkContent.this.treeNode.getPayload();
            this.networkData = treeNodeData.getNetworkData();
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)NetworkContent.this.theApp.getResourceBundle(), (String)"BEANNAME");
        }

        public Vector listAll() throws AdminException {
            ApplicationContext applicationContext = NetworkContent.this.theApp.getApplicationContext();
            if (!applicationContext.isNetworksSupported()) {
                return new Vector();
            }
            Integer n = (Integer)AdminCommonTools.CMN_getPreference((String)"hostmgr", (Object)"ShowNetworks", (Object)new Integer(1));
            if (n == 3) {
                return new Vector();
            }
            boolean bl = n == 2;
            this.listProps.setCustomBooleanArg1(bl);
            try {
                if (this.networkData == null) {
                    return this.hostMgr.listNetworks(this.listProps);
                }
                return this.hostMgr.listNetworkSubnets(this.networkData, this.listProps);
            }
            catch (HostAuthException hostAuthException) {
                throw new AdminException(ResourceStrings.getString((ResourceBundle)NetworkContent.this.theApp.getResourceBundle(), (String)"NoReadAuth"));
            }
        }

        public Vector listCustomStart() {
            Vector<NetworkData> vector = new Vector<NetworkData>();
            NetworkData networkData = new NetworkData();
            String string = ResourceStrings.getString((ResourceBundle)NetworkContent.this.theApp.getResourceBundle(), (String)"AllNetworkHosts");
            networkData.setNetworkName(string);
            vector.addElement(networkData);
            return vector;
        }

        public void listTrace(String string) {
            NetworkContent.this.theApp.Trace(string);
        }
    }
}

