/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.FilterPanel;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ListFetch;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.HostPropsDialog;
import com.sun.admin.hostmgr.client.HostRenameDialog;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class HostContent
extends Content {
    public static final String HOST_COLUMN_HOSTNAME = "hostListComputerName";
    public static final String HOST_COLUMN_IPADDRESS = "hostListIPAddress";
    public static final String HOST_COLUMN_COMMENT = "hostListComment";
    public static final String HOST_COLUMN_ALIASES = "hostListAliases";
    public static final String HOST_COLUMN_ENETADDRESS = "hostListEnetAddress";
    private final String[] filterKeys = new String[]{"hostListComputerName", "hostListIPAddress", "hostListComment", "hostListAliases"};
    private VFilter filterControl = null;
    private Vector filters = null;
    private int serverChunkSize = -99999;
    private int displayChunkSize = -99999;
    private VScopeNode rootNode = null;
    private String sortPreferencesKey;
    private ImageIcon smallHostIcon;
    private ImageIcon largeHostIcon;
    private final Object[][] advColumnHeaderConfig = new Object[][]{{"hostListIPAddress", new Integer(8)}, {"hostListComment", new Integer(8)}, {"hostListAliases", new Integer(8)}, {"hostListEnetAddress", new Integer(8)}};
    private final Object[][] genColumnHeaderConfig = new Object[][]{{"hostListIPAddress", new Integer(16)}};
    private static String[][] columnHeaders = null;

    public HostContent(VHostMgr vHostMgr) {
        super(vHostMgr);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vHostMgr.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vHostMgr.getToolBar());
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.smallHostIcon = vHostMgr.loadImageIcon("smallHost.gif");
        this.largeHostIcon = vHostMgr.loadImageIcon("largeHost.gif");
    }

    private void appendToResultsPane(Vector vector) {
        HostData hostData;
        String string = this.treeNode.getHTMLText();
        int n = 0;
        while (n < vector.size()) {
            hostData = (HostData)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), this.smallHostIcon, this.largeHostIcon, hostData.getHostName(), null, null, -1, (Object)hostData);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(HostContent.getColumnValues(this.theApp.getResourceBundle(), hostData));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(hostData);
            ++n;
        }
        hostData = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction((VConsoleEvent)hostData);
    }

    public void clear() {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        this.rootNode.removeAllChildren();
        System.gc();
        if (this.treeNode.getInternalRoot() == null) {
            this.treeNode.setInternalRoot(this.rootNode);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
        this.bRefresh = true;
    }

    public void createProperties() {
        HostPropsDialog hostPropsDialog = new HostPropsDialog(this.theApp, this.theApp.getFrame(), new HostData(""), true);
        ((Component)((Object)hostPropsDialog)).setVisible(true);
    }

    public void deleteSelected() {
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            return;
        }
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            n = Integer.parseInt(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteNumColumns"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHost"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)20, (int)5, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostWill"), n);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)2, (int)1, (int)20, (int)5, (int)10, (int)5);
        ImageIcon imageIcon = this.theApp.loadImageIcon("warning_bullet_icon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        Constraints.constrain((Container)jPanel, (Component)jButton, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostBullet1"), n - 5);
        flowArea.setFont(Constants.ERROR_DIALOG_FONT);
        flowArea.setForeground(Constants.ERROR_DIALOG_TEXT_COLOR);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"DeleteHostTitle");
        int n2 = Math.max(string.length(), 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n2, true);
        progressPanel.setRange(0, vector.size() + 1);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(resourceBundle, progressPanel, this, vector){
                    private final /* synthetic */ HostContent this$0;
                    private final /* synthetic */ ResourceBundle val$bundle;
                    private final /* synthetic */ Vector val$vSelected;
                    private final /* synthetic */ ProgressPanel val$progressPanel;
                    {
                        this.val$bundle = resourceBundle;
                        this.val$progressPanel = progressPanel;
                        this.this$0 = hostContent;
                        this.val$vSelected = vector;
                    }

                    public void run() {
                        this.val$progressPanel.setVisible(true);
                        int n = 0;
                        while (n < this.val$vSelected.size()) {
                            try {
                                VScopeNode vScopeNode = (VScopeNode)this.val$vSelected.elementAt(n);
                                HostData hostData = (HostData)vScopeNode.getPayload();
                                String string = ResourceStrings.getString((ResourceBundle)this.val$bundle, (String)"DeletingHost");
                                Object[] objectArray = new Object[]{hostData.getHostName()};
                                this.val$progressPanel.setText(MessageFormat.format(string, objectArray));
                                this.this$0.theApp.getHostMgr().deleteHost(hostData);
                                Content.broadcastUpdate(hostData, null, true);
                            }
                            catch (Exception exception) {
                                this.this$0.theApp.reportErrorException(exception);
                            }
                            this.val$progressPanel.setValue(n + 1);
                            ++n;
                        }
                        this.val$progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.val$bundle, (String)"RepaintingCurrentView"));
                        this.this$0.setSelected(new Vector<E>());
                        this.val$progressPanel.setValue(this.val$progressPanel.getValue() + 1);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        this.val$progressPanel.setVisible(false);
                        this.val$progressPanel.dispose();
                    }
                };
                thread.start();
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"ConfirmDeleteHostTitle"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Delete"));
    }

    public void find(Object object) {
        if (this.rootNode.getChildCount() == 0) {
            return;
        }
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            HostData hostData = (HostData)vScopeNode.getPayload();
            if (hostData == (HostData)object) {
                this.clearSelection();
                Vector<VScopeNode> vector = new Vector<VScopeNode>();
                vector.addElement(vScopeNode);
                this.setSelected(vector);
                return;
            }
            ++n;
        }
    }

    public String[][] getColumnHeaders() {
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        if (columnHeaders == null) {
            columnHeaders = applicationContext.isAdvancedHostPropertiesSupported() ? this.constructColumnHeaders(this.advColumnHeaderConfig) : this.constructColumnHeaders(this.genColumnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, HostData hostData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_HOSTNAME);
        hashtable.put(string, hostData.getHostName());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_IPADDRESS);
        hashtable.put(string, hostData.getNetworkAddress());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_COMMENT);
        hashtable.put(string, hostData.getDescription());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_ALIASES);
        hashtable.put(string, hostData.getAliases());
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_ENETADDRESS);
        hashtable.put(string, hostData.getEthernetAddress());
        return hashtable;
    }

    private int getDisplayChunkSize() {
        if (this.displayChunkSize != -99999) {
            return this.displayChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.PreferredDisplayChunkSize");
            this.displayChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.displayChunkSize = 10;
        }
        return this.displayChunkSize;
    }

    public String[] getFilterAttributes() {
        return this.filterKeys;
    }

    public VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new FilterControl();
        }
        return this.filterControl;
    }

    public Vector getFilters() {
        return this.filters;
    }

    private int getServerChunkSize() {
        if (this.serverChunkSize != -99999) {
            return this.serverChunkSize;
        }
        try {
            String string = System.getProperty("hostmgr.hosts.ServerChunkSize");
            this.serverChunkSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.serverChunkSize = 1000;
        }
        return this.serverChunkSize;
    }

    public String getSortAttribute() {
        return HOST_COLUMN_HOSTNAME;
    }

    public boolean isFilteringSupported() {
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        return networkData2 == null && networkData.getNetworkAddress().length() == 0;
    }

    public boolean offerDelete(Object object, boolean bl) {
        if (object != null && !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        if (this.theApp.getTree().getCurrentContent() == this) {
            this.getDataCache().removeElement(hostData);
        } else {
            Vector vector = this.getDataCache();
            int n = 0;
            while (n < vector.size()) {
                HostData hostData2 = (HostData)vector.elementAt(n);
                if (hostData2.equals(hostData)) {
                    vector.removeElement(hostData2);
                    break;
                }
                ++n;
            }
        }
        this.removeFromResultsPane(hostData);
        if (networkData.getNetworkAddress().length() == 0 || networkData.isStaticNetwork()) {
            return true;
        }
        this.theApp.getTree().removeNetwork(vScopeNode, networkData);
        return true;
    }

    public boolean offerNew(Object object, boolean bl) {
        if (object == null || !(object instanceof HostData)) {
            return false;
        }
        HostData hostData = (HostData)object;
        TreeNodeData treeNodeData = (TreeNodeData)this.treeNode.getPayload();
        NetworkData networkData = treeNodeData.getNetworkData();
        VScopeNode vScopeNode = (VScopeNode)this.treeNode.getParent();
        TreeNodeData treeNodeData2 = (TreeNodeData)vScopeNode.getPayload();
        NetworkData networkData2 = treeNodeData2.getNetworkData();
        NetworkData networkData3 = networkData;
        if (networkData3.getNetworkAddress().length() == 0) {
            networkData3 = networkData2;
        }
        boolean bl2 = true;
        if (networkData3 != null) {
            bl2 = networkData3.belongsNetwork(hostData.getNetworkAddress());
        }
        if (bl || !bl2) {
            return bl2;
        }
        Vector<HostData> vector = new Vector<HostData>();
        vector.addElement(hostData);
        this.appendToResultsPane(vector);
        return true;
    }

    public void refresh() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear();
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchHostsTitle");
        final String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"HostBatchReceived");
        String string3 = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Ellipsis");
        final String string4 = String.valueOf(string) + " " + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RefreshInterrupted") + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Ellipsis");
        int n = Math.max(string.length(), string3.length());
        n = Math.max(n, string2.length());
        n = Math.max(n, string4.length());
        n = Math.max(n, 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n, true, true);
        progressPanel.setRange(0, 100);
        progressPanel.setValue(0);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        progressPanel.setStopListener(new ActionListener((ListFetch)myListFetch, progressPanel){
            private final /* synthetic */ ProgressPanel val$progressPanel;
            private final /* synthetic */ ListFetch val$listFetch;
            {
                this.val$listFetch = listFetch;
                this.val$progressPanel = progressPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.val$listFetch.isInterrupted()) {
                    this.val$progressPanel.setText(string4);
                    this.val$listFetch.interrupt();
                }
            }
        });
        progressPanel.show();
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    this.updateStatusBar();
                    this.showFilteredStatus();
                    progressPanel.dispose();
                    theApp.waitOff();
                    return;
                }
                if (listFetchEvent.getSize() > 0) {
                    progressPanel.setValue(listFetchEvent.getNumReceived() * 100 / listFetchEvent.getSize());
                    Object[] objectArray = new Object[]{new Integer(listFetchEvent.getNumReceived()), new Integer(listFetchEvent.getSize())};
                    String string = MessageFormat.format(string2, objectArray);
                    progressPanel.appendText(string);
                    if (listFetchEvent.getNumReceived() >= listFetchEvent.getSize()) {
                        progressPanel.setValue(100);
                    }
                }
                this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    private void removeFromResultsPane(HostData hostData) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            HostData hostData2 = (HostData)vScopeNode.getPayload();
            if (hostData2 == hostData) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void renameSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        HostData hostData = (HostData)vScopeNode.getPayload();
        HostRenameDialog hostRenameDialog = new HostRenameDialog(this.theApp, this.theApp.getFrame(), hostData);
        ((Dialog)((Object)hostRenameDialog)).show();
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public void updateDefaultColumns() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)HOST_COLUMN_HOSTNAME));
        Object[][] objectArray = new Object[][]{{HOST_COLUMN_HOSTNAME, new Integer(128)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        string = "+0";
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"HostListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        HostData hostData = (HostData)vScopeNode.getPayload();
        HostPropsDialog hostPropsDialog = new HostPropsDialog(this.theApp, this.theApp.getFrame(), hostData, false);
        ((Dialog)((Object)hostPropsDialog)).show();
    }

    public String whatAmI() {
        return "hosts";
    }

    private class FilterControl
    implements VFilter {
        private Vector helpCache = new Vector(12);
        private FilterPanel filterPanel = null;
        private Action filterAction = null;
        private VConsoleProperties properties = null;

        static /* synthetic */ Action access$0(FilterControl filterControl) {
            return filterControl.filterAction;
        }

        public Vector applyFilter(VScopeNode vScopeNode) {
            return null;
        }

        public void clearFilter() {
            this.filterPanel.setDefaultState();
            this.filterAction.setEnabled(false);
        }

        public boolean getFilterEnabled() {
            if (this.filterPanel != null) {
                this.filterPanel.setFilterItems(HostContent.this.getFilters());
            }
            if (this.filterAction != null) {
                Vector vector = HostContent.this.getFilters();
                int n = 0;
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                    n += filterItem.getValue().length();
                    ++n2;
                }
                this.filterAction.setEnabled(n > 0);
            }
            return false;
        }

        public boolean getFindMode() {
            return false;
        }

        public void setFilterAction(Action action) {
            this.filterAction = action;
        }

        public void setFilterEnabled(boolean bl) {
            HostContent.this.setFilters(bl ? this.filterPanel.getFilterItems() : new Vector());
            HostContent.this.refresh();
        }

        public void setFindMode(boolean bl) {
        }

        public void setOptionPane(VOptionPane vOptionPane) {
            if (vOptionPane == null) {
                return;
            }
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FilterControl this$1;
                {
                    this.this$1 = filterControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterControl.access$0(this.this$1).setEnabled(actionEvent.getID() > 0);
                }
            };
            GenInfoPanel genInfoPanel = new GenInfoPanel(vOptionPane);
            this.filterPanel = new FilterPanel(HostContent.this.getFilterAttributes(), "com.sun.admin.hostmgr.client.resources.Resources", this.helpCache, genInfoPanel, actionListener);
            this.filterPanel.setFilterItems(HostContent.this.getFilters());
            vOptionPane.getContentPane().setLayout(new BorderLayout());
            vOptionPane.getContentPane().add((Component)this.filterPanel, "Center");
            vOptionPane.repaint();
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            this.properties = vConsoleProperties;
        }
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper hostMgr;
        NetworkData networkData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            try {
                this.listProps = new ListProperties();
                this.listProps.setSortOrderAscending();
                this.listProps.setSortColumn(HostContent.this.getSortAttribute());
                this.listProps.setChunkSize(n);
                if (HostContent.this.filters != null) {
                    this.listProps.setFilters(HostContent.this.filters);
                }
            }
            catch (Exception exception) {}
            this.hostMgr = HostContent.this.theApp.getHostMgr();
            TreeNodeData treeNodeData = (TreeNodeData)HostContent.this.treeNode.getPayload();
            this.networkData = treeNodeData.getNetworkData();
            if (this.networkData.getNetworkAddress().length() == 0) {
                VScopeNode vScopeNode = (VScopeNode)HostContent.this.treeNode.getParent();
                treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                this.networkData = treeNodeData.getNetworkData();
            }
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"BEANNAME");
        }

        public Vector listAll() throws AdminException {
            try {
                if (this.networkData == null) {
                    return this.hostMgr.listHosts(this.listProps);
                }
                return this.hostMgr.listHostsByNetwork(this.networkData, this.listProps);
            }
            catch (HostAuthException hostAuthException) {
                throw new AdminException(ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"NoReadAuth"));
            }
        }

        public void listEnd() throws AdminException {
            try {
                if (this.networkData == null) {
                    this.hostMgr.listHostsEnd();
                } else {
                    this.hostMgr.listHostsByNetworkEnd();
                }
            }
            catch (HostAuthException hostAuthException) {
                throw new AdminException(ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"NoReadAuth"));
            }
        }

        public Vector listNext() throws AdminException {
            try {
                if (this.networkData == null) {
                    return this.hostMgr.listHostsNext();
                }
                return this.hostMgr.listHostsByNetworkNext();
            }
            catch (HostAuthException hostAuthException) {
                throw new AdminException(ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"NoReadAuth"));
            }
        }

        public int listPrime() throws AdminException {
            try {
                if (this.networkData == null) {
                    return this.hostMgr.listHostsPrime(this.listProps);
                }
                return this.hostMgr.listHostsByNetworkPrime(this.networkData, this.listProps);
            }
            catch (HostAuthException hostAuthException) {
                throw new AdminException(ResourceStrings.getString((ResourceBundle)HostContent.this.theApp.getResourceBundle(), (String)"NoReadAuth"));
            }
        }

        public void listTrace(String string) {
            HostContent.this.theApp.Trace(string);
        }
    }
}

