/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli.profile;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.cli.UMgrCliTool;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrCliArgParsingException;
import com.sun.admin.usermgr.common.UserMgrCliHelpException;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserMgrProfCli
extends UMgrCliTool {
    private Vector vObjs = new Vector();
    private boolean bListAll;
    private boolean bLongList;
    private String strOldRightName;
    private CommandLineOption coTaskFile;
    private CommandLineOption coHelpHTML;
    private CommandLineOption coProfileName;
    private CommandLineOption coDescription;
    private CommandLineOption coHelp;
    private CommandLineOption coAddAuth;
    private CommandLineOption coDelAuth;
    private CommandLineOption coAddProf;
    private CommandLineOption coDelProf;
    ResourceBundle bundle;
    private CommandLineOption coPolicy;
    private boolean tsolPolicy;
    private static final String TSOL_POLICY = "tsol";
    private static final String SUSER_POLICY = "suser";
    private static final String TSOL_LABEL = "label";
    private static final String TSOL_CLEARANCE = "clearance";
    private static final String TSOL_PRIVS = "privs";

    public UserMgrProfCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.usermgr.cli.profile.resources.Resources", this.getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.usermgr.cli.profile.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
    }

    private String[] VectorToStrArray(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void addObject() throws Exception {
        try {
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in addObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.getUserMgr().addRight(rightObj);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        RightObj rightObj = new RightObj();
        ProfAttrObj profAttrObj = new ProfAttrObj();
        if (this.getDebugStatus()) {
            this.trace("checkForAddOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofadd_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofadd_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coProfileName);
            commandParser.addOption((CommandOption)this.coDescription);
            commandParser.addOption((CommandOption)this.coAddAuth);
            commandParser.addOption((CommandOption)this.coAddProf);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelpHTML);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coProfileName.wasSet()) {
                    stringArray2 = (String)this.coProfileName.getValue();
                    this.trace("Rightname :  " + (String)stringArray2);
                    if (this.checkRightExists((String)stringArray2)) {
                        throw new UserException("EXM_CLI_RIGHT_ALREADY_EXIST", (String)stringArray2);
                    }
                    if (stringArray2.indexOf(":") > -1) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_NAME", (String)stringArray2);
                    }
                    rightObj.setRightName((String)stringArray2);
                    profAttrObj.setProfName((String)stringArray2);
                }
                if (this.coDescription.wasSet()) {
                    stringArray2 = (String)this.coDescription.getValue();
                    this.trace("Description :  " + (String)stringArray2);
                    if (stringArray2.indexOf("\n") > -1 || stringArray2.indexOf(":") > -1) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_DESC");
                    }
                    rightObj.setRightDescription((String)stringArray2);
                    profAttrObj.setLongDesc((String)stringArray2);
                }
                if (this.coAddAuth.wasSet()) {
                    stringArray2 = this.coAddAuth.getValues();
                    profAttrObj.setAuthNamesVector((Vector)stringArray2);
                }
                if (this.coAddProf.wasSet()) {
                    stringArray2 = this.coAddProf.getValues();
                    this.checkListRights((Vector)stringArray2);
                    profAttrObj.setProfNamesVector((Vector)stringArray2);
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelpHTML.wasSet()) {
                    stringArray2 = (String)this.coHelpHTML.getValue();
                    this.trace("HTML = " + (String)stringArray2);
                    if (!stringArray2.endsWith(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"right_help_name_extension")) || stringArray2.indexOf(" ") > -1) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_HELP", (String)stringArray2);
                    }
                    profAttrObj.setLongDescId((String)stringArray2);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            rightObj.setProfAttr(profAttrObj);
            this.vObjs.addElement(rightObj);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        RightObj rightObj = new RightObj();
        if (this.getDebugStatus()) {
            this.trace("checkForDeleteOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofdel_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofdel_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coProfileName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coProfileName.wasSet()) {
                    stringArray2 = (String[])this.coProfileName.getValue();
                    this.trace("Rightname :  " + (String)stringArray2);
                    if (!this.checkRightExists((String)stringArray2)) {
                        throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", (String)stringArray2);
                    }
                    rightObj.setRightName((String)stringArray2);
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(rightObj);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        String[] stringArray2 = null;
        RightObj rightObj = new RightObj();
        if (this.getDebugStatus()) {
            this.trace("checkForModifyOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofmod_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofmod_desc"), true, null, null);
        CommandLineOption commandLineOption = new CommandLineOption("description", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_description_desc"), "d", 1, true, false, (Object)"", true);
        this.coHelpHTML = new CommandLineOption("html help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_html_desc"), "m", 1, true, false, (Object)"", true);
        try {
            commandParser.addOption((CommandOption)this.coProfileName);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)this.coAddAuth);
            commandParser.addOption((CommandOption)this.coDelAuth);
            commandParser.addOption((CommandOption)this.coAddProf);
            commandParser.addOption((CommandOption)this.coDelProf);
            commandParser.addOption((CommandOption)this.coHelpHTML);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coProfileName.wasSet()) {
                    string = (String)this.coProfileName.getValue();
                    this.trace("Rightname :  " + string);
                    if (!this.checkRightExists(string)) {
                        throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", string);
                    }
                }
                if (this.coAddAuth.wasSet()) {
                    vector4 = this.coAddAuth.getValues();
                    this.trace("coAddAuth.wasSet");
                }
                if (this.coDelAuth.wasSet()) {
                    vector3 = this.coDelAuth.getValues();
                    this.trace("vDelAuths.wasSet");
                }
                if (this.coAddProf.wasSet()) {
                    vector2 = this.coAddProf.getValues();
                    this.checkListRights(vector2);
                    this.trace("coAddProf.wasSet");
                }
                if (this.coDelProf.wasSet()) {
                    vector = this.coDelProf.getValues();
                    this.checkListRights(vector);
                    this.trace("coDelProf.wasSet");
                }
                if (commandLineOption.wasSet()) {
                    string2 = (String)commandLineOption.getValue();
                    if (string2.indexOf("\n") > -1 || string2.indexOf(":") > -1) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_DESC");
                    }
                    this.trace("Description :  " + string2);
                }
                if (this.coHelpHTML.wasSet()) {
                    string3 = (String)this.coHelpHTML.getValue();
                    if (!string3.endsWith(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"right_help_name_extension")) || string3.indexOf(" ") > -1) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_HELP", string3);
                    }
                    this.trace("HTML = " + string3);
                }
                if (this.coTaskFile.wasSet()) {
                    object = (String[])this.coTaskFile.getValue();
                    this.trace("Task = " + (String)object);
                    this.setTaskOperation(object.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            object = commandParser.getUnmatchedOptions();
            if (((String[])object).length >= 1) {
                int n = 0;
                while (n < ((String[])object).length) {
                    this.trace("unrecognized option:  " + object[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", object[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        rightObj = this.getObjectProps(string);
        ProfAttrObj profAttrObj = rightObj.getProfAttr();
        if (profAttrObj == null) {
            this.trace("modify no profattr");
            profAttrObj = new ProfAttrObj(string);
            object = rightObj.getRightDescription();
            profAttrObj.setLongDesc((String)object);
        }
        if (string2 != null) {
            rightObj.setRightDescription(string2);
            profAttrObj.setLongDesc(string2);
        }
        if (string3 != null) {
            profAttrObj.setLongDescId(string3);
        }
        if (vector2.size() > 0) {
            stringArray2 = this.VectorToStrArray(vector2);
            profAttrObj.addProfNames(stringArray2);
        }
        if (vector.size() > 0) {
            stringArray2 = this.VectorToStrArray(vector);
            profAttrObj.delProfNames(stringArray2);
        }
        if (vector4.size() > 0) {
            stringArray2 = this.VectorToStrArray(vector4);
            profAttrObj.addAuthNames(stringArray2);
        }
        if (vector3.size() > 0) {
            stringArray2 = this.VectorToStrArray(vector3);
            profAttrObj.delAuthNames(stringArray2);
        }
        rightObj.setProfAttr(profAttrObj);
        this.vObjs.addElement(rightObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForViewOptions(String[] stringArray) throws Exception {
        RightObj rightObj = new RightObj();
        boolean bl = false;
        if (this.getDebugStatus()) {
            this.trace("checkForViewOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandLineOption commandLineOption = new CommandLineOption("profilename", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_profilename_desc"), "n", 1, true, true, null, true);
        CommandLineOption commandLineOption2 = new CommandLineOption("longDisplay", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_longdisplay_desc"), "l", 0, true, false, (Object)"", true);
        this.coPolicy = new CommandLineOption("policy", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_policy_desc"), "p", 1, true, false, (Object)"", true);
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofls_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smprofls_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)commandLineOption2);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            commandParser.addOption((CommandOption)this.coPolicy);
            if (commandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    stringArray2 = commandLineOption.getValues();
                    this.checkListRights((Vector)stringArray2);
                    Enumeration enumeration = stringArray2.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        RightObj rightObj2 = new RightObj(string);
                        this.vObjs.addElement(rightObj2);
                    }
                    bl = true;
                }
                if (commandLineOption2.wasSet()) {
                    this.setDisplayLongList(true);
                }
                if (this.coPolicy.wasSet()) {
                    stringArray2 = (String)this.coPolicy.getValue();
                    this.trace("Policy :  " + (String)stringArray2);
                    if (stringArray2.equals(TSOL_POLICY)) {
                        this.tsolPolicy = true;
                    } else {
                        if (!stringArray2.equals(SUSER_POLICY)) throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_POLICY", (String)stringArray2);
                        this.tsolPolicy = false;
                    }
                } else {
                    this.tsolPolicy = false;
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            if (bl || this.getOperation() != 3) return;
            this.bListAll = true;
            return;
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (!this.getDebugStatus()) throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            throwable.printStackTrace();
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkListRights(Vector vector) throws Exception {
        Vector vector2 = this.getListRights();
        int n = 0;
        while (n < vector.size()) {
            Enumeration enumeration = vector2.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                RightObj rightObj = (RightObj)enumeration.nextElement();
                String string = rightObj.getRightName();
                if (!string.equals(vector.elementAt(n))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", (String)vector.elementAt(n));
            }
            ++n;
        }
    }

    private boolean checkRightExists(String string) {
        Vector vector = this.getListRights();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RightObj rightObj = (RightObj)enumeration.nextElement();
            String string2 = rightObj.getRightName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteObject() throws Exception {
        this.trace("in UserMgrProfCli->deleteObject()");
        try {
            this.trace("vObjs.size() = " + this.vObjs.size());
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.getUserMgr().deleteRight(rightObj);
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block6: {
            RightObj rightObj = new RightObj();
            CommandParser commandParser = new CommandParser("UserMgrProfCli", "main tool for users related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.trace("Task = " + string);
                        this.setTaskOperation(string.charAt(0));
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                this.coHelp.wasSet();
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new UserException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block6;
                throwable.printStackTrace();
            }
        }
    }

    private Vector getListRights() {
        Vector vector = null;
        try {
            vector = this.getUserMgr().getRightProfs();
        }
        catch (Exception exception) {}
        return vector;
    }

    private RightObj getObjectProps(String string) throws Exception {
        RightObj rightObj = new RightObj(string);
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr svc wrapper` is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            rightObj = this.getUserMgr().readRight(string);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return rightObj;
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, false, false, (Object)"V", true, true);
        this.coProfileName = new CommandLineOption("name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_profilename_desc"), "n", 1, false, false, null, true);
        this.coDescription = new CommandLineOption("description", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_description_desc"), "d", 1, false, false, (Object)"", true);
        this.coAddProf = new CommandLineOption("addprof", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_addprof_desc"), "p", 1, true, true, (Object)"", true);
        this.coDelProf = new CommandLineOption("delprof", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_delprof_desc"), "q", 1, true, true, (Object)"", true);
        this.coAddAuth = new CommandLineOption("addauth", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_addauth_desc"), "a", 1, true, true, (Object)"", true);
        this.coDelAuth = new CommandLineOption("delauth", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_delauth_desc"), "r", 1, true, true, (Object)"", true);
        this.coHelpHTML = new CommandLineOption("html help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_html_desc"), "m", 1, false, false, (Object)"", true);
        this.coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    public boolean isDisplayLongList() {
        return this.bLongList;
    }

    public void modifyObject() throws Exception {
        try {
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            this.trace("profile is:  " + rightObj.getRightName());
            if (this.getUserMgr() == null) {
                this.trace("in modifyObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.getUserMgr().modifyRight(rightObj);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            return 0;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            String string = userMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (UserException userException) {
            this.trace("got UserException in runCommandLine");
            String string = userException.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (UserException userException) {
            this.trace("runCommandLine, UserException:  " + userException.getLocalizedMessage());
            this.handleErrors(userException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    public void setDisplayLongList(boolean bl) {
        this.bLongList = bl;
    }

    public void viewObjectProps() throws Exception {
        RightObj rightObj = null;
        try {
            if (this.getUserMgr() == null) {
                this.trace("in viewObjectProps:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            if (this.bListAll) {
                this.vObjs = this.getUserMgr().getAllRights();
                Enumeration enumeration = this.vObjs.elements();
                while (enumeration.hasMoreElements()) {
                    rightObj = (RightObj)enumeration.nextElement();
                    this.viewUserOutput(rightObj);
                }
            } else if (this.vObjs != null) {
                Enumeration enumeration = this.vObjs.elements();
                while (enumeration.hasMoreElements()) {
                    rightObj = (RightObj)enumeration.nextElement();
                    rightObj = this.getUserMgr().readRight(rightObj.getRightName());
                    this.viewUserOutput(rightObj);
                }
            }
        }
        catch (Exception exception) {
            this.trace("exception in viewObjectProps(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewUserOutput(RightObj rightObj) {
        ProfAttrObj profAttrObj = rightObj.getProfAttr();
        ArrayList arrayList = rightObj.getExecAttrs();
        if (this.isDisplayLongList()) {
            String string;
            String[] stringArray;
            if (profAttrObj == null) {
                System.out.println("profile in error");
            } else {
                int n;
                Object object;
                System.out.println("Profile name:   " + profAttrObj.getProfName());
                System.out.println("  Description:  " + profAttrObj.getLongDesc());
                stringArray = profAttrObj.getAuthNames();
                if (stringArray != null) {
                    object = "  auths:        ";
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object = ((String)object).concat(stringArray[n2]);
                        n = n2 + 1;
                        if (n < stringArray.length) {
                            object = ((String)object).concat(",");
                        }
                        ++n2;
                    }
                    System.out.println((String)object);
                }
                if ((object = profAttrObj.getProfNames()) != null) {
                    String string2 = "  profiles:     ";
                    n = 0;
                    while (n < ((String[])object).length) {
                        string2 = string2.concat(object[n]);
                        int n3 = n + 1;
                        if (n3 < ((Object)object).length) {
                            string2 = string2.concat(",");
                        }
                        ++n;
                    }
                    System.out.println(string2);
                }
                if ((string = profAttrObj.getLongDescId()) != null) {
                    System.out.println("  help:         " + string);
                }
            }
            if (arrayList != null) {
                stringArray = null;
                int n = 0;
                while (n < arrayList.size()) {
                    stringArray = (String[])arrayList.get(n);
                    if (!(this.tsolPolicy ? !stringArray.getPolicy().equals(TSOL_POLICY) : !stringArray.getPolicy().equals(SUSER_POLICY))) {
                        String string3;
                        String string4;
                        String string5;
                        System.out.println("  Command:      " + stringArray.getId());
                        System.out.println("     policy:    " + stringArray.getPolicy());
                        System.out.println("     type:      " + stringArray.getType());
                        string = stringArray.getUid();
                        if (string != null) {
                            System.out.println("     uid:       " + string);
                        }
                        if ((string5 = stringArray.getEuid()) != null) {
                            System.out.println("     euid:      " + string5);
                        }
                        if ((string4 = stringArray.getGid()) != null) {
                            System.out.println("     gid:       " + string4);
                        }
                        if ((string3 = stringArray.getEgid()) != null) {
                            System.out.println("     egid:      " + string3);
                        }
                        if (this.tsolPolicy) {
                            Vector vector;
                            Vector vector2;
                            Vector vector3 = stringArray.getAttribute(TSOL_LABEL);
                            if (vector3 != null) {
                                System.out.println("     label:     " + (String)vector3.elementAt(0));
                            }
                            if ((vector2 = stringArray.getAttribute(TSOL_CLEARANCE)) != null) {
                                System.out.println("     clearance: " + (String)vector2.elementAt(0));
                            }
                            if ((vector = stringArray.getAttribute(TSOL_PRIVS)) != null) {
                                String string6 = "     privs:     ";
                                Enumeration enumeration = vector.elements();
                                while (enumeration.hasMoreElements()) {
                                    String string7 = (String)enumeration.nextElement();
                                    string6 = string6.concat(string7);
                                    string6 = string6.concat(",");
                                }
                                int n4 = string6.length();
                                string6 = string6.substring(0, n4 - 1);
                                System.out.println(string6);
                            }
                        }
                    }
                    ++n;
                }
            }
            System.out.println(" ");
        } else {
            System.out.println("Profile name: " + rightObj.getRightName() + "   Description: " + rightObj.getRightDescription());
        }
    }
}

