/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.tsol.common.AuditUserObj;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.AddRoleWizard;
import com.sun.admin.usermgr.client.rbac.AssignRightDlg;
import com.sun.admin.usermgr.client.rbac.AssignRoleDlg;
import com.sun.admin.usermgr.client.rbac.ConfDelRolePanel;
import com.sun.admin.usermgr.client.rbac.RolePropsDlg;
import com.sun.admin.usermgr.client.rbac.UMgrRoleMenuBar;
import com.sun.admin.usermgr.client.rbac.UMgrRoleTBar;
import com.sun.admin.usermgr.client.users.UserPoliciesDlg;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.services.PersistenceAgent;
import com.sun.management.viper.services.PersistenceException;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class RoleContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ImageIcon smallRoleIcon;
    private ImageIcon largeRoleIcon;
    private UMgrRoleMenuBar roleMenuBar;
    private UMgrRoleTBar roleToolBar;
    private VUserMgr theApp;
    RoleContent roleContent;

    public RoleContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.roleContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.roleMenuBar = new UMgrRoleMenuBar(vUserMgr, this);
        this.roleToolBar = new UMgrRoleTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.roleMenuBar);
        this.rootNode.setToolBar((JToolBar)this.roleToolBar);
        this.smallRoleIcon = vUserMgr.loadImageIcon("admin_roles_16.gif", "");
        this.largeRoleIcon = vUserMgr.loadImageIcon("admin_roles_32.gif", "");
    }

    public void appendToResultsPane(Vector vector) {
        UserObj userObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/roles.html", this.theApp.getClass());
        int n = 0;
        while (n < vector.size()) {
            userObj = (UserObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.roleMenuBar.getPopupMenu(), this.smallRoleIcon, this.largeRoleIcon, userObj.getUserName(), null, null, -1, (Object)userObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setDescription(userObj.getUserDescription());
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(userObj);
            ++n;
        }
        userObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)userObj);
    }

    public void assignRight() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                RoleContent.this.theApp.waitOn();
                Vector vector = RoleContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                UserObj userObj = (UserObj)vScopeNode.getPayload();
                try {
                    userObj = RoleContent.this.theApp.getUserMgr().getFullAttributes(userObj);
                }
                catch (Exception exception) {
                    RoleContent.this.theApp.reportErrorException(exception);
                    return;
                }
                AssignRightDlg assignRightDlg = new AssignRightDlg(RoleContent.this.theApp, RoleContent.this.theApp.getFrame(), userObj, true);
                ((Component)((Object)assignRightDlg)).setVisible(true);
                RoleContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void assignRole() {
        Thread thread = new Thread(){

            public void run() {
                RoleContent.this.theApp.waitOn();
                AssignRoleDlg assignRoleDlg = new AssignRoleDlg(RoleContent.this.theApp, RoleContent.this.theApp.getFrame());
                if (!assignRoleDlg.canDisplayDialog()) {
                    ((Window)((Object)assignRoleDlg)).dispose();
                    RoleContent.this.theApp.waitOff();
                    return;
                }
                ((Component)((Object)assignRoleDlg)).setVisible(true);
                RoleContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.roleMenuBar);
        this.rootNode.setToolBar((JToolBar)this.roleToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void createProperties() {
        Thread thread = new Thread(){

            public void run() {
                RoleContent.this.theApp.waitOn();
                AddRoleWizard addRoleWizard = new AddRoleWizard(RoleContent.this.theApp, RoleContent.this.roleContent, ResourceStrings.getString((ResourceBundle)RoleContent.this.bundle, (String)"role_add_wiz_tile"));
                Container container = null;
                VConsoleProperties vConsoleProperties = RoleContent.this.theApp.getProperties();
                try {
                    String string = vConsoleProperties.getProperty("vconsole.dialogtype");
                    if (string == null || string.equals("vconsole.frame")) {
                        JFrame jFrame;
                        container = jFrame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
                        if (jFrame == null) {
                            jFrame = new JFrame();
                        }
                        VDialog vDialog = new VDialog((Frame)jFrame, true);
                        addRoleWizard.setContainer((Component)vDialog);
                        vDialog.pack();
                    } else if (string.equals("vconsole.internalframe")) {
                        JInternalFrame jInternalFrame = new JInternalFrame();
                        addRoleWizard.setContainer(jInternalFrame);
                        jInternalFrame.setSize(addRoleWizard.getPreferredSize());
                        JDesktopPane jDesktopPane = (JDesktopPane)vConsoleProperties.getPropertyObject("vconsole.desktoppane");
                        jDesktopPane.add(jInternalFrame);
                        container = jDesktopPane;
                    }
                }
                catch (Exception exception) {
                    RoleContent.this.theApp.reportErrorException(exception);
                }
                addRoleWizard.reset();
                addRoleWizard.start();
                if (container != null) {
                    addRoleWizard.showCenter(container);
                }
                RoleContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void deleteSelected() {
        final ConfDelRolePanel confDelRolePanel = new ConfDelRolePanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_role"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                        UserObj userObj = (UserObj)vScopeNode.getPayload();
                        if (confDelRolePanel.delHomeDir()) {
                            userObj.setDelHomeDir(true);
                        }
                        String string = userObj.getUserName();
                        theApp.getUserMgr().deleteUser(userObj);
                        try {
                            theApp.getUserMgr().deleteAuditUser(string);
                        }
                        catch (Exception exception) {
                            theApp.reportErrorException(exception);
                        }
                        PersistenceAgent persistenceAgent = null;
                        try {
                            persistenceAgent = new PersistenceAgent(theApp.getToolInfrastructure());
                            String string2 = String.valueOf(UserPoliciesDlg.USER_POLICIES) + string;
                            if (persistenceAgent != null) {
                                persistenceAgent.delete(string2);
                            }
                        }
                        catch (PersistenceException persistenceException) {}
                        theApp.setAllRolesCache(null);
                        this.removeFromResultsPane(userObj);
                    }
                    catch (AdminException adminException) {
                        theApp.reportErrorException((Exception)((Object)adminException));
                    }
                    ++n;
                }
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelRolePanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_desc"), new Integer(32)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    protected ListProperties getListProperties() {
        return null;
    }

    public UMgrRoleMenuBar getMenuBar() {
        return this.roleMenuBar;
    }

    private int getServerChunkSize() {
        return 0;
    }

    public UMgrRoleTBar getToolBar() {
        return this.roleToolBar;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void refresh() {
        this.theApp.setAdminRoleCache(null);
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    RoleContent.this.theApp.waitOff();
                    return;
                }
                RoleContent.this.updateStatusBar();
                RoleContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                RoleContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    private void removeFromResultsPane(UserObj userObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            UserObj userObj2 = (UserObj)vScopeNode.getPayload();
            if (userObj2 == userObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void renameSelected() {
    }

    protected void setListProperties(ListProperties listProperties) {
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RoleListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                Object object;
                RoleContent.this.theApp.waitOn();
                Vector vector = RoleContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                UserObj userObj = (UserObj)vScopeNode.getPayload();
                try {
                    userObj = RoleContent.this.theApp.getUserMgr().getFullAttributes(userObj);
                }
                catch (Exception exception) {
                    RoleContent.this.theApp.reportErrorException(exception);
                    return;
                }
                try {
                    object = RoleContent.this.theApp.getUserMgr().getAuditUser(userObj.getUserName());
                    userObj.setTsolAudit((AuditUserObj)object);
                }
                catch (Exception exception) {
                    RoleContent.this.theApp.reportErrorException(exception);
                }
                object = new RolePropsDlg(RoleContent.this.theApp, RoleContent.this.theApp.getFrame(), userObj);
                ((Component)object).setVisible(true);
                RoleContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"roles");
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;

        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)RoleContent.this.bundle, (String)"roles");
        }

        public Vector listAll() throws AdminException {
            Vector vector = null;
            try {
                vector = RoleContent.this.theApp.getUserMgr().getAllRoles();
                RoleContent.this.theApp.setAllRolesCache(vector);
            }
            catch (Exception exception) {
                RoleContent.this.theApp.reportErrorException(exception);
            }
            if (vector == null) {
                return new Vector();
            }
            return vector;
        }
    }
}

