/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.tsol.common;

import com.sun.admin.cis.common.AdminCommonTools;
import java.io.Serializable;

public class AuditClassObj
implements Serializable,
Cloneable {
    public static final int AUDIT_BOTH = 0;
    public static final int AUDIT_SUCCESS = 1;
    public static final int AUDIT_FAILURE = 2;
    public static final String AUDIT_SPECIAL_CLASS = "all classes";
    private String shortName = null;
    private String longName = null;
    private int flag = 0;
    private boolean except = false;

    public AuditClassObj() {
    }

    public AuditClassObj(String string) {
        int n = 0;
        if (string.startsWith("^", n)) {
            this.except = true;
            ++n;
        }
        if (string.startsWith("+", n)) {
            this.flag = 1;
            ++n;
        } else if (string.startsWith("-", n)) {
            this.flag = 2;
            ++n;
        }
        this.shortName = string.substring(n);
    }

    public AuditClassObj(String string, String string2) {
        this.shortName = string;
        this.longName = string2;
    }

    public Object clone() {
        AuditClassObj auditClassObj = new AuditClassObj(this.shortName);
        auditClassObj.setShortName(this.shortName);
        auditClassObj.setLongName(this.longName);
        auditClassObj.setFlag(this.flag);
        auditClassObj.setExcept(this.except);
        return auditClassObj;
    }

    public void debugPrint() {
        AdminCommonTools.CMN_Trace3((String)("Audit Class Entry For " + this.shortName));
        AdminCommonTools.CMN_Trace3((String)("    Long Name: " + this.longName));
        if (this.flag == 1) {
            AdminCommonTools.CMN_Trace3((String)"    Audit SUCCESS only");
        } else if (this.flag == 2) {
            AdminCommonTools.CMN_Trace3((String)"    Audit FAILURE only");
        } else {
            AdminCommonTools.CMN_Trace3((String)"    Audit BOTH");
        }
        if (this.except) {
            AdminCommonTools.CMN_Trace3((String)"    Except flag is ON");
        } else {
            AdminCommonTools.CMN_Trace3((String)"    Except flag is OFF");
        }
    }

    public boolean equals(AuditClassObj auditClassObj) {
        String string = auditClassObj.getShortName();
        if (this.shortName == null ? string != null : !this.shortName.equals(string)) {
            return false;
        }
        String string2 = auditClassObj.getLongName();
        if (this.longName == null ? string2 != null : !this.longName.equals(string2)) {
            return false;
        }
        if (this.flag != auditClassObj.getFlag()) {
            return false;
        }
        return this.except == auditClassObj.getExcept();
    }

    public boolean getExcept() {
        return this.except;
    }

    public int getFlag() {
        return this.flag;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setExcept(boolean bl) {
        this.except = bl;
    }

    public void setFlag(int n) {
        this.flag = n;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String toString() {
        String string = new String("");
        if (this.except) {
            string = String.valueOf(string) + "^";
        }
        if (this.flag == 1) {
            string = String.valueOf(string) + "+";
        } else if (this.flag == 2) {
            string = String.valueOf(string) + "-";
        }
        string = String.valueOf(string) + this.shortName;
        return string;
    }
}

