/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.TnrhdbPropsDialog;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.TnrhdbData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class TnrhdbContent
extends Content {
    public static final String TNRHDB_COLUMN_IPADDRESS = "detail_tnrhdb_ipaddr";
    public static final String TNRHDB_COLUMN_TEMPLATE = "detail_tnrhdb_template";
    public static final String TNRHDB_COLUMN_NAME = "detail_tnrhdb_name";
    private final String[] filterKeys = new String[]{"detail_tnrhdb_ipaddr", "detail_tnrhdb_template"};
    private Vector filters = null;
    private int serverChunkSize = -99999;
    private int displayChunkSize = -99999;
    private VScopeNode rootNode = null;
    private ImageIcon smallHostIcon;
    private ImageIcon largeHostIcon;
    private ImageIcon smallTnrhdbIcon;
    private ImageIcon largeTnrhdbIcon;
    private VHostMgr App;
    private ResourceBundle bundle;
    private String sortPreferencesKey;
    private final Object[][] columnHeaderConfig = new Object[][]{{"detail_tnrhdb_name", new Integer(16)}, {"detail_tnrhdb_template", new Integer(18)}};
    private static String[][] columnHeaders = null;
    private static String HELP_FILE = "secfam_main";

    public TnrhdbContent(VHostMgr vHostMgr) {
        super(vHostMgr);
        this.App = vHostMgr;
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vHostMgr.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vHostMgr.getToolBar());
        this.bundle = vHostMgr.getResourceBundle();
        this.smallTnrhdbIcon = vHostMgr.loadImageIcon("remotehostdata.gif");
        this.largeTnrhdbIcon = vHostMgr.loadImageIcon("remotehost32.gif");
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
    }

    public void clear() {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getMenuBar());
        this.rootNode.setToolBar((JToolBar)this.theApp.getToolBar());
        this.treeNode.setInternalRoot(this.rootNode);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
        this.bRefresh = true;
    }

    public void createProperties() {
        TnrhdbPropsDialog tnrhdbPropsDialog = new TnrhdbPropsDialog(this.theApp, this.theApp.getFrame(), null, true);
        ((Component)((Object)tnrhdbPropsDialog)).setVisible(true);
    }

    public void deleteSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        TnrhdbData tnrhdbData = (TnrhdbData)vScopeNode.getPayload();
        try {
            this.theApp.getHostMgr().deleteTnrhdb(tnrhdbData);
        }
        catch (Exception exception) {}
        ((TreeNodeData)this.App.getDisplayModel().getSelectedNavigationNode().getPayload()).getContent().refresh();
    }

    public void find(Object object) {
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, TnrhdbData tnrhdbData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TNRHDB_COLUMN_IPADDRESS);
        if (tnrhdbData.getPrefixLen() != null) {
            hashtable.put(string, String.valueOf(tnrhdbData.getIpAddress()) + "/" + tnrhdbData.getPrefixLen());
        } else {
            hashtable.put(string, tnrhdbData.getIpAddress());
        }
        String string2 = tnrhdbData.getHostName();
        if (string2 != null) {
            string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TNRHDB_COLUMN_NAME);
            hashtable.put(string, string2);
        }
        string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TNRHDB_COLUMN_TEMPLATE);
        hashtable.put(string, tnrhdbData.getTemplateType());
        return hashtable;
    }

    public String[] getFilterAttributes() {
        return this.filterKeys;
    }

    public Vector getFilters() {
        return this.filters;
    }

    public String getSortAttribute() {
        return TNRHDB_COLUMN_IPADDRESS;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean offerDelete(Object object, boolean bl) {
        return false;
    }

    public boolean offerNew(Object object, boolean bl) {
        return false;
    }

    public void refresh() {
        TnrhdbData tnrhdbData = new TnrhdbData();
        Vector vector = null;
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getMenuBar());
        this.rootNode.setToolBar((JToolBar)this.theApp.getToolBar());
        this.treeNode.setInternalRoot(this.rootNode);
        try {
            Integer n;
            try {
                vector = this.theApp.getHostMgr().listTnrhdb(this.theApp.getDisplayModel().getSelectedNavigationNode().getText());
            }
            catch (HostAuthException hostAuthException) {
                this.theApp.reportErrorException((Exception)((Object)new AdminException(ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)"NoReadTnrhdbAuth"))));
                return;
            }
            catch (Exception exception) {
                this.theApp.reportErrorException((Exception)((Object)new AdminException(ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)"ReadTnrhdbProblem"))));
                return;
            }
            if (vector != null) {
                n = new Integer(vector.size());
                int n2 = 0;
                while (n2 < vector.size()) {
                    tnrhdbData = (TnrhdbData)vector.get(n2);
                    String string = null;
                    string = tnrhdbData.getPrefixLen() != null ? String.valueOf(tnrhdbData.getIpAddress()) + "/" + tnrhdbData.getPrefixLen() : tnrhdbData.getIpAddress();
                    VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), this.smallTnrhdbIcon, this.largeTnrhdbIcon, string, null, null, -1, (Object)tnrhdbData);
                    String string2 = ResourceManager.getLocalizedTextFile((String)("html/hm_ctx_" + HELP_FILE + ".html"), this.theApp.getClass());
                    vScopeNode.setHTMLText(string2);
                    vScopeNode.setColumnValues(TnrhdbContent.getColumnValues(this.theApp.getResourceBundle(), tnrhdbData));
                    this.rootNode.add((MutableTreeNode)vScopeNode);
                    ++n2;
                }
            }
            n = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction((VConsoleEvent)n);
            this.bRefresh = true;
        }
        catch (Exception exception) {}
    }

    public void renameSelected() {
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    protected void updateDefaultColumns() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)this.bundle, (String)TNRHDB_COLUMN_IPADDRESS));
        Object[][] objectArray = new Object[][]{{TNRHDB_COLUMN_IPADDRESS, new Integer(128)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    protected void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        String string2 = "vconsole.sortup";
        if (string != null && !string.equals("null")) {
            if (string.indexOf(45) >= 0) {
                string2 = "vconsole.sortdown";
            }
        } else {
            string = "+0";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void updateStatusBar() {
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        TnrhdbData tnrhdbData = (TnrhdbData)vScopeNode.getPayload();
        TnrhdbPropsDialog tnrhdbPropsDialog = new TnrhdbPropsDialog(this.theApp, this.theApp.getFrame(), tnrhdbData, false);
        ((Component)((Object)tnrhdbPropsDialog)).setVisible(true);
    }

    public String whatAmI() {
        return "Tnrhdbs";
    }
}

