/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.TemplatePropsDialog;
import com.sun.admin.hostmgr.client.TnrhdbContent;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.management.viper.Tool;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class TemplateContent
extends Content {
    public static final String TEMPLATE_COLUMN_TEMPLATENAME = "detail_temp_name";
    public static final String TEMPLATE_COLUMN_HOSTTYPE = "detail_temp_hosttype";
    private final String[] filterKeys = new String[]{"detail_temp_name", "detail_temp_hosttype"};
    private Vector filters = null;
    private int serverChunkSize = -99999;
    private int displayChunkSize = -99999;
    private VScopeNode rootNode = null;
    private ImageIcon smallHostIcon;
    private ImageIcon largeHostIcon;
    private ImageIcon smallTemplateIcon;
    private ImageIcon largeTemplateIcon;
    private VHostMgr theApp;
    private ResourceBundle bundle;
    private String sortPreferencesKey;
    private static String HELP_FILE = "secfam_main";
    private final Object[][] columnHeaderConfig = new Object[][]{{"detail_temp_hosttype", new Integer(16)}};
    private static String[][] columnHeaders = null;
    private static String[] hostTypes = new String[]{"Trusted Solaris", "Unlabeled", "RIPSO", "CIPSO", "TSIX"};
    private static String[] hostTypesinFile = new String[]{"sun_tsol", "unlabeled", "ripso", "cipso", "tsix"};

    public TemplateContent(VHostMgr vHostMgr) {
        super(vHostMgr);
        this.theApp = vHostMgr;
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getMenuBar());
        this.rootNode.setToolBar((JToolBar)this.theApp.getToolBar());
        this.bundle = this.theApp.getResourceBundle();
        this.smallHostIcon = this.theApp.loadImageIcon("smallHost.gif");
        this.largeHostIcon = this.theApp.loadImageIcon("largeHost.gif");
        this.smallTemplateIcon = this.theApp.loadImageIcon("template_blue.gif");
        this.largeTemplateIcon = this.theApp.loadImageIcon("template32.gif");
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
    }

    public void clear() {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getMenuBar());
        this.rootNode.setToolBar((JToolBar)this.theApp.getToolBar());
        this.treeNode.setInternalRoot(this.rootNode);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
        this.bRefresh = true;
    }

    public void createProperties() {
        TemplatePropsDialog templatePropsDialog = new TemplatePropsDialog(this.theApp, this.theApp.getFrame(), null, true);
        ((Component)this.theApp.getFrame()).setVisible(true);
        ((Component)((Object)templatePropsDialog)).setVisible(true);
    }

    public void deleteSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        TemplateData templateData = new TemplateData(vScopeNode.getText());
        try {
            this.theApp.getHostMgr().deleteTnrhtp(templateData);
        }
        catch (Exception exception) {}
        ((TreeNodeData)this.theApp.getDisplayModel().getSelectedNavigationNode().getPayload()).getContent().refresh();
    }

    public void find(Object object) {
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, TemplateData templateData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TEMPLATE_COLUMN_TEMPLATENAME);
        String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TEMPLATE_COLUMN_HOSTTYPE);
        if (templateData == null) {
            hashtable.put(string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"all_node"));
            hashtable.put(string2, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"all_node_desc"));
        } else {
            hashtable.put(string, templateData.getTemplateName());
            String string3 = templateData.getHostType();
            String string4 = null;
            if (string3 == null) {
                string4 = "";
            } else {
                int n = 0;
                while (n < hostTypesinFile.length) {
                    if (string3.equals(hostTypesinFile[n])) {
                        string4 = hostTypes[n];
                    }
                    ++n;
                }
            }
            if (string3 == null) {
                string4 = "";
            }
            hashtable.put(string2, string4);
        }
        return hashtable;
    }

    public String[] getFilterAttributes() {
        return this.filterKeys;
    }

    public Vector getFilters() {
        return this.filters;
    }

    public String getSortAttribute() {
        return TEMPLATE_COLUMN_TEMPLATENAME;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean offerDelete(Object object, boolean bl) {
        return false;
    }

    public boolean offerNew(Object object, boolean bl) {
        return false;
    }

    public void refresh() {
        TemplateData templateData = new TemplateData();
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        Vector vector = null;
        this.treeNode.setColumnHeaders(this.getColumnHeaders());
        try {
            this.theApp.getTree().removeAllNetworks(this.treeNode);
            ServiceWrapper serviceWrapper = this.theApp.getHostMgr();
            vector = serviceWrapper.listTemplates();
        }
        catch (HostAuthException hostAuthException) {
            this.theApp.reportErrorException((Exception)((Object)new AdminException(ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)"NoReadTnrhtpAuth"))));
            return;
        }
        catch (Exception exception) {
            this.theApp.reportErrorException((Exception)((Object)new AdminException(ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)"ReadTnrhtpProblem"))));
            return;
        }
        if (vector != null) {
            TemplateData templateData2 = new TemplateData(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"all_node"));
            TnrhdbContent tnrhdbContent = new TnrhdbContent(this.theApp);
            String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME");
            TreeNodeData treeNodeData = new TreeNodeData(string, tnrhdbContent, null, this.smallTemplateIcon, this.largeTemplateIcon, HELP_FILE, templateData2);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, (JMenuBar)this.theApp.getMenuBar(), (JToolBar)this.theApp.getToolBar(), this.theApp.getMenuBar().getPopupMenu(), this.smallTemplateIcon, this.largeTemplateIcon, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"all_node"), "", null, -1, (Object)treeNodeData);
            String string2 = ResourceManager.getLocalizedTextFile((String)("html/hm_ctx_" + treeNodeData.getHelpName() + ".html"), this.theApp.getClass());
            vScopeNode.setHTMLText(string2);
            tnrhdbContent.setTreeNode(vScopeNode);
            vScopeNode.setInternalRoot(tnrhdbContent.getInternalRoot());
            vScopeNode.setTool((Tool)this.theApp);
            vScopeNode.setColumnValues(TemplateContent.getColumnValues(this.theApp.getResourceBundle(), null));
            this.treeNode.add((MutableTreeNode)vScopeNode);
            int n = 0;
            while (n < vector.size()) {
                templateData = (TemplateData)vector.get(n);
                tnrhdbContent = new TnrhdbContent(this.theApp);
                treeNodeData = new TreeNodeData(string, tnrhdbContent, null, this.smallTemplateIcon, this.largeTemplateIcon, HELP_FILE, templateData);
                vScopeNode = new VScopeNode(null, null, null, (JMenuBar)this.theApp.getMenuBar(), (JToolBar)this.theApp.getToolBar(), this.theApp.getMenuBar().getPopupMenu(), this.smallTemplateIcon, this.largeTemplateIcon, templateData.getTemplateName(), "", null, -1, (Object)treeNodeData);
                string2 = ResourceManager.getLocalizedTextFile((String)("html/hm_ctx_" + treeNodeData.getHelpName() + ".html"), this.theApp.getClass());
                vScopeNode.setHTMLText(string2);
                tnrhdbContent.setTreeNode(vScopeNode);
                vScopeNode.setInternalRoot(tnrhdbContent.getInternalRoot());
                vScopeNode.setColumnValues(TemplateContent.getColumnValues(this.theApp.getResourceBundle(), templateData));
                vScopeNode.setTool((Tool)this.theApp);
                this.treeNode.add((MutableTreeNode)vScopeNode);
                ++n;
            }
            this.bRefresh = true;
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
    }

    public void renameSelected() {
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public void updateDefaultColumns() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setPropertyObject("vconsole.defaultcolumnheader", (Object)ResourceStrings.getString((ResourceBundle)this.bundle, (String)TEMPLATE_COLUMN_TEMPLATENAME));
        Object[][] objectArray = new Object[][]{{TEMPLATE_COLUMN_TEMPLATENAME, new Integer(128)}};
        String[][] stringArray = this.constructColumnHeaders(objectArray);
        vConsoleProperties.setProperty("vconsole.defaultcolumnwidth", stringArray[0][1]);
    }

    protected void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        String string2 = "vconsole.sortup";
        if (string != null && !string.equals("null")) {
            if (string.indexOf(45) >= 0) {
                string2 = "vconsole.sortdown";
            }
        } else {
            string = "+0";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void updateStatusBar() {
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        TemplateData templateData = ((TreeNodeData)vScopeNode.getPayload()).getTemplateData();
        TemplatePropsDialog templatePropsDialog = new TemplatePropsDialog(this.theApp, this.theApp.getFrame(), templateData, false);
        ((Component)((Object)templatePropsDialog)).setVisible(true);
    }

    public String whatAmI() {
        return "Templates";
    }
}

