/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class HostGenPropsPanel
extends AbstractPropsPanel {
    public static final int HELP_CACHE_SIZE = 2;
    private HostData originalHostObj;
    private JTextField hostName;
    private JLabel hostNameLabel;
    private JTextField ipAddress;
    private JLabel ipAddressLabel;
    private boolean bNewHost;

    public HostGenPropsPanel(VHostMgr vHostMgr, Vector vector, GenInfoPanel genInfoPanel, HostData hostData, boolean bl) {
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.bNewHost = bl;
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "GenPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "GenPropsHostName");
        this.hostNameLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)this.hostNameLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)5);
        this.hostNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.hostNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.hostName = new JTextField(hostData.getHostName(), 16);
        Constraints.constrain((Container)this, (Component)this.hostName, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)5);
        if (bl) {
            this.hostName.setFont(Constants.PROPS_RW_VALUE_FONT);
        } else {
            this.hostName.setForeground(Constants.PROPS_RO_VALUE_COLOR);
            this.hostName.setFont(Constants.PROPS_RO_VALUE_FONT);
            this.hostName.setEditable(false);
        }
        this.hostName.setMinimumSize(this.hostName.getPreferredSize());
        this.hostNameLabel.setLabelFor(this.hostName);
        this.hostNameLabel.setDisplayedMnemonic(actionString.getMnemonic());
        actionString = new ActionString(resourceBundle, "GenPropsNetAddr");
        this.ipAddressLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)this.ipAddressLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        this.ipAddressLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.ipAddressLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ipAddressLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.ipAddress = new JTextField(hostData.getNetworkAddress(), 16);
        Constraints.constrain((Container)this, (Component)this.ipAddress, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        this.ipAddress.setMinimumSize(this.ipAddress.getPreferredSize());
        this.ipAddress.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.ipAddressLabel.setLabelFor(this.ipAddress);
        if (!bl) {
            this.hostName.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_name")));
            this.ipAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_address")));
            this.ipAddress.requestFocus();
        } else {
            this.hostName.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_name")));
            this.ipAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_address")));
            this.hostName.requestFocus();
        }
        this.originalHostObj = hostData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        HostData hostData = (HostData)object;
        if (this.hostName.getText().length() == 0) {
            this.hostName.requestFocus();
            throw new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.hostNameLabel.getText().substring(0, this.hostNameLabel.getText().length() - 1));
        }
        try {
            HostData.validateHostName(this.hostName.getText());
            hostData.setHostName(this.hostName.getText());
        }
        catch (HostException hostException) {
            this.hostName.requestFocus();
            throw hostException;
        }
        if (this.ipAddress.getText().length() == 0) {
            this.ipAddress.requestFocus();
            throw new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1));
        }
        try {
            HostData.validateIPAddress(this.ipAddress.getText());
            hostData.setNetworkAddress(this.ipAddress.getText());
        }
        catch (HostException hostException) {
            this.ipAddress.requestFocus();
            throw hostException;
        }
    }

    public void dialogDataInitialize(Object object) {
        HostData hostData = (HostData)object;
        if (this.bNewHost) {
            this.hostName.setText(hostData.getHostName());
        }
        this.ipAddress.setText(hostData.getNetworkAddress());
        this.originalHostObj = hostData;
    }
}

