/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.admin.hostmgr.common.TnrhdbData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TnrhdbPropsDialog
extends AdminDialog {
    private VHostMgr theApp;
    private JLabel hostNameLabel;
    private JTextField hostNameField;
    private JButton hostNameLoad;
    private JButton ipAddressLoad;
    private JLabel ipAddressLabel;
    private JTextField ipAddressField;
    private JLabel prefixLen;
    private JTextField prefixLenField;
    private JLabel templateLabel;
    private JComboBox templateList;
    private JRadioButton hostentry;
    private JRadioButton wildcardentry;
    private ButtonGroup group;
    private Vector templateTypes;
    private JFrame pFrame;
    private ResourceBundle bundle;

    public TnrhdbPropsDialog(VHostMgr vHostMgr, JFrame jFrame, TnrhdbData tnrhdbData, boolean bl) {
        super((Frame)jFrame, "", false);
        TemplateData templateData = new TemplateData();
        this.theApp = vHostMgr;
        this.bundle = this.theApp.getResourceBundle();
        this.pFrame = jFrame;
        if (!bl) {
            ((Dialog)((Object)this)).setTitle(String.valueOf(this.getLocalized("ModTnrhdb")) + " " + tnrhdbData.getIpAddress());
        } else {
            ((Dialog)((Object)this)).setTitle(this.getLocalized("NewTnrhdb"));
        }
        try {
            Cloneable cloneable;
            this.templateTypes = this.theApp.getHostMgr().listTemplates();
            JPanel jPanel = this.getRightPanel();
            jPanel.setLayout(new GridBagLayout());
            this.hostentry = new JRadioButton(this.getLocalized("tnrhdb_host_entry"));
            this.wildcardentry = new JRadioButton(this.getLocalized("tnrhdb_wildcard_entry"));
            this.group = new ButtonGroup();
            this.group.add(this.hostentry);
            this.group.add(this.wildcardentry);
            Constraints.constrain((Container)jPanel, (Component)this.hostentry, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)0);
            Constraints.constrain((Container)jPanel, (Component)this.wildcardentry, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)0);
            this.hostNameLabel = new JLabel(this.getLocalized("tnrhdb_host_name"));
            Constraints.constrain((Container)jPanel, (Component)this.hostNameLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)0);
            this.hostNameField = new JTextField("", 16);
            Constraints.constrain((Container)jPanel, (Component)this.hostNameField, (int)-1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)0);
            this.hostNameLoad = new JButton(this.getLocalized("tnrhdb_load"));
            Constraints.constrain((Container)jPanel, (Component)this.hostNameLoad, (int)-1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)0);
            this.ipAddressLabel = new JLabel(this.getLocalized("tnrhdb_ip_addr"));
            Constraints.constrain((Container)jPanel, (Component)this.ipAddressLabel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)0);
            this.ipAddressField = new JTextField("", 16);
            Constraints.constrain((Container)jPanel, (Component)this.ipAddressField, (int)-1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)0);
            this.ipAddressLoad = new JButton(this.getLocalized("tnrhdb_load"));
            Constraints.constrain((Container)jPanel, (Component)this.ipAddressLoad, (int)-1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)10, (int)0, (int)10, (int)0);
            this.prefixLen = new JLabel(this.getLocalized("tnrhdb_prefix_len"));
            Constraints.constrain((Container)jPanel, (Component)this.prefixLen, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            this.prefixLenField = new JTextField("", 4);
            Constraints.constrain((Container)jPanel, (Component)this.prefixLenField, (int)-1, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            this.templateLabel = new JLabel(this.getLocalized("tnrhdb_template"));
            Constraints.constrain((Container)jPanel, (Component)this.templateLabel, (int)0, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            this.templateList = new JComboBox();
            int n = 0;
            while (n < this.templateTypes.size()) {
                templateData = (TemplateData)this.templateTypes.get(n);
                this.templateList.addItem(templateData.getTemplateName());
                ++n;
            }
            this.templateList.setSelectedItem(this.theApp.getDisplayModel().getSelectedNavigationNode().getText());
            Constraints.constrain((Container)jPanel, (Component)this.templateList, (int)-1, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            ((Window)((Object)this)).pack();
            Vector vector = new Vector(1000);
            this.theApp.addHelpListener(this.templateList, new HostMgrContextHelpListener(this.theApp, vector, this.getInfoPanel(), "secfam_rhosts_template"));
            this.prefixLenField.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(this.theApp, vector, this.getInfoPanel(), "secfam_rhosts_prefix")));
            this.ipAddressField.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(this.theApp, vector, this.getInfoPanel(), "secfam_rhosts_IPaddr")));
            this.hostNameField.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(this.theApp, vector, this.getInfoPanel(), "secfam_rhosts_hostname")));
            this.setDefaultFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(this.theApp, vector, this.getInfoPanel(), "secfam_rhosts_overview")), true);
            this.hostentry.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TnrhdbPropsDialog.this.prefixLen.setEnabled(false);
                    TnrhdbPropsDialog.this.prefixLenField.setEnabled(false);
                    TnrhdbPropsDialog.this.hostNameLabel.setEnabled(true);
                    TnrhdbPropsDialog.this.hostNameField.setEnabled(true);
                    TnrhdbPropsDialog.this.hostNameLoad.setEnabled(true);
                }
            });
            this.wildcardentry.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TnrhdbPropsDialog.this.prefixLen.setEnabled(true);
                    TnrhdbPropsDialog.this.prefixLenField.setEnabled(true);
                    TnrhdbPropsDialog.this.hostNameLabel.setEnabled(false);
                    TnrhdbPropsDialog.this.hostNameField.setEnabled(false);
                    TnrhdbPropsDialog.this.hostNameLoad.setEnabled(false);
                }
            });
            JButton jButton = this.getOKBtn();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(TnrhdbPropsDialog.this){
                        private final /* synthetic */ TnrhdbPropsDialog this$0;
                        {
                            this.this$0 = tnrhdbPropsDialog;
                        }

                        public void run() {
                            try {
                                this.this$0.onApply();
                                ((Window)((Object)this.this$0)).dispose();
                            }
                            catch (Exception exception) {}
                        }
                    };
                    thread.start();
                }
            });
            if (!this.theApp.getHostMgr().hasSecurityWriteAuthorization()) {
                jButton.setEnabled(false);
            }
            this.hostNameLoad.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Vector vector = new Vector();
                    HostData hostData = new HostData();
                    String string = TnrhdbPropsDialog.this.hostNameField.getText();
                    try {
                        vector = TnrhdbPropsDialog.this.theApp.getHostMgr().getHostsByName(string);
                    }
                    catch (AdminException adminException) {}
                    if (vector.size() > 0) {
                        hostData = (HostData)vector.get(0);
                        if (hostData.getNetworkAddress() != null) {
                            TnrhdbPropsDialog.this.ipAddressField.setText(hostData.getNetworkAddress());
                            TnrhdbPropsDialog.this.ipAddressField.setEditable(false);
                        }
                    } else {
                        TnrhdbPropsDialog.this.ipAddressField.setText("");
                        TnrhdbPropsDialog.this.ipAddressField.setEditable(true);
                    }
                }
            });
            this.ipAddressLoad.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HostData hostData = new HostData();
                    String string = TnrhdbPropsDialog.this.ipAddressField.getText();
                    String string2 = TnrhdbPropsDialog.this.prefixLenField.getText();
                    try {
                        hostData = TnrhdbPropsDialog.this.theApp.getHostMgr().getHostByAddress(string);
                        if (string2 != null && string2.length() > 0) {
                            string.concat("/");
                            string.concat(string2);
                        }
                        String string3 = TnrhdbPropsDialog.this.theApp.getHostMgr().getTemplateByAddress(string);
                        TnrhdbPropsDialog.this.templateList.setSelectedItem(string3);
                    }
                    catch (Exception exception) {}
                    if (hostData.getHostName() != null) {
                        TnrhdbPropsDialog.this.hostNameField.setText(hostData.getHostName());
                        TnrhdbPropsDialog.this.hostNameField.setEditable(false);
                    } else {
                        TnrhdbPropsDialog.this.hostNameField.setText("");
                        TnrhdbPropsDialog.this.hostNameField.setEditable(true);
                    }
                }
            });
            JButton jButton2 = this.getCancelBtn();
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Window)((Object)TnrhdbPropsDialog.this)).dispose();
                }
            });
            this.hostentry.setSelected(true);
            this.prefixLen.setEnabled(false);
            this.prefixLenField.setEnabled(false);
            this.hostNameLabel.setEnabled(true);
            this.hostNameField.setEnabled(true);
            this.hostNameLoad.setEnabled(true);
            if (tnrhdbData != null) {
                cloneable = new HostData();
                this.ipAddressField.setText(tnrhdbData.getIpAddress());
                if (tnrhdbData.isWildCardIPAddress()) {
                    this.wildcardentry.setSelected(true);
                    String string = tnrhdbData.getPrefixLen();
                    if (string != null) {
                        this.prefixLenField.setText(string);
                    }
                    this.prefixLen.setEnabled(true);
                    this.prefixLenField.setEnabled(true);
                    this.hostNameLabel.setEnabled(false);
                    this.hostNameField.setEnabled(false);
                    this.hostNameLoad.setEnabled(false);
                } else {
                    this.hostentry.setSelected(true);
                    cloneable = this.theApp.getHostMgr().getHostByAddress(tnrhdbData.getIpAddress());
                    if (cloneable != null && ((HostData)cloneable).getHostName() != null) {
                        this.hostNameField.setText(((HostData)cloneable).getHostName());
                    } else {
                        this.hostNameField.setText("");
                    }
                    this.hostNameField.setEditable(false);
                }
                this.templateList.setSelectedItem(tnrhdbData.getTemplateType());
            }
            cloneable = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)((Object)this)).setLocation(((Dimension)cloneable).width / 2 - ((Component)((Object)this)).getSize().width / 2, ((Dimension)cloneable).height / 2 - ((Component)((Object)this)).getSize().height / 2);
        }
        catch (Exception exception) {}
    }

    private String getLocalized(String string) {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)string);
    }

    public void onApply() throws Exception {
        String string = this.ipAddressField.getText();
        String string2 = (String)this.templateList.getSelectedItem();
        boolean bl = this.wildcardentry.isSelected();
        String string3 = this.hostNameField.getText();
        String string4 = null;
        TnrhdbData tnrhdbData = new TnrhdbData();
        try {
            if (bl) {
                tnrhdbData.setIpAddress(string);
                string4 = this.prefixLenField.getText();
                if (TnrhdbData.isIPv6Address(string)) {
                    TnrhdbData.validateIPAddress(string);
                } else if (!tnrhdbData.isWildCardIPAddress()) {
                    throw new HostException("EXM_HST_CMN10");
                }
                if (string4 != null && string4.length() != 0) {
                    tnrhdbData.setPrefixLen(string4);
                    tnrhdbData.validatePrefixLen();
                }
            } else {
                TnrhdbData.validateIPAddress(string);
                tnrhdbData.setIpAddress(string);
            }
            tnrhdbData.setTemplateType(string2);
            this.theApp.getHostMgr().setTnrhdb(tnrhdbData);
        }
        catch (HostException hostException) {
            if (hostException.getMessage().equals("PREFIX_ERROR")) {
                this.theApp.reportErrorException((Exception)((Object)hostException));
                this.prefixLenField.requestFocus();
                throw hostException;
            }
            this.theApp.reportErrorException((Exception)((Object)hostException));
            this.ipAddressField.requestFocus();
            throw hostException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        ((TreeNodeData)this.theApp.getDisplayModel().getSelectedNavigationNode().getPayload()).getContent().refresh();
    }
}

