/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.ViperServiceWrapper;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.server.HostMgr;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import java.util.ResourceBundle;

public class ApplicationContext {
    private IClientResource theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope;

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    public String getMgmtServer() {
        return this.scope.getMgmtServerName();
    }

    private String getServiceType() {
        String string = "Viper";
        try {
            String string2 = System.getProperty("hostmgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.hostmgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HostException("EXM_HST_GUI_SERVICE_NOT_REACHABLE", string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
        }
        catch (Exception exception) {
            HostException hostException = new HostException("EXM_HST_GUI_CANT_GET_SERVICE_WRAPPER", string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            hostException.addArg(exception.getMessage());
            throw hostException;
        }
        try {
            if (serviceWrapper instanceof ViperServiceWrapper) {
                HostMgr hostMgr = (HostMgr)toolInfrastructure.getServiceByName("com.sun.admin.hostmgr.server.HostMgrImpl");
                serviceWrapper.init(hostMgr, toolInfrastructure, this.scope);
            }
        }
        catch (Exception exception) {
            throw new HostException("EXM_HST_GUI_CANT_CONNECT_TO_SERVER", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), exception.getMessage());
        }
        return serviceWrapper;
    }

    public boolean isAdvancedHostPropertiesSupported() {
        return this.isNetworksSupported();
    }

    public boolean isNetworksSupported() {
        String string = "file";
        try {
            String string2 = System.getProperty("hostmgr.scopeType");
            if (string2 != null) {
                string = string2;
                if (string.equals("files")) {
                    string = "file";
                }
                if (string.equals("dns")) {
                    string = "dns";
                }
                if (string.equals("nis")) {
                    string = "nis";
                }
                if (string.equals("nisplus")) {
                    string = "nisplus";
                }
            }
        }
        catch (Exception exception) {
            AdminMgmtScope adminMgmtScope = (AdminMgmtScope)this.toolContext.getParameter("ToolContext.MGMTSCOPE");
            string = adminMgmtScope.getMgmtScopeType();
        }
        return !string.equals("dns");
    }
}

