/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.DnsTableDefinitions;
import com.sun.wbem.utility.directorytable.FileEditor;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DnsDirectoryTable
implements DirectoryTable,
TableSetup {
    private static int ROW_INCREMENT = 5;
    FileEditor fileEditor;
    TableDefinitions tableDefinitions;
    boolean singleSeparatorOnly;
    boolean allowsInlineComment;
    boolean allowEscapes;
    boolean caseSensitive;
    boolean needsFlush;
    String serverName;
    String domainName;

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions(this.serverName, this.domainName);
        dnsTableDefinitions.loadTableDefinitions(string);
        String string2 = dnsTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string2, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String string = this.fillInRequiredColumns(directoryRow);
        int n = 0;
        DirectoryRow directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string2 = this.fileEditor.getFirstLine();
        if (string2 != null) {
            if (this.isType(string, string2)) {
                this.parseStringIntoRow(string2, directoryRow2, 1);
                if (!directoryRow2.isEmpty()) {
                    n = 1;
                    while (n <= directoryRow.getNumberOfRows()) {
                        if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                            throw new DirectoryTableRowNotUniqueException();
                        }
                        ++n;
                    }
                }
            }
            string2 = this.fileEditor.getNextLine();
            while (string2 != null) {
                if (this.isType(string, string2)) {
                    directoryRow2.clearRow(1);
                    this.parseStringIntoRow(string2, directoryRow2, 1);
                    if (!directoryRow2.isEmpty()) {
                        n = 1;
                        while (n <= directoryRow.getNumberOfRows()) {
                            if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                                throw new DirectoryTableRowNotUniqueException();
                            }
                            ++n;
                        }
                    }
                }
                string2 = this.fileEditor.getNextLine();
            }
        }
        n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            String string3 = this.getRowAsString(directoryRow, n);
            this.fileEditor.addLine(string3);
            ++n;
        }
        this.needsFlush = true;
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        this.tableDefinitions = null;
        this.fileEditor = null;
        this.singleSeparatorOnly = false;
        this.allowsInlineComment = false;
        this.allowEscapes = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        n = DirectoryTableLibrary.convertAccessToMode(tableDefinitions.getAccess());
        n2 = DirectoryTableLibrary.fileCreate(tableDefinitions.getMappedTableName(), tableDefinitions.getUser(), tableDefinitions.getGroup(), n);
        DirectoryTableLibrary.errnoToException(n2, tableDefinitions);
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void create(String string) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions(this.serverName, this.domainName);
        dnsTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.convertAccessToMode(dnsTableDefinitions.getAccess());
        n2 = DirectoryTableLibrary.fileCreate(dnsTableDefinitions.getMappedTableName(), dnsTableDefinitions.getUser(), dnsTableDefinitions.getGroup(), n);
        DirectoryTableLibrary.errnoToException(n2, dnsTableDefinitions);
        this.tableDefinitions = dnsTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.fileDelete(tableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions(this.serverName, this.domainName);
        dnsTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.fileDelete(dnsTableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, dnsTableDefinitions);
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String string = this.fillInRequiredColumns(directoryRow);
        int n = 0;
        DirectoryRow directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string2 = this.fileEditor.getFirstLine();
        int n2 = directoryRow.getNumberOfRows();
        Vector<String> vector = new Vector<String>();
        vector.setSize(n2);
        if (string2 != null) {
            if (this.isType(string, string2)) {
                this.parseStringIntoRow(string2, directoryRow2, 1);
                if (!directoryRow2.isEmpty()) {
                    n = 1;
                    while (n <= n2) {
                        if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                            vector.setElementAt(string2, n - 1);
                        }
                        ++n;
                    }
                }
            }
            string2 = this.fileEditor.getNextLine();
            while (string2 != null) {
                if (this.isType(string, string2)) {
                    directoryRow2.clearRow(1);
                    this.parseStringIntoRow(string2, directoryRow2, 1);
                    if (!directoryRow2.isEmpty()) {
                        n = 1;
                        while (n <= n2) {
                            if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                                vector.setElementAt(string2, n - 1);
                            }
                            ++n;
                        }
                    }
                }
                string2 = this.fileEditor.getNextLine();
            }
        }
        n = 0;
        while (n < n2) {
            if (vector.elementAt(n) == null) {
                throw new DirectoryTableRowNotFoundException();
            }
            ++n;
        }
        n = 0;
        while (n < n2) {
            this.fileEditor.deleteLine((String)vector.elementAt(n));
            ++n;
        }
        this.needsFlush = true;
    }

    private String fillInRequiredColumns(DirectoryRow directoryRow) {
        int n = 0;
        int n2 = directoryRow.getNumberOfRows();
        String string = "";
        try {
            int n3 = this.tableDefinitions.getColumnNumber("type");
            int n4 = this.tableDefinitions.getColumnNumber("class");
            n = 1;
            while (n <= n2) {
                if (directoryRow.getColumn(n3).equals("")) {
                    directoryRow.putColumn(n3, this.tableDefinitions.getAuxilliaryColumnData(n3));
                }
                string = directoryRow.getColumn(n3);
                if (directoryRow.getColumn(n4).equals("")) {
                    directoryRow.putColumn(n4, this.tableDefinitions.getAuxilliaryColumnData(n4));
                }
                ++n;
            }
        }
        catch (DirectoryTableException directoryTableException) {}
        return string;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            String string = this.fileEditor.getFirstLine();
            String string2 = null;
            this.needsFlush = false;
            while (string != null) {
                if (this.isType("SOA", string)) {
                    string2 = this.incrementSoaSerialNumber(string);
                    this.fileEditor.modifyLine(string, string2);
                    return;
                }
                string = this.fileEditor.getNextLine();
            }
        }
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), ROW_INCREMENT);
        String string = this.fileEditor.getFirstLine();
        int n = 1;
        int n2 = ROW_INCREMENT;
        int n3 = 0;
        String string2 = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (string == null) {
            return null;
        }
        if (this.isType(string2, string) && (n3 = this.parseStringIntoRow(string, directoryRow, n)) > 0) {
            if (--n2 == 0) {
                directoryRow.addRows(ROW_INCREMENT);
                n2 = ROW_INCREMENT;
            }
            ++n;
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            if (this.isType(string2, string) && (n3 = this.parseStringIntoRow(string, directoryRow, n)) > 0) {
                if (--n2 == 0) {
                    directoryRow.addRows(ROW_INCREMENT);
                    n2 = ROW_INCREMENT;
                }
                ++n;
            }
            string = this.fileEditor.getNextLine();
        }
        if (n == 1 && directoryRow.isEmpty(n)) {
            return null;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            directoryRow.deleteRow(n + n4);
            --n4;
        }
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        String string = this.fileEditor.getFirstLine();
        int n = 0;
        String string2 = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (string == null) {
            return directoryRow2;
        }
        directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        if (this.isType(string2, string)) {
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                if (n == 0) {
                    directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                    n = 1;
                }
                this.parseStringIntoRow(string, directoryRow2, n);
                ++n;
            }
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            if (this.isType(string2, string)) {
                directoryRow.clearRow(1);
                this.parseStringIntoRow(string, directoryRow, 1);
                if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                    if (n == 0) {
                        directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                        n = 1;
                    } else {
                        directoryRow2.addRows(1);
                    }
                    this.parseStringIntoRow(string, directoryRow2, n);
                    ++n;
                }
            }
            string = this.fileEditor.getNextLine();
        }
        return directoryRow2;
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getFirstLine();
        String string2 = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (string == null) {
            return null;
        }
        if (this.isType(string2, string)) {
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            if (this.isType(string2, string)) {
                directoryRow.clearRow(1);
                this.parseStringIntoRow(string, directoryRow, 1);
                if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                    return directoryRow;
                }
            }
            string = this.fileEditor.getNextLine();
        }
        return null;
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        String string2 = this.fileEditor.getNextLine();
        while (string2 != null) {
            if (this.isType(string, string2)) {
                directoryRow.clearRow(1);
                this.parseStringIntoRow(string2, directoryRow, 1);
                if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                    return directoryRow;
                }
            }
            string2 = this.fileEditor.getNextLine();
        }
        return null;
    }

    private String getRowAsString(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2;
        String string = "";
        char c = this.tableDefinitions.getColumnSeparators().charAt(0);
        char c2 = this.tableDefinitions.getCommentSeparators().charAt(0);
        int n3 = 0;
        if (this.allowsInlineComment) {
            n2 = this.tableDefinitions.getNumberOfColumns() - 1;
            n3 = this.tableDefinitions.getNumberOfColumns();
        } else {
            n2 = this.tableDefinitions.getNumberOfColumns();
        }
        int n4 = 1;
        while (n4 <= n2) {
            if (n4 != 1) {
                string = String.valueOf(string) + c;
            }
            if (!directoryRow.getColumn(n4, n).equals("")) {
                string = string.concat(directoryRow.getColumn(n4, n));
            }
            ++n4;
        }
        if (this.allowsInlineComment && !directoryRow.getColumn(n3, n).equals("")) {
            string = string.concat(String.valueOf(c2) + directoryRow.getColumn(n3, n));
        }
        return string;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions(this.serverName, this.domainName);
        try {
            dnsTableDefinitions.loadTableDefinitions("hosts");
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = dnsTableDefinitions.getMappedTableName();
        if ((n & 2) == 2) {
            if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
                vector = new Vector<String>();
                vector.addElement("dns:/" + string + "/" + string);
            }
        } else if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            vector = new Vector();
            vector.addElement("dns:/" + string + "/" + string);
        }
        return vector;
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new DnsTableDefinitions(this.serverName, this.domainName);
    }

    private String incrementSoaSerialNumber(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3.trim();
            ++n;
            string2 = String.valueOf(string2) + string3 + " ";
            if (!string3.equals("(") || !stringTokenizer.hasMoreTokens()) continue;
            int n2 = 0;
            string3 = stringTokenizer.nextToken();
            n2 = Integer.valueOf(string3);
            string3 = String.valueOf(++n2);
            string2 = String.valueOf(string2) + string3 + " ";
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isType(String var1_1, String var2_2) {
        var3_3 = 0;
        var4_4 = false;
        var5_5 = new StringTokenizer(var2_2, "\t ");
        if (!var1_1.equals("")) ** GOTO lbl12
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var6_6 = var5_5.nextToken();
            var6_6.trim();
            if (var6_6.equals(var1_1) && (++var3_3 == 3 || var3_3 == 4)) {
                var4_4 = true;
            }
            if (var3_3 > 4) break;
lbl12:
            // 2 sources

            ** while (var5_5.hasMoreTokens())
        }
lbl13:
        // 2 sources

        return var4_4;
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String string = this.fillInRequiredColumns(directoryRow);
        String string2 = this.fillInRequiredColumns(directoryRow2);
        DirectoryRow directoryRow3 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string3 = this.fileEditor.getFirstLine();
        String string4 = this.getRowAsString(directoryRow2, 1);
        if (string3 == null) {
            throw new DirectoryTableRowNotFoundException();
        }
        String string5 = string3;
        if (this.isType(string, string3)) {
            this.parseStringIntoRow(string3, directoryRow3, 1);
            if (directoryRow3.getNumberOfColumns() > 0 && directoryRow.matchRow(directoryRow3, 1, this.tableDefinitions)) {
                this.fileEditor.modifyLine(string5, string4);
                this.needsFlush = true;
                return;
            }
        }
        string3 = this.fileEditor.getNextLine();
        while (string3 != null) {
            directoryRow3.clearRow(1);
            string5 = string3;
            if (this.isType(string, string3)) {
                this.parseStringIntoRow(string3, directoryRow3, 1);
                if (directoryRow3.getNumberOfColumns() > 0 && directoryRow.matchRow(directoryRow3, 1, this.tableDefinitions)) {
                    this.fileEditor.modifyLine(string5, string4);
                    this.needsFlush = true;
                    return;
                }
            }
            string3 = this.fileEditor.getNextLine();
        }
        throw new DirectoryTableRowNotFoundException();
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "dns", tableDefinitions.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void open(String string) throws DirectoryTableException {
        DnsTableDefinitions dnsTableDefinitions = new DnsTableDefinitions(this.serverName, this.domainName);
        dnsTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(dnsTableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(string, "dns", string);
        }
        this.tableDefinitions = dnsTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    private int parseStringIntoRow(String string, DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        char[] cArray2 = this.tableDefinitions.getCommentSeparators().toCharArray();
        int n5 = cArray2.length;
        char[] cArray3 = this.tableDefinitions.getColumnSeparators().toCharArray();
        int n6 = cArray3.length;
        boolean bl = false;
        int n7 = 0;
        while (n7 < n4) {
            if (n6 > 1) {
                n2 = 1;
                while (n2 < n6) {
                    if (cArray[n7] == cArray3[n2]) {
                        cArray[n7] = cArray3[0];
                    }
                    ++n2;
                }
            }
            if (!bl && cArray[n7] != cArray3[0]) {
                bl = true;
            }
            n2 = 0;
            while (n2 < n5) {
                if (cArray[n7] == cArray2[n2]) {
                    if (n7 == 0) {
                        return n3;
                    }
                    if (this.allowsInlineComment && n7 < n4) {
                        directoryRow.putColumn(this.tableDefinitions.getNumberOfColumns(), n, new String(cArray, n7 + 1, n4 - n7 - 1));
                        ++n3;
                        n4 = n7;
                    }
                }
                ++n2;
            }
            ++n7;
        }
        if (!bl) {
            return n3;
        }
        char c = cArray3[0];
        int n8 = 1;
        n2 = 0;
        if (n2 < n4 && cArray[n2] == c) {
            ++n2;
        }
        while (n2 < n4 && cArray[n2] == c) {
            ++n2;
            if (!this.singleSeparatorOnly) continue;
            ++n8;
        }
        while (n2 < n4) {
            if (this.tableDefinitions.getColumnName(n8).equals("data")) {
                directoryRow.putColumn(n8, n, new String(cArray, n2, n4 - n2));
                return ++n3;
            }
            n7 = n2;
            while (n7 < n4 && cArray[n7] != c) {
                ++n7;
            }
            if (n7 != n2) {
                if (this.tableDefinitions.getColumnName(n8).equals("ttl")) {
                    try {
                        int n9 = Integer.valueOf(new String(cArray, n2, n7 - n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ++n8;
                    }
                }
                directoryRow.putColumn(n8, n, new String(cArray, n2, n7 - n2));
                ++n8;
                ++n3;
            }
            n2 = n7 + 1;
            while (n2 < n4 && cArray[n2] == c) {
                ++n2;
                if (!this.singleSeparatorOnly) continue;
                ++n8;
            }
        }
        return n3;
    }

    public void refreshSetup() {
    }

    public void setContext(String string) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(string, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(string, "domainName");
        try {
            if (!this.serverName.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                throw new DirectoryTableOperationNotSupportedException("Remote DNS");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new DirectoryTableException("EXM_INTERNAL");
        }
    }

    public void setup() {
    }
}

