/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.LogWindow;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.HostMgrTree;
import com.sun.admin.hostmgr.client.MainMenuBar;
import com.sun.admin.hostmgr.client.MainToolBar;
import com.sun.admin.hostmgr.client.NavigationSelectionListener;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VHostMgr
implements Tool,
IClientResource,
PropertyChangeListener,
VConsoleActionListener {
    private ServiceWrapper hostMgr;
    private VConsoleProperties properties = null;
    private VDisplayModel displayModel = null;
    private JFrame consoleFrame = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector propertyChangeListeners = new Vector();
    private Vector navigationSelectionListeners = new Vector();
    private MainMenuBar menuBar = null;
    private MainToolBar toolBar = null;
    private HostMgrTree theTree = null;
    private ResourceBundle resourceBundle = null;
    private int busyCount = 0;
    private Component glassPane = null;
    private AdminException initException = null;
    private boolean isCriticalStop = false;
    private String traceDevice = null;
    private LogWindow traceWindow = null;

    public VHostMgr() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.hostmgr.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.resourceBundle = null;
        }
        this.addPropertyChangeListener(this);
        this.menuBar = new MainMenuBar(this);
        this.toolBar = new MainToolBar(this);
        this.theTree = new HostMgrTree(this);
        try {
            this.traceDevice = System.getProperty("hostmgr.traceDevice");
        }
        catch (Exception exception) {
            this.traceDevice = null;
        }
    }

    public void Trace(String string) {
        if (this.traceDevice == null) {
            return;
        }
        if (this.traceDevice.equals("stdout")) {
            System.out.println(string);
            return;
        }
        if (this.traceDevice.equals("stderr")) {
            System.err.println(string);
            return;
        }
        if (!this.traceDevice.equals("window")) {
            return;
        }
        if (this.getFrame() == null) {
            System.out.println(string);
            return;
        }
        if (this.traceWindow == null) {
            this.traceWindow = new LogWindow(this.getFrame(), 40, 40);
            this.traceWindow.setTitle("Computers & Networks Trace Window");
            this.traceWindow.setVisible(true);
        }
        this.traceWindow.appendToLog(string);
    }

    public void aboutTool() {
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(String.valueOf(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"MARKETING_NAME")) + " " + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"VERSION"));
        vAboutBox.setDescription(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"Copyright"));
        Dimension dimension = vAboutBox.getMinimumSize();
        FontMetrics fontMetrics = vAboutBox.getFontMetrics(vAboutBox.getFont());
        dimension.height += 2 * fontMetrics.getHeight();
        vAboutBox.setMinimumSize(dimension);
        VDialog vDialog = new VDialog((Frame)this.consoleFrame, true);
        vAboutBox.setContainer((VContainer)vDialog);
        ActionString actionString = new ActionString(this.resourceBundle, "HelpAbout");
        vDialog.setTitle(actionString.getString());
        vDialog.getContentPane().setLayout(new BorderLayout());
        vDialog.getContentPane().add((Component)vAboutBox, "Center");
        vDialog.pack();
        vDialog.showCenter((Component)this.consoleFrame);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void addHelpListener(Component component, ContextHelpListener contextHelpListener) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(componentArray[n], contextHelpListener);
                ++n;
            }
        }
        component.addFocusListener((FocusListener)contextHelpListener);
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.propertyChangeListeners.addElement(propertyChangeListener);
        if (this.properties != null) {
            this.properties.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            HostActionsListener hostActionsListener = new HostActionsListener(this, false);
            hostActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onDoubleClick();
        } else if (string.equals("vconsole.delete")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Delete");
            HostActionsListener hostActionsListener = new HostActionsListener(this, false);
            hostActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
            HostActionsListener hostActionsListener = new HostActionsListener(this, false);
            hostActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sortup")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        } else if (string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        }
    }

    public void destroy() {
        this.fireToolDestroyed();
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.consoleListeners.size()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.consoleListeners.elementAt(n);
            vConsoleActionListener.consoleAction(vConsoleEvent);
            ++n;
        }
    }

    private void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
            ++n;
        }
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        int n = 0;
        while (n < this.propertyChangeListeners.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private void fireToolDestroyed() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolDestroyed();
            ++n;
        }
    }

    private void fireToolStopped() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolStopped();
            ++n;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public VScopeNode getCurrentNode() {
        return this.theTree.getCurrentNode();
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public JFrame getFrame() {
        return this.consoleFrame;
    }

    public ServiceWrapper getHostMgr() {
        return this.hostMgr;
    }

    public MainMenuBar getMenuBar() {
        return this.menuBar;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public VScopeNode getScopeNode() {
        return this.theTree.getRootNode();
    }

    public MainToolBar getToolBar() {
        return this.toolBar;
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public HostMgrTree getTree() {
        return this.theTree;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.hostMgr = this.applicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string = String.valueOf(string) + "</p><p>" + adminException.getMessage() + "</p>";
            string = String.valueOf(string) + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), adminException.getLocalizedMessage(), (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
    }

    public boolean isWaitOn() {
        return this.busyCount > 0;
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string2, this.getClass());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        } else if (string.equals("vconsole.frame")) {
            this.consoleFrame = (JFrame)propertyChangeEvent.getNewValue();
        }
    }

    public void reportErrorException(Exception exception) {
        AdminException adminException;
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                adminException = (AdminException)((Object)exception);
                string = String.valueOf(string) + "\n" + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + "\n" + exception.getMessage();
            exception = null;
        }
        adminException = new ErrorDialog(this.getFrame(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"ErrorTitle"), string);
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    private synchronized void setBusy(boolean bl) {
        if (this.glassPane == null) {
            return;
        }
        if (bl) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.glassPane.setVisible(true);
            }
        } else {
            --this.busyCount;
            this.busyCount = Math.max(0, this.busyCount);
            if (this.busyCount == 0) {
                this.glassPane.setVisible(false);
                ((Component)this.getFrame()).setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            Object object;
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            this.consoleFrame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            this.glassPane = this.getFrame().getGlassPane();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.glassPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                }
            });
            int n = 0;
            while (n < this.propertyChangeListeners.size()) {
                object = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
                vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)object);
                ++n;
            }
            object = new PropertyChangeEvent(this, "vconsole.buttondisplay", "", vConsoleProperties.getProperty("vconsole.buttondisplay"));
            this.firePropertyChanged((PropertyChangeEvent)object);
            if (this.initException != null) {
                this.reportErrorException((Exception)((Object)this.initException));
                this.initException = null;
            }
        }
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void start() throws CriticalStopException {
        if (this.initException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.initException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.initException.getLocalizedMessage());
        }
        this.bRunning = true;
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.displayModel.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent);
    }

    public void stop() throws CriticalStopException {
        this.bRunning = false;
        this.fireToolStopped();
    }

    public void waitOff() {
        this.setBusy(false);
    }

    public void waitOn() {
        this.setBusy(true);
    }
}

