/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.HostAdvPropsPanel;
import com.sun.admin.hostmgr.client.HostGenPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HostPropsDialog
extends AdminDialog {
    HostData originalHostObj;
    ResourceBundle bundle;
    Vector groupPanels;
    boolean bNewHost;
    VHostMgr theApp;

    public HostPropsDialog(VHostMgr vHostMgr, JFrame jFrame, HostData hostData, boolean bl) {
        super((Frame)jFrame, "", true);
        this.theApp = vHostMgr;
        ApplicationContext applicationContext = vHostMgr.getApplicationContext();
        this.bNewHost = bl;
        this.bundle = vHostMgr.getResourceBundle();
        if (!bl) {
            ((Dialog)((Object)this)).setTitle(String.valueOf(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ModHost")) + " " + hostData.getHostName());
        } else {
            ((Dialog)((Object)this)).setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"NewHost"));
        }
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        int n = 8;
        Vector vector = new Vector(n);
        this.groupPanels = new Vector();
        this.groupPanels.addElement(new HostGenPropsPanel(vHostMgr, vector, genInfoPanel, hostData, bl));
        if (applicationContext.isAdvancedHostPropertiesSupported()) {
            this.groupPanels.addElement(new HostAdvPropsPanel(vHostMgr, vector, genInfoPanel, hostData, bl));
        }
        JPanel jPanel = this.getRightPanel();
        jPanel.setLayout(new GridBagLayout());
        int n2 = 0;
        while (n2 < this.groupPanels.size()) {
            Constraints.constrain((Container)jPanel, (Component)((JPanel)this.groupPanels.elementAt(n2)), (int)0, (int)-1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (int)10, (int)5, (int)20, (int)5);
            ++n2;
        }
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        JButton jButton = this.getOKBtn();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(HostPropsDialog.this){
                    private final /* synthetic */ HostPropsDialog this$0;
                    {
                        this.this$0 = hostPropsDialog;
                    }

                    public void run() {
                        try {
                            this.this$0.onApply();
                            ((Window)((Object)this.this$0)).dispose();
                        }
                        catch (HostException hostException) {}
                    }
                };
                thread.start();
            }
        });
        if (!vHostMgr.getHostMgr().hasWriteAuthorization()) {
            jButton.setEnabled(false);
        }
        JPanel jPanel2 = this.getbuttonPanel();
        JButton jButton2 = this.getApplyBtn();
        if (bl) {
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(HostPropsDialog.this){
                        private final /* synthetic */ HostPropsDialog this$0;
                        {
                            this.this$0 = hostPropsDialog;
                        }

                        public void run() {
                            try {
                                this.this$0.onApply();
                            }
                            catch (HostException hostException) {}
                        }
                    };
                    thread.start();
                }
            });
        } else {
            jPanel2.remove(jButton2);
        }
        JButton jButton3 = this.getCancelBtn();
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Window)((Object)HostPropsDialog.this)).dispose();
            }
        });
        ((Window)((Object)this)).pack();
        if (!bl) {
            this.setDefaultFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_overview")), true);
        } else {
            this.setDefaultFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_overview")), true);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setLocation(dimension.width / 2 - ((Component)((Object)this)).getSize().width / 2, dimension.height / 2 - ((Component)((Object)this)).getSize().height / 2);
        this.originalHostObj = hostData;
    }

    public void onApply() throws HostException {
        int n;
        HostData hostData = new HostData();
        Vector vector = this.theApp.getTree().getCurrentContent().getDataCache();
        Content content = this.theApp.getTree().getCurrentContent();
        AbstractPropsPanel abstractPropsPanel = null;
        ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 3, 30, false);
        try {
            Object[] objectArray;
            String string;
            n = 0;
            while (n < this.groupPanels.size()) {
                abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
                abstractPropsPanel.dialogDataExchange(hostData);
                ++n;
            }
            boolean bl = false;
            if (this.bNewHost) {
                if (!content.offerNew(hostData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionAddHostFitMessage");
                    int n2 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionFitMessageTitle"), 0, 3);
                    if (n2 == 1) {
                        throw new HostException("");
                    }
                } else {
                    bl = true;
                }
                progressPanel.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"AddHostTitle"));
                progressPanel.setVisible(true);
                string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"AddingHost");
                objectArray = new Object[]{hostData.getHostName()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    this.theApp.getHostMgr().addHost(hostData);
                }
                catch (HostWarningException hostWarningException) {
                    this.theApp.reportErrorException((Exception)((Object)hostWarningException));
                    hostData = this.theApp.getHostMgr().getHostByNameAddr(hostData.getHostName(), hostData.getNetworkAddress());
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"UpdatingOtherViews"));
                Content.broadcastUpdate(null, hostData, false);
            } else {
                if (!content.offerNew(hostData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionModHostFitMessage");
                    int n3 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionFitMessageTitle"), 0, 3);
                    if (n3 == 1) {
                        throw new HostException("");
                    }
                }
                progressPanel.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ModifyHostTitle"));
                progressPanel.setVisible(true);
                string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ModifyingHost");
                objectArray = new Object[]{hostData.getHostName()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    this.theApp.getHostMgr().setHost(this.originalHostObj, hostData);
                }
                catch (HostWarningException hostWarningException) {
                    this.theApp.reportErrorException((Exception)((Object)hostWarningException));
                    hostData = this.theApp.getHostMgr().getHostByNameAddr(hostData.getHostName(), hostData.getNetworkAddress());
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"UpdatingOtherViews"));
                Content.broadcastUpdate(this.originalHostObj, hostData, false);
            }
            progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"RepaintingCurrentView"));
            content.clearSelection();
            content.updateStatusBar();
            if (bl) {
                content.find(hostData);
            }
            progressPanel.setVisible(false);
            progressPanel.dispose();
        }
        catch (Exception exception) {
            progressPanel.setVisible(false);
            progressPanel.dispose();
            if (exception.getLocalizedMessage().length() > 0) {
                this.theApp.reportErrorException(exception);
            }
            throw new HostException(exception.getMessage());
        }
        n = 0;
        while (n < this.groupPanels.size()) {
            abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
            this.originalHostObj = new HostData();
            abstractPropsPanel.dialogDataInitialize(this.originalHostObj);
            ++n;
        }
    }
}

