/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.cli;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.VCommonInfo;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.ServiceWrapper;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;

public class HostMgrCliTool
implements Tool,
IClientResource {
    public static final int SINGLE_ADD = 0;
    public static final int SINGLE_DELETE = 1;
    public static final int SINGLE_MODIFY = 2;
    public static final int SINGLE_VIEW = 3;
    private int iOperation = -1;
    private boolean bDebug = false;
    private String strInputFile = "";
    private String strLogFile = "";
    private ServiceWrapper hostMgr = null;
    private VConsoleProperties properties = null;
    private boolean bRunning = false;
    private ToolInfrastructure infrastructure = null;
    private ResourceBundle resourceBundle = null;
    private ResourceBundle cisBundle = null;
    private ApplicationContext applicationContext = null;

    public HostMgrCliTool() {
        this.trace("enterred in HostMgrCliTool constructor");
        try {
            this.cisBundle = ResourceManager.getBundle((String)VCommonInfo.resourceClass, this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.cisBundle = null;
        }
        String string = System.getProperty("hostmgr.Debugging");
        if (string != null && string.equals("ON")) {
            this.setDebugStatus(true);
            this.trace("Debugging enabled");
        }
        this.trace("leaving HostMgrCliTool constructor");
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
    }

    public void addObject() throws Exception {
    }

    public void cascade_logging(String string) {
        this.trace("in cascade_logging");
        String string2 = this.getLogFile();
        if (this.strLogFile == null || this.strLogFile.equals("")) {
            this.trace("cascade_logging:  no log file specified so logging off");
            return;
        }
        string = String.valueOf(string) + "\n";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.trace("Can't open file for logging:  " + string2);
            this.handleErrors("Can't open file for logging:  " + string2);
        }
        this.trace("cascade_logging to file:  " + string);
    }

    public void cascade_logging(String string, boolean bl) {
        this.trace("in cascade_logging");
        if (bl) {
            string = String.valueOf(this.getDate()) + " " + this.getApplicationContext().getMgmtServer() + ":  " + string;
        }
        String string2 = this.getLogFile();
        if (this.strLogFile == null || this.strLogFile.equals("")) {
            this.trace("cascade_logging:  no log file specified so logging off");
            return;
        }
        string = String.valueOf(string) + "\n";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.trace("Can't open file for logging:  " + string2);
            this.handleErrors("Can't open file for logging:  " + string2);
        }
        this.trace("cascade_logging to file:  " + string);
    }

    public void deleteObject() throws Exception {
    }

    public void destroy() {
    }

    public void doOperation() throws Exception {
        switch (this.iOperation) {
            case 0: {
                this.addObject();
                break;
            }
            case 1: {
                this.deleteObject();
                break;
            }
            case 2: {
                this.modifyObject();
                break;
            }
            case 3: {
                this.viewObjectProps();
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getAuthenticatedUser() {
        String string = null;
        VIdentity vIdentity = this.infrastructure.getIdentity();
        if (vIdentity != null) {
            string = vIdentity.getName();
        }
        return string;
    }

    public ResourceBundle getCisBundle() {
        return this.cisBundle;
    }

    public String getDate() {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        return date.toString();
    }

    public boolean getDebugStatus() {
        return this.bDebug;
    }

    public ServiceWrapper getHostMgr() {
        return this.hostMgr;
    }

    public String getLogFile() {
        return this.strLogFile;
    }

    public String getMgmtServer() {
        return this.applicationContext.getMgmtServer();
    }

    public int getOperation() {
        return this.iOperation;
    }

    public String getOperationType() {
        String string = "";
        switch (this.iOperation) {
            case 0: {
                string = "Add Object";
                break;
            }
            case 1: {
                string = "Delete Object";
                break;
            }
            case 2: {
                string = "Modify Object";
                break;
            }
            case 3: {
                string = "Single View";
                break;
            }
        }
        return string;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public VScopeNode getScopeNode() {
        return null;
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public void giveNoBundleMessage() {
        System.err.println("This tool was not able to load it's resource strings.");
        System.err.println("This could be a temporary situation. Try again.");
        System.err.println("If this problem persists, refer to the Log Viewer and ");
        System.err.println("contact your Sun Microsystems support provider.");
    }

    public void handleErrors(String string) {
        System.err.println(string);
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.trace("enterred HostMgrCliTool.init() ");
        this.infrastructure = toolInfrastructure;
        try {
            this.trace("calling applicationContext.getServiceWrapper()");
            this.hostMgr = this.applicationContext.getServiceWrapper(toolInfrastructure);
            this.trace("done calling applicationContext.getServiceWrapper()");
        }
        catch (HostException hostException) {
            this.handleErrors(hostException.getLocalizedMessage());
            throw new CriticalStopException(hostException.getLocalizedMessage());
        }
        catch (Exception exception) {
            HostException hostException = new HostException("EXM_NO_CIMOM");
            this.handleErrors(hostException.getLocalizedMessage());
            throw new CriticalStopException(exception.getLocalizedMessage());
        }
        AdminCommonTools.CMN_TraceOpen((int)2, (String)"stdout");
        this.trace("leaving HostMgrCliTool.init() ");
    }

    public void logit(String string) {
        System.out.println(string);
    }

    public void modifyObject() throws Exception {
    }

    public void printDebugStack(Exception exception) {
        if (this.getDebugStatus()) {
            exception.printStackTrace();
        }
    }

    public void printDebugStack(Throwable throwable) {
        if (this.getDebugStatus()) {
            throwable.printStackTrace();
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return 0;
    }

    public void setCisBundle(ResourceBundle resourceBundle) {
        this.cisBundle = resourceBundle;
    }

    public void setDebugStatus(boolean bl) {
        this.bDebug = bl;
    }

    public void setHostMgr(ServiceWrapper serviceWrapper) {
        this.hostMgr = serviceWrapper;
    }

    public void setLogFile(String string) {
        this.trace("read in logfile:  " + string);
        this.strLogFile = string;
    }

    public void setOperation(int n) {
        this.iOperation = n;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.trace("HostMgrCliTool.setProperties");
        this.properties = vConsoleProperties;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setTaskOperation(char c) {
        switch (c) {
            case 'A': {
                this.iOperation = 0;
                this.trace("RECOGNIZED ACTION: ADDING ONE OBJECT");
                break;
            }
            case 'X': {
                this.iOperation = 1;
                this.trace("RECOGNIZED ACTION: DELETING ONE OBJECT");
                break;
            }
            case 'M': {
                this.iOperation = 2;
                this.trace("RECOGNIZED ACTION: MODIFYING ONE OBJECT");
                break;
            }
            case 'V': {
                this.iOperation = 3;
                this.trace("RECOGNIZED ACTION: viewing a list of objects");
                break;
            }
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void start() {
        this.bRunning = true;
        this.trace("HostMgrCliTool.start");
    }

    public void stop() {
        this.bRunning = false;
    }

    public void trace(String string) {
        if (this.getDebugStatus()) {
            System.out.println(string);
        }
    }

    public void viewObjectProps() throws Exception {
    }
}

