/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    void add(TimerTask timerTask) {
        if (++this.size == this.queue.length) {
            TimerTask[] timerTaskArray = new TimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, timerTaskArray, 0, this.size);
            this.queue = timerTaskArray;
        }
        this.queue[this.size] = timerTask;
        this.fixUp(this.size);
    }

    void clear() {
        int n = 1;
        while (n <= this.size) {
            this.queue[n] = null;
            ++n;
        }
        this.size = 0;
    }

    private void fixDown(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.queue[n2].nextExecutionTime > this.queue[n2 + 1].nextExecutionTime) {
                ++n2;
            }
            if (this.queue[n].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
        }
    }

    private void fixUp(int n) {
        while (n > 1) {
            int n2 = n >> 1;
            if (this.queue[n2].nextExecutionTime <= this.queue[n].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
        }
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long l) {
        this.queue[1].nextExecutionTime = l;
        this.fixDown(1);
    }
}

