/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.tsol;

import com.sun.management.viperimpl.server.tsol.TsolServerSocket;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;

public class TsolAttrs {
    public static final int T6_SL = 0;
    public static final int T6_NAT_CAVEATS = 1;
    public static final int T6_INTEG_LABEL = 2;
    public static final int T6_SESSION_ID = 3;
    public static final int T6_CLEARANCE = 4;
    public static final int T6_ACL = 5;
    public static final int T6_IL = 6;
    public static final int T6_PRIVILEGES = 7;
    public static final int T6_AUDIT_ID = 8;
    public static final int T6_PID = 9;
    public static final int RESV = 10;
    public static final int T6_AUDIT_INFO = 11;
    public static final int T6_PROC_ATTR = 12;
    public static final int T6_UID = 13;
    public static final int T6_GID = 14;
    public static final int T6_GROUPS = 15;
    private String hostType;
    private String uid;
    private String gid;
    private String auditid;
    private String procAttr;
    private Socket socket;
    private int fd = -1;

    static {
        System.loadLibrary("tsolAttrs");
    }

    public TsolAttrs(Socket socket) {
        this.socket = socket;
    }

    public static boolean assumeRoleOK(AuthenticationPrincipal authenticationPrincipal) {
        String string;
        String string2 = authenticationPrincipal.getName();
        String string3 = string = string2.equals(authenticationPrincipal.getUserName()) ? null : authenticationPrincipal.getUserName();
        if (string == null) {
            return true;
        }
        TsolAttrs tsolAttrs = TsolServerSocket.getTsolAttrs();
        if (tsolAttrs == null) {
            return false;
        }
        try {
            if (tsolAttrs.isTsolClient()) {
                return tsolAttrs.hasTrustedPath() && string.equals(tsolAttrs.getAuditId()) && string2.equals(tsolAttrs.getUserId());
            }
            Properties properties = System.getProperties();
            String string4 = properties.getProperty("tsol.untrustedroles");
            return string4.equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getAuditId() throws SocketException {
        if (this.fd == -1) {
            this.fd = this.getFileDescriptor(this.socket);
        }
        return this.getTSOLattr(this.fd, 8);
    }

    private native int getFileDescriptor(Socket var1) throws SocketException;

    public String getLabel() throws SocketException {
        if (this.fd == -1) {
            this.fd = this.getFileDescriptor(this.socket);
        }
        return this.getTSOLattr(this.fd, 0);
    }

    private synchronized native String getTSOLattr(int var1, int var2) throws SocketException;

    public String getUserId() throws SocketException {
        if (this.fd == -1) {
            this.fd = this.getFileDescriptor(this.socket);
        }
        return this.getTSOLattr(this.fd, 13);
    }

    public boolean hasTrustedPath() throws SocketException {
        String string;
        if (this.fd == -1) {
            this.fd = this.getFileDescriptor(this.socket);
        }
        return (string = this.getTSOLattr(this.fd, 12)).equals("trusted");
    }

    private native boolean isTSOLHostType(int var1, InetAddress var2) throws SocketException;

    public boolean isTsolClient() throws SocketException, UnknownHostException {
        InetAddress inetAddress = this.socket.getInetAddress();
        if (InetAddress.getLocalHost().equals(inetAddress)) {
            return true;
        }
        if (this.fd == -1) {
            this.fd = this.getFileDescriptor(this.socket);
            return this.isTSOLHostType(this.fd, inetAddress);
        }
        return false;
    }

    public static boolean roleListOK() {
        TsolAttrs tsolAttrs = TsolServerSocket.getTsolAttrs();
        if (tsolAttrs == null) {
            return false;
        }
        try {
            if (tsolAttrs.isTsolClient()) {
                return tsolAttrs.hasTrustedPath();
            }
            Properties properties = System.getProperties();
            String string = properties.getProperty("tsol.untrustedroles");
            return string.equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

