/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.server.ViperServer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteRegistryServlet
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() <= 1) {
            this.sendInternalError(httpServletResponse, string);
            return;
        }
        string = string.substring(1).trim();
        Debug.trace((String)"RemoteRegistryServlet", (int)Debug.INFORMATION, (String)("Request: " + string), null);
        if (string.indexOf("..") >= 0) {
            this.sendInternalError(httpServletResponse, string);
            return;
        }
        if (string.endsWith("_vstub")) {
            this.getViperStub(httpServletResponse);
        }
    }

    private void getViperStub(HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)servletOutputStream);
            objectOutputStream.writeObject(ViperServer.viperRemote);
            objectOutputStream.flush();
            objectOutputStream.close();
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            this.sendInternalError(httpServletResponse, iOException.getMessage());
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    private void sendInternalError(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(404, "File " + string + " is NOT used for ViperStub.");
    }
}

