/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class RoleChooser
extends VOptionPane
implements Serializable {
    public static final int OK_OPTION = 0;
    public static final int SKIP_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int PREF_WIDTH = 500;
    public static final int PREF_HEIGHT = 300;
    protected JPasswordField passField = null;
    protected JLabel serverLabel = null;
    protected JLabel userLabel = null;
    protected JLabel roleLabel = null;
    protected JLabel passLabel = null;
    protected JTextField serverField = null;
    protected JTextField nameField = null;
    protected JComboBox roleField = null;
    protected JButton okButton = null;
    protected JButton ignoreButton = null;
    protected JButton cancelButton = null;
    protected JDialog dialog = null;
    protected int returnValue = 2;
    protected transient String normalHelp = null;
    protected transient String failedHelp = null;
    protected transient String baseTitle = null;
    protected transient String normalTitle = null;
    protected transient String failedTitle = null;
    protected transient String noRole = null;
    protected transient Dimension prefSize = new Dimension(500, 300);
    protected VIdentity[] roleSet = null;
    static /* synthetic */ Class class$java$awt$Frame;

    public RoleChooser() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(30, 15, 15, 15));
        this.toggleContentTitle(false);
        this.serverLabel = new JLabel();
        this.userLabel = new JLabel();
        this.roleLabel = new JLabel();
        this.passLabel = new JLabel();
        this.serverField = new JTextField(15){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }
        };
        this.serverField.setEditable(false);
        this.serverLabel.setLabelFor(this.serverField);
        this.nameField = new JTextField(15){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }
        };
        this.nameField.setEditable(false);
        this.userLabel.setLabelFor(this.nameField);
        try {
            this.nameField.setText(System.getProperty("user.name"));
        }
        catch (Exception exception) {}
        this.roleField = new JComboBox(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }
        };
        this.roleField.setEditable(false);
        this.roleLabel.setLabelFor(this.roleField);
        this.passField = new JPasswordField(15){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }
        };
        this.passField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoleChooser.this.returnValue = 0;
                if (RoleChooser.this.dialog != null) {
                    ((Component)RoleChooser.this.dialog).setVisible(false);
                }
            }
        });
        this.passLabel.setLabelFor(this.passField);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoleChooser.this.returnValue = 0;
                if (RoleChooser.this.dialog != null) {
                    ((Component)RoleChooser.this.dialog).setVisible(false);
                }
            }
        });
        this.ignoreButton = new JButton();
        this.ignoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoleChooser.this.returnValue = 1;
                if (RoleChooser.this.dialog != null) {
                    ((Component)RoleChooser.this.dialog).setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoleChooser.this.returnValue = 2;
                if (RoleChooser.this.dialog != null) {
                    ((Component)RoleChooser.this.dialog).setVisible(false);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.serverLabel);
        jPanel.add(Box.createVerticalStrut(12));
        jPanel.add(this.userLabel);
        jPanel.add(Box.createVerticalStrut(36));
        jPanel.add(this.roleLabel);
        jPanel.add(Box.createVerticalStrut(20));
        jPanel.add(this.passLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.serverField);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.nameField);
        jPanel2.add(Box.createVerticalStrut(30));
        jPanel2.add(this.roleField);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.passField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel3);
        jPanel4.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)jPanel4, "North");
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.ignoreButton);
        this.getButtonPane().add(this.cancelButton);
        this.passField.requestDefaultFocus();
        this.init();
    }

    protected Dimension calculatePreferredSize() {
        Dimension dimension = super.calculatePreferredSize();
        Dimension dimension2 = this.prefSize;
        if (!this.infoOn) {
            dimension2 = new Dimension(500 - this.prefInfoWidth, 300);
        }
        if (dimension.width > dimension2.width && dimension.height > dimension2.height) {
            return dimension;
        }
        if (dimension.width < dimension2.width && dimension.height < dimension2.height) {
            return dimension2;
        }
        int n = Math.max(dimension.width, dimension2.width);
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getRoleName() {
        try {
            int n = this.roleField.getSelectedIndex();
            if (n < 0 || n > this.roleSet.length) {
                return null;
            }
            return this.roleSet[n].getName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getRolePassword() {
        return new String(this.passField.getPassword());
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    protected void installStrings() {
        this.serverLabel.setText(ImplResourceManager.getString("SMC Server:"));
        this.serverLabel.setDisplayedMnemonic(ImplResourceManager.getString("SMC Server:_mnemonic").charAt(0));
        this.serverLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("SMC Server:_access_name"));
        this.userLabel.setText(ImplResourceManager.getString("User Name:"));
        this.userLabel.setDisplayedMnemonic(ImplResourceManager.getString("User Name:_mnemonic").charAt(0));
        this.userLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("User Name:_accessible_name"));
        this.roleLabel.setText(ImplResourceManager.getString("Role Name:"));
        this.roleLabel.setDisplayedMnemonic(ImplResourceManager.getString("Role Name:_mnemonic").charAt(0));
        this.roleLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Role Name:_access_name"));
        this.passLabel.setText(ImplResourceManager.getString("Role Password:"));
        this.passLabel.setDisplayedMnemonic(ImplResourceManager.getString("Role Password:_mnemonic").charAt(0));
        this.passLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Role Password:_access_name"));
        this.cancelButton.setText(ResourceManager.getString((String)"CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString((String)"CANCEL_BUTTON_mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.okButton.setText(ImplResourceManager.getString("Login with Role"));
        this.okButton.setMnemonic(ImplResourceManager.getString("Login with Role_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Login with Role_BUTTON_access_name"));
        this.ignoreButton.setText(ImplResourceManager.getString("Login without Role"));
        this.ignoreButton.setMnemonic(ImplResourceManager.getString("Login without Role_mnemonic").charAt(0));
        this.ignoreButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Login without Role_BUTTON_access_name"));
        this.normalHelp = ImplResourceManager.getString("RoleChooserHelp");
        this.normalHelp = ContextHelpLoader.getContextHelp((String)this.normalHelp, null);
        this.failedHelp = ImplResourceManager.getString("RoleFailedChooserHelp");
        this.failedHelp = ContextHelpLoader.getContextHelp((String)this.failedHelp, null);
        this.baseTitle = ImplResourceManager.getString("Log In:");
        this.normalTitle = ImplResourceManager.getString("Role Name");
        this.failedTitle = ImplResourceManager.getString("Login Failed");
        this.setTitle(this.normalTitle);
        this.setHelpHTML(this.normalHelp);
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed((boolean)true);
        RoleChooser roleChooser = new RoleChooser();
        int n = roleChooser.showRoleDialog(null, "dodgeviper", "testuser", null, stringArray.length > 0);
        if (n == 0) {
            System.err.println("Role: " + roleChooser.getRoleName());
            System.err.println("Password: " + roleChooser.getRolePassword());
        }
        System.exit(0);
    }

    public int showRoleDialog(Component component, String string, String string2, VIdentity[] vIdentityArray, boolean bl) {
        this.returnValue = 2;
        this.roleSet = vIdentityArray;
        try {
            Frame frame;
            if (string != null) {
                this.serverField.setText(string);
            }
            if (string2 != null) {
                this.nameField.setText(string2);
            }
            if (this.roleField.getItemCount() > 0) {
                this.roleField.removeAllItems();
            }
            if (vIdentityArray != null && vIdentityArray.length > 0) {
                int n = 0;
                while (n < vIdentityArray.length) {
                    String string3 = vIdentityArray[n].getName();
                    this.roleField.addItem(string3);
                    ++n;
                }
            } else {
                this.roleField.setEnabled(false);
            }
            ((JTextComponent)this.passField).setText("");
            this.passField.setCaretPosition(0);
            Frame frame2 = component instanceof Frame ? (Frame)component : (frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = RoleChooser.class$("java.awt.Frame")), component));
            if (bl) {
                this.dialog = new VDialog(frame, null, true);
                this.setHelpHTML(this.failedHelp);
                this.setTitle(String.valueOf(this.baseTitle) + " " + this.failedTitle);
            } else {
                this.dialog = new VDialog(frame, null, true);
                this.setHelpHTML(this.normalHelp);
                this.setTitle(String.valueOf(this.baseTitle) + " " + this.normalTitle);
            }
            super.setContainer((Component)this.dialog);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(component);
            this.roleField.requestFocus();
            this.dialog.show();
        }
        catch (Throwable throwable) {}
        return this.returnValue;
    }

    protected void updateFontAndColor() {
        this.serverLabel.setFont(ResourceManager.labelFont);
        this.serverLabel.setForeground(ResourceManager.labelColor);
        this.serverField.setFont(ResourceManager.bodyFont);
        this.serverField.setForeground(ResourceManager.bodyColor);
        this.userLabel.setFont(ResourceManager.labelFont);
        this.userLabel.setForeground(ResourceManager.labelColor);
        this.nameField.setFont(ResourceManager.bodyFont);
        this.nameField.setForeground(ResourceManager.bodyColor);
        this.passLabel.setFont(ResourceManager.labelFont);
        this.passLabel.setForeground(ResourceManager.labelColor);
        this.passField.setFont(ResourceManager.bodyFont);
        this.passField.setForeground(ResourceManager.bodyColor);
        this.roleLabel.setFont(ResourceManager.labelFont);
        this.roleLabel.setForeground(ResourceManager.labelColor);
        this.roleField.setFont(ResourceManager.bodyFont);
        this.roleField.setForeground(ResourceManager.bodyColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.ignoreButton.setFont(ResourceManager.menuFont);
        this.ignoreButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }
}

