/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.PropertiesNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.config.myResolver;
import com.sun.management.viperimpl.console.config.myXmlDocumentBuilder;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.SimpleElementFactory;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class VBaseConfiguration
extends XmlDocument {
    protected ToolBoxNode rootNode;
    protected static String viperPublicId = "-//Sun Microsystems, Inc.//Solaris Management Console Toolbox//EN";
    protected static String viperSystemId = "http://www.sun.com/solaris/management/toolbox.dtd";
    protected URL baseURL;
    protected boolean rawtext = false;
    protected Hashtable definedScopes = new Hashtable();

    protected VBaseConfiguration() {
    }

    public BGImageNode createBGImageNode(String string, String string2) {
        BGImageNode bGImageNode = (BGImageNode)this.createElementEx("BackgroundImage");
        bGImageNode.setURL(string);
        bGImageNode.setLocation(string2);
        return bGImageNode;
    }

    public static VBaseConfiguration createConfiguration() {
        VBaseConfiguration vBaseConfiguration = new VBaseConfiguration();
        vBaseConfiguration.rawtext = true;
        vBaseConfiguration.baseURL = null;
        myXmlDocumentBuilder myXmlDocumentBuilder2 = new myXmlDocumentBuilder(vBaseConfiguration);
        Properties properties = new Properties();
        SimpleElementFactory simpleElementFactory = new SimpleElementFactory();
        String string = ((Object)((Object)vBaseConfiguration)).getClass().getPackage().getName();
        properties.setProperty("Folder", String.valueOf(string) + ".FolderNode");
        properties.setProperty("Tool", String.valueOf(string) + ".ToolNode");
        properties.setProperty("Properties", String.valueOf(string) + ".PropertiesNode");
        properties.setProperty("ToolBoxURL", String.valueOf(string) + ".ToolBoxURLNode");
        properties.setProperty("BackgroundImage", String.valueOf(string) + ".BGImageNode");
        properties.setProperty("ToolBox", String.valueOf(string) + ".ToolBoxNode");
        properties.setProperty("*Element", String.valueOf(string) + ".GenericElement");
        simpleElementFactory.addMapping((Dictionary)properties, ((Object)((Object)vBaseConfiguration)).getClass().getClassLoader());
        vBaseConfiguration.setElementFactory((ElementFactory)simpleElementFactory);
        vBaseConfiguration.setDoctype(viperPublicId, viperSystemId, null);
        vBaseConfiguration.rootNode = (ToolBoxNode)((Object)vBaseConfiguration.getDocumentElement());
        return vBaseConfiguration;
    }

    public static VBaseConfiguration createConfiguration(URL uRL) throws ConfigurationException {
        if (uRL == null) {
            return VBaseConfiguration.createConfiguration();
        }
        return VBaseConfiguration.createConfiguration(uRL, true);
    }

    public static VBaseConfiguration createConfiguration(URL uRL, boolean bl) throws ConfigurationException {
        return VBaseConfiguration.createConfiguration(uRL, true, false);
    }

    public static VBaseConfiguration createConfiguration(URL uRL, boolean bl, boolean bl2) throws ConfigurationException {
        try {
            Parser parser;
            VBaseConfiguration vBaseConfiguration = new VBaseConfiguration();
            vBaseConfiguration.rawtext = bl2;
            vBaseConfiguration.baseURL = uRL;
            myXmlDocumentBuilder myXmlDocumentBuilder2 = new myXmlDocumentBuilder(vBaseConfiguration);
            InputSource inputSource = Resolver.createInputSource((URL)uRL, (boolean)false);
            Properties properties = new Properties();
            SimpleElementFactory simpleElementFactory = new SimpleElementFactory();
            String string = "com.sun.management.viperimpl.console.config";
            if (bl) {
                parser = new ValidatingParser(true);
                properties.setProperty("Folder", String.valueOf(string) + ".FolderNode");
                properties.setProperty("Tool", String.valueOf(string) + ".ToolNode");
                properties.setProperty("Properties", String.valueOf(string) + ".PropertiesNode");
                properties.setProperty("ToolBoxURL", String.valueOf(string) + ".ToolBoxURLNode");
                properties.setProperty("BackgroundImage", String.valueOf(string) + ".BGImageNode");
            } else {
                parser = new Parser();
            }
            properties.setProperty("ToolBox", String.valueOf(string) + ".ToolBoxNode");
            properties.setProperty("*Element", String.valueOf(string) + ".GenericElement");
            simpleElementFactory.addMapping((Dictionary)properties, ((Object)((Object)vBaseConfiguration)).getClass().getClassLoader());
            vBaseConfiguration.setElementFactory((ElementFactory)simpleElementFactory);
            parser.setEntityResolver((EntityResolver)((Object)new myResolver(vBaseConfiguration.baseURL)));
            parser.setDocumentHandler((DocumentHandler)((Object)myXmlDocumentBuilder2));
            parser.parse(inputSource);
            vBaseConfiguration.setDoctype(viperPublicId, viperSystemId, null);
            vBaseConfiguration.rootNode = (ToolBoxNode)((Object)vBaseConfiguration.getDocumentElement());
            return vBaseConfiguration;
        }
        catch (SAXParseException sAXParseException) {
            String string = "** Parsing error, line " + sAXParseException.getLineNumber() + (sAXParseException.getColumnNumber() >= 0 ? ", column " + sAXParseException.getColumnNumber() : "") + ", uri " + sAXParseException.getSystemId();
            System.out.println(string);
            System.out.println("   " + sAXParseException.getMessage());
            throw new ConfigurationException(string, sAXParseException);
        }
        catch (Exception exception) {
            throw new ConfigurationException("", exception);
        }
    }

    public FolderNode createFolderNode(String string, String string2, String string3, String string4, String string5) {
        FolderNode folderNode = (FolderNode)this.createElementEx("Folder");
        folderNode.setName(string);
        folderNode.setDescription(string2);
        folderNode.setSmallIcon(string3);
        folderNode.setLargeIcon(string4);
        folderNode.setScope(string5);
        return folderNode;
    }

    public PropertiesNode createPropertiesNode(Properties properties) {
        PropertiesNode propertiesNode = (PropertiesNode)this.createElementEx("Properties");
        propertiesNode.setProperties(properties);
        return propertiesNode;
    }

    public ToolBoxNode createToolBoxNode(String string, String string2, String string3, String string4, String string5, String string6, String string7, Properties properties) {
        ToolBoxNode toolBoxNode = (ToolBoxNode)this.createElementEx("ToolBox");
        toolBoxNode.setName(string);
        toolBoxNode.setDescription(string2);
        toolBoxNode.setInformation(string3);
        toolBoxNode.setSmallIcon(string5);
        toolBoxNode.setLargeIcon(string6);
        toolBoxNode.setScope(string7);
        return toolBoxNode;
    }

    public ToolBoxNode createToolBoxNode(String string, String string2, String string3, String string4, String string5, String string6, Properties properties) {
        return this.createToolBoxNode(string, string2, null, string3, string4, string5, string6, properties);
    }

    public ToolBoxURLNode createToolBoxURLNode(String string) {
        ToolBoxURLNode toolBoxURLNode = (ToolBoxURLNode)this.createElementEx("ToolBoxURL");
        toolBoxURLNode.setURL(string);
        return toolBoxURLNode;
    }

    public ToolNode createToolNode(String string, int n, String string2, boolean bl, boolean bl2, String string3, Properties properties) {
        return this.createToolNode(string, n, string2, bl, bl2, string3, properties, null, null, null, null);
    }

    public ToolNode createToolNode(String string, int n, String string2, boolean bl, boolean bl2, String string3, Properties properties, String string4, String string5, String string6, String string7) {
        ToolNode toolNode = (ToolNode)this.createElementEx("Tool");
        toolNode.setScope(string3);
        toolNode.setClassName(string2);
        toolNode.setServerName(string);
        toolNode.setServerPort(n);
        toolNode.setAutoLoad(bl);
        toolNode.setBackgroundLoad(bl2);
        toolNode.setParameters(properties);
        toolNode.setName(string4);
        toolNode.setDescription(string5);
        toolNode.setSmallIcon(string6);
        toolNode.setLargeIcon(string7);
        return toolNode;
    }

    public ToolNode createToolNode(String string, String string2, boolean bl, boolean bl2, String string3, Properties properties) {
        return this.createToolNode(string, -1, string2, bl, bl2, string3, properties);
    }

    public Enumeration enumerateScopes() {
        return this.definedScopes.keys();
    }

    public String getID() {
        return this.rootNode.getName();
    }

    public VConfigurationInfo getInfo() {
        return new VConfigurationInfo(null, this.baseURL, this.rootNode.getLocale(), this.rootNode.getName(), this.rootNode.getDescription(), this.rootNode.getType(), this.rootNode.getSmallIcon(), this.rootNode.getLargeIcon());
    }

    public VConfigurationNode getRootNode() {
        return this.rootNode;
    }

    String getServerName() {
        String string;
        block3: {
            string = "";
            if (this.baseURL != null) {
                string = this.baseURL.getHost();
            }
            if (!string.equals("")) break block3;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "localhost";
            }
        }
        return string;
    }

    boolean isRawText() {
        return this.rawtext;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: $0 <config file>");
            System.exit(1);
        }
        try {
            VBaseConfiguration vBaseConfiguration;
            try {
                vBaseConfiguration = VBaseConfiguration.createConfiguration(new URL(stringArray[0]), true, true);
            }
            catch (MalformedURLException malformedURLException) {
                vBaseConfiguration = VBaseConfiguration.createConfiguration(new File(stringArray[0]).toURL(), true, true);
            }
            VBaseNode vBaseNode = (VBaseNode)vBaseConfiguration.getRootNode();
            System.out.println("\nPrinting Document");
            vBaseNode.printTree(0);
            System.out.println("\nPrinting Document XML");
            vBaseConfiguration.write(System.out);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            System.exit(1);
        }
    }
}

