/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VSplashScreen;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VDebug;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.console.BaseConsoleOptions;
import com.sun.management.viperimpl.console.CSecurityManager;
import com.sun.management.viperimpl.console.CodeSourcePolicy;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.editor.SMCEditor;
import com.sun.management.viperimpl.console.gui.SMCConsole;
import com.sun.management.viperimpl.console.tty.SMCTerminal;
import com.sun.management.viperimpl.util.AuthData;
import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.SimpleDebugger;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Policy;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

public class BaseConsoleOptionsManager {
    protected static CommandOption termOption = null;
    protected static CommandOption hostOption = null;
    protected static CommandOption authDataOption = null;
    protected static CommandOption userOption = null;
    protected static CommandOption pwordOption = null;
    protected static CommandOption roleOption = null;
    protected static CommandOption rolePwordOption = null;
    protected static CommandOption toolOption = null;
    protected static CommandOption scopeOption = null;
    protected static CommandOption confOption = null;
    protected static CommandOption debugOption = null;
    protected static CommandOption helpOption = null;
    protected static CommandOption trustedOption = null;
    protected static CommandOption yesOption = null;
    protected static CommandOption silentOption = null;
    protected static CommandOption versionOption = null;
    protected static CommandOption ptOption = null;
    protected static CommandParser parser = null;
    protected static CommandParser openCommand = null;
    protected static CommandParser editCommand = null;
    protected static CommandParser subCommand = null;
    protected static InputStream input = null;
    protected static PrintStream output = null;
    protected static PrintStream error = null;
    protected static String[] secArgs = null;
    static /* synthetic */ Class class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static void configureParser(CommandParser commandParser) {
        if (commandParser == null) {
            return;
        }
        commandParser.addOption(debugOption);
        commandParser.addOption(termOption);
        commandParser.addOption(hostOption);
        commandParser.addOption(authDataOption);
        commandParser.addOption(userOption);
        commandParser.addOption(pwordOption);
        commandParser.addOption(roleOption);
        commandParser.addOption(rolePwordOption);
        commandParser.addOption(toolOption);
        commandParser.addOption(scopeOption);
        commandParser.addOption(confOption);
        commandParser.addOption(helpOption);
        commandParser.addOption(trustedOption);
        commandParser.addOption(yesOption);
        commandParser.addOption(silentOption);
    }

    protected static void editConsole(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdminMgmtScope adminMgmtScope, String[] stringArray, boolean bl, boolean bl2, boolean bl3, InputStream inputStream, PrintStream printStream, PrintStream printStream2, boolean bl4) throws Exception {
        if (!bl4) {
            ResourceManager.seed((boolean)true);
            VSplashScreen vSplashScreen = new VSplashScreen(null);
            ImageIcon imageIcon = ConsoleUtility.loadImageIcon((String)"editor/lf/images/splash.gif", (Class)(class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager != null ? class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager : (class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager = BaseConsoleOptionsManager.class$("com.sun.management.viperimpl.console.BaseConsoleOptionsManager"))));
            vSplashScreen.setImage(imageIcon);
            vSplashScreen.setTextFont(new Font("SanSerif", 0, 20));
            vSplashScreen.show();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Instantiating editor..."));
            SMCEditor sMCEditor = new SMCEditor();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Initializing editor..."));
            sMCEditor.init(null);
            VFrame vFrame = new VFrame();
            sMCEditor.setContainer((Container)vFrame);
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting options..."));
            sMCEditor.setInitialOptions(string, string2, string3, string4, string5, string6, string7, string8, adminMgmtScope, stringArray, bl, bl2, bl3, inputStream, printStream, printStream2);
            vSplashScreen.dispose();
            vFrame.showCenter(null);
            sMCEditor.start();
        }
    }

    protected static void establishSecurityManager() {
        try {
            CodeSourcePolicy codeSourcePolicy = new CodeSourcePolicy(Policy.getPolicy());
            Policy.setPolicy(codeSourcePolicy);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"OptionsManager", (int)Debug.WARNING, (String)"Unable to set CodeSourcePolicy", (Throwable)throwable);
        }
        try {
            System.setSecurityManager(new CSecurityManager());
        }
        catch (Throwable throwable) {
            Debug.trace((String)"OptionsManager", (int)Debug.WARNING, (String)"Unable to set security manager", (Throwable)throwable);
        }
    }

    protected static void handleDebugOption() {
        if (debugOption == null) {
            return;
        }
        if (debugOption.wasSet()) {
            Debug.setDebugLevel((int)((Integer)debugOption.getValue()));
        }
    }

    protected static void handleHelpOption(CommandParser commandParser) {
        if (helpOption == null || commandParser == null) {
            return;
        }
        if (helpOption.wasSet()) {
            commandParser.printUsage(null);
            System.exit(0);
        }
    }

    protected static void handleVersionOption() {
        if (versionOption == null || parser == null) {
            return;
        }
        if (versionOption.wasSet()) {
            output.println("Solaris Management Console " + SMCVersion.getFullVersion());
            System.exit(0);
        }
    }

    protected static void init() {
        String string = null;
        String string2 = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
            string2 = System.getProperty("user.name");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        termOption = BaseConsoleOptions.getTerminalOption();
        hostOption = BaseConsoleOptions.getHostOption(string);
        authDataOption = BaseConsoleOptions.getAuthDataOption();
        userOption = BaseConsoleOptions.getUserNameOption(string2);
        pwordOption = BaseConsoleOptions.getPasswordOption(null);
        roleOption = BaseConsoleOptions.getRoleNameOption(null);
        rolePwordOption = BaseConsoleOptions.getRolePasswordOption(null);
        toolOption = BaseConsoleOptions.getToolOption(null);
        scopeOption = BaseConsoleOptions.getScopeOption(null);
        confOption = BaseConsoleOptions.getToolBoxOption(null);
        debugOption = BaseConsoleOptions.getDebugOption();
        helpOption = BaseConsoleOptions.getHelpOption();
        trustedOption = BaseConsoleOptions.getTrustedOption();
        yesOption = BaseConsoleOptions.getYesOption();
        silentOption = BaseConsoleOptions.getSilentOption();
        versionOption = BaseConsoleOptions.getVersionOption();
        ptOption = BaseConsoleOptions.getPassThruOption();
    }

    protected static void launchConsole(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        ResourceManager.seed((boolean)false);
        parser = new CommandParser("smc", "Solaris Management Console", true, inputStream, printStream);
        input = inputStream;
        output = printStream;
        error = printStream2;
        Debug.setDebugImpl((VDebug)new SimpleDebugger());
        BaseConsoleOptionsManager.init();
        BaseConsoleOptionsManager.setParserOptions();
        if (!BaseConsoleOptionsManager.parseAndProcessArgs(stringArray)) {
            System.err.println("Error parsing and processing args");
            System.exit(1);
        } else {
            BaseConsoleOptionsManager.redirectToConsole();
        }
    }

    public static void main(String[] stringArray) {
        try {
            BaseConsoleOptionsManager.launchConsole(stringArray, System.in, System.out, System.err);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    protected static void openConsole(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdminMgmtScope adminMgmtScope, String[] stringArray, boolean bl, boolean bl2, boolean bl3, InputStream inputStream, PrintStream printStream, PrintStream printStream2, boolean bl4) throws Exception {
        if (bl4) {
            SMCTerminal sMCTerminal = new SMCTerminal();
            sMCTerminal.init(null);
            sMCTerminal.setInitialOptions(string, string2, string3, string4, string5, string6, string7, string8, adminMgmtScope, stringArray, bl, bl2, bl3, inputStream, printStream, printStream2);
            sMCTerminal.start();
        } else {
            ResourceManager.seed((boolean)true);
            VSplashScreen vSplashScreen = new VSplashScreen(null);
            ImageIcon imageIcon = ConsoleUtility.loadImageIcon((String)"gui/images/splash.gif", (Class)(class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager != null ? class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager : (class$com$sun$management$viperimpl$console$BaseConsoleOptionsManager = BaseConsoleOptionsManager.class$("com.sun.management.viperimpl.console.BaseConsoleOptionsManager"))));
            vSplashScreen.setImage(imageIcon);
            vSplashScreen.setTextFont(new Font("SanSerif", 0, 20));
            vSplashScreen.show();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Instantiating console..."));
            SMCConsole sMCConsole = new SMCConsole();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Initializing console..."));
            sMCConsole.init(null);
            VFrame vFrame = new VFrame();
            sMCConsole.setContainer((Container)vFrame);
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting options..."));
            sMCConsole.setInitialOptions(string, string2, string3, string4, string5, string6, string7, string8, adminMgmtScope, stringArray, bl, bl2, bl3, inputStream, printStream, printStream2);
            vSplashScreen.dispose();
            vFrame.showCenter(null);
            sMCConsole.start();
        }
    }

    protected static boolean parseAndProcessArgs(String[] stringArray) {
        try {
            String[] stringArray2;
            secArgs = CommandParser.getSecondaryArgs((String[])stringArray);
            stringArray = CommandParser.getPrimaryArgs((String[])stringArray);
            parser.addOption(helpOption);
            parser.addOption(debugOption);
            parser.addOption(versionOption);
            if (!parser.parseArgs(stringArray)) {
                return false;
            }
            BaseConsoleOptionsManager.handleHelpOption(parser);
            BaseConsoleOptionsManager.handleVersionOption();
            BaseConsoleOptionsManager.handleDebugOption();
            helpOption = BaseConsoleOptions.getHelpOption();
            debugOption = BaseConsoleOptions.getDebugOption();
            subCommand = parser.getSubCommand();
            if (subCommand == null) {
                subCommand = openCommand;
            } else {
                stringArray2 = parser.getUnmatchedOptions();
                if (stringArray2.length > 0) {
                    parser.printUsage(null);
                    System.exit(0);
                }
                stringArray = parser.getSubCommandArgs();
            }
            BaseConsoleOptionsManager.configureParser(subCommand);
            if (!subCommand.parseArgs(stringArray)) {
                return false;
            }
            stringArray2 = subCommand.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                subCommand.printUsage(null);
                System.exit(0);
            }
            BaseConsoleOptionsManager.handleDebugOption();
            BaseConsoleOptionsManager.handleHelpOption(subCommand);
            if (termOption.wasSet()) {
                BaseConsoleOptionsManager.parseAndProcessTerminalOptions();
            }
            return true;
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleOptionsManager", (int)Debug.ERROR, (String)"Unexpected error parsing command line", (Throwable)throwable);
            return false;
        }
    }

    protected static void parseAndProcessTerminalOptions() {
        if (parser == null) {
            return;
        }
        if (!authDataOption.wasSet()) {
            if (!pwordOption.wasSet()) {
                output.println("Authenticating as user: " + (String)userOption.getValue());
                pwordOption.promptUser(input, output);
            }
            if (roleOption.wasSet() && !rolePwordOption.wasSet()) {
                output.println("Authenticating as role: " + (String)roleOption.getValue());
                rolePwordOption.promptUser(input, output);
            }
        } else {
            File file = null;
            try {
                file = new File((String)authDataOption.getValue());
            }
            catch (Throwable throwable) {}
            if (file == null || !file.exists() || !file.canRead()) {
                output.println("Authentication Data either not found or not readable.");
                System.exit(1);
            }
        }
    }

    protected static void redirectToConsole() {
        BaseConsoleOptionsManager.establishSecurityManager();
        AdminMgmtScope adminMgmtScope = null;
        try {
            adminMgmtScope = !scopeOption.wasSet() ? new AdminMgmtScope("file", null, (String)hostOption.getValue(), null) : (AdminMgmtScope)scopeOption.getValue();
        }
        catch (Throwable throwable) {}
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = (String)authDataOption.getValue();
            if (authDataOption.wasSet()) {
                try {
                    object3 = new AuthData(string7);
                    string2 = ((AuthData)object3).getHostname();
                    string3 = ((AuthData)object3).getUserName();
                    object2 = ((AuthData)object3).getPassword();
                    if (object2 != null) {
                        string4 = new String((char[])object2);
                    }
                    string5 = ((AuthData)object3).getRoleName();
                    object2 = ((AuthData)object3).getRolePassword();
                    if (object2 != null) {
                        string6 = new String((char[])object2);
                    }
                    ((AuthData)object3).destroy();
                }
                catch (Throwable throwable) {
                    output.println("Error in Authentication Data file:");
                    output.println(throwable.getMessage());
                    System.exit(1);
                }
            }
            if (hostOption.wasSet() || string2 == null || string2.length() == 0) {
                string2 = (String)hostOption.getValue();
            }
            object3 = null;
            if (confOption.wasSet()) {
                object3 = (String)confOption.getValue();
                if (((String)object3).startsWith((String)(object2 = (Object)System.getProperty("file.separator")))) {
                    object3 = "file:" + (String)object3;
                } else if (((String)object3).startsWith("." + (String)object2)) {
                    object3 = "file:" + (String)object3;
                } else if (((String)object3).startsWith(".." + (String)object2)) {
                    object3 = "file:" + (String)object3;
                }
                try {
                    object = new URL((String)object3);
                }
                catch (MalformedURLException malformedURLException) {
                    string = string2;
                    int n = ManagerUtility.parsePortFromString(string);
                    if (n < 0) {
                        n = 898;
                        string = String.valueOf(string) + ":" + n;
                    }
                    if (!((String)object3).endsWith(".tbx")) {
                        object3 = String.valueOf(object3) + ".tbx";
                    }
                    object3 = "http://" + string + "/toolboxes/" + (String)object3;
                }
            }
            if (userOption.wasSet() || string3 == null || string3.length() == 0) {
                string3 = (String)userOption.getValue();
            }
            if (pwordOption.wasSet()) {
                string4 = (String)pwordOption.getValue();
            }
            if (roleOption.wasSet()) {
                string5 = (String)roleOption.getValue();
            }
            if (rolePwordOption.wasSet()) {
                string6 = (String)rolePwordOption.getValue();
            }
            boolean bl = termOption.wasSet();
            object = System.getProperty("viper.display");
            if (object != null && ((String)object).equals("false") && !bl) {
                error.println("\n" + ImplResourceManager.getString("NoDisplayForGUI"));
                System.exit(1);
            }
            if (bl && (string4 == null || string4.length() == 0)) {
                error.println("\n" + ImplResourceManager.getString("MissingAuthData"));
                System.exit(1);
            }
            if (bl && !toolOption.wasSet()) {
                toolOption.promptUser(input, output);
                if (secArgs == null) {
                    ptOption.promptUser(input, output);
                    secArgs = BaseConsoleOptionsManager.tokenizeInput((String)ptOption.getValue());
                }
            }
            string = null;
            if (toolOption.wasSet()) {
                Vector vector = toolOption.getValues();
                if (vector != null && vector.size() > 1) {
                    error.println("Multiple tools not yet supported, will launch first tool only...");
                }
                string = (String)vector.elementAt(0);
            }
            boolean bl2 = trustedOption.wasSet();
            boolean bl3 = yesOption.wasSet();
            boolean bl4 = silentOption.wasSet();
            String string8 = subCommand.getName();
            if (string8.equals(openCommand.getName())) {
                BaseConsoleOptionsManager.openConsole(string7, string2, string3, string4, string5, string6, (String)object3, string, adminMgmtScope, secArgs, bl2, bl3, bl4, input, output, error, bl);
            } else if (string8.equals(editCommand.getName())) {
                BaseConsoleOptionsManager.editConsole(string7, string2, string3, string4, string5, string6, (String)object3, string, adminMgmtScope, secArgs, bl2, bl3, bl4, input, output, error, bl);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    protected static void setParserOptions() {
        if (parser == null) {
            return;
        }
        editCommand = new CommandParser("edit", ImplResourceManager.getString("edit_option_desc"), true, input, output);
        parser.addSubCommand(editCommand);
        openCommand = new CommandParser("open", ImplResourceManager.getString("open_option_desc"), true, input, output);
        parser.addSubCommand(openCommand);
    }

    protected static String smcVersion() {
        return SMCVersion.getVersion();
    }

    protected static String[] tokenizeInput(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }
}

