/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceContext;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.ServiceProvider;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ServiceContainer;
import java.rmi.RemoteException;

public abstract class UnicastContainer
extends ServiceContainer {
    protected ServiceProvider bean = null;
    private int beanstatus = 0;

    protected UnicastContainer() throws RemoteException {
    }

    public Service create(ServiceInfrastructure serviceInfrastructure, ServiceContext serviceContext) throws CriticalStopException {
        if (this.bean == null) {
            throw new CriticalStopException("ServiceNotFound");
        }
        if (!(this.bean instanceof Service)) {
            throw new CriticalStopException("InvalidServiceImpl");
        }
        try {
            if (this.beanstatus == 1) {
                this.bean.destroy();
            } else if (this.beanstatus == 2) {
                this.bean.stop();
                this.bean.destroy();
            }
            this.bean.setContext(serviceContext);
            this.bean.init(serviceInfrastructure);
            this.bean.start();
            this.beanstatus = 2;
        }
        catch (Throwable throwable) {
            if (throwable instanceof CriticalStopException) {
                throw (CriticalStopException)throwable;
            }
            if (throwable instanceof Exception) {
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to create service " + this.bean + ":" + throwable.getMessage()), null);
                throw new CriticalStopException(" failed to create service " + this.bean + ":", (Exception)throwable);
            }
            Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to create service " + this.bean + ":" + throwable.getMessage()), null);
            throw new CriticalStopException("InitStartFailed" + this.bean);
        }
        return (Service)this.bean;
    }

    public void destroy() throws CriticalStopException {
        block5: {
            if (this.bean == null) break block5;
            try {
                if (this.beanstatus == 0) {
                    return;
                }
                if (this.beanstatus == 2) {
                    this.bean.stop();
                }
                this.bean.destroy();
                this.beanstatus = 0;
            }
            catch (Throwable throwable) {
                if (throwable instanceof CriticalStopException) {
                    throw (CriticalStopException)throwable;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to destroy service " + this.bean + ":" + throwable.getMessage()), null);
            }
        }
    }

    protected int getBeanStatus() {
        return this.beanstatus;
    }

    public void init(ServiceInfrastructure serviceInfrastructure) throws CriticalStopException {
        block6: {
            super.init(serviceInfrastructure);
            if (this.bean == null) break block6;
            try {
                if (this.beanstatus == 1) {
                    this.bean.destroy();
                } else if (this.beanstatus == 2) {
                    this.bean.stop();
                    this.bean.destroy();
                }
                this.bean.init(serviceInfrastructure);
                this.beanstatus = 1;
            }
            catch (Throwable throwable) {
                if (throwable instanceof CriticalStopException) {
                    throw (CriticalStopException)throwable;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to init service " + this.bean + ":" + throwable.getMessage()), null);
            }
        }
    }

    public void remove(Service service) throws CriticalStopException {
        if (service == this.bean) {
            this.destroy();
        }
    }

    public void start() throws CriticalStopException {
        block5: {
            if (this.bean == null) break block5;
            try {
                if (this.beanstatus == 0) {
                    String string = "Error: start is called before init(), service won't be started.";
                    Debug.trace((String)"UnicastContainer", (int)Debug.INFORMATION, (String)string, null);
                    return;
                }
                if (this.beanstatus == 2) {
                    return;
                }
                this.bean.start();
                this.beanstatus = 2;
            }
            catch (Throwable throwable) {
                if (throwable instanceof CriticalStopException) {
                    throw (CriticalStopException)throwable;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to start service " + this.bean + ":" + throwable.getMessage()), null);
            }
        }
    }

    public void stop() throws CriticalStopException {
        block5: {
            if (this.bean == null) break block5;
            try {
                if (this.beanstatus == 0) {
                    return;
                }
                if (this.beanstatus == 1) {
                    return;
                }
                this.bean.stop();
                this.beanstatus = 1;
            }
            catch (Throwable throwable) {
                if (throwable instanceof CriticalStopException) {
                    throw (CriticalStopException)throwable;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to stop service " + this.bean + ":" + throwable.getMessage()), null);
            }
        }
    }
}

