/* Gate Specific Code -- BEGIN */
/*
 * Copyright (c) 1998-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#pragma ident "@(#)xfs_update.c  1.6     01/01/30 SMI"
/* Gate Specific Code -- END */
/* Sun Cluster Data Services Builder template version 1.0 */
/*
 * xfs_update.c - Update method for XFS
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <rgm/libdsdev.h>
#include "xfs.h"

/*
 * Some of the resource properties might have been updated. All such
 * updatable properties are related to the fault monitor. Hence, just
 * restarting the monitor should be enough.
 */

int
main(int argc, char *argv[])
{
	scds_handle_t   scds_handle;
	scha_err_t	result;

	/* Process the arguments passed by RGM and initialize syslog */
	if (scds_initialize(&scds_handle, argc, argv) != SCHA_ERR_NOERR)
		return (1);

	/*
	 * check if the Fault monitor is already running and if so stop and
	 * restart it. The second parameter to scds_pmf_restart_fm() uniquely
	 * identifies the instance of the fault monitor that needs to be
	 * restarted.
	 */

	result = scds_pmf_restart_fm(scds_handle, 0);
	if (result != SCHA_ERR_NOERR) {
		scds_syslog(LOG_ERR,
		    "Failed to restart fault monitor.");
		/* Free up all the memory allocated by scds_initialize */
		scds_close(&scds_handle);
		return (1);
	}

	scds_syslog(LOG_INFO,
	    "Completed successfully.");

	/* Free up all the memory allocated by scds_initialize */
	scds_close(&scds_handle);

	return (0);
}
