/* Gate Specific Code -- BEGIN */
/*
 * Copyright (c) 1998-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#pragma ident "@(#)xfs_svc_start.c 1.7 01/01/30 SMI"
/* Gate Specific Code -- END */
/* Sun Cluster Data Services Builder template version 1.0 */
/*
 * xfs_svc_start.c - Start method for XFS
 */

#include <rgm/libdsdev.h>
#include "xfs.h"

/*
 * The start method for XFS. Does some sanity checks on
 * the resource settings then starts the XFS under PMF with
 * an action script.
 */

int
main(int argc, char *argv[])
{
	scds_handle_t	scds_handle;
	int rc;

	/*
	 * Process all the arguments that have been passed to us from RGM
	 * and do some initialization for syslog
	 */

	if (scds_initialize(&scds_handle, argc, argv) != SCHA_ERR_NOERR) {
		return (1);
	}

	/* Validate the configuration and if there is an error return back */
	rc = svc_validate(scds_handle);
	if (rc != 0) {
		scds_syslog(LOG_ERR,
		    "Failed to validate configuration.");
		goto finished;
	}

	/* Start the data service, if it fails return with an error */
	rc = svc_start(scds_handle);
	if (rc != 0) {
		goto finished;
	}

	/* Network aware applications code -- BEGIN */
	/* Wait for the service to start up fully */
	rc = svc_wait(scds_handle);
	scds_syslog_debug(DBG_LEVEL_HIGH, "Returned from svc_wait");
	/* Network aware applications code -- END */

finished:
	/* Free up the Environment resources that were allocated */
	(void) scds_close(&scds_handle);

	return (rc);
}
