
# Copyright 12/17/99 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)Config-Reader4u-d.x	1.44 99/12/17 Sun Microsystems"


[ use MANAGED-MODULE ]
[ requires package configd ]
[ requires package pfa ]
[ requires template Config-Reader-models-d ]
[ requires template sena-models-d ]

[ load Config-Reader4u-m.x ]

# Define services required by this module

_services = { [ use SERVICE ]
	Config-Reader4uShell = {
		command	= "pipe://localhost/oa-shell.sh;transport=shell;args=Config-Reader4u-shell.tcl"
		max	= 1
	}
}


_filters = { [ use PROC ]
        [ source Config-Reader4u-d.flt ]
}

adhocCommand(tree) = probeserver -u root -c /usr/bin/cat /var/opt/SUNWsymon/cfg/Config-Reader4u.tree
adhocCommand(schema) = probeserver -c Config-Reader4u-schema.sh


#
# configd Availability
#
availability = {
	type		= derived
	refreshMode	= async
        refreshTrigger  = system.timestamp:update
	refreshCommand  = get_availabilty_status
	timeoutInterval = 600

# change the default error message. Change the default alarm.
 
	errorMessage       = "Is not supported on this platform."
	alarmChecks         = "error-ne";
	alarmlimit:error-ne  = AVAILABLE
	mediumDesc          = 
	statusActions(error-ne)      = forcedown
	statusService(forcedown)    = _superior
	statusCommand(forcedown)    = forceModuleState down %[ toe_self ]

}


system = { [ use templates.Config-Reader-models-d.system ]
	type		= active
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshCommand  = configd system 0 OS OS_version System_clock_frequency architecture hostname machine platform sample serial_number timestamp timestamp_raw total_disks total_memory total_processors total_tape_devices 
        initInterval    = 2
	refreshInterval	= 300
	refreshFilter   = join
	timeoutInterval = 600
	total_model_changes = { [ use _filters ]
		type		= derived
		refreshService	= _services.Config-Reader4uShell
		refreshMode	= async
		refreshCommand  = get_prom_changed_status 0
		refreshFilter   = modelChange
        	refreshTrigger  = system.timestamp:refresh
		initInterval    = 2
		timeoutInterval = 600
	}
	total_config_changes = { [ use _filters ]
		type		= derived
		refreshService	= _services.Config-Reader4uShell
		refreshMode	= async
		refreshCommand  = get_prom_changed_status 1
		refreshFilter   = configChange
		initInterval    = 2
        	refreshTrigger  = system.timestamp:refresh
		timeoutInterval = 600

	}
}


system-board = { [ use templates.Config-Reader-models-d.system-board ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd system-board 0
	refreshFilter 	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
clock-board = { [ use templates.Config-Reader-models-d.clock-board ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd clock-board 0
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
SUNWUltra-1  = { [ use templates.Config-Reader-models-d.SUNWUltra-1  ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd SUNW,Ultra-1 0
	refreshFilter	= join
	timeoutInterval = 600
        initInterval    = 5
	refreshInterval	= 6000
}
SUNWUltra-2  = { [ use templates.Config-Reader-models-d.SUNWUltra-2  ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd SUNW,Ultra-2 0
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
slot = { [ use templates.Config-Reader-models-d.slot ]
slotTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd slot 1 slot-num
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
board = { [ use templates.Config-Reader-models-d.board ]
boardTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd board 1 board-num  fru hot-plugged hpu memory_size state temperature type type-int upa-mid 
	refreshFilter	= join
        initInterval    = 5
	refreshInterval	= 6000
}
}
cpu-unit = { [ use templates.Config-Reader-models-d.cpu-unit ]
cpu-unitTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
	refreshFilter	= join
        refreshCommand  = configd cpu-unit 1 board# board# clock-frequency cpu-type dcache-size device_type ecache-size fru icache-size model pathname_element processor-id reg status unit upa-mid upa-portid
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
#sd = { [ use templates.Config-Reader-models-d.sd ]
#	type		= derived
#	refreshMode	= async
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sd 1 device_type fru mounted_partitions disk_name
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#zs = { [ use templates.Config-Reader-models-d.zs ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd zs 1 device_type device_usage instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
simm = { [ use templates.Config-Reader-models-d.simm ]
simmTbl    = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd simm 1 board_reference_number fru size slot type
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
AC_PS = { [ use templates.Config-Reader-models-d.AC_PS ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd AC_PS 0 status
	refreshFilter	= join 
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
hot_plug_charges = { [ use templates.Config-Reader-models-d.hot_plug_charges ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd hot_plug_charges 0 fru
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
auxiliary_5v = { [ use templates.Config-Reader-models-d.auxiliary_5v ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd auxiliary_5v 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
peripheral_5v = { [ use templates.Config-Reader-models-d.peripheral_5v ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd peripheral_5v 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
peripheral_5v_precharge = { [ use templates.Config-Reader-models-d.peripheral_5v_precharge ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd peripheral_5v_precharge 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
peripheral_12v = { [ use templates.Config-Reader-models-d.peripheral_12v ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd peripheral_12v 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
peripheral_12v_precharge = { [ use templates.Config-Reader-models-d.peripheral_12v_precharge ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd peripheral_12v_precharge 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
system_3v = { [ use templates.Config-Reader-models-d.system_3v ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd system_3v 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
system_3v_precharge = { [ use templates.Config-Reader-models-d.system_3v_precharge ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd system_3v_precharge 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
system_5v = { [ use templates.Config-Reader-models-d.system_5v ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd system_5v 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
system_5v_precharge = { [ use templates.Config-Reader-models-d.system_5v_precharge ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd system_5v_precharge 0 fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
keyswitch = { [ use templates.Config-Reader-models-d.keyswitch ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd keyswitch 0 position
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
peripheral_PS = { [ use templates.Config-Reader-models-d.peripheral_PS ]
peripheral_PSTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd peripheral_PS 1 fru hpu status unit#
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
power_supply = { [ use templates.Config-Reader-models-d.power_supply ]
power_supplyTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd power_supply 1 fru hpu status unit#
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
rack_fan = { [ use templates.Config-Reader-models-d.rack_fan ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd rack_fan 0 status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

disk_fan = { [ use templates.Config-Reader-models-d.disk_fan ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd disk_fan 0 hpu status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
remote_console = { [ use templates.Config-Reader-models-d.remote_console ]
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd remote_console 0 status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
fhc = { [ use templates.Config-Reader-models-d.fhc ]
fhcTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd fhc 1 board# model reg upa-mid version#
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
ac = { [ use templates.Config-Reader-models-d.ac ]
acTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd ac 1 bank-0-status bank-1-status device_type model pv_ancestor_alarm reg version#
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
environment = { [ use templates.Config-Reader-models-d.environment ]
environmentTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd environment 1 reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
environ = { [ use templates.Config-Reader-models-d.environ ]
environTbl = { 
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd environ 1 instance reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}
}

flashprom = { [ use templates.Config-Reader-models-d.flashprom ]
flashpromTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        initInterval    = 5
        refreshCommand  = configd flashprom 1 model reg 
	refreshFilter	= join
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
simmstat = { [ use templates.Config-Reader-models-d.simmstat ]
simmstatTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd simmstat 1 instance reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
simm-status = { [ use templates.Config-Reader-models-d.simm-status ]
simm-statusTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd simm-status 1 reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

simm-group = { [ use templates.Config-Reader-models-d.simm-group ]
simm-groupTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd simm-group 1 device_type group# size status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
sram = { [ use templates.Config-Reader-models-d.sram ]
sramTbl = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd sram 1 reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
#sbus = { [ use templates.Config-Reader-models-d.sbus ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sbus 1 clock-frequency board_num device_type model network_count reg upa-mid upa-portid version#
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-speed = { [ use templates.Config-Reader-models-d.sbus-speed ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sbus-speed 1 reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#ba = { [ use templates.Config-Reader-models-d.ba ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd ba 1 instance model reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#soc = { [ use templates.Config-Reader-models-d.soc ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd soc 1 device_type instance model port-wwns reg soc-fcode soc-wwn
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWsoc = { [ use templates.Config-Reader-models-d.SUNWsoc ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd SUNW,soc 1 device_type model port-wwns reg soc-fcode soc-wwN
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWsocmod = { [ use templates.Config-Reader-models-d.SUNWsocmod ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd SUNW,socmod 1 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWhme = { [ use templates.Config-Reader-models-d.SUNWhme ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd SUNW,hme 1 device_type ether inet dt_name  reg pathname_element symbol
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWfas = { [ use templates.Config-Reader-models-d.SUNWfas ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd SUNW,fas 1 device_type disk_count reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWpln = { [ use templates.Config-Reader-models-d.SUNWpln ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd SUNW,pln 1 device_type disk_count instance status unit_no
#        initInterval    = 5
#	refreshInterval	= 6000
#}

# This is commented since we can use the ssd model from the sena-models-d.x
#
#ssd = { [ use templates.Config-Reader-models-d.ssd ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd ssd 1 device_type fru instance mounted_partitions disk_name
#        initInterval    = 5
#	refreshInterval	= 6000
#}

#fas = { [ use templates.Config-Reader-models-d.fas ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd fas 1 device_type disk_count instance reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#cdrom0 = { [ use templates.Config-Reader-models-d.cdrom0 ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd cdrom0 1 device_type fru  instance mounted_partitions name 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#hme = { [ use templates.Config-Reader-models-d.hme ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd hme 1 device_type ether inet instance pathname_element symbol
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#QLGCisp = { [ use templates.Config-Reader-models-d.QLGCisp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd QLGC,isp 1 device_type disk_count model reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#isp = { [ use templates.Config-Reader-models-d.isp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd isp 1 device_type disk_count instance model reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#st = { [ use templates.Config-Reader-models-d.st ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd st 1 device_type fru model tape_name status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
led = { [ use templates.Config-Reader-models-d.led ]
ledTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd led 1 led-num state
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
central = { [ use templates.Config-Reader-models-d.central ]
centralTbl    = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd central 1 reg upa-mid
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
eeprom = { [ use templates.Config-Reader-models-d.eeprom ]
eepromTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd eeprom 1 model reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
sysctrl = { [ use templates.Config-Reader-models-d.sysctrl ]
sysctrlTbl    = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd sysctrl 1 instance reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
#cgsix = { [ use templates.Config-Reader-models-d.cgsix ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd cgsix 1 device_type height model reg width
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#socal = { [ use templates.Config-Reader-models-d.socal ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd socal 1 device_type instance model reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sf = { [ use templates.Config-Reader-models-d.sf ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sf 1 device_type disk_count instance port-wwn reg slot-num 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#
fan = { [ use templates.Config-Reader-models-d.fan ]
fanTbl    = { 
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd fan 1 status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

#disk = { [ use templates.Config-Reader-models-d.disk ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd disk 1  scsi-target-id
#        initInterval    = 5
#	refreshInterval	= 6000
#}
memory = { [ use templates.Config-Reader-models-d.memory ]
memoryTbl    = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd memory 1 pathname_element
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
#audiocs = { [ use templates.Config-Reader-models-d.audiocs ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd audiocs 1 device_type instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#bpp = { [ use templates.Config-Reader-models-d.bpp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd bpp 1 instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#fd = { [ use templates.Config-Reader-models-d.fd ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd fd 1 device_type fru instance pathname_element status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-slot = { [ use templates.Config-Reader-models-d.sbus-slot ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sbus-slot 1 slot-num
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-board = { [ use templates.Config-Reader-models-d.sbus-board ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd sbus-board 1 board-num fru model state type
#        initInterval    = 5
#	refreshInterval	= 6000
#}
ffb = { [ use templates.Config-Reader-models-d.ffb ]
ffbTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd ffb 1 buffer device_type model pathname_element 
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

SUNWffb = { [ use templates.Config-Reader-models-d.SUNWffb ]
SUNWffbTbl = {
	type		= derived
	refreshService	= _services.Config-Reader4uShell
	refreshMode	= async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd SUNW,ffb 1 3DRAM DAC FBC_version board_type buffer device_type height model revision upa-portid width
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}
#pci = { [ use templates.Config-Reader-models-d.pci ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd pci 1 compatible0 device_type model reg upa-mid upa-portid version#
#        initInterval    = 5
#	refreshInterval	= 6000
#}
hardware-rules = { [ use templates.Config-Reader-models-d.hardware-rules ]
#	        type            = active
}

pfa-rules = { [ use templates.Config-Reader-models-d.pfa-rules ]
#	        type            = active
}

# sena information

sena = { [ use templates.sena-models-d.sena ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd sena 1  box_rev device_count instance loop_configuration_status machine name node-wwn platform  slot_count type virtual_node
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

front = { [ use templates.sena-models-d.front ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd front 1  instance
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
rear = { [ use templates.sena-models-d.rear ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd rear 1  instance
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

disk_backplane = { [ use templates.sena-models-d.disk_backplane ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd disk_backplane 1  byp_a_enabled byp_b_enabled status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

fan_tray = { [ use templates.sena-models-d.fan_tray ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd fan_tray 1  fan_fail speed status type
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
## This is commented . All the leds (including sena) will be reported in 
# one table.
#led = { [ use templates.sena-models-d.led ]
#        type            = derived
#        refreshMode     = sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configd led 1  led-num state
#        initInterval    = 5
#	 refreshInterval	= 6000
#}
#
front_slot = { [ use templates.sena-models-d.front_slot ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd front_slot 1  id loop_status slot-num status temperature temperature_status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
rear_slot = { [ use templates.sena-models-d.rear_slot ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd rear_slot 1  id loop_status slot-num status temperature temperature_status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

# This table would have the disks attached to sena

ssd = { [ use templates.sena-models-d.ssd ]
ssdTbl = {
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd ssd 1  device_type fru hard_address instance mounted_partitions name node-wwn parent port-wwn status alternate_instances alternate_names alternate_parents
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

sena_power_supply = { [ use templates.sena-models-d.sena_power_supply ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd sena_power_supply 1  AC_status  DC-current DC-voltage ps-instance status temperature_status type
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

interconnect = { [ use templates.sena-models-d.interconnect ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd interconnect 1  eprom_failure status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
ib = { [ use templates.sena-models-d.ib ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd ib 1  ib-instance loop loop0_fault loop1_fault status temperature_status 
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
gbic = { [ use templates.sena-models-d.gbic ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd gbic 1  gbic-instance status xmit_fail
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
io_controller = { [ use templates.Config-Reader-models-d.io_controller ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd io_controller 1 board# clock-frequency device_type instance model reg  upa-mid upa-portid version#
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000

 }

io_device = { [ use templates.Config-Reader-models-d.io_device ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd io_device 1 device_type disk_count instance model node_hierarchy network_count reg tape_count
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}
disk = { [ use templates.Config-Reader-models-d.disk ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd disk 1 device_type name fru instance node_hierarchy target
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}

tape = { [ use templates.Config-Reader-models-d.tape ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd tape 1 device_type fru instance model node_hierarchy name status target
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}

network = { [ use templates.Config-Reader-models-d.network ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd network 1 device_type ether inet name node_hierarchy symbol reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}

io-unit = { [ use templates.Config-Reader-models-d.io-unit ]
        type            = derived
	refreshService	= _services.Config-Reader4uShell
        refreshMode     = async
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configd io-unit 1 board# device-id instance reg
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
        refreshInterval = 6000
}

