/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.IOException;
import java.io.OutputStream;
import palm.conduit.Log;

class ConduitStream
extends OutputStream {
    boolean isErrStream;
    byte[] buff = new byte[1024];
    int index = 0;

    ConduitStream(boolean isErr) {
        this.isErrStream = isErr;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
        if (this.index > 0) {
            String s = new String(this.buff, 0, this.index);
            this.index = 0;
            if (this.isErrStream) {
                Log.AddEntry(s, 22, false);
            } else {
                Log.AddEntry(s, -1, false);
            }
        }
    }

    public void write(int b) throws IOException {
        char c = (char)b;
        if (c == '\n') {
            this.flush();
        } else {
            if (this.index > 1023) {
                this.flush();
            }
            this.buff[this.index++] = (byte)c;
        }
    }

    public void write(byte[] b) throws IOException {
        int i = 0;
        while (i < b.length) {
            this.write(b[i]);
            ++i;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int i = off;
        while (i - off < len) {
            this.write(b[i]);
            ++i;
        }
    }
}

