/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncConstants;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncException;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncProperties;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncRecord;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncUtils;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Classification;
import sunw.jdt.cal.csa.Reminder;
import sunw.jdt.cal.csa.Repeat;

public class CalendarSyncWriter {
    FileOutputStream out;
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public Vector localAppts = new Vector();
    public Vector updateVectorList = new Vector();
    public static String calName = null;
    public static String hostName = null;
    public static String userName = System.getProperty("user.name");
    public static Calendar cal = null;
    public Date lastSyncDate;
    public int calDataVersion = 0;
    public int calServerVersion = 0;
    private CalendarSyncProperties calProps;
    private CalendarSyncException cse;

    public CalendarSyncWriter(CalendarSyncProperties calSyncProps) throws CalendarSyncException {
        this.calProps = calSyncProps;
        try {
            CalendarSyncUtils.doDebug("In CalendarSyncWriter()\n");
            CalendarSyncUtils.doDebug("calLocation is " + this.calProps.calLocation);
            try {
                StringTokenizer st = new StringTokenizer(this.calProps.calLocation, "@", false);
                calName = st.nextToken();
                hostName = st.nextToken();
            }
            catch (Throwable throwable) {
                this.cse = new CalendarSyncException(4120);
                CalendarSyncUtils.doLog("  ---> " + this.calProps.calLocation + " <---");
                throw this.cse;
            }
            CalendarSyncUtils.doDebug("calName is " + calName);
            CalendarSyncUtils.doDebug("hostName is " + hostName);
            cal = new Calendar(calName, hostName, new AuthUser(userName));
            this.calDataVersion = cal.getDataVersion();
            this.calServerVersion = cal.getServerVersion();
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4100, e);
            throw this.cse;
        }
    }

    private Date calculateEndDate(Appointment dtAppt, int nExceptions) throws CalendarSyncException {
        Date ed = null;
        Date sd = dtAppt.getStartDate();
        Repeat dtRepeat = dtAppt.getRepeat();
        int ntimes = 0;
        int rType = 0;
        if (dtRepeat.repeats()) {
            ed = dtAppt.getApptEndDate();
            if (ed != null) {
                return ed;
            }
            try {
                ntimes = dtRepeat.getTimes();
                rType = dtRepeat.getType();
                if (cal.getServerVersion() < 6 && (rType < 10 || rType > 12)) {
                    ntimes += nExceptions;
                }
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4103, e);
                throw this.cse;
            }
        }
        java.util.Calendar gc = java.util.Calendar.getInstance();
        gc.setTime(sd);
        switch (rType) {
            case 1: 
            case 7: {
                if (dtRepeat.getType() == 7) {
                    try {
                        ntimes *= dtRepeat.getFrequency();
                    }
                    catch (CalendarException e) {
                        this.cse = new CalendarSyncException(4102, e);
                        throw this.cse;
                    }
                }
                long stime = sd.getTime();
                long etime = (long)((double)stime + 8.64E7 * (double)(--ntimes));
                ed = new Date();
                ed.setTime(etime);
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                if (dtRepeat.getType() == 8) {
                    try {
                        ntimes *= dtRepeat.getFrequency();
                    }
                    catch (CalendarException e) {
                        this.cse = new CalendarSyncException(4102, e);
                        throw this.cse;
                    }
                }
                long stime = sd.getTime();
                long etime = (long)((double)stime + 6.048E8 * (double)(--ntimes));
                ed = new Date();
                ed.setTime(etime);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                ed = dtAppt.getApptEndDate();
                if (ed != null) break;
                long stime = sd.getTime();
                int wday = gc.get(7);
                long etime = (stime -= (long)((double)(wday - 1) * 8.64E7)) + (long)(8.64E7 * (double)(ntimes * 7 - 1));
                ed = new Date();
                ed.setTime(etime);
                break;
            }
            case 3: {
                long stime = sd.getTime();
                long etime = (long)((double)stime + 6.048E8 * (double)(--ntimes) * 2.0);
                ed = new Date();
                ed.setTime(etime);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                int yr = gc.get(1);
                int mo = gc.get(2);
                if (dtRepeat.getType() == 9) {
                    try {
                        ntimes *= dtRepeat.getFrequency();
                    }
                    catch (CalendarException e) {
                        this.cse = new CalendarSyncException(4102, e);
                        throw this.cse;
                    }
                }
                if (--ntimes > 0) {
                    if ((mo += ntimes % 12) >= 12) {
                        mo -= 12;
                        yr += ntimes / 12 + 1;
                    } else {
                        yr += ntimes / 12;
                    }
                }
                gc.set(1, yr);
                gc.set(2, mo);
                if (dtRepeat.getType() == 4) {
                    if (mo == 1 && (yr % 4 == 0 && yr % 100 != 0 || yr % 400 == 0)) {
                        gc.set(5, 29);
                    } else {
                        gc.set(5, daysInMonth[mo]);
                    }
                }
                ed = gc.getTime();
                break;
            }
            case 6: {
                int yr = gc.get(1);
                gc.set(1, yr += --ntimes);
                ed = gc.getTime();
                break;
            }
        }
        return ed;
    }

    public int calculateNtimes(Date sd, Date ed, CalendarSyncRecord record, int art) {
        CalendarSyncUtils.doDebug("In calculateNtimes()");
        long ntimes = 0L;
        java.util.Calendar calStart = java.util.Calendar.getInstance();
        java.util.Calendar calEnd = java.util.Calendar.getInstance();
        calStart.setTime(sd);
        calStart.set(13, 0);
        calStart.set(14, 0);
        calEnd.setTime(ed);
        calEnd.set(11, 23);
        calEnd.set(12, 59);
        calEnd.set(13, 59);
        calEnd.set(14, 0);
        sd = calStart.getTime();
        ed = calEnd.getTime();
        long sdt = sd.getTime();
        long edt = ed.getTime();
        sdt = (long)((double)sdt / 1000.0);
        edt = (long)((double)edt / 1000.0);
        int syr = calStart.get(1);
        int eyr = calEnd.get(1);
        int smo = calStart.get(2);
        int emo = calEnd.get(2);
        int sda = calStart.get(5);
        int eda = calEnd.get(5);
        int sdw = calStart.get(7);
        switch (record.getRepeatType()) {
            case 0: {
                ntimes = 1L;
                break;
            }
            case 1: {
                ntimes = (long)(((double)edt - (double)sdt) / 86400.0 + 1.0);
                break;
            }
            case 2: {
                ntimes = (long)((double)(edt - sdt) / 604800.0 + 1.0);
                break;
            }
            case 3: {
                int edw = calEnd.get(7);
                int swmo = calStart.get(4);
                int ewmo = calEnd.get(4);
                ntimes = (eyr - syr + 1) * 12 - (smo - 1) - (12 - emo);
                if (record.getRepeatOnWeek() == 4) {
                    if (eda + 7 > daysInMonth[emo] && sdw >= edw) break;
                    --ntimes;
                    break;
                }
                if (swmo <= ewmo && (swmo != ewmo || sdw <= edw)) break;
                --ntimes;
                break;
            }
            case 4: {
                ntimes = (eyr - syr + 1) * 12 - (smo - 1) - (12 - emo);
                if (sda <= eda) break;
                --ntimes;
                break;
            }
            case 5: 
            case 6: {
                ntimes = eyr - syr + 1;
                if ((ntimes == 0L || smo <= emo) && (smo != emo || sda <= eda)) break;
                --ntimes;
                break;
            }
            default: {
                ntimes = 1L;
            }
        }
        if (record.getRepeatFrequency() > 1 && art != 11 && art != 10 && art != 12) {
            ntimes = (long)(ntimes % (long)record.getRepeatFrequency() == 0L ? 0 : 1) + ntimes / (long)record.getRepeatFrequency();
        }
        return (int)ntimes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createNote(CalendarSyncRecord record, Appointment dtAppt) throws IOException {
        int endIndex;
        int beginIndex;
        String summary;
        String note = null;
        CalendarSyncUtils.doDebug("In createNote()");
        note = record.getNote();
        if (note == null || (summary = dtAppt.getSummary()) == null || (beginIndex = summary.indexOf("\n<*** ")) == -1 || (endIndex = summary.indexOf(" ***>")) == -1) return;
        String noteSpec = summary.substring(beginIndex + 6, endIndex);
        CalendarSyncUtils.doDebug("noteFile: " + noteSpec);
        File noteDir = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + SyncConstants.SEPARATOR + "notes");
        FileOutputStream fos = null;
        if (!noteDir.exists()) {
            CalendarSyncUtils.doDebug("Creating notes directory");
            noteDir.mkdirs();
        }
        try {
            try {
                fos = new FileOutputStream(noteSpec);
                fos.write(note.getBytes(), 0, note.length());
            }
            catch (IOException iOException) {
                this.cse = new CalendarSyncException(4114);
                throw this.cse;
            }
            Object var11_10 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    private void doNotePathDescr(CalendarSyncRecord record, Appointment dtAppt) throws CalendarSyncException {
        String recNote = record.getNote();
        String rDescr = record.getDescription();
        CalendarSyncUtils.doDebug("In doNotePathDescr()\n");
        try {
            if (recNote != null) {
                CalendarSyncUtils.doDebug("Record has note.\n");
                rDescr = String.valueOf(rDescr) + "\n<*** " + CalendarSyncConstants.CALENDAR_DIR_PATH + SyncConstants.SEPARATOR + "notes" + SyncConstants.SEPARATOR + record.getId() + ".txt ***>";
                CalendarSyncUtils.doDebug("description: " + rDescr);
            } else {
                CalendarSyncUtils.doDebug("Record has no note.\n");
            }
            dtAppt.setSummary(rDescr);
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4106, e);
            throw this.cse;
        }
    }

    public Appointment getApptById(int id) {
        Appointment dtAppt = null;
        if (this.localAppts != null && this.localAppts.size() > 0) {
            int i = 0;
            while (i < this.localAppts.size()) {
                dtAppt = (Appointment)this.localAppts.elementAt(i);
                if (dtAppt.getIdentifier() == id) {
                    return dtAppt;
                }
                ++i;
            }
        }
        return null;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    private CalendarSyncRecord getRecordById(Vector records, int id) {
        CalendarSyncRecord rec = null;
        int i = 0;
        while (i < records.size()) {
            rec = (CalendarSyncRecord)((Object)records.elementAt(i));
            if (rec.getId() == id) {
                return rec;
            }
            ++i;
        }
        return rec;
    }

    public Appointment populateDtAppt(CalendarSyncRecord record, Appointment dtAppt) throws CalendarSyncException {
        CalendarSyncUtils.doDebug("In populateDtAppt()");
        Reminder r = null;
        int seconds = 0;
        java.util.Calendar gc = java.util.Calendar.getInstance();
        Date ed = null;
        Date sd = null;
        Date osd = null;
        try {
            osd = record.getStartDate();
            if (osd.before(CalendarSyncConstants.theEpoch)) {
                this.cse = new CalendarSyncException(4119);
                CalendarSyncUtils.doLog(this.cse.getMessage());
                CalendarSyncUtils.doLog(record.toString());
                gc.setTime(osd);
                gc.set(1, 1970);
                osd = gc.getTime();
            }
            gc.setTime(osd);
            gc.set(13, 0);
            gc.set(14, 0);
            sd = gc.getTime();
            ed = record.getEndDate();
            if (ed.before(CalendarSyncConstants.theEpoch)) {
                gc.setTime(ed);
                gc.set(1, 1970);
                ed = gc.getTime();
            }
            gc.setTime(ed);
            gc.set(13, 0);
            gc.set(14, 0);
            ed = gc.getTime();
            if (dtAppt == null) {
                dtAppt = new Appointment(sd, ed);
            } else {
                dtAppt.setStartAndEndDate(sd, ed);
            }
        }
        catch (CalendarException e) {
            if (ed != null && ed.before(sd)) {
                gc.add(5, 1);
                ed = gc.getTime();
                try {
                    if (dtAppt == null) {
                        dtAppt = new Appointment(sd, ed);
                    } else {
                        dtAppt.setStartAndEndDate(sd, ed);
                    }
                }
                catch (CalendarException calendarException) {
                    this.cse = new CalendarSyncException(4104, e);
                    throw this.cse;
                }
            }
            this.cse = new CalendarSyncException(4104, e);
            throw this.cse;
        }
        if (record.getIsAlarmed()) {
            int aau = record.getAlarmAdvanceUnit();
            int aat = record.getAlarmAdvanceTime();
            if (aau == 0) {
                seconds = aat * 60;
            } else if (aau == 1) {
                seconds = aat * 60 * 60;
            } else if (aau == 2) {
                seconds = aat * 60 * 60 * 24;
            }
        }
        try {
            r = dtAppt.getReminder();
            if (r != null) {
                dtAppt.setReminder(null);
            }
            if (seconds != 0) {
                r = new Reminder(seconds);
                dtAppt.setReminder(r);
            }
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4105, e);
            throw this.cse;
        }
        this.doNotePathDescr(record, dtAppt);
        try {
            dtAppt.setShowTime(record.getIsUntimed() ^ true);
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4107, e);
            throw this.cse;
        }
        int art = 0;
        switch (record.getRepeatType()) {
            case 0: {
                art = 0;
                break;
            }
            case 1: {
                if (record.getRepeatFrequency() == 1) {
                    art = 1;
                    break;
                }
                art = 7;
                break;
            }
            case 2: {
                int[] days = record.getRepeatOn();
                if (days.length == 2) {
                    if (days[0] != 2 || days[1] != 4) break;
                    art = 12;
                    break;
                }
                if (days.length == 3) {
                    if (days[0] != 1 || days[1] != 3 || days[2] != 5) break;
                    art = 11;
                    break;
                }
                if (days.length == 5) {
                    if (days[0] != 1 || days[1] != 2 || days[2] != 3 || days[3] != 4 || days[4] != 5) break;
                    art = 10;
                    break;
                }
                if (record.getRepeatFrequency() == 1) {
                    art = 2;
                    break;
                }
                if (record.getRepeatFrequency() == 2) {
                    art = 3;
                    break;
                }
                art = 8;
                break;
            }
            case 3: {
                art = 4;
                break;
            }
            case 4: {
                if (record.getRepeatFrequency() == 1) {
                    art = 5;
                    break;
                }
                art = 9;
                break;
            }
            case 5: {
                art = 6;
                break;
            }
            default: {
                art = 0;
            }
        }
        Repeat repeat = null;
        if (art != 0) {
            ed = record.getRepeatEndDate();
            if (ed == null) {
                try {
                    repeat = new Repeat(art, 0);
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4108, e);
                    throw this.cse;
                }
            }
            sd = osd;
            int ntimes = this.calculateNtimes(sd, ed, record, art);
            try {
                repeat = new Repeat(art, ntimes);
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4108, e);
                throw this.cse;
            }
            Vector dateExceptions = record.getDateExceptions();
            int de = dateExceptions.size();
            java.util.Calendar ocal = java.util.Calendar.getInstance();
            java.util.Calendar ecal = java.util.Calendar.getInstance();
            ocal.setTime(osd);
            int ohr = ocal.get(11);
            int omin = ocal.get(12);
            int osec = ocal.get(13);
            int omsec = ocal.get(14);
            if (de > 0) {
                Date[] exceptionArray = new Date[de];
                int i = 0;
                while (i < de) {
                    ecal.setTime((Date)dateExceptions.elementAt(i));
                    ecal.set(11, ohr);
                    ecal.set(12, omin);
                    ecal.set(13, osec);
                    ecal.set(14, omsec);
                    exceptionArray[i] = ecal.getTime();
                    ++i;
                }
                try {
                    dtAppt.setExceptionDates(exceptionArray);
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4118, e);
                    throw this.cse;
                }
            }
        } else {
            try {
                repeat = new Repeat(art, 1);
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4108, e);
                throw this.cse;
            }
        }
        repeat.setFrequency(record.getRepeatFrequency());
        if (record.getRepeatType() == 3 && record.getRepeatOnWeek() == 4) {
            try {
                repeat.setLastWeek(true);
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4109, e);
                throw this.cse;
            }
        }
        try {
            dtAppt.setRepeat(repeat);
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4108, e);
            throw this.cse;
        }
        int privacy = 1;
        privacy = record.isPrivate() ? (this.calProps.privacyShowTime ? 2 : 1) : 0;
        try {
            dtAppt.setClassification(new Classification(privacy));
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4110, e);
            throw this.cse;
        }
        return dtAppt;
    }

    private void populateHHRecord(Appointment dtAppt, CalendarSyncRecord record) throws CalendarSyncException {
        int endIndex;
        int[] daysRepeat = null;
        if (!dtAppt.getShowTime()) {
            record.setIsUntimed(true);
        }
        Date sDate = dtAppt.getStartDate();
        record.setStartDate(sDate);
        Date eDate = dtAppt.getEndDate();
        if (eDate == null) {
            eDate = sDate;
        }
        record.setEndDate(eDate);
        Reminder dtReminder = dtAppt.getReminder();
        if (dtReminder != null) {
            record.setIsAlarmed(true);
            int dtLeadTime = dtReminder.getLeadTime();
            if (dtLeadTime % 86400 == 0) {
                record.setAlarmAdvanceTime(dtLeadTime / 86400);
                record.setAlarmAdvanceUnit(2);
            } else if (dtLeadTime % 3600 == 0) {
                record.setAlarmAdvanceTime(dtLeadTime / 3600);
                record.setAlarmAdvanceUnit(1);
            } else {
                record.setAlarmAdvanceTime(dtLeadTime / 60);
                record.setAlarmAdvanceUnit(0);
            }
        }
        Repeat dtRepeat = dtAppt.getRepeat();
        record.setIsRepeating(dtRepeat.repeats());
        switch (dtRepeat.getType()) {
            case 0: {
                record.setRepeatType(0);
                record.setRepeatFrequency(0);
                break;
            }
            case 1: {
                record.setRepeatType(1);
                break;
            }
            case 2: 
            case 13: {
                record.setRepeatType(2);
                java.util.Calendar tcal = java.util.Calendar.getInstance();
                tcal.setTime(sDate);
                daysRepeat = new int[]{tcal.get(7) - 1};
                record.setRepeatOn(daysRepeat);
                break;
            }
            case 3: {
                record.setRepeatType(2);
                try {
                    record.setRepeatFrequency(dtRepeat.getFrequency());
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4102, e);
                    throw this.cse;
                }
                java.util.Calendar tcal = java.util.Calendar.getInstance();
                tcal.setTime(sDate);
                daysRepeat = new int[]{tcal.get(7) - 1};
                record.setRepeatOn(daysRepeat);
                break;
            }
            case 4: {
                record.setRepeatType(3);
                java.util.Calendar tcal = java.util.Calendar.getInstance();
                tcal.setTime(sDate);
                record.setRepeatOnDay(tcal.get(7) - 1);
                if (dtRepeat.lastWeek()) {
                    record.setRepeatOnWeek(4);
                    break;
                }
                int weekNum = tcal.get(4);
                tcal = java.util.Calendar.getInstance();
                tcal.setTime(sDate);
                int dayOfMonth = tcal.get(5);
                if (dayOfMonth - (weekNum - 1) * 7 <= 0) {
                    --weekNum;
                }
                record.setRepeatOnWeek(--weekNum);
                break;
            }
            case 5: {
                record.setRepeatType(4);
                break;
            }
            case 6: {
                record.setRepeatType(5);
                break;
            }
            case 7: {
                record.setRepeatType(1);
                try {
                    record.setRepeatFrequency(dtRepeat.getFrequency());
                    break;
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4102, e);
                    throw this.cse;
                }
            }
            case 8: {
                record.setRepeatType(2);
                try {
                    record.setRepeatFrequency(dtRepeat.getFrequency());
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4102, e);
                    throw this.cse;
                }
                java.util.Calendar tcal = java.util.Calendar.getInstance();
                tcal.setTime(sDate);
                daysRepeat = new int[]{tcal.get(7) - 1};
                record.setRepeatOn(daysRepeat);
                break;
            }
            case 9: {
                record.setRepeatType(4);
                try {
                    record.setRepeatFrequency(dtRepeat.getFrequency());
                    break;
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4102, e);
                    throw this.cse;
                }
            }
            case 10: {
                record.setRepeatType(2);
                daysRepeat = new int[5];
                int i = 0;
                while (i < 5) {
                    daysRepeat[i] = i + 1;
                    ++i;
                }
                record.setRepeatOn(daysRepeat);
                break;
            }
            case 11: {
                record.setRepeatType(2);
                daysRepeat = new int[]{1, 3, 5};
                record.setRepeatOn(daysRepeat);
                break;
            }
            case 12: {
                record.setRepeatType(2);
                daysRepeat = new int[]{2, 4};
                record.setRepeatOn(daysRepeat);
                break;
            }
        }
        if (dtRepeat.repeats()) {
            Vector dateExceptions = dtAppt.getExceptionDates();
            int vSize = 0;
            if (dateExceptions != null) {
                record.setDateExceptions(dateExceptions);
                vSize = dateExceptions.size();
            }
            try {
                if (dtRepeat.getTimes() == 0) {
                    record.setRepeatEndDate(null);
                } else {
                    record.setRepeatEndDate(this.calculateEndDate(dtAppt, vSize));
                }
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4103, e);
                throw this.cse;
            }
            catch (CalendarSyncException cse) {
                throw cse;
            }
        }
        if (dtAppt.getClassification().getValue() == 0) {
            record.setIsPrivate(false);
        } else {
            record.setIsPrivate(true);
        }
        String summary = dtAppt.getSummary();
        int beginIndex = summary.indexOf("\n<*** ");
        if (beginIndex != -1 && (endIndex = summary.indexOf(" ***>")) != -1) {
            String string = summary.substring(0, beginIndex);
            record.setDescription(string);
            String noteFile = summary.substring(beginIndex + 6, endIndex);
            CalendarSyncUtils.doDebug("noteFile: " + noteFile);
            CalendarSyncUtils.doDebug("Description: " + string);
            try {
                string = this.readNoteFile(noteFile);
            }
            catch (IOException iOException) {
                this.cse = new CalendarSyncException(4113);
                throw this.cse;
            }
            if (string != null) {
                CalendarSyncUtils.doDebug("setting Note: " + string);
            } else {
                CalendarSyncUtils.doDebug("setting note to null");
                record.setIsModified(true);
            }
            record.setNote(string);
        } else {
            record.setDescription(summary);
        }
        record.setApptId(dtAppt.getIdentifier());
    }

    public Vector readBackupFromDt(String backupFilePath) throws IOException {
        CalendarSyncUtils.doDebug("In readBackupFromDt()");
        File backupFile = null;
        DataInputStream in = null;
        String buFname = null;
        Vector<CalendarSyncRecord> buRecords = new Vector<CalendarSyncRecord>();
        buFname = String.valueOf(new String(backupFilePath)) + SyncConstants.SEPARATOR + "backup." + calName + "." + hostName + "." + this.calServerVersion;
        backupFile = new File(buFname);
        if (backupFile.exists() && backupFile.length() > 0L) {
            in = new DataInputStream(new FileInputStream(buFname));
            buFname = null;
            CalendarSyncRecord buRecord = new CalendarSyncRecord();
            this.lastSyncDate = buRecord.readBUDate(in);
            CalendarSyncUtils.doDebug("LastSyncDate is  " + this.lastSyncDate);
            try {
                try {
                    while (true) {
                        buRecord = new CalendarSyncRecord();
                        buRecord.readBUData(in);
                        CalendarSyncUtils.doDebug("Appt ID is " + buRecord.getApptId());
                        CalendarSyncUtils.doDebug(buRecord.toFormattedString());
                        buRecords.addElement(buRecord);
                    }
                }
                catch (EOFException eOFException) {
                }
                catch (IOException iOException) {
                    this.cse = new CalendarSyncException(4111);
                    throw this.cse;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
        }
        if (backupFile.exists()) {
            backupFile.delete();
        }
        return buRecords;
    }

    public Vector readCbkFromDt(String cbkFilePath, Vector cbkRecords) throws IOException {
        block7: {
            block6: {
                CalendarSyncUtils.doDebug("In readCbkFromDt()");
                File cbkFile = null;
                DataInputStream in = null;
                Object cbkFname = null;
                cbkFile = new File(CalendarSyncConstants.CBKFNAME);
                if (!cbkFile.exists() || cbkFile.length() <= 0L) break block6;
                in = new DataInputStream(new FileInputStream(cbkFile));
                try {
                    try {
                        while (true) {
                            CalendarSyncRecord cbkRecord = new CalendarSyncRecord();
                            cbkRecord.readCbkData(in);
                            cbkRecords.addElement(cbkRecord);
                        }
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException iOException) {
                        this.cse = new CalendarSyncException(4115);
                        throw this.cse;
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                break block7;
            }
            cbkRecords = null;
        }
        return cbkRecords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readNoteFile(String nFile) throws IOException {
        File noteFile = new File(nFile);
        String string = null;
        FileInputStream in = null;
        CalendarSyncUtils.doDebug("In readNoteFile()");
        if (!noteFile.exists() || noteFile.length() <= 0L) return string;
        try {
            try {
                in = new FileInputStream(noteFile);
                int fileSize = (int)noteFile.length();
                byte[] fileBytes = new byte[fileSize];
                int bytesRead = in.read(fileBytes);
                in.close();
                string = new String(fileBytes, 0, fileBytes.length);
                CalendarSyncUtils.doDebug("Note File Contents:\n" + string);
            }
            catch (IOException iOException) {
                this.cse = new CalendarSyncException(4113);
                throw this.cse;
            }
            Object var6_8 = null;
            if (in == null) return string;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return string;
    }

    public Vector readRecordsFromDt(Date lookupRangeStartDate, Date lookupRangeEndDate) throws CalendarSyncException {
        CalendarSyncUtils.doDebug("In readRecordsFromDt()");
        Vector<CalendarSyncRecord> localRecords = new Vector<CalendarSyncRecord>();
        Appointment[] dtAppts = null;
        int i = 0;
        java.util.Calendar tcal = java.util.Calendar.getInstance();
        tcal.setTime(lookupRangeStartDate);
        long start = tcal.getTime().getTime();
        tcal.setTime(lookupRangeEndDate);
        long end = tcal.getTime().getTime();
        long stop = start + 2419200000L;
        if (stop > end) {
            stop = end;
        }
        try {
            Appointment localAppt;
            Date startDate = new Date(start);
            Date stopDate = new Date(stop);
            while (stop <= end) {
                dtAppts = cal.lookupAppointments(startDate, stopDate);
                while (dtAppts != null && dtAppts.length != 0 && i < dtAppts.length) {
                    this.localAppts.addElement(dtAppts[i]);
                    ++i;
                }
                i = 0;
                if (stop == end) break;
                start = stop + 1L;
                if ((stop = start + 2419200000L) > end) {
                    stop = end;
                }
                startDate.setTime(start);
                stopDate.setTime(stop);
            }
            i = 0;
            while (i < this.localAppts.size()) {
                localAppt = (Appointment)this.localAppts.elementAt(i);
                if (localAppt.getRepeat().repeats()) {
                    int id = localAppt.getIdentifier();
                    if ((localAppt = cal.lookupApptById(id)) != null) {
                        this.localAppts.insertElementAt(localAppt, i);
                    }
                    int j = i + 1;
                    while (j < this.localAppts.size()) {
                        localAppt = (Appointment)this.localAppts.elementAt(j);
                        if (localAppt.getIdentifier() == id) {
                            this.localAppts.removeElementAt(j);
                            continue;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.localAppts.trimToSize();
            i = 0;
            while (!this.localAppts.isEmpty() && i < this.localAppts.size()) {
                CalendarSyncRecord localRecord = new CalendarSyncRecord();
                localAppt = (Appointment)this.localAppts.elementAt(i);
                try {
                    this.populateHHRecord(localAppt, localRecord);
                    localRecords.addElement(localRecord);
                    ++i;
                }
                catch (CalendarSyncException cse) {
                    CalendarSyncUtils.doLog(cse.getMessage());
                }
            }
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4101, e);
            throw this.cse;
        }
        localRecords.trimToSize();
        return localRecords;
    }

    public void removeBackupFiles(String keepFile) throws IOException {
        File file = new File(CalendarSyncConstants.CALENDAR_DIR_PATH);
        if (file.exists()) {
            String[] filename = file.list();
            int i = 0;
            while (i < filename.length) {
                if (filename[i].startsWith("backup.") && (keepFile == null || filename[i].compareTo(keepFile) != 0)) {
                    file = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + SyncConstants.SEPARATOR + filename[i]);
                    if (file.isFile()) {
                        file.delete();
                    }
                    file = null;
                }
                ++i;
            }
            Object var3_3 = null;
        }
    }

    public void removeNote(Appointment dtAppt) {
        int endIndex;
        int beginIndex;
        String summary = dtAppt.getSummary();
        CalendarSyncUtils.doDebug("In removeNote()");
        if (summary != null && (beginIndex = summary.indexOf("\n<*** ")) != -1 && (endIndex = summary.indexOf(" ***>")) != -1) {
            String nFile = summary.substring(beginIndex + 6, endIndex);
            File noteFile = new File(nFile);
            CalendarSyncUtils.doDebug("noteFile: " + nFile);
            if (noteFile.exists()) {
                CalendarSyncUtils.doDebug("Deleting Note file.");
                noteFile.delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateNote(CalendarSyncRecord record, String oldNote, Appointment dtAppt) throws IOException {
        File noteFile;
        String note = null;
        CalendarSyncUtils.doDebug("In updateNote()");
        note = record.getNote();
        if (note != null) {
            int endIndex;
            int beginIndex;
            String summary = dtAppt.getSummary();
            if (summary == null || (beginIndex = summary.indexOf("\n<*** ")) == -1 || (endIndex = summary.indexOf(" ***>")) == -1 || oldNote != null && oldNote.compareTo(note) == 0) return;
            FileOutputStream fos = null;
            File noteFile2 = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + SyncConstants.SEPARATOR + "notes");
            if (oldNote == null && !noteFile2.exists()) {
                noteFile2.mkdirs();
            }
            CalendarSyncUtils.doDebug("Contents of note: " + note);
            String noteSpec = summary.substring(beginIndex + 6, endIndex);
            CalendarSyncUtils.doDebug("noteFile: " + noteSpec);
            try {
                try {
                    fos = new FileOutputStream(noteSpec);
                    fos.write(note.getBytes(), 0, note.length());
                }
                catch (IOException iOException) {
                    this.cse = new CalendarSyncException(4114);
                    throw this.cse;
                }
                Object var12_12 = null;
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        if (oldNote == null || !(noteFile = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + SyncConstants.SEPARATOR + "notes" + SyncConstants.SEPARATOR + record.getId() + ".txt")).exists()) return;
        noteFile.delete();
    }

    public void writeBackupToDt(String backupFilePath, Vector buRecords, Vector oldBuRecords, Vector saveDeletedRecs) throws IOException {
        CalendarSyncRecord buRecord;
        int j;
        int i;
        CalendarSyncUtils.doDebug("In writeBackupToDt()");
        DataOutputStream out = null;
        File buPath = new File(backupFilePath);
        if (!buPath.exists()) {
            buPath.mkdirs();
        }
        buRecords.trimToSize();
        if (buRecords.size() > 0 && oldBuRecords != null && oldBuRecords.size() > 0) {
            i = 0;
            while (i < oldBuRecords.size()) {
                CalendarSyncRecord oldBuRecord = (CalendarSyncRecord)((Object)oldBuRecords.elementAt(i));
                j = 0;
                while (j < buRecords.size()) {
                    buRecord = (CalendarSyncRecord)((Object)buRecords.elementAt(j));
                    if (buRecord.getId() == oldBuRecord.getId()) break;
                    ++j;
                }
                if (j == buRecords.size() && this.getRecordById(saveDeletedRecs, oldBuRecord.getId()) == null) {
                    buRecords.addElement(oldBuRecord);
                }
                ++i;
            }
        }
        out = new DataOutputStream(new FileOutputStream(String.valueOf(backupFilePath) + SyncConstants.SEPARATOR + "backup." + calName + "." + hostName + "." + this.calServerVersion));
        i = 0;
        while (i < buRecords.size()) {
            buRecord = (CalendarSyncRecord)((Object)buRecords.elementAt(i));
            if (i == 0) {
                this.lastSyncDate = new Date();
                ((CalendarSyncRecord)((Object)buRecords.elementAt(0))).writeBUDate(out, this.lastSyncDate);
                CalendarSyncUtils.doDebug("LastSyncDate is  " + this.lastSyncDate);
            }
            try {
                buRecord.writeBUData(out);
            }
            catch (IOException iOException) {
                this.cse = new CalendarSyncException(4112);
                throw this.cse;
            }
            CalendarSyncUtils.doDebug("Appt ID is " + buRecord.getApptId());
            CalendarSyncUtils.doDebug(buRecord.toFormattedString());
            ++i;
        }
        out.close();
        if (this.updateVectorList.size() > 0) {
            CalendarSyncUtils.doDebug("Updating appts that had notes spec removed");
            CalendarSyncRecord rec = null;
            Appointment dtAppt = null;
            i = 0;
            while (i < this.updateVectorList.size()) {
                rec = (CalendarSyncRecord)((Object)this.updateVectorList.elementAt(i));
                int id = rec.getApptId();
                j = 0;
                while (j < this.localAppts.size()) {
                    dtAppt = (Appointment)this.localAppts.elementAt(j);
                    if (id == dtAppt.getIdentifier()) {
                        CalendarSyncUtils.doDebug("Appt found");
                        break;
                    }
                    ++j;
                }
                if (j < this.localAppts.size()) {
                    String aSummary = dtAppt.getSummary();
                    CalendarSyncUtils.doDebug("Appt summary " + aSummary);
                    if (rec.getNote() != null && aSummary.indexOf("\n<*** ") == -1 && aSummary.indexOf(" ***>") == -1) {
                        CalendarSyncUtils.doDebug("updating appt");
                        CalendarSyncUtils.doDebug("Old Summary: " + aSummary);
                        aSummary = String.valueOf(aSummary) + "\n<*** " + CalendarSyncConstants.CALENDAR_DIR_PATH + SyncConstants.SEPARATOR + "notes" + SyncConstants.SEPARATOR + rec.getId() + ".txt ***>";
                        try {
                            dtAppt.setSummary(aSummary);
                        }
                        catch (CalendarException e) {
                            this.cse = new CalendarSyncException(4106, e);
                            throw this.cse;
                        }
                        CalendarSyncUtils.doDebug("New Summary: " + aSummary);
                        try {
                            cal.updateAppt(dtAppt);
                        }
                        catch (CalendarException e) {
                            this.cse = new CalendarSyncException(4099, e);
                            throw this.cse;
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCbkToDt(String cbkFilePath, String cbkFname, Vector cbkRecords) throws IOException {
        DataOutputStream out = null;
        if (cbkRecords == null || cbkRecords.size() == 0) {
            CalendarSyncUtils.doDebug("In writeCbkToDt(): No cbk file is written");
            return;
        }
        File cbkFile = new File(cbkFilePath);
        if (!cbkFile.exists()) {
            cbkFile.mkdirs();
        }
        String cbkFilePathName = String.valueOf(cbkFilePath) + SyncConstants.SEPARATOR + cbkFname;
        cbkFile = new File(cbkFilePathName);
        out = new DataOutputStream(new FileOutputStream(cbkFile));
        try {
            try {
                int i = 0;
                while (i < cbkRecords.size()) {
                    CalendarSyncRecord cbkRecord = (CalendarSyncRecord)((Object)cbkRecords.elementAt(i));
                    if (!cbkRecord.isDeleted()) {
                        cbkRecord.writeCbkData(out);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                this.cse = new CalendarSyncException(4116);
                throw this.cse;
            }
            Object var10_9 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (out == null) throw throwable;
            out.close();
            SyncUtils.setFilePermission((String)cbkFilePathName, (String)"600");
            throw throwable;
        }
        out.close();
        SyncUtils.setFilePermission((String)cbkFilePathName, (String)"600");
    }

    public void writeRecordsToDt(Vector hhrecords) throws IOException {
        int i;
        CalendarSyncUtils.doDebug("In writeRecordsToDt()");
        if (cal == null) {
            try {
                cal = new Calendar(calName, hostName, true);
            }
            catch (CalendarException e) {
                this.cse = new CalendarSyncException(4100, e);
                CalendarSyncUtils.doLog(this.cse.getMessage());
                throw this.cse;
            }
        }
        if (cal != null && this.localAppts.size() != 0) {
            CalendarSyncUtils.doDebug("localAppts.size is " + this.localAppts.size());
            i = 0;
            while (i < this.localAppts.size()) {
                try {
                    cal.deleteAppt((Appointment)this.localAppts.elementAt(i));
                    this.removeNote((Appointment)this.localAppts.elementAt(i));
                }
                catch (CalendarException e) {
                    this.cse = new CalendarSyncException(4098, e);
                    CalendarSyncUtils.doLog(this.cse.getMessage());
                }
                ++i;
            }
        }
        if (hhrecords != null) {
            hhrecords.trimToSize();
            i = 0;
            while (i < hhrecords.size()) {
                block13: {
                    Appointment dtAppt;
                    CalendarSyncRecord record = (CalendarSyncRecord)((Object)hhrecords.elementAt(i));
                    try {
                        dtAppt = this.populateDtAppt(record, null);
                    }
                    catch (CalendarSyncException cse) {
                        CalendarSyncUtils.doLog(cse.getMessage());
                        break block13;
                    }
                    try {
                        dtAppt = cal.insertAppt(dtAppt);
                        this.createNote(record, dtAppt);
                        record.setApptId(dtAppt.getIdentifier());
                    }
                    catch (CalendarException e) {
                        this.cse = new CalendarSyncException(4097, e);
                        dtAppt.print();
                        CalendarSyncUtils.doLog(this.cse.getMessage());
                    }
                }
                ++i;
            }
        }
    }
}

