/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncProperties;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CalendarSyncPropsUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle calRes;
    private static ResourceBundle calTips;
    private static ResourceBundle commonRes;
    protected JPanel calP;
    protected JTextField calLocation;
    protected JLabel calName;
    protected JLabel dateRange;
    protected JComboBox monthComboBox;
    protected JLabel monthLabel;
    protected JLabel dateRangeInfo;
    protected ButtonGroup privacyGrp;
    protected JLabel privacy;
    protected JRadioButton seeTime;
    protected JRadioButton seeNothing;
    protected ButtonGroup changesGroup;
    protected JLabel changes;
    protected JRadioButton dtCalModPda;
    protected JRadioButton pdaModDtCal;
    protected JRadioButton mergeAndDelDup;
    protected CalendarSyncProperties props;
    Document calLDoc;

    static {
        try {
            theLocale = Locale.getDefault();
            calRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CalendarSyncPropsUIMessages", theLocale);
            calTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CalendarSyncPropsUITips", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: CalSyncProperties can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public CalendarSyncPropsUI(JFrame parent, CalendarSyncProperties calSyncProps) {
        super(parent, calRes.getString("Configure Calendar Conduit"));
        this.props = calSyncProps;
        this.userProperties = calSyncProps;
        this.setDialogMessage(this.createPropsPanel());
        ((JDialog)((Object)this)).setContentPane(this.propsOptions);
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
    }

    private Object createPropsPanel() {
        HelpBroker helpBroker = null;
        this.calP = new JPanel(false);
        this.calP.setLayout(new GridBagLayout());
        int gbcGridy = 0;
        this.calName = new JLabel(calRes.getString("Calendar:"));
        this.calLocation = new JTextField(20);
        this.calLocation.setToolTipText(calTips.getString("Calendar - user@host"));
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.calName, (int)0, (int)gbcGridy, (int)1, (int)1, (int)0, (int)13, (Insets)new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.calLocation, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, (Insets)new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        this.dateRange = new JLabel(calRes.getString("Date Range:"));
        String[] monthOption = new String[]{" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
        this.monthComboBox = new JComboBox<String>(monthOption);
        this.monthComboBox.setMaximumRowCount(5);
        this.monthComboBox.setSelectedIndex(2);
        ActionListener monthChanged = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int month = cb.getSelectedIndex() + 1;
                String begin = CalendarSyncPropsUI.this.props.getNextMonth(-month);
                String end = CalendarSyncPropsUI.this.props.getNextMonth(month);
                CalendarSyncPropsUI.this.dateRangeInfo.setText("(" + begin + calRes.getString(" to ") + end + ")");
            }
        };
        this.monthComboBox.addActionListener(monthChanged);
        this.monthLabel = new JLabel(calRes.getString("months before and after today"));
        this.dateRangeInfo = new JLabel("(..." + calRes.getString(" to ") + "...)");
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.dateRange, (int)0, (int)gbcGridy, (int)1, (int)1, (int)0, (int)13, (Insets)new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.monthComboBox, (int)1, (int)gbcGridy, (int)1, (int)1, (int)0, (int)17, (Insets)new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.monthLabel, (int)2, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, (Insets)new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.dateRangeInfo, (int)0, (int)gbcGridy, (int)0, (int)1, (int)0, (int)10, (Insets)new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)new JSeparator(), (int)0, (int)gbcGridy, (int)0, (int)1, (int)2, (int)10, (Insets)new Insets(10, 0, 10, 0));
        }
        catch (AWTException aWTException) {}
        this.privacyGrp = new ButtonGroup();
        this.privacy = new JLabel(calRes.getString("For Private Appointments:"));
        this.seeTime = new JRadioButton(calRes.getString("Others see time only"));
        this.seeNothing = new JRadioButton(calRes.getString("Others see nothing"));
        this.privacyGrp.add(this.seeTime);
        this.privacyGrp.add(this.seeNothing);
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.privacy, (int)0, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.seeTime, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.seeNothing, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        this.changes = new JLabel(calRes.getString("Changes:"));
        this.mergeAndDelDup = new JRadioButton(calRes.getString("Synchronize the files"));
        this.pdaModDtCal = new JRadioButton(calRes.getString("PDA overwrites desktop"));
        this.dtCalModPda = new JRadioButton(calRes.getString("Desktop overwrites PDA"));
        this.changesGroup = new ButtonGroup();
        this.changesGroup.add(this.dtCalModPda);
        this.changesGroup.add(this.pdaModDtCal);
        this.changesGroup.add(this.mergeAndDelDup);
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)new JSeparator(), (int)0, (int)gbcGridy, (int)0, (int)1, (int)2, (int)10, (Insets)new Insets(10, 0, 10, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.changes, (int)0, (int)gbcGridy, (int)1, (int)1, (int)0, (int)13, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.mergeAndDelDup, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.dtCalModPda, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)this.pdaModDtCal, (int)1, (int)gbcGridy, (int)0, (int)1, (int)0, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)this.calP, (Component)new JSeparator(), (int)0, (int)gbcGridy, (int)0, (int)1, (int)2, (int)10, (Insets)new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        PropsUI.PropsUIChangeListener stateChangedListener = new PropsUI.PropsUIChangeListener((PropsUI)this);
        this.calLocation.getDocument().addDocumentListener((DocumentListener)stateChangedListener);
        this.calLDoc = this.calLocation.getDocument();
        this.monthComboBox.addItemListener((ItemListener)stateChangedListener);
        this.seeTime.addItemListener((ItemListener)stateChangedListener);
        this.seeNothing.addItemListener((ItemListener)stateChangedListener);
        this.dtCalModPda.addItemListener((ItemListener)stateChangedListener);
        this.pdaModDtCal.addItemListener((ItemListener)stateChangedListener);
        this.mergeAndDelDup.addItemListener((ItemListener)stateChangedListener);
        this.setDialogParameters();
        this.propsChanged = false;
        helpBroker = PDASyncHelp.enableContextHelp((Component)this.help, (String)"pda_calendarConfig");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
        return this.calP;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Calendar Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        CalendarSyncProperties calSyncProps = new CalendarSyncProperties();
        CalendarSyncPropsUI cprops = new CalendarSyncPropsUI(fr, calSyncProps);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((Dialog)((Object)CalendarSyncPropsUI.this)).show();
                ((Dialog)((Object)CalendarSyncPropsUI.this)).setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public void setDialogParameters() {
        if (this.props.calLocation != null) {
            this.calLocation.setText(this.props.calLocation);
        }
        this.monthComboBox.setSelectedIndex(this.props.windowSize - 1);
        String begin = this.props.getNextMonth(-this.props.windowSize);
        String end = this.props.getNextMonth(this.props.windowSize);
        this.dateRangeInfo.setText("(" + begin + calRes.getString(" to ") + end + ")");
        this.seeTime.setSelected(this.props.privacyShowTime);
        this.seeNothing.setSelected(this.props.privacyShowTime ^ true);
        if (this.props.syncBehavior.equals("merge")) {
            this.dtCalModPda.setSelected(false);
            this.pdaModDtCal.setSelected(false);
            this.mergeAndDelDup.setSelected(true);
        } else if (this.props.syncBehavior.equals("desktop")) {
            this.dtCalModPda.setSelected(true);
            this.pdaModDtCal.setSelected(false);
            this.mergeAndDelDup.setSelected(false);
        } else {
            this.dtCalModPda.setSelected(false);
            this.pdaModDtCal.setSelected(true);
            this.mergeAndDelDup.setSelected(false);
        }
    }

    public void updateFromUI() {
        this.props.calLocation = this.calLocation.getText();
        this.props.windowSize = this.monthComboBox.getSelectedIndex() + 1;
        this.props.privacyShowTime = this.seeTime.isSelected();
        if (this.dtCalModPda.isSelected()) {
            this.props.syncBehavior = new String("desktop");
        } else if (this.pdaModDtCal.isSelected()) {
            this.props.syncBehavior = new String("pda");
        } else if (this.mergeAndDelDup.isSelected()) {
            this.props.syncBehavior = new String("merge");
        }
    }
}

