/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import palm.conduit.SyncException;
import sunw.jdt.cal.csa.CalendarException;

public class CalendarSyncException
extends IOException {
    public SyncException syncErr;
    public CalendarException calErr;
    public int errorCode;
    public static final int NONE = 0;
    public static final int FIRST = 4096;
    public static final int ERR_INSERT_APPT = 4097;
    public static final int ERR_DELETE_APPT = 4098;
    public static final int ERR_UPDATE_APPT = 4099;
    public static final int ERR_ACCESS_CAL = 4100;
    public static final int ERR_LOOKUP_CAL = 4101;
    public static final int ERR_GET_APPTFREQ = 4102;
    public static final int ERR_GET_APPTNTIMES = 4103;
    public static final int ERR_CREATE_APPT = 4104;
    public static final int ERR_SET_APPTREMINDER = 4105;
    public static final int ERR_SET_APPTSUMMARY = 4106;
    public static final int ERR_SET_APPTSHOWTM = 4107;
    public static final int ERR_CREATE_REPEAT = 4108;
    public static final int ERR_SET_LASTWK = 4109;
    public static final int ERR_CREATE_CLASSN = 4110;
    public static final int ERR_READ_BACKUP = 4111;
    public static final int ERR_WRITE_REC = 4112;
    public static final int ERR_READ_NOTE = 4113;
    public static final int ERR_WRITE_NOTE = 4114;
    public static final int ERR_READ_CBK = 4115;
    public static final int ERR_WRITE_CBK = 4116;
    public static final int ERR_WRONG_DATAVERS = 4117;
    public static final int ERR_SET_EXCEPT_DATES = 4118;
    public static final int ERR_APPT_STARTDATE = 4119;
    public static final int ERR_INVALID_CAL = 4120;
    static final int LAST = 4120;
    static final String[] details = new String[]{"None", "Error inserting calendar appointment", "Error deleting calendar appointment", "Error updating calendar appointment", "Error creating/accessing desktop calendar", "Error looking up calendar appointment", "Error getting frequency for repeating appointment", "Error getting repeat times for repeating appointment", "Error creating appointment", "Error setting appointment reminder", "Error setting appointment summary", "Error setting appointment showtime", "Error creating repeat", "Error setting lastweek of an appointment ", "Error creating classification", "Error reading backup data", "Error writing data record", "Error reading note file", "Error writing note file", "Error reading cbk file", "Error writing cbk file", "Unsupported data version.  Upgrade of data file is required for calendar synchronization", "Error setting exception dates", "The desktop does not support events before 1970.  The following event was moved to 1970: ", "Invalid calendar configured."};
    private String msg = null;
    private static Locale theLocale;
    private static ResourceBundle calRes;

    static {
        try {
            theLocale = Locale.getDefault();
            calRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CalendarSyncExceptionMsgs", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: CalSyncProperties can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public CalendarSyncException(int errorCode) {
        this.syncErr = null;
        this.calErr = null;
        this.errorCode = errorCode;
    }

    public CalendarSyncException(int errorCode, SyncException syncErr) {
        this.syncErr = syncErr;
        this.calErr = null;
        this.errorCode = errorCode;
    }

    public CalendarSyncException(int errorCode, CalendarException calErr) {
        this.syncErr = null;
        this.calErr = calErr;
        this.errorCode = errorCode;
    }

    public String getMessage() {
        if (this.errorCode > 4096 && this.errorCode <= 4120) {
            if (this.syncErr != null) {
                if (this.msg != null) {
                    return String.valueOf(calRes.getString(details[this.errorCode - 4096])) + ": " + this.msg + "\n" + this.syncErr.getMessage();
                }
                return String.valueOf(calRes.getString(details[this.errorCode - 4096])) + "\n" + this.syncErr.getMessage();
            }
            if (this.calErr != null) {
                if (this.msg != null) {
                    return String.valueOf(calRes.getString(details[this.errorCode - 4096])) + ": " + this.msg + "\n" + this.calErr.toString();
                }
                return String.valueOf(calRes.getString(details[this.errorCode - 4096])) + "\n" + this.calErr.toString();
            }
            if (this.msg != null) {
                return String.valueOf(calRes.getString(details[this.errorCode - 4096])) + ": " + this.msg;
            }
            return calRes.getString(details[this.errorCode - 4096]);
        }
        return "Unknown";
    }
}

