/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncMgr;

import com.sun.pdasync.SyncMgr.CDTDateTime;
import com.sun.pdasync.SyncMgr.CDTResponseBase;
import com.sun.pdasync.SyncMgr.DlpReadStorInfoExRespType;
import com.sun.pdasync.SyncUtils.BufferedBytes;
import com.sun.pdasync.SyncUtils.SyncUtils;

public class CRespReadCardInfo
extends CDTResponseBase {
    public static final int CARDNAME_LENGTH = 128;
    public static final int MANUFACTUR_LENGTH = 128;
    protected byte m_CardNo_u = 0;
    protected short m_CardVersion_u = 0;
    protected CDTDateTime m_CreateDate = new CDTDateTime();
    protected int m_RomSize_u = 0;
    protected int m_RamSize_u = 0;
    protected int m_FreeRam_u = 0;
    protected byte m_CardNameLen_u = 0;
    protected byte m_ManufNameLen_u = 0;
    protected byte[] m_CardName = new byte[128];
    protected byte[] m_ManufName = new byte[128];
    protected short m_wRomDBCount_u = (short)-1;
    protected short m_wRamDBCount_u = (short)-1;

    public CRespReadCardInfo() {
        super((byte)21);
    }

    public int GetCardName(byte[] buff, int nLen) {
        int didCopy = -1;
        if (buff != null && nLen >= (this.m_CardNameLen_u & 0xFF)) {
            System.arraycopy(this.m_CardName, 0, buff, 0, nLen);
            didCopy = 0;
        }
        return didCopy;
    }

    public byte GetCardNameLen() {
        return this.m_CardNameLen_u;
    }

    public byte GetCardNo() {
        return this.m_CardNo_u;
    }

    public short GetCardVersion() {
        return this.m_CardVersion_u;
    }

    public int GetCreateDate(CDTDateTime rDate) {
        rDate = this.m_CreateDate;
        return 0;
    }

    public int GetDBCounts(short[] pwRomDBCount_u, short[] pwRamDBCount_u) {
        pwRomDBCount_u[0] = this.m_wRomDBCount_u;
        pwRamDBCount_u[0] = this.m_wRamDBCount_u;
        return 0;
    }

    public int GetFreeRam() {
        return this.m_FreeRam_u;
    }

    public int GetManufName(byte[] buff, int nLen) {
        int didCopy = -1;
        if (buff != null && nLen >= (this.m_ManufNameLen_u & 0xFF)) {
            System.arraycopy(this.m_ManufName, 0, buff, 0, nLen);
            didCopy = 0;
        }
        return didCopy;
    }

    public byte GetManufNameLen() {
        return this.m_ManufNameLen_u;
    }

    public int GetRamSize() {
        return this.m_RamSize_u;
    }

    public int GetRomSize() {
        return this.m_RomSize_u;
    }

    public long UnWrapYourself() {
        short[] argSize_u = new short[]{0};
        BufferedBytes pBuff = new BufferedBytes();
        long retval = super.UnWrapYourself();
        if (retval == 0L) {
            pBuff = this.ScanForRespArgId((byte)32);
            if (this.m_RemoteErr_u != 0) {
                retval = 0L;
            } else if (pBuff != null) {
                byte respArgId_u = pBuff.getByte();
                short sizeArgData_u = this.CalcArgContentsSize(respArgId_u, pBuff.bytes);
                byte advance_u = (byte)this.CalcArgWrapperAdvance(respArgId_u);
                pBuff.increment((int)advance_u);
                byte lastCardNo_u = pBuff.getByte();
                pBuff.increment();
                byte anyMore_u = pBuff.getByte();
                pBuff.increment();
                pBuff.increment();
                byte actCount_u = pBuff.getByte();
                pBuff.increment();
                int entryFixed_u = 26;
                byte entryLength_u = pBuff.getByte();
                pBuff.increment();
                this.m_CardNo_u = pBuff.getByte();
                pBuff.increment();
                this.m_CardVersion_u = SyncUtils.dtPilotToHostWord((short)pBuff.getShort());
                pBuff.increment(2);
                this.m_CreateDate.getObjAt(pBuff);
                this.m_RomSize_u = SyncUtils.dtPilotToHostDWord((int)pBuff.getInt());
                pBuff.increment(4);
                this.m_RamSize_u = SyncUtils.dtPilotToHostDWord((int)pBuff.getInt());
                pBuff.increment(4);
                this.m_FreeRam_u = SyncUtils.dtPilotToHostDWord((int)pBuff.getInt());
                pBuff.increment(4);
                this.m_CardNameLen_u = pBuff.getByte();
                pBuff.increment();
                this.m_ManufNameLen_u = pBuff.getByte();
                pBuff.increment();
                if ((this.m_CardNameLen_u & 0xFF) > 0 && (this.m_CardNameLen_u & 0xFF) <= entryLength_u - entryFixed_u) {
                    pBuff.fillArrayOfBytes(this.m_CardName, (int)this.m_CardNameLen_u);
                }
                if ((this.m_ManufNameLen_u & 0xFF) > 0 && (this.m_ManufNameLen_u & 0xFF) <= entryLength_u - entryFixed_u) {
                    pBuff.fillArrayOfBytes(this.m_ManufName, (int)this.m_ManufNameLen_u);
                }
                if ((pBuff = this.FindRespArg((byte)33, argSize_u)) != null) {
                    DlpReadStorInfoExRespType pExResp = new DlpReadStorInfoExRespType();
                    pExResp.getObjAt(pBuff);
                    this.m_wRomDBCount_u = SyncUtils.dtPilotToHostWord((short)pExResp.romDBCount_u);
                    this.m_wRamDBCount_u = SyncUtils.dtPilotToHostWord((short)pExResp.ramDBCount_u);
                } else {
                    this.m_wRamDBCount_u = (short)-1;
                    this.m_wRomDBCount_u = (short)-1;
                }
                retval = 0L;
            } else {
                retval = 16401L;
            }
        }
        return retval;
    }
}

