/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.HotSync.CConduitJar;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitStateInfo;
import com.sun.pdasync.Registry.Registry;
import com.sun.pdasync.SyncUtils.UserConduitInfo;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;

public class CConduitManager
implements Serializable {
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;
    private static final int eNative = 0;
    private static final int eForeign = 1;
    private static final int CM_CREATOR_ID_SIZE = 8;
    protected Vector m_conduits = new Vector();
    protected Registry registry;

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find message file");
            Logger.doLogging((String)("PDASync:" + e.getMessage()));
            System.exit(1);
        }
    }

    public CConduitManager() {
        this(new Registry());
    }

    public CConduitManager(Registry reg) {
        this.registry = reg;
    }

    public boolean AddConduit(CConduitJar pConduit) {
        int nPriority;
        boolean bRtn = false;
        if (pConduit != null && (nPriority = pConduit.conduit.getPriority()) >= 0 && nPriority <= 4) {
            ConduitStateInfo aConduit;
            int nSize = this.m_conduits.size();
            int n = 0;
            while (n < nSize) {
                CConduitJar pTemp = (CConduitJar)this.m_conduits.elementAt(n);
                if (pTemp.conduit.getPriority() > nPriority) {
                    aConduit = pConduit.conduit;
                    this.RemoveConduit(pConduit.conduit.getCreatorID());
                    this.m_conduits.insertElementAt(pConduit, n);
                    bRtn = true;
                    break;
                }
                ++n;
            }
            if (!bRtn) {
                aConduit = pConduit.conduit;
                nSize = this.RemoveConduit(pConduit.conduit.getCreatorID());
                this.m_conduits.insertElementAt(pConduit, nSize);
                bRtn = true;
            }
        }
        return bRtn;
    }

    protected boolean DiscoverConduitInfo(CConduitJar pConduit) {
        if (!pConduit.Load()) {
            return false;
        }
        pConduit.GetDisplayName();
        pConduit.GetDefaultSyncAction();
        return true;
    }

    public boolean DiscoverConduits() {
        this.DiscoverTypeConduits(0);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void DiscoverTypeConduits(int type) {
        iConduitCount = this.registry.getRegistryCount();
        cList = this.registry.getStateEnumeration();
        if (type == 0 || type == 1) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            aConduit = (ConduitStateInfo)cList.nextElement();
            if (aConduit.getCreatorID() == 0 || aConduit.getCreatorID() == -1 || !this.DiscoverConduitInfo(pConduit = new CConduitJar(aConduit))) continue;
            pConduit.AddFileName(aConduit.getFile0().getBytes());
            pConduit.AddRemoteFileName(aConduit.getRemote0().getBytes());
            this.AddConduit(pConduit);
lbl11:
            // 3 sources

            ** while (cList.hasMoreElements())
        }
lbl12:
        // 1 sources

    }

    public CConduitJar FindConduit(int nViewerAppID_ui) {
        CConduitJar pConduit = null;
        int nSize = this.m_conduits.size();
        int n = 0;
        while (n < nSize) {
            pConduit = (CConduitJar)this.m_conduits.elementAt(n);
            if (pConduit.conduit.getCreatorID() == nViewerAppID_ui) {
                ConduitStateInfo aConduit = pConduit.conduit;
                return pConduit;
            }
            ++n;
        }
        return null;
    }

    public CConduitJar GetConduit(int nIndex) {
        CConduitJar pConduit = null;
        if (nIndex >= 0 && nIndex < this.m_conduits.size()) {
            pConduit = (CConduitJar)this.m_conduits.elementAt(nIndex);
        }
        return pConduit;
    }

    public int GetConduitCount() {
        return this.m_conduits.size();
    }

    public int RemoveConduit(int nViewerAppID_ui) {
        int nSize = this.m_conduits.size();
        int n = 0;
        while (n < nSize) {
            CConduitJar pTemp = (CConduitJar)this.m_conduits.elementAt(n);
            if (pTemp.conduit.getCreatorID() == nViewerAppID_ui) {
                ConduitStateInfo aConduit = pTemp.conduit;
                this.m_conduits.removeElementAt(n);
                return n;
            }
            ++n;
        }
        return nSize;
    }

    public boolean configureConduit(String condName) {
        CConduitJar pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            Conduit cond = (Conduit)pConduit.conduitObj;
            ConfigureConduitInfo condInfo = pConduit.getConduitConfiguration();
            int ret = cond.configure(condInfo);
            if (ret == 0) {
                pConduit.processConduitConfigure(condInfo);
            }
            return true;
        }
        return false;
    }

    protected CConduitJar getConduitByName(String condName) {
        CConduitJar retConduit = null;
        int i = 0;
        while (i < this.m_conduits.size()) {
            Conduit cond;
            CConduitJar pConduit = (CConduitJar)this.m_conduits.elementAt(i);
            if (!pConduit.isLoaded()) {
                pConduit.Load();
            }
            if ((cond = (Conduit)pConduit.conduitObj).name().equals(condName)) {
                retConduit = pConduit;
                break;
            }
            ++i;
        }
        return retConduit;
    }

    public Vector getConduitInfo() {
        Vector<UserConduitInfo> infoVec = new Vector<UserConduitInfo>();
        int nSize = this.m_conduits.size();
        int n = 0;
        while (n < nSize) {
            CConduitJar pConduit = (CConduitJar)this.m_conduits.elementAt(n);
            if (!pConduit.conduit.getUsersDeletedState()) {
                if (!pConduit.isLoaded()) {
                    pConduit.Load();
                }
                Conduit cond = (Conduit)pConduit.conduitObj;
                UserConduitInfo userCond = new UserConduitInfo(cond.name(), pConduit.conduit.getUsersActiveState());
                infoVec.addElement(userCond);
            }
            ++n;
        }
        return infoVec;
    }

    public boolean getDeletedState(String condName) {
        CConduitJar pConduit = null;
        pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            return this.registry.getDeleted(pConduit.conduit);
        }
        return true;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean setActiveState(String condName, boolean state) {
        CConduitJar pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            this.registry.setActive(pConduit.conduit, state);
            return true;
        }
        return false;
    }

    public CConduitJar setDeletedState(String condName, boolean state) {
        CConduitJar pConduit = null;
        pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            this.registry.setDeleted(pConduit.conduit, state);
        }
        return pConduit;
    }

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public boolean toggleActiveState(String condName) {
        CConduitJar pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            this.registry.toggleActive(pConduit.conduit);
            return true;
        }
        return false;
    }

    public CConduitJar toggleDeletedState(String condName) {
        CConduitJar pConduit = null;
        pConduit = this.getConduitByName(condName);
        if (pConduit != null) {
            this.registry.toggleDeleted(pConduit.conduit);
        }
        return pConduit;
    }
}

