/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncProperties;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class AddressSyncPropsUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle addressRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle addressTips;
    private AddressSyncProperties addressSyncProps;
    protected JRadioButton pilotModifies;
    protected JRadioButton addressModifies;
    protected JRadioButton mergeTogether;

    static {
        try {
            theLocale = Locale.getDefault();
            addressRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.AddressSyncPropsUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            addressTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.AddressSyncPropsUITips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
        }
    }

    public AddressSyncPropsUI(JFrame parent, AddressSyncProperties addrSyncProps) {
        super(parent, addressRes.getString("Configure Address Conduit"));
        this.addressSyncProps = addrSyncProps;
        this.userProperties = addrSyncProps;
        this.setDialogMessage(this.createPropsPanel());
        ((JDialog)((Object)this)).setContentPane(this.propsOptions);
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
    }

    private Object createPropsPanel() {
        HelpBroker helpBroker = null;
        JPanel changesPanel = new JPanel(new GridBagLayout(), true);
        JLabel changesLabel = new JLabel(addressRes.getString("Changes:"));
        this.mergeTogether = new JRadioButton(addressRes.getString("Synchronize the files"), false);
        this.mergeTogether.setToolTipText(addressTips.getString("Synchronize the files"));
        this.addressModifies = new JRadioButton(addressRes.getString("Desktop overwrites PDA"), false);
        this.addressModifies.setToolTipText(addressTips.getString("Desktop overwrites PDA"));
        this.pilotModifies = new JRadioButton(addressRes.getString("PDA overwrites desktop"), true);
        this.pilotModifies.setToolTipText(addressTips.getString("PDA overwrites desktop"));
        ButtonGroup rbGroup = new ButtonGroup();
        rbGroup.add(this.pilotModifies);
        rbGroup.add(this.addressModifies);
        rbGroup.add(this.mergeTogether);
        try {
            Insets ins = new Insets(0, 10, 0, 0);
            CommandPane.addComponent((Container)changesPanel, (Component)changesLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, null);
            CommandPane.addComponent((Container)changesPanel, (Component)this.mergeTogether, (int)-1, (int)0, (int)0, (int)1, (int)1, (int)17, (Insets)ins);
            CommandPane.addComponent((Container)changesPanel, (Component)this.addressModifies, (int)1, (int)1, (int)0, (int)1, (int)1, (int)17, (Insets)ins);
            CommandPane.addComponent((Container)changesPanel, (Component)this.pilotModifies, (int)1, (int)2, (int)0, (int)1, (int)1, (int)17, (Insets)ins);
        }
        catch (AWTException aWTException) {}
        PropsUI.PropsUIChangeListener stateChangedListener = new PropsUI.PropsUIChangeListener((PropsUI)this);
        this.pilotModifies.addItemListener((ItemListener)stateChangedListener);
        this.addressModifies.addItemListener((ItemListener)stateChangedListener);
        this.mergeTogether.addItemListener((ItemListener)stateChangedListener);
        this.setDialogParameters();
        this.propsChanged = false;
        Object[] messages = new Object[]{changesPanel, new JSeparator()};
        helpBroker = PDASyncHelp.enableContextHelp((Component)this.help, (String)"pda_addressConfig");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
        return messages;
    }

    private String lastSyncDate() {
        return new Date().toString();
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Address Sync AddressSyncPropsUI");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        AddressSyncProperties addrSyncProps = new AddressSyncProperties();
        AddressSyncPropsUI cprops = new AddressSyncPropsUI(fr, addrSyncProps);
        ((Dialog)((Object)cprops)).show();
        ((Dialog)((Object)cprops)).setResizable(false);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((Dialog)((Object)AddressSyncPropsUI.this)).show();
                ((Dialog)((Object)AddressSyncPropsUI.this)).setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public void setDialogParameters() {
        this.pilotModifies.setSelected(this.addressSyncProps.pilotModifies);
        this.addressModifies.setSelected(this.addressSyncProps.addressModifies);
        this.mergeTogether.setSelected(this.addressSyncProps.mergeTogether);
    }

    public void updateFromUI() {
        this.addressSyncProps.pilotModifies = this.pilotModifies.isSelected();
        this.addressSyncProps.addressModifies = this.addressModifies.isSelected();
        this.addressSyncProps.mergeTogether = this.mergeTogether.isSelected();
    }
}

