package com.sun.cc.platform.user;

public final class UserServiceClientMain {

    public static void main(String[] args) throws Exception {
        
        if (args.length != 3 && args.length != 23 && args.length != 27) {
            System.out.println("UserServiceClientMain Usage:");
            System.out.println("\tendpointURL uname pass"
                               + " [firstname lastname companyName"
                               + " street1 street2 street3 "
                               + " city state zip country"
                               + " phone email"
                               + " language jobTitle maySunContact"
                               + " touName touVersion"
                               + " touCountryCode touLanguageCode"
                               + " [licenseName licenseVersion"
                               + " licenseCountryCode licenseLanguageCode]"
                               + " applicationUUID]");
            System.out.println();
            System.out.println("\tempty fields can be replaced with a '.'");
            System.out.println("\tusername, password, lastname, and the"
                               + " legal agreement related attributes can NOT"
                               + " be empty.");
            return;
        }
        
        System.out.println();

        UserServiceClient client
            = UserServiceClientFactory.getInstance().getClient(args[0], 
                                                               System.out);
        if (client == null) { 
            System.err.println("Unable to connect to given endpoint: " 
                               + args[0]);
            return;
        }

        String token = (args.length == 3
                        ? client.validate(getArg(args[1]), getArg(args[2]))
                        : (args.length == 23
                           ? client.registerUser(getArg(args[1]), 
                                                 getArg(args[2]),
                                                 getArg(args[3]), 
                                                 getArg(args[4]),
                                                 getArg(args[5]), 
                                                 getArg(args[6]),
                                                 getArg(args[7]),
                                                 getArg(args[8]),
                                                 getArg(args[9]), 
                                                 getArg(args[10]),
                                                 getArg(args[11]),
                                                 getArg(args[12]),
                                                 getArg(args[13]),
                                                 getArg(args[14]),
                                                 getArg(args[15]),
                                                 getArg(args[16]),
                                                 new Boolean(getArg(args[17]))
                                                     .booleanValue(),
                                                 args[18], args[19], args[20], 
                                                 args[21], args[22])
                           : client.registerUser(getArg(args[1]), 
                                                 getArg(args[2]),
                                                 getArg(args[3]), 
                                                 getArg(args[4]),
                                                 getArg(args[5]), 
                                                 getArg(args[6]),
                                                 getArg(args[7]),
                                                 getArg(args[8]),
                                                 getArg(args[9]), 
                                                 getArg(args[10]),
                                                 getArg(args[11]),
                                                 getArg(args[12]),
                                                 getArg(args[13]),
                                                 getArg(args[14]),
                                                 getArg(args[15]),
                                                 getArg(args[16]),
                                                 new Boolean(getArg(args[17]))
                                                     .booleanValue(),
                                                 args[18], args[19], args[20], 
                                                 args[21], args[22],
                                                 args[23], args[24],
                                                 args[25], args[26])));
                           
        System.out.println();        
        System.out.println("Token response: " + token);
        
    }

    private static String getArg(String argValue) {
        return (argValue.equals(".") ? null : argValue);
    }
}
