/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.common;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.ProxyAuthenticator;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public class ProxyManager {
    public static final String PROXY_SET_PROPERTY = "http.proxySet";
    public static final String PROXY_HOST_PROPERTY = "http.proxyHost";
    public static final String PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final String PROXY_USER_PROPERTY = "http.proxyUser";
    public static final String PROXY_PASS_PROPERTY = "http.proxyPassword";
    public static final String SECURE_PROXY_SET_PROPERTY = "https.proxySet";
    public static final String SECURE_PROXY_HOST_PROPERTY = "https.proxyHost";
    public static final String SECURE_PROXY_PORT_PROPERTY = "https.proxyPort";
    public static final String SECURE_PROXY_USER_PROPERTY = "https.proxyUser";
    public static final String SECURE_PROXY_PASS_PROPERTY = "https.proxyPassword";
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$common$ProxyManager == null ? (class$com$sun$cns$basicreg$common$ProxyManager = ProxyManager.class$("com.sun.cns.basicreg.common.ProxyManager")) : class$com$sun$cns$basicreg$common$ProxyManager).getName());
    public static String HTTP_URL = "http://www.sun.com";
    public static String HTTPS_URL = "https://www.sun.com";
    private static ProxyManager INSTANCE = null;
    static /* synthetic */ Class class$com$sun$cns$basicreg$common$ProxyManager;

    private ProxyManager() {
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
    }

    public static ProxyManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProxyManager();
        }
        return INSTANCE;
    }

    public Properties getProxySettings() {
        Properties prop = new Properties();
        if (System.getProperty(PROXY_SET_PROPERTY) != null) {
            LOG.info("retrieving proxySet:" + System.getProperty(PROXY_SET_PROPERTY));
            prop.put(PROXY_SET_PROPERTY, System.getProperty(PROXY_SET_PROPERTY));
            LOG.info("retrieving secure proxySet:" + System.getProperty(SECURE_PROXY_SET_PROPERTY));
            prop.put(SECURE_PROXY_SET_PROPERTY, System.getProperty(SECURE_PROXY_SET_PROPERTY));
        }
        if (System.getProperty(PROXY_HOST_PROPERTY) != null) {
            LOG.info("retrieving proxyHost:" + System.getProperty(PROXY_HOST_PROPERTY));
            prop.put(PROXY_HOST_PROPERTY, System.getProperty(PROXY_HOST_PROPERTY));
            LOG.info("retrieving secure proxyHost:" + System.getProperty(SECURE_PROXY_HOST_PROPERTY));
            prop.put(SECURE_PROXY_HOST_PROPERTY, System.getProperty(SECURE_PROXY_HOST_PROPERTY));
        }
        if (System.getProperty(PROXY_PORT_PROPERTY) != null) {
            LOG.info("retrieving proxyPort:" + System.getProperty(PROXY_PORT_PROPERTY));
            prop.put(PROXY_PORT_PROPERTY, System.getProperty(PROXY_PORT_PROPERTY));
            LOG.info("retrieving secure proxyPort:" + System.getProperty(SECURE_PROXY_PORT_PROPERTY));
            prop.put(SECURE_PROXY_PORT_PROPERTY, System.getProperty(SECURE_PROXY_PORT_PROPERTY));
        }
        if (System.getProperty(PROXY_USER_PROPERTY) != null) {
            LOG.info("retrieving proxyUser:" + System.getProperty(PROXY_USER_PROPERTY));
            prop.put(PROXY_USER_PROPERTY, System.getProperty(PROXY_USER_PROPERTY));
            LOG.info("retrieving secure proxyUser:" + System.getProperty(SECURE_PROXY_USER_PROPERTY));
            prop.put(SECURE_PROXY_USER_PROPERTY, System.getProperty(SECURE_PROXY_USER_PROPERTY));
        }
        if (System.getProperty(PROXY_PASS_PROPERTY) != null) {
            LOG.info("retrieving proxyPassword: ****");
            prop.put(PROXY_PASS_PROPERTY, System.getProperty(PROXY_PASS_PROPERTY));
            LOG.info("retrieving secure proxyPassword: ****");
            prop.put(SECURE_PROXY_PASS_PROPERTY, System.getProperty(SECURE_PROXY_PASS_PROPERTY));
        }
        return prop;
    }

    public synchronized boolean setProxySettings(Properties inProp) {
        boolean isOk = false;
        try {
            inProp.store((OutputStream)null, (String)null);
        }
        catch (Exception e) {
            // empty catch block
        }
        Properties old_prop = this.getProxySettings();
        this.loadProxyProperties(inProp);
        if (inProp.getProperty(PROXY_SET_PROPERTY) == null || !inProp.getProperty(PROXY_SET_PROPERTY).equals("true")) {
            LOG.info("proxy set: off");
            return true;
        }
        if (this.testSettings(HTTP_URL) && this.testSettings(HTTPS_URL)) {
            isOk = true;
            LOG.info("new proxy setting is OK !");
        } else {
            LOG.info("new proxy setting is not OK ! and restore the original proxy setting");
            this.loadProxyProperties(old_prop);
        }
        return isOk;
    }

    public boolean testSettings(String inURL) {
        boolean result = false;
        try {
            int i;
            BufferedInputStream bis = new BufferedInputStream(new URL(inURL).openStream());
            StringBuffer sb = new StringBuffer();
            while ((i = bis.read()) != -1) {
                sb.append((char)i);
            }
            LOG.finest(sb.toString());
            result = true;
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
            LOG.severe("Error reading from " + inURL);
        }
        return result;
    }

    public synchronized void loadProxyProperties(Properties inProp) {
        Properties systemProperties = System.getProperties();
        if (inProp.getProperty(PROXY_SET_PROPERTY) != null) {
            LOG.info("setting proxySet:" + inProp.getProperty(PROXY_SET_PROPERTY));
            systemProperties.put(PROXY_SET_PROPERTY, inProp.getProperty(PROXY_SET_PROPERTY));
        }
        if (inProp.getProperty(PROXY_HOST_PROPERTY) != null) {
            LOG.info("setting proxyHost:" + inProp.getProperty(PROXY_HOST_PROPERTY));
            systemProperties.put(PROXY_HOST_PROPERTY, inProp.getProperty(PROXY_HOST_PROPERTY));
        }
        if (inProp.getProperty(PROXY_PORT_PROPERTY) != null) {
            LOG.info("setting proxyPort:" + inProp.getProperty(PROXY_PORT_PROPERTY));
            systemProperties.put(PROXY_PORT_PROPERTY, inProp.getProperty(PROXY_PORT_PROPERTY));
        }
        if (inProp.getProperty(PROXY_USER_PROPERTY) != null) {
            LOG.info("setting proxyUser:" + inProp.getProperty(PROXY_USER_PROPERTY));
            systemProperties.put(PROXY_USER_PROPERTY, inProp.getProperty(PROXY_USER_PROPERTY));
        }
        if (inProp.getProperty(PROXY_PASS_PROPERTY) != null) {
            LOG.info("setting proxyPassword: ****");
            systemProperties.put(PROXY_PASS_PROPERTY, inProp.getProperty(PROXY_PASS_PROPERTY));
        }
        if (inProp.getProperty(SECURE_PROXY_SET_PROPERTY) != null) {
            LOG.info("setting secure proxySet:" + inProp.getProperty(SECURE_PROXY_SET_PROPERTY));
            systemProperties.put(SECURE_PROXY_SET_PROPERTY, inProp.getProperty(SECURE_PROXY_SET_PROPERTY));
        }
        if (inProp.getProperty(SECURE_PROXY_HOST_PROPERTY) != null) {
            LOG.info("setting secure proxyHost:" + inProp.getProperty(SECURE_PROXY_HOST_PROPERTY));
            systemProperties.put(SECURE_PROXY_HOST_PROPERTY, inProp.getProperty(SECURE_PROXY_HOST_PROPERTY));
        }
        if (inProp.getProperty(SECURE_PROXY_PORT_PROPERTY) != null) {
            LOG.info("setting secure proxyPort:" + inProp.getProperty(SECURE_PROXY_PORT_PROPERTY));
            systemProperties.put(SECURE_PROXY_PORT_PROPERTY, inProp.getProperty(SECURE_PROXY_PORT_PROPERTY));
        }
        if (inProp.getProperty(SECURE_PROXY_USER_PROPERTY) != null) {
            LOG.info("setting secure proxyUser:" + inProp.getProperty(SECURE_PROXY_USER_PROPERTY));
            systemProperties.put(SECURE_PROXY_USER_PROPERTY, inProp.getProperty(SECURE_PROXY_USER_PROPERTY));
        }
        if (inProp.getProperty(SECURE_PROXY_PASS_PROPERTY) != null) {
            LOG.info("setting secure proxyPassword: ****");
            systemProperties.put(SECURE_PROXY_PASS_PROPERTY, inProp.getProperty(SECURE_PROXY_PASS_PROPERTY));
        }
        if (inProp.getProperty(PROXY_USER_PROPERTY) != null) {
            LOG.info("setting ProxyAuthenticator:");
            Authenticator.setDefault(new ProxyAuthenticator(inProp.getProperty(PROXY_USER_PROPERTY), inProp.getProperty(PROXY_PASS_PROPERTY)));
        } else if (inProp.getProperty(SECURE_PROXY_USER_PROPERTY) != null) {
            LOG.info("setting SecureProxyAuthenticator:");
            Authenticator.setDefault(new ProxyAuthenticator(inProp.getProperty(SECURE_PROXY_USER_PROPERTY), inProp.getProperty(SECURE_PROXY_PASS_PROPERTY)));
        }
        System.setProperties(systemProperties);
    }

    public boolean isProxyEnabled() {
        Properties systemProperties = System.getProperties();
        if (systemProperties.getProperty(PROXY_SET_PROPERTY) != null && systemProperties.getProperty(PROXY_SET_PROPERTY).equals("true")) {
            LOG.info("proxy is enabled");
            return true;
        }
        return false;
    }

    public boolean isSecureProxyEnabled() {
        Properties systemProperties = System.getProperties();
        if (systemProperties.getProperty(SECURE_PROXY_SET_PROPERTY) != null && systemProperties.getProperty(SECURE_PROXY_SET_PROPERTY).equals("true")) {
            LOG.info("secure proxy is enabled");
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

